/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.util.math.noise.FractalSimplexNoiseFast;
import frostnox.nightfall.world.Weather;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;

public class ContinentalEffects
extends DimensionSpecialEffects {
    public static final ResourceLocation SUN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/environment/sun.png");
    public static final ResourceLocation MOON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/environment/moon_phases.png");
    public static final ResourceLocation STARS_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/environment/stars.png");
    public static final float MOON_SIZE = 16.0f;
    public static final float SUN_SIZE = 32.0f;
    protected static final int CLOUD_WIDTH = 16;
    protected static final int CLOUD_HEIGHT = 12;
    protected final VertexBuffer skyBuffer;
    protected final VertexBuffer darkBuffer;
    protected final VertexBuffer starBuffer;
    @Nullable
    protected VertexBuffer cloudBuffer;
    @Nullable
    protected FractalSimplexNoiseFast opacityNoise;
    @Nullable
    protected FractalSimplexNoiseFast minYNoise;
    @Nullable
    protected FractalSimplexNoiseFast maxYNoise;
    protected int prevCloudX = Integer.MIN_VALUE;
    protected int prevCloudY = Integer.MIN_VALUE;
    protected int prevCloudZ = Integer.MIN_VALUE;
    protected double prevTime = 0.0;
    protected Vec3 prevCloudColor = Vec3.f_82478_;
    @Nullable
    protected CloudStatus prevCloudsType;
    public boolean regenClouds = true;
    protected final float[] rainSizeX = new float[1024];
    protected final float[] rainSizeZ = new float[1024];
    protected int rainSoundTime;
    private boolean initialized = false;

    public void init(long seed) {
        Random cloudRand = new Random(seed);
        this.opacityNoise = new FractalSimplexNoiseFast(cloudRand.nextLong(), 0.025f, 2, 0.5f, 2.0f);
        this.minYNoise = new FractalSimplexNoiseFast(cloudRand.nextLong(), 0.02f, 2, 0.5f, 2.0f);
        this.maxYNoise = new FractalSimplexNoiseFast(cloudRand.nextLong(), 0.02f, 2, 0.5f, 2.0f);
        this.initialized = true;
    }

    public ContinentalEffects(float pCloudLevel, boolean pHasGround, DimensionSpecialEffects.SkyType pSkyType, boolean pForceBrightLightmap, boolean pConstantAmbientLight) {
        super(pCloudLevel, pHasGround, pSkyType, pForceBrightLightmap, pConstantAmbientLight);
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                float centerZ = z - 16;
                float centerX = x - 16;
                float dist = Mth.m_14116_((float)(centerZ * centerZ + centerX * centerX));
                this.rainSizeX[x << 5 | z] = -centerX / dist * 0.5f;
                this.rainSizeZ[x << 5 | z] = centerZ / dist * 0.5f;
            }
        }
        Tesselator skyTesselator = Tesselator.m_85913_();
        BufferBuilder builder = skyTesselator.m_85915_();
        this.skyBuffer = new VertexBuffer();
        ContinentalEffects.buildSkyDisc(builder, 16.0f);
        this.skyBuffer.m_85925_(builder);
        skyTesselator = Tesselator.m_85913_();
        builder = skyTesselator.m_85915_();
        this.darkBuffer = new VertexBuffer();
        ContinentalEffects.buildSkyDisc(builder, -2.0f);
        this.darkBuffer.m_85925_(builder);
        skyTesselator = Tesselator.m_85913_();
        builder = skyTesselator.m_85915_();
        this.starBuffer = new VertexBuffer();
        ContinentalEffects.buildStars(builder);
        this.starBuffer.m_85925_(builder);
        this.setSkyRenderHandler((ticks, partialTick, poseStack, level, minecraft) -> {
            FogType fogtype;
            boolean doFog;
            Camera camera = minecraft.f_91063_.m_109153_();
            boolean bl = doFog = this.m_5781_(Mth.m_14107_((double)camera.m_90583_().f_82479_), Mth.m_14107_((double)camera.m_90583_().f_82481_)) || minecraft.f_91065_.m_93090_().m_93715_();
            if (!doFog && (fogtype = camera.m_167685_()) == FogType.NONE) {
                LivingEntity entity;
                Entity cameraEntity = camera.m_90592_();
                if (cameraEntity instanceof LivingEntity && (entity = (LivingEntity)cameraEntity).m_21023_(MobEffects.f_19610_)) {
                    return;
                }
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                RenderSystem.m_69472_();
                Vec3 skyColor = level.m_171660_(minecraft.f_91063_.m_109153_().m_90583_(), partialTick);
                float skyR = (float)skyColor.f_82479_;
                float skyG = Math.max(0.01f, (float)skyColor.f_82480_);
                float skyB = Math.max(0.03f, (float)skyColor.f_82481_);
                FogRenderer.m_109036_();
                BufferBuilder skyBuilder = Tesselator.m_85913_().m_85915_();
                RenderSystem.m_69458_((boolean)false);
                RenderSystem.m_157429_((float)skyR, (float)skyG, (float)skyB, (float)1.0f);
                ShaderInstance discShader = RenderSystem.m_157196_();
                this.skyBuffer.m_166867_(matrix, RenderSystem.m_157192_(), discShader);
                RenderSystem.m_69493_();
                RenderSystem.m_69478_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                poseStack.m_85836_();
                float skyVisibility = 1.0f - level.m_46722_(partialTick);
                ILevelData capL = LevelData.get((Level)level);
                if (capL.getGlobalWeather() == Weather.FOG) {
                    float fogVisibility = Math.min(1.0f, capL.getFogIntensity());
                    skyVisibility = Math.min(skyVisibility, 1.2f - fogVisibility);
                }
                float starAlpha = level.m_104811_(partialTick) * skyVisibility;
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)skyVisibility);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(level.m_46942_(partialTick) * 360.0f));
                Matrix4f celestialMatrix = poseStack.m_85850_().m_85861_();
                poseStack.m_85849_();
                if (starAlpha > 0.0f) {
                    RenderSystem.m_157429_((float)(starAlpha * 2.0f), (float)(starAlpha * 2.0f), (float)(starAlpha * 2.0f), (float)(starAlpha * 1.2f));
                    RenderSystem.m_157456_((int)0, (ResourceLocation)STARS_LOCATION);
                    this.starBuffer.m_166867_(celestialMatrix, RenderSystem.m_157192_(), GameRenderer.m_172817_());
                }
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.m_69461_();
                RenderSystem.m_69472_();
                double eyeY = minecraft.f_91074_.m_20299_((float)partialTick).f_82480_ - 416.0;
                if (eyeY + 16.0 < 0.0 && minecraft.f_91073_.m_45517_(LightLayer.SKY, minecraft.f_91074_.m_146901_()) <= 0) {
                    RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                } else {
                    RenderSystem.m_157429_((float)RenderSystem.m_157198_()[0], (float)RenderSystem.m_157198_()[1], (float)RenderSystem.m_157198_()[2], (float)RenderSystem.m_157198_()[3]);
                }
                this.darkBuffer.m_166867_(poseStack.m_85850_().m_85861_(), RenderSystem.m_157192_(), discShader);
                RenderSystem.m_69453_();
                RenderSystem.m_69478_();
                float[] sunriseColors = super.m_7518_(level.m_46942_(partialTick), partialTick);
                if (sunriseColors != null) {
                    RenderSystem.m_157427_(GameRenderer::m_172811_);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    poseStack.m_85836_();
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                    float f2 = Mth.m_14031_((float)level.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
                    poseStack.m_85845_(Vector3f.f_122227_.m_122240_(f2));
                    poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                    float f3 = sunriseColors[0];
                    float f4 = sunriseColors[1];
                    float f5 = sunriseColors[2];
                    Matrix4f sunsetMatrix = poseStack.m_85850_().m_85861_();
                    skyBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                    skyBuilder.m_85982_(sunsetMatrix, 0.0f, 100.0f, 0.0f).m_85950_(f3, f4, f5, sunriseColors[3]).m_5752_();
                    for (int j = 0; j <= 16; ++j) {
                        float f6 = (float)j * ((float)Math.PI * 2) / 16.0f;
                        float f7 = Mth.m_14031_((float)f6);
                        float f8 = Mth.m_14089_((float)f6);
                        skyBuilder.m_85982_(sunsetMatrix, f7 * 120.0f, f8 * 120.0f, -f8 * 40.0f * sunriseColors[3]).m_85950_(sunriseColors[0], sunriseColors[1], sunriseColors[2], 0.0f).m_5752_();
                    }
                    skyBuilder.m_85721_();
                    BufferUploader.m_85761_((BufferBuilder)skyBuilder);
                    poseStack.m_85849_();
                }
                RenderSystem.m_69493_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)SUN_LOCATION);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((1.0f - starAlpha * 2.0f) * skyVisibility));
                skyBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                skyBuilder.m_85982_(celestialMatrix, -32.0f, 100.0f, -32.0f).m_7421_(0.0f, 0.0f).m_5752_();
                skyBuilder.m_85982_(celestialMatrix, 32.0f, 100.0f, -32.0f).m_7421_(1.0f, 0.0f).m_5752_();
                skyBuilder.m_85982_(celestialMatrix, 32.0f, 100.0f, 32.0f).m_7421_(1.0f, 1.0f).m_5752_();
                skyBuilder.m_85982_(celestialMatrix, -32.0f, 100.0f, 32.0f).m_7421_(0.0f, 1.0f).m_5752_();
                skyBuilder.m_85721_();
                BufferUploader.m_85761_((BufferBuilder)skyBuilder);
                RenderSystem.m_69453_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)MOON_LOCATION);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(starAlpha * 2.0f));
                int phase = level.m_46941_();
                int l = phase % 4;
                int i1 = phase / 4 % 2;
                float f13 = (float)l / 4.0f;
                float f14 = (float)i1 / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                skyBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                skyBuilder.m_85982_(celestialMatrix, -16.0f, -100.0f, 16.0f).m_7421_(f15, f16).m_5752_();
                skyBuilder.m_85982_(celestialMatrix, 16.0f, -100.0f, 16.0f).m_7421_(f13, f16).m_5752_();
                skyBuilder.m_85982_(celestialMatrix, 16.0f, -100.0f, -16.0f).m_7421_(f13, f14).m_5752_();
                skyBuilder.m_85982_(celestialMatrix, -16.0f, -100.0f, -16.0f).m_7421_(f15, f14).m_5752_();
                skyBuilder.m_85721_();
                BufferUploader.m_85761_((BufferBuilder)skyBuilder);
                if (level.m_104583_().m_108882_()) {
                    RenderSystem.m_157429_((float)(skyR * 0.2f + 0.04f), (float)(skyG * 0.2f + 0.04f), (float)(skyB * 0.6f + 0.1f), (float)1.0f);
                } else {
                    RenderSystem.m_157429_((float)skyR, (float)skyG, (float)skyB, (float)1.0f);
                }
                RenderSystem.m_69493_();
                RenderSystem.m_69458_((boolean)true);
            }
        });
        this.setCloudRenderHandler((ticks, partialTick, stack, level, mc, camX, camY, camZ) -> {
            double time;
            double offZ;
            double offY;
            double offX;
            double renderZ;
            double renderY;
            double renderX;
            LivingEntity entity;
            Entity patt14610$temp;
            if (!this.initialized || mc.f_91063_.m_109153_().m_167685_() != FogType.NONE || (patt14610$temp = mc.f_91063_.m_109153_().m_90592_()) instanceof LivingEntity && (entity = (LivingEntity)patt14610$temp).m_21023_(MobEffects.f_19610_)) {
                return;
            }
            float levelHeight = level.m_104583_().m_108871_();
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69482_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_69458_((boolean)true);
            float drift = ((float)ticks + partialTick) * 0.03f;
            if (mc.f_91074_ != null) {
                Vec3 pos = mc.f_91074_.m_20299_(partialTick);
                renderX = pos.f_82479_ + (double)drift;
                renderY = (double)levelHeight - pos.f_82480_;
                renderZ = pos.f_82481_;
                offX = renderX - camX - renderX % 16.0;
                offY = pos.f_82480_ - camY - pos.f_82480_ % 12.0;
                offZ = pos.f_82481_ - camZ - pos.f_82481_ % 16.0;
            } else {
                renderX = camX + (double)drift;
                renderY = (double)levelHeight - camY;
                renderZ = camZ;
                offX = -renderX % 16.0;
                offY = renderY % 12.0;
                offZ = -renderZ % 16.0;
            }
            Vec3 color = level.m_104808_(partialTick);
            int cloudX = Mth.m_14107_((double)(renderX / 16.0)) * 16;
            int cloudY = Mth.m_14107_((double)(renderY / 12.0)) * 12;
            int cloudZ = Mth.m_14107_((double)(renderZ / 16.0)) * 16;
            if (renderX > 0.0) {
                offX += 16.0;
            }
            if (renderZ > 0.0) {
                offZ += 16.0;
            }
            if ((time = (double)(level.m_46467_() / 200L)) != this.prevTime || cloudX != this.prevCloudX || cloudY != this.prevCloudY || cloudZ != this.prevCloudZ || mc.f_91066_.m_92174_() != this.prevCloudsType || this.prevCloudColor.m_82557_(color) > 2.0E-4) {
                this.prevCloudX = cloudX;
                this.prevCloudY = cloudY;
                this.prevCloudZ = cloudZ;
                this.prevTime = time;
                this.prevCloudColor = color;
                this.prevCloudsType = mc.f_91066_.m_92174_();
                this.regenClouds = true;
            }
            if (this.regenClouds) {
                this.regenClouds = false;
                BufferBuilder cloudBuilder = Tesselator.m_85913_().m_85915_();
                if (this.cloudBuffer != null) {
                    this.cloudBuffer.close();
                }
                this.cloudBuffer = new VertexBuffer();
                this.buildClouds(cloudBuilder, (Level)level, cloudX, cloudY, cloudZ, (float)cloudX - drift, cloudZ, color, time);
            }
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            FogRenderer.m_109036_();
            stack.m_85836_();
            stack.m_85837_(offX - (double)drift + (double)0.0015f, offY + (double)0.0015f, offZ + (double)0.0015f);
            stack.m_85841_(0.999f, 0.999f, 0.999f);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.cloudBuffer != null) {
                ShaderInstance shader = RenderSystem.m_157196_();
                RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                this.cloudBuffer.m_166867_(stack.m_85850_().m_85861_(), RenderSystem.m_157192_(), shader);
                RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                this.cloudBuffer.m_166867_(stack.m_85850_().m_85861_(), RenderSystem.m_157192_(), shader);
            }
            stack.m_85849_();
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
        });
        this.setWeatherRenderHandler((ticks, partialTick, level, minecraft, lightTexture, camX, camY, camZ) -> {});
        this.setWeatherParticleRenderHandler((ticks, level, mc, camera) -> {
            ILevelData capL = LevelData.get((Level)level);
            if (capL.getGlobalWeatherIntensity() > 0.15f) {
                float intensity;
                BlockPos camPos = camera.m_90588_();
                BlockPos soundPos = null;
                for (int i = 0; i < 60; ++i) {
                    int z;
                    int x = level.f_46441_.nextInt(21) - 10;
                    BlockPos rainPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, camPos.m_142082_(x, 0, z = level.f_46441_.nextInt(21) - 10));
                    if (rainPos.m_123342_() <= level.m_141937_() || rainPos.m_123342_() > camPos.m_123342_() + 10 || rainPos.m_123342_() < camPos.m_123342_() - 10 || capL.getWeather(ChunkData.get(level.m_46745_(rainPos)), rainPos) != Weather.RAIN) continue;
                    soundPos = rainPos.m_7495_();
                    break;
                }
                if (soundPos != null && level.f_46441_.nextInt(3 + Math.round(3.0f * (1.0f - (intensity = Mth.m_14036_((float)capL.getWeatherIntensity(ChunkData.get(level.m_46745_(soundPos)), soundPos), (float)0.25f, (float)1.0f))))) < this.rainSoundTime++) {
                    float volume = 0.25f * intensity;
                    float pitch = 0.9f - 0.2f * intensity;
                    this.rainSoundTime = 0;
                    if (soundPos.m_123342_() > camPos.m_123342_() + 1 && level.m_5452_(Heightmap.Types.MOTION_BLOCKING, camPos).m_123342_() > camPos.m_123342_()) {
                        mc.f_91073_.m_104677_(soundPos, SoundEvents.f_12542_, SoundSource.WEATHER, volume * 0.5f, pitch * 0.5f, false);
                    } else {
                        mc.f_91073_.m_104677_(soundPos, SoundEvents.f_12541_, SoundSource.WEATHER, volume, pitch, false);
                    }
                }
            }
        });
    }

    public Vec3 m_5927_(Vec3 pFogColor, float pBrightness) {
        return pFogColor.m_82542_((double)(pBrightness * 0.94f + 0.06f), (double)(pBrightness * 0.94f + 0.06f), (double)(pBrightness * 0.91f + 0.09f));
    }

    public boolean m_5781_(int x, int pY) {
        return false;
    }

    @Nullable
    public float[] m_7518_(float pTimeOfDay, float pPartialTicks) {
        return null;
    }

    private void buildClouds(BufferBuilder builder, Level level, int centerX, int startY, int centerZ, double worldX, int worldZ, Vec3 color, double time) {
        ILevelData capL = LevelData.get(level);
        float density = Math.min(capL.getGlobalWeatherIntensity() + 0.425f, 1.0f);
        float minOpacity = 1.0f - density;
        if (minOpacity < 0.0f) {
            return;
        }
        density = 1.0f + density * 2.0f;
        time *= 0.05;
        float presence = Math.max(0.0f, capL.getGlobalWeatherIntensity() + 0.2f);
        presence *= presence;
        float rainLevel = level.m_46722_(1.0f);
        float offset = 9.765625E-4f;
        float r = (float)color.f_82479_;
        float g = (float)color.f_82480_;
        float b = (float)color.f_82481_;
        float r9 = r * 0.9f;
        float g9 = g * 0.9f;
        float b9 = b * 0.9f;
        float r7 = r * 0.7f;
        float g7 = g * 0.7f;
        float b7 = b * 0.7f;
        float r8 = r * 0.8f;
        float g8 = g * 0.8f;
        float b8 = b * 0.8f;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        int maxSize = this.prevCloudsType == CloudStatus.FANCY ? 48 : 32;
        int size = Math.min(maxSize, Minecraft.m_91087_().f_91066_.f_92106_ * 2) * 16;
        int sampleSize = this.prevCloudsType == CloudStatus.FANCY ? 3 : 15;
        for (int x = -size; x <= size; x += 16) {
            for (int z = -size; z <= size; z += 16) {
                int ySize;
                int y;
                int noiseX = centerX + x;
                float frequency = 0.0625f;
                int noiseZ = centerZ + z;
                float a = Math.abs(this.opacityNoise.noise3D((float)noiseX * frequency, time, (float)noiseZ * frequency));
                if (a < minOpacity) continue;
                a = Math.min(1.0f, (a + rainLevel * 0.2f) * density);
                int maxGroundOffset = 0;
                for (int xOff = 0; xOff < 16; xOff += sampleSize) {
                    for (int zOff = 0; zOff < 16; zOff += sampleSize) {
                        int groundOffset = Math.max(0, level.m_6924_(Heightmap.Types.MOTION_BLOCKING, Mth.m_14107_((double)(worldX + (double)x + (double)xOff)), worldZ + z + zOff) - 416);
                        if (groundOffset <= maxGroundOffset) continue;
                        maxGroundOffset = groundOffset;
                    }
                }
                float fade = Math.min(1.0f, (float)maxGroundOffset / ((this.m_108871_() - 416.0f) * 0.5f));
                if ((a *= 1.0f - fade * fade) < 0.3f) continue;
                float dist = Math.max(Math.abs(x), Math.abs(z));
                int yFar = Mth.m_14143_((float)(dist * dist * 2.5E-4f)) / 12 * 12;
                if (yFar > 48) {
                    a *= 1.0f - Mth.m_14036_((float)(((float)yFar - 48.0f) / 192.0f), (float)0.0f, (float)0.5f);
                }
                if ((y = startY - (yFar = Mth.m_14143_((float)((float)yFar * presence)) / 12 * 12) + (int)(this.minYNoise.noise3D((float)noiseX * frequency * 5.0f, time, (float)noiseZ * frequency * 5.0f) * 30.0f) / 12 * 12) >= -(ySize = yFar / 8 + Math.max(12, Math.abs((int)(this.maxYNoise.noise3D((float)noiseX * frequency, time, (float)noiseZ * frequency) * 100.0f)) / 12 * 12))) {
                    builder.m_5483_((double)x, (double)y, (double)(z + 16)).m_85950_(r7, g7, b7, a).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)(x + 16), (double)y, (double)(z + 16)).m_85950_(r7, g7, b7, a).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)(x + 16), (double)y, (double)z).m_85950_(r7, g7, b7, a).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)x, (double)y, (double)z).m_85950_(r7, g7, b7, a).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                }
                if (y <= ySize) {
                    builder.m_5483_((double)x, (double)((float)(y + ySize) - offset), (double)(z + 16)).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)(x + 16), (double)((float)(y + ySize) - offset), (double)(z + 16)).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)(x + 16), (double)((float)(y + ySize) - offset), (double)z).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)x, (double)((float)(y + ySize) - offset), (double)z).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                }
                if (x >= -16) {
                    builder.m_5483_((double)x, (double)y, (double)(z + 16)).m_85950_(r9, g9, b9, a).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)x, (double)(y + ySize), (double)(z + 16)).m_85950_(r9, g9, b9, a).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)x, (double)(y + ySize), (double)z).m_85950_(r9, g9, b9, a).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)x, (double)y, (double)z).m_85950_(r9, g9, b9, a).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                }
                if (x <= 16) {
                    builder.m_5483_((double)((float)(x + 16) - offset), (double)y, (double)(z + 16)).m_85950_(r9, g9, b9, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)((float)(x + 16) - offset), (double)(y + ySize), (double)(z + 16)).m_85950_(r9, g9, b9, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)((float)(x + 16) - offset), (double)(y + ySize), (double)z).m_85950_(r9, g9, b9, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                    builder.m_5483_((double)((float)(x + 16) - offset), (double)y, (double)z).m_85950_(r9, g9, b9, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                }
                if (z >= -16) {
                    builder.m_5483_((double)x, (double)(y + ySize), (double)z).m_85950_(r8, g8, b8, a).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                    builder.m_5483_((double)(x + 16), (double)(y + ySize), (double)z).m_85950_(r8, g8, b8, a).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                    builder.m_5483_((double)(x + 16), (double)y, (double)z).m_85950_(r8, g8, b8, a).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                    builder.m_5483_((double)x, (double)y, (double)z).m_85950_(r8, g8, b8, a).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                }
                if (z > 16) continue;
                builder.m_5483_((double)x, (double)(y + ySize), (double)((float)(z + 16) - offset)).m_85950_(r8, g8, b8, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_5483_((double)(x + 16), (double)(y + ySize), (double)((float)(z + 16) - offset)).m_85950_(r8, g8, b8, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_5483_((double)(x + 16), (double)y, (double)((float)(z + 16) - offset)).m_85950_(r8, g8, b8, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_5483_((double)x, (double)y, (double)((float)(z + 16) - offset)).m_85950_(r8, g8, b8, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            }
        }
        builder.m_85721_();
        this.cloudBuffer.m_85925_(builder);
    }

    public static void buildSkyDisc(BufferBuilder pBuilder, float pY) {
        float f = Math.signum(pY) * 512.0f;
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        pBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        pBuilder.m_5483_(0.0, (double)pY, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            pBuilder.m_5483_((double)(f * Mth.m_14089_((float)((float)i * ((float)Math.PI / 180)))), (double)pY, (double)(512.0f * Mth.m_14031_((float)((float)i * ((float)Math.PI / 180))))).m_5752_();
        }
        pBuilder.m_85721_();
    }

    public static void buildStars(BufferBuilder builder) {
        Random random = new Random(10842L);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        for (int i = 0; i < 3000; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double xPos = (d0 *= d4) * 100.0;
            double yPos = (d1 *= d4) * 100.0;
            double zPos = (d2 *= d4) * 100.0;
            if (yPos < 0.0 && xPos >= -16.0 && xPos <= 16.0 && zPos >= -16.0 && zPos <= 16.0 || yPos > 0.0 && xPos >= -32.0 && xPos <= 32.0 && zPos >= -32.0 && zPos <= 32.0) continue;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            float colorType = random.nextFloat();
            float uv = colorType < 0.4f ? 0.2f : (colorType < 0.75f ? 0.4f : (colorType < 0.9f ? 0.6f : (colorType < 0.97f ? 0.8f : 0.99f)));
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                builder.m_5483_((double)((float)(xPos + d25)), (double)((float)(yPos + d23)), (double)((float)(zPos + d26))).m_7421_(0.0f, uv).m_5752_();
            }
        }
        builder.m_85721_();
    }
}

