/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.block.block.cauldron.CauldronBlockEntity;
import frostnox.nightfall.block.block.cauldron.CauldronBlockNF;
import frostnox.nightfall.block.block.cauldron.Task;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.util.RenderUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.awt.Color;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CauldronRenderer<T extends CauldronBlockEntity>
implements BlockEntityRenderer<T> {
    private final ModelPart LID;
    private static final Map<Block, Material> MATERIALS = new Object2ObjectArrayMap(1);
    private static final Map<Item, ResourceLocation> TEXTURES = new Object2ObjectArrayMap(1);
    private static final Map<Item, ResourceLocation> SIDE_TEXTURES = new Object2ObjectArrayMap(1);
    private static final float FREQ = 0.25f;

    public CauldronRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.m_173582_(ModelRegistryNF.CAULDRON);
        this.LID = root.m_171324_("lid");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition lid = partdefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-5.0f, -0.5f, -5.0f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(22, 0).m_171488_(-2.0f, -1.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public int m_142163_() {
        return Integer.MAX_VALUE;
    }

    public boolean shouldRender(T pBlockEntity, Vec3 pCameraPos) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void render(T cauldron, float pPartialTick, PoseStack stack, MultiBufferSource buffers, int pPackedLight, int pPackedOverlay) {
        float tick;
        Material material;
        BlockState state = cauldron.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof CauldronBlockNF)) return;
        CauldronBlockNF cauldronBlock = (CauldronBlockNF)block;
        if (state.m_61143_(CauldronBlockNF.TASK) == Task.DONE) {
            if (!((CauldronBlockEntity)cauldron).hasMeal()) {
                return;
            }
            stack.m_85836_();
            Item meal = ((CauldronBlockEntity)cauldron).meal.m_41720_();
            ResourceLocation loc = TEXTURES.get(meal);
            if (loc == null) {
                ResourceLocation itemLoc = meal.getRegistryName();
                loc = ResourceLocation.fromNamespaceAndPath((String)itemLoc.m_135827_(), (String)("block/" + itemLoc.m_135815_()));
                TEXTURES.put(meal, loc);
            }
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(loc);
            VertexConsumer builder = buffers.m_6299_(RenderType.m_110446_((ResourceLocation)sprite.m_118414_().m_118330_()));
            switch ((int)state.m_60726_(cauldron.m_58899_()) % 4) {
                case 0: {
                    stack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                    stack.m_85837_(-1.0, 0.0, 0.0);
                    break;
                }
                case 1: {
                    stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                    stack.m_85837_(-1.0, 0.0, -1.0);
                    break;
                }
                case 3: {
                    stack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
                    stack.m_85837_(0.0, 0.0, -1.0);
                }
            }
            if (((CauldronBlockEntity)cauldron).meal.m_204117_(TagsNF.CAULDRON_FLUID_MEAL)) {
                RenderUtil.drawFace(Direction.UP, stack.m_85850_().m_85861_(), stack.m_85850_().m_85864_(), builder, Color.WHITE, new Vec3(0.5, 0.125 + 0.0625 * (double)((CauldronBlockEntity)cauldron).meal.m_41613_(), 0.5), 0.5f, 0.5f, new Vec2(sprite.m_118409_(), sprite.m_118411_()), 8.0f / (float)ClientEngine.get().atlasWidth, 8.0f / (float)ClientEngine.get().atlasHeight, pPackedLight);
            } else {
                float slice = 2.0f * (float)(4 - ((CauldronBlockEntity)cauldron).meal.m_41613_());
                float uOff = slice / (float)ClientEngine.get().atlasWidth;
                RenderUtil.drawFace(Direction.UP, stack.m_85850_().m_85861_(), stack.m_85850_().m_85864_(), builder, Color.WHITE, new Vec3(0.5 - (double)(slice / 32.0f), 0.375, 0.5), 0.5f - slice / 16.0f, 0.5f, new Vec2(sprite.m_118409_() + uOff, sprite.m_118411_()), (8.0f - slice) / (float)ClientEngine.get().atlasWidth, 8.0f / (float)ClientEngine.get().atlasHeight, pPackedLight);
                if (slice > 0.0f) {
                    loc = SIDE_TEXTURES.get(meal);
                    if (loc == null) {
                        ResourceLocation itemLoc = meal.getRegistryName();
                        loc = ResourceLocation.fromNamespaceAndPath((String)itemLoc.m_135827_(), (String)("block/" + itemLoc.m_135815_() + "_side"));
                        SIDE_TEXTURES.put(meal, loc);
                    }
                    sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(loc);
                    builder = buffers.m_6299_(RenderType.m_110446_((ResourceLocation)sprite.m_118414_().m_118330_()));
                    RenderUtil.drawFace(Direction.EAST, stack.m_85850_().m_85861_(), stack.m_85850_().m_85864_(), builder, Color.WHITE, new Vec3(0.75 - (double)(slice / 16.0f), 0.21875, 0.5), 0.5f, 0.3125f, new Vec2(sprite.m_118409_(), sprite.m_118411_()), 8.0f / (float)ClientEngine.get().atlasWidth, 5.0f / (float)ClientEngine.get().atlasHeight, pPackedLight);
                }
            }
            stack.m_85849_();
            return;
        }
        if (state.m_61143_(CauldronBlockNF.TASK) != Task.COOK) {
            if (((CauldronBlockEntity)cauldron).forceEntityRenderTick != -1 || !cauldron.m_58898_()) return;
            ((CauldronBlockEntity)cauldron).forceEntityRenderTick = ((CauldronBlockEntity)cauldron).animTick;
        } else if (((CauldronBlockEntity)cauldron).forceEntityRenderTick < ((CauldronBlockEntity)cauldron).animTick) {
            ((CauldronBlockEntity)cauldron).forceEntityRenderTick = -1;
        }
        stack.m_85836_();
        stack.m_85837_(0.5, 1.5, 0.5);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        if (state.m_61143_(CauldronBlockNF.AXIS) == Direction.Axis.X) {
            stack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        }
        if ((material = MATERIALS.get(cauldronBlock)) == null) {
            material = new Material(TextureAtlas.f_118259_, ResourceLocation.fromNamespaceAndPath((String)cauldronBlock.getRegistryName().m_135827_(), (String)("block/" + cauldronBlock.getRegistryName().m_135815_())));
            MATERIALS.put(cauldronBlock, material);
        }
        this.LID.f_104203_ = (tick = (float)((CauldronBlockEntity)cauldron).animTick + pPartialTick) % ((float)Math.PI * 8) < (float)Math.PI * 4 ? 0.0f : Mth.m_14031_((float)(tick * 0.25f)) * Mth.m_14031_((float)(tick * 0.25f * 1.5f)) * Mth.m_14031_((float)(tick * 0.25f * 2.2f)) * 0.1f;
        this.LID.m_104301_(stack, material.m_119194_(buffers, RenderType::m_110446_), pPackedLight, pPackedOverlay);
        stack.m_85849_();
    }
}

