/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.block.ITree;
import frostnox.nightfall.block.block.chest.ChestBlockEntityNF;
import frostnox.nightfall.block.block.chest.ChestBlockNF;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.registry.RegistriesNF;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.TextureStitchEvent;

public class ChestRendererNF<T extends ChestBlockEntityNF>
implements BlockEntityRenderer<T> {
    private static Map<ITree, ResourceLocation> SINGLE_TEXTURES;
    private static Map<ITree, ResourceLocation> RIGHT_TEXTURES;
    private static Map<ITree, ResourceLocation> LEFT_TEXTURES;
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lid;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightLock;

    public ChestRendererNF(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(ModelRegistryNF.CHEST);
        this.lid = modelpart.m_171324_(LID);
        this.lock = modelpart.m_171324_(LOCK);
        ModelPart modelpart1 = context.m_173582_(ModelRegistryNF.DOUBLE_CHEST_LEFT);
        this.doubleLeftLid = modelpart1.m_171324_(LID);
        this.doubleLeftLock = modelpart1.m_171324_(LOCK);
        ModelPart modelpart2 = context.m_173582_(ModelRegistryNF.DOUBLE_CHEST_RIGHT);
        this.doubleRightLid = modelpart2.m_171324_(LID);
        this.doubleRightLock = modelpart2.m_171324_(LOCK);
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyRightLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyLeftLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public int m_142163_() {
        return Integer.MAX_VALUE;
    }

    public boolean shouldRender(T pBlockEntity, Vec3 pCameraPos) {
        return true;
    }

    public void render(T chest, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        BlockState blockState = chest.m_58900_();
        Block block = blockState.m_60734_();
        if (block instanceof ChestBlockNF) {
            boolean open;
            ChestBlockNF chestBlock = (ChestBlockNF)block;
            Level level = chest.m_58904_();
            DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> combiner = level != null ? chestBlock.m_5641_(blockState, level, chest.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float lidAngle = ((Float2FloatFunction)combiner.m_5649_(ChestBlock.m_51517_(chest))).get(pPartialTick);
            boolean bl = open = chest.m_6683_(pPartialTick) > 0.0f;
            if ((Boolean)blockState.m_61143_((Property)ChestBlockNF.OPEN) != open) {
                if (!open && ((ChestBlockEntityNF)chest).forceEntityRenderTick < ((ChestBlockEntityNF)chest).tickCount) {
                    ((ChestBlockEntityNF)chest).forceEntityRenderTick = ((ChestBlockEntityNF)chest).tickCount;
                }
                level.m_7731_(chest.m_58899_(), (BlockState)blockState.m_61124_((Property)ChestBlockNF.OPEN, (Comparable)Boolean.valueOf(open)), 18);
            } else if (((ChestBlockEntityNF)chest).forceEntityRenderTick < ((ChestBlockEntityNF)chest).tickCount) {
                ((ChestBlockEntityNF)chest).forceEntityRenderTick = -1;
            }
            if (lidAngle == 0.0f && ((ChestBlockEntityNF)chest).forceEntityRenderTick == -1) {
                return;
            }
            lidAngle = 1.0f - lidAngle;
            lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
            ChestType type = blockState.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockState.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
            boolean doubled = type != ChestType.SINGLE;
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.5, 0.5, 0.5);
            pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(-((Direction)blockState.m_61143_((Property)ChestBlock.f_51478_)).m_122435_()));
            pPoseStack.m_85837_(-0.5, -0.5, -0.5);
            int i = ((Int2IntFunction)combiner.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(pPackedLight);
            Material material = new Material(Sheets.f_110740_, this.chooseLocationByType(type, chestBlock.getType()));
            VertexConsumer buffer = material.m_119194_(pBufferSource, RenderType::m_110446_);
            if (doubled) {
                if (type == ChestType.LEFT) {
                    this.render(pPoseStack, buffer, this.doubleLeftLid, this.doubleLeftLock, lidAngle, i, pPackedOverlay);
                } else {
                    this.render(pPoseStack, buffer, this.doubleRightLid, this.doubleRightLock, lidAngle, i, pPackedOverlay);
                }
            } else {
                this.render(pPoseStack, buffer, this.lid, this.lock, lidAngle, i, pPackedOverlay);
            }
            pPoseStack.m_85849_();
        }
    }

    private void render(PoseStack pPoseStack, VertexConsumer pConsumer, ModelPart pLidPart, ModelPart pLockPart, float pLidAngle, int pPackedLight, int pPackedOverlay) {
        pLockPart.f_104203_ = pLidPart.f_104203_ = -(pLidAngle * 1.5707964f);
        pLidPart.m_104301_(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pLockPart.m_104301_(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
    }

    protected ResourceLocation chooseLocationByType(ChestType chestType, ITree materialType) {
        if (chestType == ChestType.RIGHT) {
            return RIGHT_TEXTURES.get(materialType);
        }
        if (chestType == ChestType.LEFT) {
            return LEFT_TEXTURES.get(materialType);
        }
        return SINGLE_TEXTURES.get(materialType);
    }

    public static void stitchChestTextures(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)Sheets.f_110740_)) {
            return;
        }
        ImmutableMap.Builder singleBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder rightBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder leftBuilder = new ImmutableMap.Builder();
        for (ITree.Entry type : RegistriesNF.getTrees().getValues()) {
            singleBuilder.put((Object)type.value, (Object)ResourceLocation.fromNamespaceAndPath((String)type.getRegistryName().m_135827_(), (String)("entity/chest/" + type.getRegistryName().m_135815_() + "_chest_single")));
            rightBuilder.put((Object)type.value, (Object)ResourceLocation.fromNamespaceAndPath((String)type.getRegistryName().m_135827_(), (String)("entity/chest/" + type.getRegistryName().m_135815_() + "_chest_right")));
            leftBuilder.put((Object)type.value, (Object)ResourceLocation.fromNamespaceAndPath((String)type.getRegistryName().m_135827_(), (String)("entity/chest/" + type.getRegistryName().m_135815_() + "_chest_left")));
        }
        SINGLE_TEXTURES = singleBuilder.build();
        RIGHT_TEXTURES = rightBuilder.build();
        LEFT_TEXTURES = leftBuilder.build();
        for (ITree.Entry type : RegistriesNF.getTrees()) {
            event.addSprite(SINGLE_TEXTURES.get(type.value));
            event.addSprite(RIGHT_TEXTURES.get(type.value));
            event.addSprite(LEFT_TEXTURES.get(type.value));
        }
    }
}

