/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.mold.ItemMoldBlockEntity;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.registry.forge.FluidsNF;
import frostnox.nightfall.util.RenderUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class ItemMoldRenderer
implements BlockEntityRenderer<ItemMoldBlockEntity> {
    public ItemMoldRenderer(BlockEntityRendererProvider.Context renderer) {
    }

    public void render(ItemMoldBlockEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        int b;
        int g;
        int r;
        if (entity.getInputFluid().isEmpty()) {
            return;
        }
        stack.m_85836_();
        boolean isFluid = !entity.isCool();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(entity.getTemperature() > 500.0f ? entity.getInputFluid().getFluid().getAttributes().getStillTexture() : FluidsNF.METAL_SOLID);
        VertexConsumer builder = buffers.m_6299_(RenderType.m_110446_((ResourceLocation)sprite.m_118414_().m_118330_()));
        Matrix4f matrix = stack.m_85850_().m_85861_();
        Matrix3f normal = stack.m_85850_().m_85864_();
        TieredHeat heat = TieredHeat.fromTemp(entity.getTemperature());
        if (entity.getTemperature() >= TieredHeat.ORANGE.getBaseTemp()) {
            TieredHeat fromHeat = TieredHeat.fromTier(heat.getTier() + 1);
            Color toColor = heat.color;
            Color fromColor = fromHeat.color;
            float progress = 1.0f - (entity.getTemperature() - heat.getBaseTemp()) / (fromHeat.getBaseTemp() - heat.getBaseTemp());
            r = (int)Mth.m_14179_((float)progress, (float)fromColor.getRed(), (float)toColor.getRed());
            g = (int)Mth.m_14179_((float)progress, (float)fromColor.getGreen(), (float)toColor.getGreen());
            b = (int)Mth.m_14179_((float)progress, (float)fromColor.getBlue(), (float)toColor.getBlue());
        } else if (entity.getTemperature() >= 500.0f) {
            TieredHeat fromHeat = TieredHeat.fromTier(heat.getTier() + 1);
            Color fromColor = fromHeat.color;
            float progress = 1.0f - (entity.getTemperature() - 500.0f) / (fromHeat.getBaseTemp() - 500.0f);
            r = (int)Mth.m_14179_((float)progress, (float)fromColor.getRed(), (float)heat.color.getRed());
            g = (int)Mth.m_14179_((float)progress, (float)fromColor.getGreen(), (float)heat.color.getGreen());
            b = (int)Mth.m_14179_((float)progress, (float)fromColor.getBlue(), (float)heat.color.getBlue());
        } else {
            int color = entity.getInputFluid().getFluid().getAttributes().getColor();
            r = (color & 0xFF0000) >> 16;
            g = (color & 0xFF00) >> 8;
            b = color & 0xFF;
            if (heat == TieredHeat.RED) {
                float progress = 1.0f - (entity.getTemperature() - 100.0f) / 400.0f;
                r = (int)Mth.m_14179_((float)progress, (float)heat.color.getRed(), (float)r);
                g = (int)Mth.m_14179_((float)progress, (float)heat.color.getGreen(), (float)g);
                b = (int)Mth.m_14179_((float)progress, (float)heat.color.getBlue(), (float)b);
            }
        }
        float height = (float)entity.getInputFluid().getAmount() / (float)entity.getMaxUnits();
        AABB shape = entity.m_58900_().m_60808_((BlockGetter)entity.m_58904_(), entity.m_58899_()).m_83215_();
        float xSize = (float)shape.m_82362_() - 0.125f;
        float zSize = (float)shape.m_82385_() - 0.125f;
        Vec2 UV = new Vec2(sprite.m_118409_(), sprite.m_118411_());
        RenderUtil.drawFace(Direction.UP, matrix, normal, builder, new Color(r, g, b), new Vec3(0.5, 0.0625 + (shape.m_82376_() - 0.078125) * (double)height, 0.5), xSize, zSize, UV, 16.0f * xSize / (float)ClientEngine.get().atlasWidth, 16.0f * zSize / (float)ClientEngine.get().atlasHeight, isFluid ? 240 : combinedLight);
        stack.m_85849_();
    }
}

