/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.block.ITree;
import frostnox.nightfall.block.block.sign.SignBlockEntityNF;
import frostnox.nightfall.block.block.sign.StandingSignBlockNF;
import frostnox.nightfall.block.block.sign.WallSignBlockNF;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.registry.RegistriesNF;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;

@OnlyIn(value=Dist.CLIENT)
public class SignRendererNF
implements BlockEntityRenderer<SignBlockEntityNF> {
    public static final int MAX_LINE_WIDTH = 90;
    private static final int LINE_HEIGHT = 10;
    private static final int BLACK_TEXT_OUTLINE_COLOR = -988212;
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private static Map<ITree, ResourceLocation> TEXTURES;
    private final Font font;
    private final SignRenderer.SignModel standingModel;
    private final SignRenderer.SignModel wallModel;

    public SignRendererNF(BlockEntityRendererProvider.Context pContext) {
        this.font = pContext.m_173586_();
        this.standingModel = new SignRenderer.SignModel(pContext.m_173582_(ModelRegistryNF.SIGN));
        this.wallModel = new SignRenderer.SignModel(pContext.m_173582_(ModelRegistryNF.SIGN));
    }

    public void render(SignBlockEntityNF pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        int l;
        boolean flag;
        int k;
        Material material;
        SignRenderer.SignModel model;
        BlockState blockstate = pBlockEntity.m_58900_();
        pPoseStack.m_85836_();
        Block block = blockstate.m_60734_();
        if (block instanceof StandingSignBlockNF) {
            StandingSignBlockNF standingSign = (StandingSignBlockNF)block;
            model = this.standingModel;
            material = new Material(Sheets.f_110739_, TEXTURES.get(standingSign.type));
            pPoseStack.m_85837_(0.5, 0.5, 0.5);
            float f1 = -((float)((Integer)blockstate.m_61143_((Property)StandingSignBlock.f_56987_) * 360) / 16.0f);
            pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(f1));
            model.f_112507_.f_104207_ = true;
        } else {
            WallSignBlockNF wallSign = (WallSignBlockNF)blockstate.m_60734_();
            model = this.wallModel;
            material = new Material(Sheets.f_110739_, TEXTURES.get(wallSign.type));
            pPoseStack.m_85837_(0.5, 0.5, 0.5);
            float f4 = -((Direction)blockstate.m_61143_((Property)WallSignBlock.f_58064_)).m_122435_();
            pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(f4));
            pPoseStack.m_85837_(0.0, -0.3125, -0.4375);
            model.f_112507_.f_104207_ = false;
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        VertexConsumer vertexconsumer = material.m_119194_(pBufferSource, arg_0 -> ((SignRenderer.SignModel)model).m_103119_(arg_0));
        model.f_173655_.m_104301_(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        pPoseStack.m_85849_();
        pPoseStack.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
        pPoseStack.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
        int i = SignRendererNF.getDarkColor(pBlockEntity);
        FormattedCharSequence[] aformattedcharsequence = pBlockEntity.m_155717_(Minecraft.m_91087_().m_167974_(), p_173653_ -> {
            List list = this.font.m_92923_((FormattedText)p_173653_, 90);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (pBlockEntity.m_155727_()) {
            k = pBlockEntity.m_59753_().m_41071_();
            flag = SignRendererNF.isOutlineVisible(pBlockEntity, k);
            l = 0xF000F0;
        } else {
            k = i;
            flag = false;
            l = pPackedLight;
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
            float f3 = -this.font.m_92724_(formattedcharsequence) / 2;
            if (flag) {
                this.font.m_168645_(formattedcharsequence, f3, (float)(i1 * 10 - 20), k, i, pPoseStack.m_85850_().m_85861_(), pBufferSource, l);
                continue;
            }
            this.font.m_92733_(formattedcharsequence, f3, (float)(i1 * 10 - 20), k, false, pPoseStack.m_85850_().m_85861_(), pBufferSource, false, 0, l);
        }
        pPoseStack.m_85849_();
    }

    private static boolean isOutlineVisible(SignBlockEntityNF pBlockEntity, int pTextColor) {
        if (pTextColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)pBlockEntity.m_58899_())) < (double)OUTLINE_RENDER_DISTANCE;
    }

    private static int getDarkColor(SignBlockEntityNF pBlockEntity) {
        int i = pBlockEntity.m_59753_().m_41071_();
        int j = (int)((double)NativeImage.m_85085_((int)i) * 0.4);
        int k = (int)((double)NativeImage.m_85103_((int)i) * 0.4);
        int l = (int)((double)NativeImage.m_85119_((int)i) * 0.4);
        return i == DyeColor.BLACK.m_41071_() && pBlockEntity.m_155727_() ? -988212 : NativeImage.m_84992_((int)0, (int)l, (int)k, (int)j);
    }

    public static void stitchSignTextures(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)Sheets.f_110739_)) {
            return;
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ITree.Entry type : RegistriesNF.getTrees().getValues()) {
            builder.put((Object)type.value, (Object)ResourceLocation.fromNamespaceAndPath((String)type.getRegistryName().m_135827_(), (String)("entity/sign/" + type.getRegistryName().m_135815_() + "_plank")));
        }
        TEXTURES = builder.build();
        for (ITree.Entry type : RegistriesNF.getTrees()) {
            event.addSprite(TEXTURES.get(type.value));
        }
    }

    public static ResourceLocation getTexture(ITree type) {
        return TEXTURES.get(type);
    }
}

