/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import frostnox.nightfall.block.block.anvil.TieredAnvilBlockEntity;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.TieredAnvilRecipe;
import frostnox.nightfall.registry.forge.FluidsNF;
import frostnox.nightfall.util.RenderUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TieredAnvilRenderer
implements BlockEntityRenderer<TieredAnvilBlockEntity> {
    private static final Color SLAG_COLOR = new Color(48, 43, 50);

    public TieredAnvilRenderer(BlockEntityRendererProvider.Context renderer) {
    }

    public void render(TieredAnvilBlockEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        stack.m_85836_();
        if (entity.getRotationDegrees() != 0.0f) {
            stack.m_85837_(0.5, 0.5, 0.5);
            stack.m_85845_(Vector3f.f_122225_.m_122240_(entity.getRotationDegrees()));
            stack.m_85837_(-0.5, -0.5, -0.5);
        }
        if (!entity.getResult().m_41619_()) {
            if (entity.getResult().m_41720_() instanceof BlockItem) {
                stack.m_85837_(0.5, 1.125, 0.5);
            } else {
                stack.m_85837_(0.5, 1.015625, 0.5);
                stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            }
            stack.m_85841_(0.5f, 0.5f, 0.5f);
            Minecraft.m_91087_().m_91291_().m_174269_(entity.getResult(), ItemTransforms.TransformType.FIXED, entity.m_58898_() ? LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_58904_(), (BlockPos)entity.m_58899_().m_7494_()) : 0xF000F0, combinedOverlay, stack, buffers, (int)entity.m_58899_().m_121878_());
        } else {
            stack.m_85837_((double)entity.getWorldGridOffset().m_122239_(), (double)entity.getWorldGridOffset().m_122260_(), (double)entity.getWorldGridOffset().m_122269_());
            if (entity.gridColors[0][0][0] != null) {
                for (int x = 0; x < 14; ++x) {
                    for (int y = 0; y < 6; ++y) {
                        for (int z = 0; z < 8; ++z) {
                            boolean slag = entity.slag[x][y][z];
                            if (!entity.grid[x][y][z] && !slag) continue;
                            RenderUtil.drawMicroGridCube(stack, buffers, slag ? SLAG_COLOR : entity.gridColors[x][y][z], 0xF000F0, 0.0625f, entity.grid, x, y, z, (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(FluidsNF.METAL_SOLID));
                        }
                    }
                }
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (entity.inProgress && entity.m_58904_() != null && entity.getRecipeID() != null && entity.m_58904_().m_7465_().m_44043_(entity.getRecipeID()).isPresent() && player != null && player.m_6084_() && entity.m_58899_().m_203193_((Position)player.m_20318_(partialTicks)) <= 9.0 && (player.m_21205_().m_204117_(TagsNF.HAMMER) || player.m_21206_().m_204117_(TagsNF.HAMMER))) {
                Vec3i hitPos = ClientEngine.get().microHitResult;
                boolean hitNull = hitPos == null || !ClientEngine.get().microBlockEntityPos.equals((Object)entity.m_58899_());
                int hitX = 0;
                int hitY = 0;
                int hitZ = 0;
                if (!hitNull) {
                    hitX = hitPos.m_123341_();
                    hitY = hitPos.m_123342_();
                    hitZ = hitPos.m_123343_();
                }
                TieredAnvilRecipe recipe = (TieredAnvilRecipe)entity.m_58904_().m_7465_().m_44043_(entity.getRecipeID()).get();
                boolean[][][] finishShape = recipe.getFinishShape();
                for (int x = 0; x < 14; ++x) {
                    for (int y = 0; y < 6; ++y) {
                        for (int z = 0; z < 8; ++z) {
                            if (!hitNull && x == hitX && y == hitY && z == hitZ || entity.grid[x][y][z] == finishShape[x][y][z]) continue;
                            double cubeX = (double)x / 16.0;
                            double cubeY = (double)y / 16.0;
                            double cubeZ = (double)z / 16.0;
                            VoxelShape cube = Shapes.m_166049_((double)cubeX, (double)cubeY, (double)cubeZ, (double)(cubeX + 0.0625), (double)(cubeY + 0.0625), (double)(cubeZ + 0.0625));
                            Color color = entity.grid[x][y][z] ? Color.RED : Color.WHITE;
                            RenderUtil.drawMicroGridCubeOutline(stack, buffers, color, cube, hitNull);
                        }
                    }
                }
            }
        }
        stack.m_85849_();
    }
}

