/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.monster.UndeadEntity;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.math.Easing;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class AnimatedMobRenderer<T extends ActionableEntity, M extends AnimatedModel<T>>
extends MobRenderer<T, M> {
    public AnimatedMobRenderer(EntityRendererProvider.Context renderer, M entity, float shadowRadius) {
        super(renderer, entity, shadowRadius);
    }

    public void render(T entity, float p_225623_2_, float partialTick, PoseStack matrix, MultiBufferSource buffers, int light) {
        Entity leashHolder;
        Direction direction;
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(entity, (LivingEntityRenderer)this, partialTick, matrix, buffers, light))) {
            return;
        }
        matrix.m_85836_();
        ((AnimatedModel)this.f_115290_).f_102608_ = this.m_115342_((LivingEntity)entity, partialTick);
        ((AnimatedModel)this.f_115290_).f_102609_ = shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        ((AnimatedModel)this.f_115290_).f_102610_ = entity.m_6162_();
        float f = Mth.m_14189_((float)partialTick, (float)((ActionableEntity)((Object)entity)).f_20884_, (float)((ActionableEntity)((Object)entity)).f_20883_);
        float f1 = Mth.m_14189_((float)partialTick, (float)((ActionableEntity)((Object)entity)).f_20886_, (float)((ActionableEntity)((Object)entity)).f_20885_);
        float f2 = f1 - f;
        if (shouldSit && entity.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.m_20202_();
            f = Mth.m_14189_((float)partialTick, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)partialTick, (float)((ActionableEntity)((Object)entity)).f_19860_, (float)entity.m_146909_());
        if (entity.m_20089_() == Pose.SLEEPING && (direction = entity.m_21259_()) != null) {
            float f4 = entity.m_20236_(Pose.STANDING) - 0.1f;
            matrix.m_85837_((double)((float)(-direction.m_122429_()) * f4), 0.0, (double)((float)(-direction.m_122431_()) * f4));
        }
        float f7 = this.m_6930_((LivingEntity)entity, partialTick);
        this.setupRotations(entity, matrix, f7, f, partialTick);
        matrix.m_85841_(-1.0f, -1.0f, 1.0f);
        this.m_7546_((LivingEntity)entity, matrix, partialTick);
        matrix.m_85837_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entity.m_6084_()) {
            if (((ActionableEntity)((Object)entity)).f_20924_ == 1.5f) {
                ((ActionableEntity)((Object)entity)).f_20924_ = ((ActionableEntity)((Object)entity)).f_20923_;
            }
            f8 = Mth.m_14179_((float)partialTick, (float)((ActionableEntity)((Object)entity)).f_20923_, (float)((ActionableEntity)((Object)entity)).f_20924_);
            f5 = ((ActionableEntity)((Object)entity)).f_20925_ - ((ActionableEntity)((Object)entity)).f_20924_ * (1.0f - partialTick);
            if (entity.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((AnimatedModel)this.f_115290_).m_6839_((Entity)entity, f5, f8, partialTick);
        ((AnimatedModel)this.f_115290_).m_6973_((Entity)entity, f5, f8, f7, f2, f6);
        ((AnimatedModel)this.f_115290_).doCombatAnimations(entity, matrix);
        Minecraft minecraft = Minecraft.m_91087_();
        float alpha = this.getAlpha(entity);
        boolean flag = this.m_5933_((LivingEntity)entity);
        boolean flag1 = !flag && !entity.m_20177_((Player)minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_(entity);
        RenderType renderType = this.m_7225_((LivingEntity)entity, flag, flag1 || alpha < 1.0f, flag2);
        if (renderType != null) {
            VertexConsumer ivertexbuilder = buffers.m_6299_(renderType);
            int i = AnimationUtil.getOverlayCoords(entity, this.m_6931_((LivingEntity)entity, partialTick));
            ((AnimatedModel)this.f_115290_).m_7695_(matrix, ivertexbuilder, light, i, 1.0f, 1.0f, 1.0f, alpha);
        }
        if (!entity.m_5833_()) {
            for (RenderLayer layerrenderer : this.f_115291_) {
                layerrenderer.m_6494_(matrix, buffers, light, entity, f5, f8, partialTick, f7, f2, f6);
            }
        }
        matrix.m_85849_();
        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent(entity, entity.m_5446_(), (EntityRenderer)this, matrix, buffers, light, partialTick);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.m_6512_((Mob)entity))) {
            this.m_7649_((Entity)entity, renderNameplateEvent.getContent(), matrix, buffers, light);
        }
        if ((leashHolder = entity.m_21524_()) != null) {
            this.m_115461_((Mob)entity, partialTick, matrix, buffers, leashHolder);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(entity, (LivingEntityRenderer)this, partialTick, matrix, buffers, light));
    }

    protected void setupRotations(T pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        Pose pose;
        if (this.m_5936_((LivingEntity)pEntityLiving)) {
            pRotationYaw += (float)(Math.cos((double)((ActionableEntity)((Object)pEntityLiving)).f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = pEntityLiving.m_20089_()) != Pose.SLEEPING) {
            pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - pRotationYaw));
        }
        if (((ActionableEntity)((Object)pEntityLiving)).f_20919_ > 0) {
            float f;
            UndeadEntity undead;
            if (pEntityLiving instanceof UndeadEntity && (undead = (UndeadEntity)((Object)pEntityLiving)).isResurrecting()) {
                f = AnimationUtil.applyEasing(Mth.m_14036_((float)(((float)((ActionableEntity)((Object)pEntityLiving)).f_20919_ - pPartialTicks + 1.0f) / 20.0f), (float)0.0f, (float)1.0f), Easing.inOutSine);
            } else {
                f = ((float)((ActionableEntity)((Object)pEntityLiving)).f_20919_ + pPartialTicks - 1.0f) / 20.0f * 1.6f;
                if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                    f = 1.0f;
                }
            }
            int dir = ((ActionableEntity)((Object)pEntityLiving)).getSynchedRandom() % 2 == 0 ? 1 : -1;
            EntityDimensions dimensions = pEntityLiving.m_6095_().m_20680_();
            pMatrixStack.m_85845_(Vector3f.f_122227_.m_122240_(f * this.m_6441_((LivingEntity)pEntityLiving) * (float)dir));
            pMatrixStack.m_85837_((double)(dimensions.f_20377_ / 4.0f * f * (float)dir), (double)(-dimensions.f_20378_ / 2.0f * f), 0.0);
        } else if (AnimatedMobRenderer.m_194453_(pEntityLiving)) {
            pMatrixStack.m_85837_(0.0, (double)(pEntityLiving.m_20206_() + 0.1f), 0.0);
            pMatrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
    }

    protected float getAlpha(T entity) {
        return !this.m_5933_((LivingEntity)entity) && !entity.m_20177_((Player)Minecraft.m_91087_().f_91074_) ? 0.15f : 1.0f;
    }
}

