/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.client.model.entity.ArmorStandDummyModel;
import frostnox.nightfall.client.render.entity.layer.ArmorLayer;
import frostnox.nightfall.client.render.entity.layer.EquipmentLayer;
import frostnox.nightfall.client.render.entity.layer.HeldItemLayer;
import frostnox.nightfall.entity.entity.ArmorStandDummyEntity;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ArmorStandDummyRenderer
extends LivingEntityRenderer<ArmorStandDummyEntity, ArmorStandDummyModel> {
    private static final Map<String, ResourceLocation> TEXTURE_CACHE = Maps.newHashMap();

    public ArmorStandDummyRenderer(EntityRendererProvider.Context renderer) {
        super(renderer, (EntityModel)new ArmorStandDummyModel(renderer.m_174023_(ModelRegistryNF.ARMOR_STAND)), 0.0f);
        this.m_115326_(new ArmorLayer(this, renderer));
        this.m_115326_((RenderLayer)new HeldItemLayer(this));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, renderer.m_174027_()));
        this.m_115326_((RenderLayer)new EquipmentLayer(this, renderer));
    }

    public ResourceLocation getTextureLocation(ArmorStandDummyEntity pEntity) {
        String key = pEntity.getMaterial();
        ResourceLocation texture = TEXTURE_CACHE.get(key);
        if (texture == null) {
            int split = key.indexOf(":");
            String nameSpace = key.substring(0, split);
            String name = key.substring(split + 1);
            texture = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)("textures/entity/armorstand/" + name + ".png"));
            TEXTURE_CACHE.put(key, texture);
        }
        return texture;
    }

    protected void setupRotations(ArmorStandDummyEntity pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - pRotationYaw));
        float f = (float)(pEntityLiving.f_19853_.m_46467_() - pEntityLiving.lastHit) + pPartialTicks;
        if (f < 5.0f) {
            pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14031_((float)(f / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }

    protected boolean shouldShowName(ArmorStandDummyEntity pEntity) {
        double d0 = this.f_114476_.m_114471_((Entity)pEntity);
        float f = pEntity.m_6047_() ? 32.0f : 64.0f;
        return !(d0 >= (double)(f * f)) && pEntity.m_20151_();
    }

    @Nullable
    protected RenderType getRenderType(ArmorStandDummyEntity pLivingEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        if (!pLivingEntity.isMarker()) {
            return super.m_7225_((LivingEntity)pLivingEntity, pBodyVisible, pTranslucent, pGlowing);
        }
        ResourceLocation resourcelocation = this.getTextureLocation(pLivingEntity);
        if (pTranslucent) {
            return RenderType.m_110454_((ResourceLocation)resourcelocation, (boolean)false);
        }
        return pBodyVisible ? RenderType.m_110443_((ResourceLocation)resourcelocation, (boolean)false) : null;
    }

    protected void scale(ArmorStandDummyEntity pLivingEntity, PoseStack pMatrixStack, float pPartialTickTime) {
        float f = 0.9375f;
        pMatrixStack.m_85841_(f, f, f);
    }
}

