/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.entity.entity.BoatEntity;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class BoatRendererNF
extends BoatRenderer {
    protected final BoatModel model;
    private static final Map<String, Pair<ResourceLocation, BoatModel>> TEXTURE_CACHE = Maps.newHashMap();

    public BoatRendererNF(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new BoatModel(pContext.m_174023_(ModelRegistryNF.BOAT));
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(Boat boat) {
        String key = ((BoatEntity)boat).getMaterial();
        Pair pair = TEXTURE_CACHE.get(key);
        if (pair == null) {
            int split = key.indexOf(":");
            String nameSpace = key.substring(0, split);
            String name = key.substring(split + 1);
            pair = Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)("textures/entity/boat/" + name + ".png")), (Object)this.model);
            TEXTURE_CACHE.put(key, (Pair<ResourceLocation, BoatModel>)pair);
        }
        return pair;
    }

    public static LayerDefinition createModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bottom = partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-14.0f, -8.0f, 0.0f, 28.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition front = partdefinition.m_171599_("front", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171480_().m_171488_(-10.0f, -3.0f, -1.0f, 20.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition back = partdefinition.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171480_().m_171488_(-10.0f, -3.0f, -1.0f, 20.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition right = partdefinition.m_171599_("right", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171480_().m_171488_(-14.0f, -3.0f, -1.0f, 28.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-9.0f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        PartDefinition left = partdefinition.m_171599_("left", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171480_().m_171488_(-14.0f, -3.0f, -1.0f, 28.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)9.0f));
        PartDefinition paddle_left = partdefinition.m_171599_("left_paddle", CubeListBuilder.m_171558_().m_171514_(67, 4).m_171480_().m_171488_(-0.5f, -1.0f, -5.5f, 1.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(62, 0).m_171480_().m_171488_(-0.51f, -3.0f, 8.5f, 1.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)-4.0f, (float)9.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition paddle_right = partdefinition.m_171599_("right_paddle", CubeListBuilder.m_171558_().m_171514_(67, 4).m_171480_().m_171488_(-0.5f, -1.0f, -5.5f, 1.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(62, 0).m_171480_().m_171488_(-0.49f, -3.0f, 8.5f, 1.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.5f, (float)-4.0f, (float)-9.0f, (float)-0.5236f, (float)3.1416f, (float)0.0f));
        partdefinition.m_171599_("water_patch", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }
}

