/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.client.model.entity.CreeperModel;
import frostnox.nightfall.client.render.entity.AnimatedMobRenderer;
import frostnox.nightfall.entity.entity.monster.CreeperEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CreeperRenderer
extends AnimatedMobRenderer<CreeperEntity, CreeperModel> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/entity/creeper/creeper.png");

    public CreeperRenderer(EntityRendererProvider.Context renderer) {
        super(renderer, new CreeperModel(renderer.m_174023_(ModelRegistryNF.CREEPER)), 0.5f);
    }

    protected void scale(CreeperEntity creeper, PoseStack stack, float pPartialTickTime) {
        float swelling = creeper.getSwelling(pPartialTickTime);
        float f = 1.0f + Mth.m_14031_((float)(swelling * 100.0f)) * swelling * 0.01f;
        swelling = Mth.m_14036_((float)swelling, (float)0.0f, (float)1.0f);
        swelling *= swelling;
        swelling *= swelling;
        float xzScale = (1.0f + swelling * 0.4f) * f;
        float yScale = (1.0f + swelling * 0.1f) / f;
        stack.m_85841_(xzScale, yScale, xzScale);
    }

    protected float getWhiteOverlayProgress(CreeperEntity creeper, float pPartialTicks) {
        if (!creeper.m_6084_() || creeper.getActionTracker().isStunned()) {
            return 0.0f;
        }
        float swelling = creeper.getSwelling(pPartialTicks);
        return (int)(swelling * 6.0f) % 2 == 0 ? 0.0f : Mth.m_14036_((float)swelling, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(CreeperEntity pEntity) {
        return TEXTURE;
    }
}

