/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity;

import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.client.model.entity.DrakefowlModel;
import frostnox.nightfall.client.render.entity.AnimatedMobRenderer;
import frostnox.nightfall.entity.Sex;
import frostnox.nightfall.entity.entity.animal.DrakefowlEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class DrakefowlRenderer
extends AnimatedMobRenderer<DrakefowlEntity, DrakefowlModel> {
    public static final ResourceLocation BRONZE_MALE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/entity/drakefowl/bronze_male.png");
    public static final ResourceLocation EMERALD_MALE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/entity/drakefowl/emerald_male.png");
    public static final ResourceLocation BRONZE_FEMALE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/entity/drakefowl/bronze_female.png");
    public static final ResourceLocation EMERALD_FEMALE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/entity/drakefowl/emerald_female.png");
    public static final ResourceLocation BRONZE_SPECIAL = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/entity/drakefowl/bronze_special.png");
    public static final ResourceLocation EMERALD_SPECIAL = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/entity/drakefowl/emerald_special.png");

    public DrakefowlRenderer(EntityRendererProvider.Context renderer) {
        super(renderer, new DrakefowlModel(renderer.m_174023_(ModelRegistryNF.DRAKEFOWL)), 0.25f);
    }

    public ResourceLocation getTextureLocation(DrakefowlEntity pEntity) {
        if (pEntity.isSpecial()) {
            return switch (pEntity.getDrakefowlType()) {
                default -> throw new IncompatibleClassChangeError();
                case DrakefowlEntity.Type.BRONZE -> BRONZE_SPECIAL;
                case DrakefowlEntity.Type.EMERALD -> EMERALD_SPECIAL;
            };
        }
        return switch (pEntity.getDrakefowlType()) {
            default -> throw new IncompatibleClassChangeError();
            case DrakefowlEntity.Type.BRONZE -> {
                if (pEntity.sex == Sex.MALE) {
                    yield BRONZE_MALE;
                }
                yield BRONZE_FEMALE;
            }
            case DrakefowlEntity.Type.EMERALD -> pEntity.sex == Sex.MALE ? EMERALD_MALE : EMERALD_FEMALE;
        };
    }
}

