/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.entity.EctoplasmInnerModel;
import frostnox.nightfall.client.model.entity.EctoplasmOuterModel;
import frostnox.nightfall.client.render.entity.AnimatedMobRenderer;
import frostnox.nightfall.client.render.entity.layer.EctoplasmBodyLayer;
import frostnox.nightfall.entity.entity.monster.EctoplasmEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.math.Easing;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EctoplasmRenderer
extends AnimatedMobRenderer<EctoplasmEntity, AnimatedModel<EctoplasmEntity>> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/entity/ectoplasm/ectoplasm.png");

    public EctoplasmRenderer(EntityRendererProvider.Context renderer, float shadowRadius, ModelLayerLocation inner, ModelLayerLocation outerInner, ModelLayerLocation outer) {
        super(renderer, new EctoplasmInnerModel(renderer.m_174023_(inner)), shadowRadius);
        this.m_115326_(new EctoplasmBodyLayer((RenderLayerParent<EctoplasmEntity, AnimatedModel<EctoplasmEntity>>)this, new EctoplasmOuterModel(renderer.m_174023_(outerInner))));
        this.m_115326_(new EctoplasmBodyLayer((RenderLayerParent<EctoplasmEntity, AnimatedModel<EctoplasmEntity>>)this, new EctoplasmOuterModel(renderer.m_174023_(outer))));
    }

    protected int getBlockLightLevel(EctoplasmEntity pEntity, BlockPos pPos) {
        return 15;
    }

    protected float getFlipDegrees(EctoplasmEntity pLivingEntity) {
        return 0.0f;
    }

    @Override
    protected void setupRotations(EctoplasmEntity pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        if (this.m_5936_((LivingEntity)pEntityLiving)) {
            pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-((float)(Math.cos((double)pEntityLiving.f_19797_ * 3.25) * Math.PI * (double)0.4f))));
        }
        if (EctoplasmRenderer.m_194453_((LivingEntity)pEntityLiving)) {
            pMatrixStack.m_85837_(0.0, (double)(pEntityLiving.m_20206_() + 0.1f), 0.0);
            pMatrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
    }

    protected void scale(EctoplasmEntity entity, PoseStack pMatrixStack, float pPartialTickTime) {
        float highestProgress = 0.0f;
        if (ActionTracker.isPresent((Entity)entity)) {
            float progress;
            IActionTracker capA = entity.getActionTracker();
            float animScale = 0.25f;
            if (capA.isStunned()) {
                progress = AnimationUtil.getStunProgress(capA.getStunFrame(), capA.getStunDuration(), pPartialTickTime);
                if (capA.getStunFrame() < capA.getStunDuration() / 2) {
                    progress = Easing.outQuart.apply(progress);
                } else {
                    Easing.inOutSine.apply(progress);
                }
                animScale *= capA.getStunFrame() < capA.getStunDuration() / 2 ? 1.0f - progress : 0.0f;
                progress *= 0.08f;
                if (progress > highestProgress) {
                    highestProgress = progress;
                }
            }
            if (capA.getState() <= 1 && (capA.getActionID().equals((Object)ActionsNF.ECTOPLASM_EXPLODE_LARGE.getId()) || capA.getActionID().equals((Object)ActionsNF.ECTOPLASM_EXPLODE_MEDIUM.getId())) && (progress = (capA.getState() == 0 ? Easing.inOutSine.apply(capA.getProgress(pPartialTickTime)) : Easing.inQuart.apply(1.0f - capA.getProgress(pPartialTickTime))) * animScale) > highestProgress) {
                highestProgress = progress;
            }
        }
        if (entity.f_20919_ > 0) {
            float progress = ((float)entity.f_20919_ + pPartialTickTime - 1.0f) / 20.0f * 1.6f;
            if (progress > 1.0f) {
                progress = 1.0f;
            }
            progress = Easing.outSine.apply(progress);
            if ((progress *= 0.25f) > highestProgress) {
                highestProgress = progress;
            }
        }
        if (highestProgress > 0.0f) {
            pMatrixStack.m_85841_(1.0f - highestProgress / 2.0f, 1.0f - highestProgress, 1.0f - highestProgress / 2.0f);
        }
    }

    public ResourceLocation getTextureLocation(EctoplasmEntity pEntity) {
        return TEXTURE;
    }
}

