/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public abstract class EntitySpriteRenderer<T extends Entity>
extends EntityRenderer<T> {
    protected final float halfSize;

    protected EntitySpriteRenderer(EntityRendererProvider.Context pContext, float shadowRadius, float shadowStrength) {
        this(pContext, 1.0f, shadowRadius, shadowStrength);
    }

    protected EntitySpriteRenderer(EntityRendererProvider.Context pContext, float size, float shadowRadius, float shadowStrength) {
        super(pContext);
        this.f_114477_ = shadowRadius;
        this.f_114478_ = shadowStrength;
        this.halfSize = size / 2.0f;
    }

    public void m_7392_(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack stack, MultiBufferSource bufferSource, int light) {
        stack.m_85836_();
        Quaternion quat = this.f_114476_.m_114470_();
        quat.m_80148_(Vector3f.f_122225_.m_122240_(180.0f));
        Vector3f[] vertices = new Vector3f[]{new Vector3f(-this.halfSize, -this.halfSize, 0.0f), new Vector3f(this.halfSize, -this.halfSize, 0.0f), new Vector3f(this.halfSize, this.halfSize, 0.0f), new Vector3f(-this.halfSize, this.halfSize, 0.0f)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vertex = vertices[i];
            vertex.m_122251_(quat);
        }
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110467_((ResourceLocation)this.m_5478_((Entity)pEntity)));
        stack.m_85837_(0.0, (double)this.halfSize, 0.0);
        PoseStack.Pose pose = stack.m_85850_();
        Matrix4f mat = pose.m_85861_();
        Matrix3f normal = pose.m_85864_();
        EntitySpriteRenderer.vertex(buffer, mat, normal, vertices[0], 0.0f, 1.0f, light);
        EntitySpriteRenderer.vertex(buffer, mat, normal, vertices[1], 1.0f, 1.0f, light);
        EntitySpriteRenderer.vertex(buffer, mat, normal, vertices[2], 1.0f, 0.0f, light);
        EntitySpriteRenderer.vertex(buffer, mat, normal, vertices[3], 0.0f, 0.0f, light);
        stack.m_85849_();
        super.m_7392_(pEntity, pEntityYaw, pPartialTicks, stack, bufferSource, light);
    }

    private static void vertex(VertexConsumer pBuffer, Matrix4f pMatrix, Matrix3f pMatrixNormal, Vector3f vertex, float pTexU, float pTexV, int pPackedLight) {
        pBuffer.m_85982_(pMatrix, vertex.m_122239_(), vertex.m_122260_(), vertex.m_122269_()).m_6122_(255, 255, 255, 255).m_7421_(pTexU, pTexV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_85977_(pMatrixNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

