/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.client.model.entity.JellyfishInnerModel;
import frostnox.nightfall.client.model.entity.JellyfishOuterModel;
import frostnox.nightfall.client.render.entity.AnimatedMobRenderer;
import frostnox.nightfall.client.render.entity.layer.TranslucentBodyLayer;
import frostnox.nightfall.entity.entity.ambient.JellyfishEntity;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;

public class JellyfishRenderer
extends AnimatedMobRenderer<JellyfishEntity, AnimatedModel<JellyfishEntity>> {
    protected static final float XZ_SCALE = 0.25f;
    protected static final float Y_SCALE = 0.05f;
    protected static final EnumMap<JellyfishEntity.Type, ResourceLocation> TEXTURES = new EnumMap(JellyfishEntity.Type.class);

    public JellyfishRenderer(EntityRendererProvider.Context renderer) {
        super(renderer, new JellyfishInnerModel(renderer.m_174023_(ModelRegistryNF.JELLYFISH_INNER)), 0.225f);
        this.m_115326_(new TranslucentBodyLayer(this, new JellyfishOuterModel(renderer.m_174023_(ModelRegistryNF.JELLYFISH_OUTER))));
    }

    protected int getBlockLightLevel(JellyfishEntity pEntity, BlockPos pPos) {
        return 15;
    }

    @Override
    protected void setupRotations(JellyfishEntity pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        float deathScale = 0.75f;
        if (!pEntityLiving.m_20072_()) {
            pMatrixStack.m_85837_(0.0, -0.5625, 0.0);
            deathScale = 1.39f;
        } else if (pEntityLiving.getJellyfishType() == JellyfishEntity.Type.MOON) {
            pMatrixStack.m_85837_(0.0, -0.4375, 0.0);
            deathScale = 1.25f;
        }
        if (pEntityLiving.f_20919_ > 0) {
            float f = ((float)pEntityLiving.f_20919_ + pPartialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            int dir = pEntityLiving.getSynchedRandom() % 2 == 0 ? 1 : -1;
            EntityDimensions dimensions = pEntityLiving.m_6095_().m_20680_();
            pMatrixStack.m_85845_(Vector3f.f_122227_.m_122240_(f * this.getFlipDegrees(pEntityLiving) * (float)dir));
            pMatrixStack.m_85837_(0.0, (double)(-dimensions.f_20378_ * deathScale * f), 0.0);
        } else if (JellyfishRenderer.m_194453_((LivingEntity)pEntityLiving)) {
            pMatrixStack.m_85837_(0.0, (double)(pEntityLiving.m_20206_() + 0.1f), 0.0);
            pMatrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
    }

    protected float getFlipDegrees(JellyfishEntity pLivingEntity) {
        return 180.0f;
    }

    protected void scale(JellyfishEntity entity, PoseStack pMatrixStack, float pPartialTickTime) {
        float progress;
        int propulsion = entity.getPropulsionTicks();
        if (propulsion >= 0) {
            progress = Math.min(1.0f, Mth.m_14179_((float)pPartialTickTime, (float)(propulsion + 1), (float)propulsion) / 24.0f);
            if (entity.isDeflating()) {
                progress = Easing.inQuart.apply(progress);
                pMatrixStack.m_85841_(1.0f + progress * 0.25f, 1.0f + progress * 0.05f, 1.0f + progress * 0.25f);
            } else {
                progress = Easing.inOutCubic.apply(progress);
                pMatrixStack.m_85841_(1.25f - progress * 0.25f, 1.05f - progress * 0.05f, 1.25f - progress * 0.25f);
            }
        }
        if (entity.f_20919_ > 0) {
            progress = ((float)entity.f_20919_ + pPartialTickTime - 1.0f) / 20.0f * 1.6f;
            if (progress > 1.0f) {
                progress = 1.0f;
            }
            progress = Easing.outSine.apply(progress);
            pMatrixStack.m_85841_(1.0f - (progress *= 0.25f), 1.0f - progress, 1.0f - progress);
        }
    }

    public ResourceLocation getTextureLocation(JellyfishEntity pEntity) {
        return TEXTURES.get((Object)pEntity.getJellyfishType());
    }

    static {
        for (JellyfishEntity.Type type : JellyfishEntity.Type.values()) {
            TEXTURES.put(type, ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("textures/entity/jellyfish/" + type.name().toLowerCase() + ".png")));
        }
    }
}

