/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.block.IHoldable;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.client.model.entity.PlayerModelNF;
import frostnox.nightfall.client.render.entity.layer.ArmorLayer;
import frostnox.nightfall.client.render.entity.layer.PlayerEquipmentLayer;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.data.Vec3f;
import frostnox.nightfall.util.math.Easing;
import frostnox.nightfall.world.inventory.AccessorySlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PlayerRendererNF
extends PlayerRenderer {
    public PlayerModelNF<AbstractClientPlayer> newModel;
    public final boolean slim;

    public PlayerRendererNF(EntityRendererProvider.Context renderer) {
        this(renderer, false);
    }

    public PlayerRendererNF(EntityRendererProvider.Context renderer, boolean slim) {
        this(renderer, slim, (ImmutableMap<String, Vec3f>)ImmutableMap.of());
    }

    public PlayerRendererNF(EntityRendererProvider.Context renderer, boolean slim, ImmutableMap<String, Vec3f> layerScaleMap) {
        super(renderer, slim);
        this.newModel = new PlayerModelNF(renderer.m_174023_(slim ? ModelRegistryNF.PLAYER_SLIM : ModelRegistryNF.PLAYER), slim);
        this.slim = slim;
        for (int i = 0; i < this.f_115291_.size(); ++i) {
            if (this.f_115291_.get(i) instanceof ItemInHandLayer) {
                this.f_115291_.remove(i);
                this.f_115291_.add(i, new CombatHeldItemLayer(this));
                continue;
            }
            if (this.f_115291_.get(i) instanceof HumanoidArmorLayer) {
                this.f_115291_.remove(i);
                this.f_115291_.add(i, new ArmorLayer(this, renderer, layerScaleMap));
                continue;
            }
            if (this.f_115291_.get(i) instanceof CustomHeadLayer) {
                this.f_115291_.remove(i);
                this.f_115291_.add(i, new PlayerEquipmentLayer(this, renderer));
                continue;
            }
            if (!(this.f_115291_.get(i) instanceof ArrowLayer)) continue;
            this.f_115291_.remove(i);
            --i;
        }
        this.f_115291_.add(new HeldBlockEntityLayer(this));
    }

    public void m_7392_(AbstractClientPlayer player, float yaw, float partialTicks, PoseStack matrix, MultiBufferSource buffers, int light) {
        float tilt;
        Direction direction;
        float headPitch;
        boolean shouldSit;
        this.m_117818_(player);
        matrix.m_85836_();
        this.newModel.f_102608_ = this.m_115342_((LivingEntity)player, partialTicks);
        this.newModel.f_102609_ = shouldSit = player.m_20159_() && player.m_20202_() != null && player.m_20202_().shouldRiderSit();
        this.newModel.f_102610_ = player.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)player.f_20886_, (float)player.f_20885_);
        float headYaw = f1 - f;
        if (shouldSit && player.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)player.m_20202_();
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            headYaw = f1 - f;
            float f3 = Mth.m_14177_((float)headYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            headYaw = f1 - f;
        }
        float f2 = headPitch = player == Minecraft.m_91087_().f_91074_ ? player.m_146909_() : Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_());
        if (player.m_20089_() == Pose.SLEEPING && (direction = player.m_21259_()) != null) {
            float f4 = player.m_20236_(Pose.STANDING) - 0.1f;
            matrix.m_85837_((double)((float)(-direction.m_122429_()) * f4), 0.0, (double)((float)(-direction.m_122431_()) * f4));
        }
        float bobProgress = this.m_6930_((LivingEntity)player, partialTicks);
        this.m_7523_(player, matrix, bobProgress, f, partialTicks);
        matrix.m_85841_(-1.0f, -1.0f, 1.0f);
        this.m_7546_(player, matrix, partialTicks);
        matrix.m_85837_(0.0, (double)-1.501f, 0.0);
        if (player.m_6047_() && player.m_6084_() && PlayerData.get((Player)player).isCrawling()) {
            matrix.m_85837_(0.0, 0.0, 0.134 * (double)player.m_20998_(partialTicks));
        }
        if (player.m_20143_()) {
            matrix.m_85837_(0.0, 0.0, -0.18 * (double)player.m_20998_(partialTicks));
        }
        if (player.m_20143_() && !player.m_20069_() && (tilt = AnimationUtil.getAirborneProgress((Player)player, partialTicks)) > 0.0f) {
            tilt = AnimationUtil.applyEasing(tilt, Easing.inOutCubic);
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14179_((float)player.m_20998_(partialTicks), (float)0.0f, (float)75.0f) * tilt));
        }
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && player.m_6084_()) {
            if (player.f_20924_ == 1.5f) {
                player.f_20924_ = player.f_20923_;
            }
            limbSwingAmount = Mth.m_14179_((float)partialTicks, (float)player.f_20923_, (float)player.f_20924_);
            limbSwing = player.f_20925_ - player.f_20924_ * (1.0f - partialTicks);
            if (player.m_6162_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        this.newModel.m_6839_((LivingEntity)player, limbSwing, limbSwingAmount, partialTicks);
        this.newModel.setupAnim(player, limbSwing, limbSwingAmount, bobProgress, headYaw, headPitch);
        if (this.newModel.f_102818_ > 0.0f && player.m_20143_()) {
            matrix.m_85845_(Vector3f.f_122227_.m_122270_(this.newModel.f_102818_ * Mth.m_14089_((float)(limbSwing * 0.75f)) * 0.09f));
        }
        float yRot = this.newModel.doCombatAnimations((Player)player, matrix);
        if (player.m_6084_()) {
            IPlayerData capP = PlayerData.get((Player)player);
            float xAmount = CombatUtil.DodgeDirection.get(capP.getDodgeDirection()).getXAmount();
            float zAmount = CombatUtil.DodgeDirection.get(capP.getDodgeDirection()).getZAmount();
            float x = xAmount * Mth.m_14089_((float)yRot) - zAmount * Mth.m_14031_((float)yRot);
            float z = xAmount * Mth.m_14031_((float)yRot) + zAmount * Mth.m_14089_((float)yRot);
            if (player.f_19797_ - capP.getLastDodgeTick() >= 0 && player.f_19797_ - capP.getLastDodgeTick() < 4) {
                calc = new AnimationCalculator(3, player.f_19797_ - capP.getLastDodgeTick(), partialTicks, Easing.outQuart);
                matrix.m_85845_(Vector3f.f_122223_.m_122240_(x * 5.0f * calc.getProgress()));
                matrix.m_85845_(Vector3f.f_122227_.m_122240_(z * 5.0f * calc.getProgress()));
            } else if (player.f_19797_ - capP.getLastDodgeTick() < 7) {
                calc = new AnimationCalculator(3, player.f_19797_ - capP.getLastDodgeTick() - 4, partialTicks, Easing.inOutSine);
                matrix.m_85845_(Vector3f.f_122223_.m_122240_(x * 5.0f * (1.0f - calc.getProgress())));
                matrix.m_85845_(Vector3f.f_122227_.m_122240_(z * 5.0f * (1.0f - calc.getProgress())));
            }
        }
        this.newModel.f_102809_.m_104315_(this.newModel.f_102808_);
        this.newModel.f_103376_.m_104315_(this.newModel.f_102814_);
        this.newModel.f_103377_.m_104315_(this.newModel.f_102813_);
        this.newModel.leftSleeveN.m_104315_(this.newModel.leftHand);
        this.newModel.rightSleeveN.m_104315_(this.newModel.rightHand);
        this.newModel.f_103378_.m_104315_(this.newModel.f_102810_);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = this.m_5933_((LivingEntity)player);
        boolean flag1 = !flag && !player.m_20177_((Player)minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_((Entity)player);
        RenderType rendertype = this.m_7225_((LivingEntity)player, flag, flag1, flag2);
        this.newModel.f_102811_.f_104200_ = this.newModel.f_102811_.f_104200_ + (this.slim ? -0.5f : -1.0f);
        this.newModel.f_102812_.f_104200_ = this.newModel.f_102812_.f_104200_ + (this.slim ? 0.5f : 1.0f);
        if (rendertype != null) {
            VertexConsumer ivertexbuilder = buffers.m_6299_(rendertype);
            int i = AnimationUtil.getOverlayCoords((LivingEntity)player, this.m_6931_((LivingEntity)player, partialTicks));
            this.newModel.m_7695_(matrix, ivertexbuilder, light, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!player.m_5833_()) {
            for (RenderLayer layerrenderer : this.f_115291_) {
                layerrenderer.m_6494_(matrix, buffers, light, (Entity)player, limbSwing, limbSwingAmount, partialTicks, bobProgress, headYaw, headPitch);
            }
        }
        matrix.m_85849_();
        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent((Entity)player, player.m_5446_(), (EntityRenderer)this, matrix, buffers, light, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.shouldShowName(player))) {
            this.m_7649_(player, renderNameplateEvent.getContent(), matrix, buffers, light);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)player, (LivingEntityRenderer)this, partialTicks, matrix, buffers, light));
        MinecraftForge.EVENT_BUS.post((Event)new RenderPlayerEvent.Post((Player)player, (PlayerRenderer)this, partialTicks, matrix, buffers, light));
    }

    protected boolean shouldShowName(AbstractClientPlayer pEntity) {
        if (PlayerData.get((Player)pEntity).getAccessoryInventory().getItem(AccessorySlot.FACE).m_150930_((Item)ItemsNF.MASK.get())) {
            return false;
        }
        return super.m_6512_((LivingEntity)pEntity);
    }

    public PlayerModel<AbstractClientPlayer> getModel() {
        return this.newModel;
    }

    protected void m_117818_(AbstractClientPlayer player) {
        PlayerModelNF<AbstractClientPlayer> playermodel = this.newModel;
        if (player.m_5833_()) {
            playermodel.m_8009_(false);
            playermodel.f_102808_.f_104207_ = true;
            playermodel.f_102809_.f_104207_ = true;
        } else {
            playermodel.m_8009_(true);
            playermodel.f_102809_.f_104207_ = player.m_36170_(PlayerModelPart.HAT);
            playermodel.f_103378_.f_104207_ = player.m_36170_(PlayerModelPart.JACKET);
            playermodel.f_103376_.f_104207_ = player.m_36170_(PlayerModelPart.LEFT_PANTS_LEG);
            playermodel.f_103377_.f_104207_ = player.m_36170_(PlayerModelPart.RIGHT_PANTS_LEG);
            playermodel.f_103374_.f_104207_ = false;
            playermodel.f_103375_.f_104207_ = false;
            playermodel.leftSleeveN.f_104207_ = player.m_36170_(PlayerModelPart.LEFT_SLEEVE);
            playermodel.rightSleeveN.f_104207_ = player.m_36170_(PlayerModelPart.RIGHT_SLEEVE);
            playermodel.f_102817_ = player.m_6047_() && (!player.m_6084_() || !PlayerData.get((Player)player).isCrawling());
            HumanoidModel.ArmPose bipedmodel$armpose = PlayerRendererNF.m_117794_(player, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose bipedmodel$armpose1 = PlayerRendererNF.m_117794_(player, InteractionHand.OFF_HAND);
            if (bipedmodel$armpose.m_102897_()) {
                HumanoidModel.ArmPose armPose = bipedmodel$armpose1 = player.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                playermodel.f_102816_ = bipedmodel$armpose;
                playermodel.f_102815_ = bipedmodel$armpose1;
            } else {
                playermodel.f_102816_ = bipedmodel$armpose1;
                playermodel.f_102815_ = bipedmodel$armpose;
            }
        }
    }

    protected static HumanoidModel.ArmPose m_117794_(AbstractClientPlayer player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (player.m_7655_() == hand && player.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && hand == player.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!player.f_20911_ && itemstack.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    private static class CombatHeldItemLayer<T extends Player, M extends EntityModel<T> & ArmedModel>
    extends PlayerItemInHandLayer<T, M> {
        public CombatHeldItemLayer(RenderLayerParent<T, M> p_i50934_1_) {
            super(p_i50934_1_);
        }

        public void render(PoseStack p_225628_1_, MultiBufferSource p_225628_2_, int p_225628_3_, T p_225628_4_, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
            ItemStack itemstack1;
            boolean flag = p_225628_4_.m_5737_() == HumanoidArm.RIGHT;
            ItemStack itemstack = flag ? p_225628_4_.m_21206_() : p_225628_4_.m_21205_();
            ItemStack itemStack = itemstack1 = flag ? p_225628_4_.m_21205_() : p_225628_4_.m_21206_();
            if (!itemstack.m_41619_() || !itemstack1.m_41619_()) {
                p_225628_1_.m_85836_();
                this.m_117184_((LivingEntity)p_225628_4_, itemstack1, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, p_225628_1_, p_225628_2_, p_225628_3_);
                this.m_117184_((LivingEntity)p_225628_4_, itemstack, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, p_225628_1_, p_225628_2_, p_225628_3_);
                p_225628_1_.m_85849_();
            }
        }

        private void m_174517_(LivingEntity p_174518_, ItemStack p_174519_, HumanoidArm p_174520_, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_) {
            p_174521_.m_85836_();
            ModelPart modelpart = ((HeadedModel)this.m_117386_()).m_5585_();
            float f = modelpart.f_104203_;
            modelpart.f_104203_ = Mth.m_14036_((float)modelpart.f_104203_, (float)-0.5235988f, (float)1.5707964f);
            modelpart.m_104299_(p_174521_);
            modelpart.f_104203_ = f;
            CustomHeadLayer.m_174483_((PoseStack)p_174521_, (boolean)false);
            boolean flag = p_174520_ == HumanoidArm.LEFT;
            p_174521_.m_85837_((double)((flag ? -2.5f : 2.5f) / 16.0f), -0.0625, 0.0);
            Minecraft.m_91087_().m_91292_().m_109322_(p_174518_, p_174519_, ItemTransforms.TransformType.HEAD, false, p_174521_, p_174522_, p_174523_);
            p_174521_.m_85849_();
        }

        protected void m_117184_(LivingEntity user, ItemStack itemStack, ItemTransforms.TransformType p_229135_3_, HumanoidArm handSide, PoseStack stack, MultiBufferSource p_229135_6_, int p_229135_7_) {
            if (itemStack.m_150930_(Items.f_151059_) && user.m_21211_() == itemStack && user.f_20913_ == 0) {
                this.m_174517_(user, itemStack, handSide, stack, p_229135_6_, p_229135_7_);
            } else if (!itemStack.m_41619_()) {
                stack.m_85836_();
                ((ArmedModel)this.m_117386_()).m_6002_(handSide, stack);
                stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                boolean flag = handSide == HumanoidArm.LEFT;
                stack.m_85837_(0.0, 0.125, -0.625);
                if (((PlayerModelNF)this.m_117386_()).slim) {
                    stack.m_85837_(flag ? -0.03125 : 0.03125, 0.0, 0.0);
                }
                Minecraft.m_91087_().m_91292_().m_109322_(user, itemStack, p_229135_3_, flag, stack, p_229135_6_, p_229135_7_);
                stack.m_85849_();
            }
        }
    }

    private static class HeldBlockEntityLayer<T extends Player, M extends EntityModel<T> & ArmedModel>
    extends PlayerItemInHandLayer<T, M> {
        public HeldBlockEntityLayer(RenderLayerParent<T, M> p_i50934_1_) {
            super(p_i50934_1_);
        }

        public void render(PoseStack stack, MultiBufferSource pBuffer, int pPackedLight, T player, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            BlockState state;
            BlockEntity blockEntity;
            CompoundTag contents = PlayerData.get(player).getHeldContents();
            if (player.m_6084_() && !contents.m_128456_() && (blockEntity = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)(state = Block.m_49803_((int)contents.m_128451_("state"))), (CompoundTag)contents)) instanceof IHoldable) {
                int light;
                IHoldable holdable = (IHoldable)blockEntity;
                stack.m_85836_();
                stack.m_85841_(0.99f, 0.99f, 0.99f);
                stack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                float crouch = AnimationUtil.getCrouchProgress(player, pPartialTicks);
                double y = -0.625 + holdable.getThirdPersonYOffset();
                if (crouch > 0.0f) {
                    stack.m_85837_(-0.5, y - 0.1825 * (double)crouch, 0.125);
                } else {
                    stack.m_85837_(-0.5, y, 0.125);
                }
                int n = light = state.m_60788_((BlockGetter)((Player)player).f_19853_, player.m_142538_()) ? 0xF000F0 : pPackedLight;
                if (holdable.useBlockEntityItemRenderer()) {
                    BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(blockEntity);
                    renderer.m_6922_(blockEntity, pPartialTicks, stack, pBuffer, light, OverlayTexture.f_118083_);
                }
                Minecraft.m_91087_().m_91289_().renderSingleBlock(state, stack, pBuffer, light, OverlayTexture.f_118083_, blockEntity.getModelData());
                stack.m_85849_();
            }
        }
    }
}

