/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.client.model.entity.RockwormModel;
import frostnox.nightfall.client.render.entity.AnimatedMobRenderer;
import frostnox.nightfall.entity.entity.monster.RockwormEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.LightLayer;

public class RockwormRenderer
extends AnimatedMobRenderer<RockwormEntity, RockwormModel> {
    public static final ResourceLocation ROCKWORM_0 = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/entity/rockworm/rockworm_0.png");

    public RockwormRenderer(EntityRendererProvider.Context renderer) {
        super(renderer, new RockwormModel(renderer.m_174023_(ModelRegistryNF.ROCKWORM)), 0.3f);
    }

    protected int getSkyLightLevel(RockwormEntity pEntity, BlockPos pPos) {
        if (!pEntity.m_6084_()) {
            return super.m_114508_((Entity)pEntity, pPos);
        }
        return Math.max(super.m_114508_((Entity)pEntity, pPos), pEntity.f_19853_.m_45517_(LightLayer.SKY, pPos.m_7495_()));
    }

    protected int getBlockLightLevel(RockwormEntity pEntity, BlockPos pPos) {
        if (!pEntity.m_6084_()) {
            return super.m_6086_((Entity)pEntity, pPos);
        }
        return Math.max(super.m_6086_((Entity)pEntity, pPos), pEntity.f_19853_.m_45517_(LightLayer.BLOCK, pPos.m_7495_()));
    }

    @Override
    protected void setupRotations(RockwormEntity pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        Pose pose;
        if (this.m_5936_((LivingEntity)pEntityLiving)) {
            pRotationYaw += (float)(Math.cos((double)pEntityLiving.f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = pEntityLiving.m_20089_()) != Pose.SLEEPING) {
            pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - pRotationYaw));
        }
        if (RockwormRenderer.m_194453_((LivingEntity)pEntityLiving)) {
            pMatrixStack.m_85837_(0.0, (double)(pEntityLiving.m_20206_() + 0.1f), 0.0);
            pMatrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
    }

    public ResourceLocation getTextureLocation(RockwormEntity pEntity) {
        return ROCKWORM_0;
    }
}

