/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity.layer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.client.model.entity.AnimatedHumanoidModel;
import frostnox.nightfall.client.model.entity.ArmorModel;
import frostnox.nightfall.client.model.entity.PlayerModelNF;
import frostnox.nightfall.item.ITieredArmorMaterial;
import frostnox.nightfall.item.item.TieredArmorItem;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.util.data.Vec3f;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;

public class ArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final Map<ITieredArmorMaterial, ResourceLocation> TEXTURES = Maps.newHashMap();
    private static final Map<ITieredArmorMaterial, ResourceLocation> OVERLAY_TEXTURES = Maps.newHashMap();
    private static final Map<String, ResourceLocation> VANILLA_TEXTURES = Maps.newHashMap();
    private final Map<ITieredArmorMaterial, ArmorModel> MODEL_MAP = Maps.newHashMap();
    private final ArmorModel innerModel;
    private final ArmorModel outerModel;

    public ArmorLayer(RenderLayerParent<T, M> parentLayer, EntityRendererProvider.Context renderer, ImmutableMap<String, Vec3f> scaleMap) {
        super(parentLayer);
        this.innerModel = new ArmorModel(renderer.m_174023_(ModelRegistryNF.INNER_ARMOR), scaleMap);
        this.outerModel = new ArmorModel(renderer.m_174023_(ModelRegistryNF.OUTER_ARMOR), scaleMap);
        for (ITieredArmorMaterial.Entry material : RegistriesNF.getTieredArmorMaterials()) {
            boolean skip = false;
            for (ITieredArmorMaterial key : this.MODEL_MAP.keySet()) {
                if (!key.getStyledArmorName().equals(material.value.getStyledArmorName())) continue;
                this.MODEL_MAP.put(material.value, this.MODEL_MAP.get(key));
                skip = true;
                break;
            }
            if (skip) continue;
            this.MODEL_MAP.put(material.value, new ArmorModel(renderer.m_174023_(ModelRegistryNF.getArmor(material.value)), scaleMap));
        }
    }

    public ArmorLayer(RenderLayerParent<T, M> parentLayer, EntityRendererProvider.Context renderer) {
        this(parentLayer, renderer, (ImmutableMap<String, Vec3f>)ImmutableMap.of());
    }

    public void render(PoseStack p_225628_1_, MultiBufferSource p_225628_2_, int p_225628_3_, T p_225628_4_, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        this.renderArmorPiece(p_225628_1_, p_225628_2_, p_225628_4_, EquipmentSlot.CHEST, p_225628_3_);
        this.renderArmorPiece(p_225628_1_, p_225628_2_, p_225628_4_, EquipmentSlot.LEGS, p_225628_3_);
        this.renderArmorPiece(p_225628_1_, p_225628_2_, p_225628_4_, EquipmentSlot.FEET, p_225628_3_);
        this.renderArmorPiece(p_225628_1_, p_225628_2_, p_225628_4_, EquipmentSlot.HEAD, p_225628_3_);
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, T entity, EquipmentSlot slot, int light) {
        ItemStack itemStack = entity.m_6844_(slot);
        EquipmentSlot armorSlot = null;
        ArmorModel model = null;
        ResourceLocation loc = null;
        boolean vanilla = false;
        Item item = itemStack.m_41720_();
        if (item instanceof TieredArmorItem) {
            TieredArmorItem armor = (TieredArmorItem)item;
            armorSlot = armor.slot;
            model = this.getArmorModel((Entity)entity, armor, armorSlot);
            loc = this.getArmorResource(itemStack);
        } else {
            item = itemStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)item;
                armorSlot = armor.m_40402_();
                model = this.getVanillaArmorModel((Entity)entity, armor, armorSlot);
                loc = this.getVanillaArmorResource((Entity)entity, itemStack, slot, null);
                vanilla = true;
            }
        }
        if (armorSlot == slot) {
            item = this.m_117386_();
            if (item instanceof PlayerModelNF) {
                PlayerModelNF parentModel = (PlayerModelNF)item;
                parentModel.copyPropertiesTo(model);
            } else {
                item = this.m_117386_();
                if (item instanceof AnimatedHumanoidModel) {
                    AnimatedHumanoidModel parentModel = (AnimatedHumanoidModel)item;
                    parentModel.copyPropertiesTo(model);
                }
            }
            this.setPartVisibility(entity, model, slot, vanilla);
            boolean foil = itemStack.m_41790_();
            item = itemStack.m_41720_();
            if (item instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeable = (DyeableLeatherItem)item;
                int color = dyeable.m_41121_(itemStack);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                if (vanilla) {
                    this.renderModel(poseStack, bufferSource, light, foil, model, r, g, b, loc);
                    this.renderModel(poseStack, bufferSource, light, foil, model, 1.0f, 1.0f, 1.0f, this.getVanillaArmorResource((Entity)entity, itemStack, slot, "overlay"));
                    return;
                }
                this.renderModel(poseStack, bufferSource, light, foil, model, r, g, b, this.getArmorOverlayResource(itemStack));
            }
            this.renderModel(poseStack, bufferSource, light, foil, model, 1.0f, 1.0f, 1.0f, loc);
        }
    }

    protected ArmorModel getArmorModel(Entity entity, TieredArmorItem armor, EquipmentSlot slot) {
        return this.MODEL_MAP.get(armor.material);
    }

    protected ArmorModel getVanillaArmorModel(Entity entity, ArmorItem armor, EquipmentSlot slot) {
        return this.usesInnerModel(slot) ? this.innerModel : this.outerModel;
    }

    private void renderModel(PoseStack p_117107_, MultiBufferSource p_117108_, int light, boolean p_117111_, ArmorModel p_117112_, float p_117114_, float p_117115_, float p_117116_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)p_117108_, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)p_117111_);
        p_117112_.m_7695_(p_117107_, vertexconsumer, light, OverlayTexture.f_118083_, p_117114_, p_117115_, p_117116_, 1.0f);
    }

    private boolean usesInnerModel(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS;
    }

    protected void setPartVisibility(T entity, ArmorModel model, EquipmentSlot slot, boolean vanilla) {
        model.setAllVisible(false);
        switch (slot) {
            case HEAD: {
                model.bodyHeadJoint.f_104207_ = true;
                model.neck.f_104207_ = true;
                model.head.f_104207_ = true;
                break;
            }
            case CHEST: {
                model.body.f_104207_ = true;
                model.innerBody.f_104207_ = true;
                model.bodyRightArmJoint.f_104207_ = true;
                model.rightArm.f_104207_ = true;
                model.rightHand.f_104207_ = true;
                model.bodyLeftArmJoint.f_104207_ = true;
                model.leftArm.f_104207_ = true;
                model.leftHand.f_104207_ = true;
                model.rightSkirt.f_104207_ = true;
                model.leftSkirt.f_104207_ = true;
                break;
            }
            case LEGS: {
                model.body.f_104207_ = vanilla;
                model.innerBody.f_104207_ = entity.m_6844_(EquipmentSlot.CHEST).m_41619_();
                model.rightLeg.f_104207_ = true;
                model.leftLeg.f_104207_ = true;
                break;
            }
            case FEET: {
                if (vanilla) {
                    model.rightLeg.f_104207_ = true;
                    model.leftLeg.f_104207_ = true;
                    break;
                }
                model.rightFoot.f_104207_ = true;
                model.leftFoot.f_104207_ = true;
            }
        }
    }

    protected ResourceLocation getArmorResource(ItemStack stack) {
        TieredArmorItem item = (TieredArmorItem)stack.m_41720_();
        ITieredArmorMaterial material = item.material;
        ResourceLocation location = TEXTURES.get(material);
        if (location == null) {
            String path = material.getName();
            String domain = item.getRegistryName().m_135827_();
            int idx = path.indexOf(58);
            if (idx != -1) {
                domain = path.substring(0, idx);
                path = path.substring(idx + 1);
            }
            String string = String.format("%s:textures/models/armor/%s.png", domain, path);
            location = ResourceLocation.parse((String)string);
            TEXTURES.put(material, location);
        }
        return location;
    }

    protected ResourceLocation getArmorOverlayResource(ItemStack stack) {
        TieredArmorItem item = (TieredArmorItem)stack.m_41720_();
        ITieredArmorMaterial material = item.material;
        ResourceLocation location = OVERLAY_TEXTURES.get(material);
        if (location == null) {
            String path = material.getStyledArmorName();
            String domain = item.getRegistryName().m_135827_();
            int idx = path.indexOf(58);
            if (idx != -1) {
                domain = path.substring(0, idx);
                path = path.substring(idx + 1);
            }
            String string = String.format("%s:textures/models/armor/%s_overlay.png", domain, path);
            location = ResourceLocation.parse((String)string);
            OVERLAY_TEXTURES.put(material, location);
        }
        return location;
    }

    protected ResourceLocation getVanillaArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = VANILLA_TEXTURES.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = ResourceLocation.parse((String)s1);
            VANILLA_TEXTURES.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

