/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.client.model.entity.AttachedEntityModel;
import frostnox.nightfall.client.model.entity.IHumanoidModel;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.item.client.IAnimatedEquipment;
import frostnox.nightfall.item.item.TieredArmorItem;
import frostnox.nightfall.util.LevelUtil;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class EquipmentLayer<T extends LivingEntity, M extends EntityModel<T>>
extends CustomHeadLayer<T, M> {
    private static final Map<Item, ResourceLocation> TEXTURES = new Object2ObjectOpenHashMap();
    private static final Map<Item, ResourceLocation> DYED_OVERLAY_TEXTURES = new Object2ObjectOpenHashMap();
    private final Map<Item, AttachedEntityModel> MODEL_MAP = new Object2ObjectOpenHashMap();

    public EquipmentLayer(RenderLayerParent<T, M> parent, EntityRendererProvider.Context renderer) {
        super(parent, renderer.m_174027_());
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            Pair<EntityPart, ModelLayerLocation> data = ModelRegistryNF.getEquipment(item);
            if (data == null) continue;
            this.MODEL_MAP.put(item, new AttachedEntityModel(renderer.m_174023_((ModelLayerLocation)data.right()), (EntityPart)((Object)data.left())));
        }
    }

    public void m_6494_(PoseStack poseStack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        for (EquipmentSlot slot : LevelUtil.ARMOR_SLOTS) {
            Item item;
            ItemStack itemStack = entity.m_6844_(slot);
            if (itemStack.m_41619_() || itemStack.m_41720_() instanceof TieredArmorItem || (item = itemStack.m_41720_()) instanceof TieredArmorItem) continue;
            if (slot == EquipmentSlot.HEAD && !this.MODEL_MAP.containsKey(item)) {
                super.m_6494_(poseStack, buffer, light, entity, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch);
                continue;
            }
            this.renderItem(itemStack, this.MODEL_MAP.get(item), poseStack, buffer, light, entity, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch);
        }
    }

    protected void renderItem(ItemStack itemStack, AttachedEntityModel model, PoseStack poseStack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (model == null) {
            return;
        }
        poseStack.m_85836_();
        Item item = itemStack.m_41720_();
        EntityModel entityModel = this.m_117386_();
        if (entityModel instanceof IHumanoidModel) {
            IHumanoidModel parentModel = (IHumanoidModel)entityModel;
            model.copyFrom(parentModel.getModelPart(model.attachedPart));
        }
        if (item instanceof IAnimatedEquipment) {
            IAnimatedEquipment animated = (IAnimatedEquipment)item;
            animated.animate(model, itemStack, poseStack, buffer, light, (LivingEntity)entity, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch);
        }
        boolean foil = itemStack.m_41790_();
        if (item instanceof DyeableLeatherItem) {
            DyeableLeatherItem dyeable = (DyeableLeatherItem)item;
            int color = dyeable.m_41121_(itemStack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            this.renderModel(poseStack, buffer, light, foil, model, r, g, b, EquipmentLayer.getResource(item, true));
        }
        this.renderModel(poseStack, buffer, light, foil, model, 1.0f, 1.0f, 1.0f, EquipmentLayer.getResource(item, false));
        poseStack.m_85849_();
    }

    protected void renderModel(PoseStack stack, MultiBufferSource buffer, int light, boolean foil, AttachedEntityModel model, float r, float g, float b, ResourceLocation loc) {
        VertexConsumer consumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)model.m_103119_(loc), (boolean)false, (boolean)foil);
        model.m_7695_(stack, consumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
    }

    protected static ResourceLocation getResource(Item item, boolean overlay) {
        ResourceLocation location = (overlay ? DYED_OVERLAY_TEXTURES : TEXTURES).get(item);
        if (location == null) {
            ResourceLocation name = item.getRegistryName();
            Object path = overlay ? name.m_135815_() + "_overlay" : name.m_135815_();
            location = ResourceLocation.parse((String)String.format("%s:textures/models/equipment/%s.png", name.m_135827_(), path));
            (overlay ? DYED_OVERLAY_TEXTURES : TEXTURES).put(item, location);
        }
        return location;
    }
}

