/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.Humidity;
import frostnox.nightfall.block.Metal;
import frostnox.nightfall.block.SoilCover;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.block.block.ChairBlock;
import frostnox.nightfall.block.block.ClusterBlock;
import frostnox.nightfall.block.block.CoveredSoilBlock;
import frostnox.nightfall.block.block.CrossCollisionBlockNF;
import frostnox.nightfall.block.block.DoorBlockNF;
import frostnox.nightfall.block.block.FenceBlockNF;
import frostnox.nightfall.block.block.FenceGateBlockNF;
import frostnox.nightfall.block.block.HatchBlock;
import frostnox.nightfall.block.block.HeatablePileBlock;
import frostnox.nightfall.block.block.LadderBlockNF;
import frostnox.nightfall.block.block.SidingBlock;
import frostnox.nightfall.block.block.SlabBlockNF;
import frostnox.nightfall.block.block.StairBlockNF;
import frostnox.nightfall.block.block.TrapdoorBlockNF;
import frostnox.nightfall.block.block.TroughBlock;
import frostnox.nightfall.block.block.anvil.TieredAnvilBlock;
import frostnox.nightfall.block.block.barrel.BarrelBlockNF;
import frostnox.nightfall.block.block.campfire.CampfireBlockNF;
import frostnox.nightfall.block.block.cauldron.CauldronBlockNF;
import frostnox.nightfall.block.block.cauldron.Task;
import frostnox.nightfall.block.block.eggnest.EggNestBlock;
import frostnox.nightfall.block.block.fireable.FireablePartialBlock;
import frostnox.nightfall.block.block.nest.OverlayBurrowBlock;
import frostnox.nightfall.block.block.pile.PileBlock;
import frostnox.nightfall.block.block.tree.TreeBranchesBlock;
import frostnox.nightfall.block.block.tree.TreeSeedBlock;
import frostnox.nightfall.block.block.tree.TreeStemBlock;
import frostnox.nightfall.block.block.tree.TreeTrunkBlock;
import frostnox.nightfall.item.Armament;
import frostnox.nightfall.registry.forge.BlocksNF;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class BlockStateProviderNF
extends BlockStateProvider {
    protected final String externalPath;
    protected final DataGenerator generator;

    public BlockStateProviderNF(DataGenerator generator, String id, ExistingFileHelper helper) {
        super(generator, id, helper);
        this.generator = generator;
        String outputString = generator.m_123916_().toString();
        this.externalPath = outputString.substring(0, outputString.lastIndexOf("\\src\\")) + "\\src\\main\\resources\\assets\\" + id + "\\models\\";
    }

    protected Path getExternalImagePath(ResourceLocation loc) {
        return this.generator.m_123916_().getFileSystem().getPath(this.externalPath + loc.m_135815_() + ".json", new String[0]);
    }

    protected ResourceLocation extendWithFolder(ResourceLocation location) {
        if (location.m_135815_().contains("/")) {
            return location;
        }
        return ResourceLocation.fromNamespaceAndPath((String)location.m_135827_(), (String)("block/" + location.m_135815_()));
    }

    protected ModelFile file(Block block) {
        return new ModelFile.ExistingModelFile(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("block/" + block.getRegistryName().m_135815_())), this.models().existingFileHelper);
    }

    protected ModelFile file(Block block, String suffix) {
        return new ModelFile.ExistingModelFile(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("block/" + block.getRegistryName().m_135815_() + suffix)), this.models().existingFileHelper);
    }

    protected String name(Block block) {
        return block.getRegistryName().m_135815_();
    }

    protected ResourceLocation resource(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("block/" + name));
    }

    protected ResourceLocation resource(Block block) {
        return ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("block/" + block.getRegistryName().m_135815_()));
    }

    protected ResourceLocation resource(Block block, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("block/" + block.getRegistryName().m_135815_() + suffix));
    }

    protected ResourceLocation resource(String prefix, Block block, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("block/" + prefix + block.getRegistryName().m_135815_() + suffix));
    }

    public void fileBlock(Block block) {
        this.simpleBlock(block, this.file(block));
    }

    public void emptyBlock(Block block) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)this.models().getBuilder(this.name(block))).build());
    }

    public void particleOnlyBlock(Block block, ResourceLocation particleLocation) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("particle", particleLocation)).build());
    }

    public ModelFile templateModel(Block block, ResourceLocation template, Pair<String, ResourceLocation> ... textures) {
        return this.templateModel(this.name(block), template, textures);
    }

    public ModelFile templateModel(String name, ResourceLocation template, Pair<String, ResourceLocation> ... textures) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().withExistingParent(name, template);
        for (Pair<String, ResourceLocation> texture : textures) {
            model.texture((String)texture.left(), (ResourceLocation)texture.right());
        }
        return model;
    }

    public void templateBlock(Block block, ResourceLocation template, Pair<String, ResourceLocation> ... textures) {
        ModelFile model = this.templateModel(block, template, textures);
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile(model).build());
    }

    public void cubeTopBlock(Block block) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile(this.cubeTop(block)).build());
    }

    public ModelFile cubeTop(Block block) {
        return this.models().cubeTop(this.name(block), this.resource(block), this.resource(block, "_top"));
    }

    public ModelFile cubeColumn(Block block) {
        return this.models().cubeColumn(this.name(block), this.resource(block), this.resource(block, "_top"));
    }

    public ModelFile cubeMirroredAll(Block block) {
        return ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_mirrored", "cube_mirrored_all")).texture("all", this.resource(block));
    }

    public ModelFile cubeMirroredColumn(Block block) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_mirrored", "cube_column_mirrored")).texture("side", this.resource(block))).texture("end", this.resource(block, "_top"));
    }

    public void wallTorchBlock(Block block, Block torch) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("template_torch_wall"))).texture("torch", this.resource(torch))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 90) % 360).build(), new Property[]{BlockStatePropertiesNF.WATER_LEVEL, BlockStatePropertiesNF.WATERLOG_TYPE});
    }

    public void lanternBlock(Block block) {
        this.getVariantBuilder(block).partialState().with((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("template_lantern"))).texture("lantern", this.resource(block))).build()).partialState().with((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_hanging", this.mcLoc("template_hanging_lantern"))).texture("lantern", this.resource(block))).build());
    }

    public ModelFile cubeTopHorizontalRotated(String name, ResourceLocation side, ResourceLocation top) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.resource("cube_top_horizontal_rotated"))).texture("side", side)).texture("top", top);
    }

    public ModelFile cubeTopHorizontal(String name, ResourceLocation side, ResourceLocation top) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.resource("cube_top_horizontal"))).texture("side", side)).texture("top", top);
    }

    public void woodBlock(RotatedPillarBlock block, ResourceLocation texture) {
        this.axisBlock(block, texture, texture);
    }

    public void stemBlock(TreeStemBlock block, RotatedPillarBlock texBlock) {
        ResourceLocation sideTex = this.resource((Block)texBlock);
        ResourceLocation topTex = this.resource((Block)texBlock, "_top");
        for (TreeStemBlock.Type type : TreeStemBlock.TYPE.m_6908_()) {
            ModelBuilder horizontal;
            ModelBuilder vertical;
            int xRot;
            int n = xRot = type == TreeStemBlock.Type.BOTTOM || type == TreeStemBlock.Type.ROTATED_BOTTOM ? 180 : 0;
            if (type == TreeStemBlock.Type.END || type == TreeStemBlock.Type.FAKE_END) {
                vertical = this.models().cubeColumn(this.name((Block)block) + "_end", sideTex, sideTex);
                horizontal = this.models().cubeColumnHorizontal(this.name((Block)block) + "_horizontal_end", sideTex, sideTex);
            } else if (type == TreeStemBlock.Type.TOP || type == TreeStemBlock.Type.BOTTOM) {
                vertical = this.models().cubeTop(this.name((Block)block), sideTex, topTex);
                horizontal = this.cubeTopHorizontal(this.name((Block)block) + "_horizontal", sideTex, topTex);
            } else {
                vertical = this.cubeTopHorizontalRotated(this.name((Block)block) + "_horizontal_rotated", sideTex, topTex);
                horizontal = this.cubeTopHorizontalRotated(this.name((Block)block) + "_horizontal_rotated", sideTex, topTex);
            }
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).with(TreeStemBlock.TYPE, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)vertical).rotationX(xRot).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).with(TreeStemBlock.TYPE, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)horizontal).rotationX(xRot + 90).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).with(TreeStemBlock.TYPE, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)horizontal).rotationX(xRot + 90).rotationY(90).addModel();
        }
    }

    public void leavesBlock(Block block) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "leaves")).texture("all", this.resource(block))).build());
    }

    public void crossLeavesBlock(Block block) {
        this.getVariantBuilder(block).partialState().with((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("leaves_cross"))).texture("all", this.resource(block))).texture("cross", this.resource(block, "_cross"))).build());
        this.getVariantBuilder(block).partialState().with((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_alt", this.resource("leaves_cross_alt"))).texture("all", this.resource(block))).texture("cross", this.resource(block, "_cross"))).build());
    }

    public void fruitLeavesBlock(Block base, Block block) {
        this.getVariantBuilder(block).partialState().with((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("leaves_cross"))).texture("all", this.resource(base))).texture("cross", this.resource(block, "_cross"))).build());
        this.getVariantBuilder(block).partialState().with((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_alt", this.resource("leaves_cross_alt"))).texture("all", this.resource(base))).texture("cross", this.resource(block, "_cross"))).build());
    }

    public void tintedFruitLeavesBlock(Block base, Block block) {
        this.getVariantBuilder(block).partialState().with((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("leaves_double_cross"))).texture("all", this.resource(base))).texture("cross2", this.resource(block, "_cross"))).texture("cross", this.resource(block, "_foliage_cross"))).build());
        this.getVariantBuilder(block).partialState().with((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_alt", this.resource("leaves_double_cross_alt"))).texture("all", this.resource(base))).texture("cross2", this.resource(block, "_cross"))).texture("cross", this.resource(block, "_foliage_cross"))).build());
    }

    public void rotatedFruitLeavesBlock(Block base, Block block) {
        this.getVariantBuilder(block).partialState().with((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("leaves_cross"))).texture("all", this.resource(base))).texture("cross", this.resource(block, "_cross"))).build());
        this.getVariantBuilder(block).partialState().with((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_alt", this.resource("leaves_cross_rotated"))).texture("all", this.resource(base))).texture("cross", this.resource(block, "_cross"))).build());
    }

    public void rotatedLeavesBlock(Block block) {
        this.getVariantBuilder(block).partialState().with((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "leaves")).texture("all", this.resource(block))).build());
        this.getVariantBuilder(block).partialState().with((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_alt", this.resource("leaves_rotated"))).texture("all", this.resource(block))).build());
    }

    public void trunkBlock(TreeTrunkBlock block, Block textureBlock) {
        this.getVariantBuilder((Block)block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeColumn(this.name((Block)block), this.resource(textureBlock), this.resource(textureBlock.getRegistryName().m_135815_() + "_top"))).build());
    }

    public void barrelBlock(BarrelBlockNF block) {
        ModelFile vertical = this.templateModel(block, this.resource("barrel_vertical"), Pair.of((Object)"side", (Object)this.resource(block, "_side")), Pair.of((Object)"top", (Object)this.resource(block, "_end")), Pair.of((Object)"bottom", (Object)this.resource(block, "_end")));
        ModelFile horizontal = this.templateModel(this.name(block) + "_horizontal", this.resource("barrel_horizontal"), Pair.of((Object)"side", (Object)this.resource(block, "_side")), Pair.of((Object)"top", (Object)this.resource(block, "_end")), Pair.of((Object)"bottom", (Object)this.resource(block, "_end")));
        ModelFile verticalOpen = this.templateModel(this.name(block) + "_open", this.resource("barrel_vertical"), Pair.of((Object)"side", (Object)this.resource(block, "_side")), Pair.of((Object)"top", (Object)this.resource(block, "_open")), Pair.of((Object)"bottom", (Object)this.resource(block, "_end")));
        ModelFile horizontalOpen = this.templateModel(this.name(block) + "_horizontal_open", this.resource("barrel_horizontal"), Pair.of((Object)"side", (Object)this.resource(block, "_side")), Pair.of((Object)"top", (Object)this.resource(block, "_open")), Pair.of((Object)"bottom", (Object)this.resource(block, "_end")));
        for (Direction facing : BarrelBlockNF.FACING.m_6908_()) {
            Iterator iterator = BarrelBlockNF.OPEN.m_6908_().iterator();
            while (iterator.hasNext()) {
                boolean open = (Boolean)iterator.next();
                if (facing.m_122434_().m_122479_()) {
                    this.getVariantBuilder(block).partialState().with((Property)BarrelBlockNF.OPEN, (Comparable)Boolean.valueOf(open)).with((Property)BarrelBlockNF.FACING, (Comparable)facing).addModels(ConfiguredModel.builder().modelFile(open ? horizontalOpen : horizontal).rotationY((int)facing.m_122424_().m_122435_()).build());
                    continue;
                }
                this.getVariantBuilder(block).partialState().with((Property)BarrelBlockNF.OPEN, (Comparable)Boolean.valueOf(open)).with((Property)BarrelBlockNF.FACING, (Comparable)facing).addModels(ConfiguredModel.builder().modelFile(open ? verticalOpen : vertical).build());
            }
        }
    }

    public void chestBlock(Block block, ResourceLocation particle) {
        for (Direction facing : ChestBlock.f_51478_.m_6908_()) {
            int yRot = (int)facing.m_122424_().m_122435_();
            this.getVariantBuilder(block).partialState().with((Property)ChestBlock.f_51478_, (Comparable)facing).with((Property)ChestBlock.f_51479_, (Comparable)ChestType.SINGLE).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("chest_single"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("entity/chest/" + block.getRegistryName().m_135815_() + "_single")))).texture("particle", particle)).rotationY(yRot).build());
            this.getVariantBuilder(block).partialState().with((Property)ChestBlock.f_51478_, (Comparable)facing).with((Property)ChestBlock.f_51479_, (Comparable)ChestType.LEFT).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_left", this.resource("chest_left"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("entity/chest/" + block.getRegistryName().m_135815_() + "_left")))).texture("particle", particle)).rotationY(yRot).build());
            this.getVariantBuilder(block).partialState().with((Property)ChestBlock.f_51478_, (Comparable)facing).with((Property)ChestBlock.f_51479_, (Comparable)ChestType.RIGHT).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_right", this.resource("chest_right"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("entity/chest/" + block.getRegistryName().m_135815_() + "_right")))).texture("particle", particle)).rotationY(yRot).build());
        }
    }

    public void chairBlock(ChairBlock block, ResourceLocation particle) {
        ModelFile singleBottom = this.templateModel(this.name(block) + "_single_bottom", this.resource("chair_single_bottom"), Pair.of((Object)"0", (Object)this.resource(block)), Pair.of((Object)"particle", (Object)particle));
        ModelFile leftBottom = this.templateModel(this.name(block) + "_left_bottom", this.resource("chair_left_bottom"), Pair.of((Object)"0", (Object)this.resource(block)), Pair.of((Object)"particle", (Object)particle));
        ModelFile rightBottom = this.templateModel(this.name(block) + "_right_bottom", this.resource("chair_right_bottom"), Pair.of((Object)"0", (Object)this.resource(block)), Pair.of((Object)"particle", (Object)particle));
        ModelFile middleBottom = this.templateModel(this.name(block) + "_middle_bottom", this.resource("chair_middle_bottom"), Pair.of((Object)"0", (Object)this.resource(block)), Pair.of((Object)"particle", (Object)particle));
        ModelFile singleTop = this.templateModel(this.name(block) + "_single_top", this.resource("chair_single_top"), Pair.of((Object)"0", (Object)this.resource(block)), Pair.of((Object)"particle", (Object)particle));
        ModelFile leftTop = this.templateModel(this.name(block) + "_left_top", this.resource("chair_left_top"), Pair.of((Object)"0", (Object)this.resource(block)), Pair.of((Object)"particle", (Object)particle));
        ModelFile rightTop = this.templateModel(this.name(block) + "_right_top", this.resource("chair_right_top"), Pair.of((Object)"0", (Object)this.resource(block)), Pair.of((Object)"particle", (Object)particle));
        ModelFile middleTop = this.templateModel(this.name(block) + "_middle_top", this.resource("chair_middle_top"), Pair.of((Object)"0", (Object)this.resource(block)), Pair.of((Object)"particle", (Object)particle));
        for (Direction facing : ChairBlock.FACING.m_6908_()) {
            for (ChairBlock.Type type : ChairBlock.TYPE.m_6908_()) {
                for (DoubleBlockHalf half : ChairBlock.HALF.m_6908_()) {
                    VariantBlockStateBuilder.PartialBlockstate partialBlockstate = this.getVariantBuilder(block).partialState().with(ChairBlock.TYPE, (Comparable)((Object)type)).with((Property)ChairBlock.FACING, (Comparable)facing).with(ChairBlock.HALF, (Comparable)half);
                    ConfiguredModel.Builder builder = ConfiguredModel.builder();
                    partialBlockstate.addModels(builder.modelFile(switch (type) {
                        default -> throw new IncompatibleClassChangeError();
                        case ChairBlock.Type.SINGLE -> {
                            if (half == DoubleBlockHalf.LOWER) {
                                yield singleBottom;
                            }
                            yield singleTop;
                        }
                        case ChairBlock.Type.LEFT -> {
                            if (half == DoubleBlockHalf.LOWER) {
                                yield leftBottom;
                            }
                            yield leftTop;
                        }
                        case ChairBlock.Type.RIGHT -> {
                            if (half == DoubleBlockHalf.LOWER) {
                                yield rightBottom;
                            }
                            yield rightTop;
                        }
                        case ChairBlock.Type.MIDDLE -> half == DoubleBlockHalf.LOWER ? middleBottom : middleTop;
                    }).rotationY((int)facing.m_122424_().m_122435_()).build());
                }
            }
        }
    }

    public void troughBlock(TroughBlock block, ResourceLocation particle) {
        for (Direction.Axis facing : TroughBlock.AXIS.m_6908_()) {
            Iterator iterator = TroughBlock.AMOUNT.m_6908_().iterator();
            while (iterator.hasNext()) {
                int amount = (Integer)iterator.next();
                if (amount == 0) {
                    this.getVariantBuilder(block).partialState().with(TroughBlock.AXIS, (Comparable)facing).with((Property)TroughBlock.AMOUNT, (Comparable)Integer.valueOf(amount)).addModels(ConfiguredModel.builder().modelFile(this.templateModel(this.name(block) + "_" + amount, this.resource("trough_" + amount), Pair.of((Object)"long", (Object)this.resource(block)), Pair.of((Object)"short", (Object)this.resource(block, "_side")), Pair.of((Object)"bottom", (Object)this.resource(block, "_bottom")), Pair.of((Object)"particle", (Object)particle))).rotationY(facing == Direction.Axis.X ? 90 : 0).build());
                    continue;
                }
                for (TroughBlock.FoodType foodType : TroughBlock.FOOD_TYPE.m_6908_()) {
                    this.getVariantBuilder(block).partialState().with(TroughBlock.AXIS, (Comparable)facing).with((Property)TroughBlock.AMOUNT, (Comparable)Integer.valueOf(amount)).with(TroughBlock.FOOD_TYPE, (Comparable)((Object)foodType)).addModels(ConfiguredModel.builder().modelFile(this.templateModel(this.name(block) + "_" + foodType.m_7912_() + "_" + amount, this.resource("trough_" + amount), Pair.of((Object)"long", (Object)this.resource(block)), Pair.of((Object)"short", (Object)this.resource(block, "_side")), Pair.of((Object)"bottom", (Object)this.resource(block, "_bottom")), Pair.of((Object)"food", (Object)this.resource("trough_" + foodType.m_7912_())), Pair.of((Object)"particle", (Object)particle))).rotationY(facing == Direction.Axis.X ? 90 : 0).build());
                }
            }
        }
    }

    public void crossBlock(Block block) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "cross")).texture("cross", this.resource(block))).build());
    }

    public void crossBlock(Block block, ResourceLocation texture) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "cross")).texture("cross", texture)).build());
    }

    public void tintedCrossBlock(Block block) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "tinted_cross")).texture("cross", this.resource(block))).build());
    }

    public void tallTintedCrossBlock(Block block) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("tall_tinted_cross"))).texture("cross", this.resource(block))).build());
    }

    public void saplingBlock(Block block) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("sapling"))).texture("base", this.resource(block))).texture("overlay", this.resource(block, "_overlay"))).build());
    }

    public void evergreenSaplingBlock(Block block) {
        this.getVariantBuilder(block).partialState().with((Property)TreeSeedBlock.STAGE, (Comparable)Integer.valueOf(0)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_sprout", "cross")).texture("cross", this.resource(block, "_sprout"))).build());
        this.getVariantBuilder(block).partialState().with((Property)TreeSeedBlock.STAGE, (Comparable)Integer.valueOf(1)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "cross")).texture("cross", this.resource(block))).build());
    }

    public void deciduousSaplingBlock(Block block) {
        this.getVariantBuilder(block).partialState().with((Property)TreeSeedBlock.STAGE, (Comparable)Integer.valueOf(0)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_sprout", "cross")).texture("cross", this.resource(block, "_sprout"))).build());
        this.getVariantBuilder(block).partialState().with((Property)TreeSeedBlock.STAGE, (Comparable)Integer.valueOf(1)).addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("sapling"))).texture("base", this.resource(block))).texture("overlay", this.resource(block, "_overlay"))).build());
    }

    public void vinesBlock(Block block) {
        this.multifaceBlock(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "vine")).texture("vine", this.resource(block)));
    }

    public void multifaceBlock(Block block, ModelFile model) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile(model).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{true}).end().part().modelFile(model).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end().part().modelFile(model).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end().part().modelFile(model).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end().part().modelFile(model).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
        if (block.m_49966_().m_61138_((Property)BlockStateProperties.f_61367_)) {
            ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile(model).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{true}).end();
        }
    }

    public void randomRotatedBlock(Block block, ModelFile model) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile(model).nextModel().modelFile(model).rotationY(90).nextModel().modelFile(model).rotationY(180).nextModel().modelFile(model).rotationY(270).build());
    }

    public void randomRotatedBlock(Block block) {
        this.randomRotatedBlock(block, this.cubeAll(block));
    }

    public void mirroredBlock(Block block) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile(this.cubeAll(block)).nextModel().modelFile(this.cubeMirroredAll(block)).nextModel().modelFile(this.cubeAll(block)).rotationY(180).nextModel().modelFile(this.cubeMirroredAll(block)).rotationY(180).build());
    }

    public void columnBlock(Block block) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile(this.cubeColumn(block)).build());
    }

    public void mirroredColumnBlock(Block block) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile(this.cubeColumn(block)).nextModel().modelFile(this.cubeMirroredColumn(block)).nextModel().modelFile(this.cubeColumn(block)).rotationY(180).nextModel().modelFile(this.cubeMirroredColumn(block)).rotationY(180).build());
    }

    public void snowyTintedSoilBlock(CoveredSoilBlock block, String soilName, String topName) {
        this.getVariantBuilder(block).forAllStates(state -> {
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61451_)).booleanValue()) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_snow", "cube_bottom_top")).texture("top", this.resource(topName))).texture("bottom", this.resource((Block)block.soilBlock.get()))).texture("side", this.resource("snowy_" + soilName + "_side"))).texture("particle", this.resource((Block)block.soilBlock.get()))).build();
            }
            ModelBuilder file = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("template_soil"))).texture("overlay", this.resource(block, "_side_overlay"))).texture("top", this.resource(topName))).texture("bottom", this.resource((Block)block.soilBlock.get()))).texture("side", this.resource(block, "_side"))).texture("particle", this.resource((Block)block.soilBlock.get()));
            return ConfiguredModel.builder().modelFile((ModelFile)file).nextModel().modelFile((ModelFile)file).rotationY(90).nextModel().modelFile((ModelFile)file).rotationY(180).nextModel().modelFile((ModelFile)file).rotationY(270).build();
        });
    }

    public void snowySoilBlock(CoveredSoilBlock block, String soilName, String topName) {
        this.getVariantBuilder(block).forAllStates(state -> {
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61451_)).booleanValue()) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_snow", "cube_bottom_top")).texture("top", this.resource(topName))).texture("bottom", this.resource((Block)block.soilBlock.get()))).texture("side", this.resource("snowy_" + soilName + "_side"))).texture("particle", this.resource((Block)block.soilBlock.get()))).build();
            }
            ModelBuilder file = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "cube_bottom_top")).texture("top", this.resource(topName))).texture("bottom", this.resource((Block)block.soilBlock.get()))).texture("side", this.resource(block, "_side"))).texture("particle", this.resource((Block)block.soilBlock.get()));
            return ConfiguredModel.builder().modelFile((ModelFile)file).nextModel().modelFile((ModelFile)file).rotationY(90).nextModel().modelFile((ModelFile)file).rotationY(180).nextModel().modelFile((ModelFile)file).rotationY(270).build();
        });
    }

    public void fuelPileBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            String suffix;
            String string = (Boolean)state.m_61143_((Property)BlockStatePropertiesNF.SMELTED) != false ? "_smelted" : (suffix = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? "_lit" : "");
            if (suffix.equals("_lit")) {
                return ConfiguredModel.builder().modelFile(this.file(block, suffix)).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(this.name(block) + suffix, this.resource(this.name(block) + suffix))).build();
        });
    }

    public void stairBlock(StairBlockNF block, ResourceLocation texture) {
        this.stairBlock(block, texture, texture, texture);
    }

    public void stairBlock(StairBlockNF block, String name, ResourceLocation texture) {
        this.stairBlock(block, name, texture, texture, texture);
    }

    public void stairBlock(StairBlockNF block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.stairsBlockInternal(block, block.getRegistryName().toString(), side, bottom, top);
    }

    public void stairBlock(StairBlockNF block, String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.stairsBlockInternal(block, name + "_stairs", side, bottom, top);
    }

    private void stairsBlockInternal(StairBlockNF block, String baseName, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        ModelBuilder stairs = this.models().stairs(baseName, side, bottom, top);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", side, bottom, top);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", side, bottom, top);
        this.stairBlock(block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    public void stairBlock(StairBlockNF block, ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)StairBlockNF.f_56841_);
            Half half = (Half)state.m_61143_((Property)StairBlockNF.f_56842_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlockNF.f_56843_);
            int yRot = (int)facing.m_122427_().m_122435_();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
        }, new Property[]{StairBlockNF.WATER_LEVEL, StairBlockNF.WATERLOG_TYPE, StairBlock.f_56844_});
    }

    public void sidingBlock(SidingBlock block, ResourceLocation texture) {
        this.sidingBlock(block, texture, texture, texture, texture, texture, texture, texture, texture, texture, texture, true);
    }

    public void sidingBlock(SidingBlock block, ResourceLocation doubled, ResourceLocation side, ResourceLocation shortSide, ResourceLocation bottom, ResourceLocation top, ResourceLocation quartBottom, ResourceLocation quartTop, ResourceLocation innerBottom, ResourceLocation innerTop, ResourceLocation innerSide, boolean lockUV) {
        this.sidingBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("siding"))).texture("side", side)).texture("short_side", shortSide)).texture("bottom", bottom)).texture("top", top), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_quartet", this.resource("quartet"))).texture("side", shortSide)).texture("bottom", quartBottom)).texture("top", quartTop), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_inner", this.resource("siding_inner"))).texture("side", side)).texture("short_side", shortSide)).texture("inner_side", innerSide)).texture("bottom", innerBottom)).texture("top", innerTop), (ModelFile)this.models().getExistingFile(doubled), lockUV);
    }

    public void sidingBlock(SidingBlock block, ModelFile full, ModelFile quartet, ModelFile inner, ModelFile doubled, boolean lockUV) {
        for (SidingBlock.Type type : SidingBlock.Type.values()) {
            for (SidingBlock.Shape shape : SidingBlock.Shape.values()) {
                if (type == SidingBlock.Type.DOUBLE) {
                    if (shape != SidingBlock.Shape.FULL) continue;
                    this.getVariantBuilder(block).partialState().with(SidingBlock.TYPE, (Comparable)((Object)type)).addModels(new ConfiguredModel[]{new ConfiguredModel(doubled)});
                    continue;
                }
                int yRot = (int)type.getDirection().m_122427_().m_122435_();
                if (!shape.positive) {
                    yRot -= 90;
                }
                yRot = (yRot + 360) % 360;
                this.getVariantBuilder(block).partialState().with(SidingBlock.TYPE, (Comparable)((Object)type)).with(SidingBlock.SHAPE, (Comparable)((Object)shape)).addModels(ConfiguredModel.builder().modelFile(shape == SidingBlock.Shape.FULL ? full : (shape.inner ? inner : quartet)).rotationY(yRot).uvLock(yRot != 0 && lockUV).build());
            }
        }
    }

    public void slabBlock(SlabBlockNF block, ResourceLocation texture) {
        this.slabBlock(block, texture, texture, texture, texture);
    }

    public void slabBlock(SlabBlockNF block, ResourceLocation doubleslab, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.slabBlock(block, (ModelFile)this.models().slab(this.name((Block)block), side, bottom, top), (ModelFile)this.models().slabTop(this.name((Block)block) + "_top", side, bottom, top), (ModelFile)this.models().getExistingFile(doubleslab));
    }

    public void slabBlock(SlabBlockNF block, ModelFile bottom, ModelFile top, ModelFile doubleslab) {
        this.getVariantBuilder((Block)block).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel(bottom)}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel(top)}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel(doubleslab)});
    }

    public void fourWayBlock(CrossCollisionBlockNF block, ModelFile post, ModelFile side) {
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile(post).addModel()).end();
        this.fourWayMultipart(builder, side);
    }

    public void fenceBlock(FenceBlockNF block, ResourceLocation texture) {
        String baseName = block.getRegistryName().toString();
        this.fourWayBlock(block, (ModelFile)this.models().fencePost(baseName + "_post", texture), (ModelFile)this.models().fenceSide(baseName + "_side", texture));
    }

    public void fenceBlock(FenceBlockNF block, String name, ResourceLocation texture) {
        this.fourWayBlock(block, (ModelFile)this.models().fencePost(name + "_fence_post", texture), (ModelFile)this.models().fenceSide(name + "_fence_side", texture));
    }

    public void fenceGateBlock(FenceGateBlockNF block, ResourceLocation texture) {
        this.fenceGateBlockInternal(block, block.getRegistryName().toString(), texture);
    }

    public void fenceGateBlock(FenceGateBlockNF block, String name, ResourceLocation texture) {
        this.fenceGateBlockInternal(block, name + "_fence_gate", texture);
    }

    private void fenceGateBlockInternal(FenceGateBlockNF block, String baseName, ResourceLocation texture) {
        ModelFile gate = this.templateModel(baseName, this.resource("template_fence_gate"), Pair.of((Object)"0", (Object)texture));
        ModelFile gateOpen = this.templateModel(baseName + "_open", this.resource("template_fence_gate_open"), Pair.of((Object)"0", (Object)texture));
        ModelFile gateWall = this.templateModel(baseName + "_wall", this.resource("template_fence_gate_wall"), Pair.of((Object)"0", (Object)texture));
        ModelFile gateWallOpen = this.templateModel(baseName + "_wall_open", this.resource("template_fence_gate_wall_open"), Pair.of((Object)"0", (Object)texture));
        this.fenceGateBlock(block, gate, gateOpen, gateWall, gateWallOpen);
    }

    public void fenceGateBlock(FenceGateBlockNF block, ModelFile gate, ModelFile gateOpen, ModelFile gateWall, ModelFile gateWallOpen) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            ModelFile model = gate;
            if (((Boolean)state.m_61143_((Property)FenceGateBlock.f_53343_)).booleanValue()) {
                model = gateWall;
            }
            if (((Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
                model = model == gateWall ? gateWallOpen : gateOpen;
            }
            return ConfiguredModel.builder().modelFile(model).rotationY((int)((Direction)state.m_61143_((Property)FenceGateBlock.f_54117_)).m_122435_()).uvLock(true).build();
        }, new Property[]{FenceGateBlock.f_53342_, FenceGateBlockNF.WATER_LEVEL, BlockStatePropertiesNF.WATERLOG_TYPE});
    }

    public void ingotBlock(HeatablePileBlock block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int heat = (Integer)state.m_61143_((Property)BlockStatePropertiesNF.HEAT);
            String suffix = "_" + state.m_61143_((Property)block.count);
            if (heat == 0) {
                ResourceLocation texture = this.resource(this.name(block));
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + suffix, this.resource("template_ingot" + suffix))).texture("all", texture)).texture("particle", texture)).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.resource("hot_ingot_" + (heat - 1) + suffix))).build();
        }, new Property[]{HeatablePileBlock.WATER_LEVEL, BlockStatePropertiesNF.WATERLOG_TYPE});
    }

    public void simpleHeatableBlock(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int heat = (Integer)state.m_61143_((Property)BlockStatePropertiesNF.HEAT);
            String suffix = "_" + TieredHeat.fromTier(heat);
            ResourceLocation texture = this.resource(this.name(block) + suffix);
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(texture.m_135815_(), texture)).build();
        }, new Property[0]);
    }

    public void horizontalHeatableBlock(Block block) {
        Iterator iterator = BlockStatePropertiesNF.HEAT.m_6908_().iterator();
        while (iterator.hasNext()) {
            int heat = (Integer)iterator.next();
            String suffix = "_" + TieredHeat.fromTier(heat);
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + suffix, this.resource("cube_column_horizontal"))).texture("side", this.resource(this.name(block) + suffix))).texture("end", this.resource(this.name(block) + "_top" + suffix));
            ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStatePropertiesNF.HEAT, (Comparable)Integer.valueOf(heat)).with((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)BlockStatePropertiesNF.HEAT, (Comparable)Integer.valueOf(heat)).with((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationY(90).addModel();
        }
    }

    public void crucibleBlock(Block block) {
        Iterator iterator = BlockStatePropertiesNF.HEAT_FULL.m_6908_().iterator();
        while (iterator.hasNext()) {
            int heat = (Integer)iterator.next();
            String suffix = "_" + TieredHeat.fromTier(heat);
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + suffix, this.resource(block))).texture("all", this.resource(this.name(block) + suffix))).texture("particle", this.resource((Block)BlocksNF.TERRACOTTA.get()));
            ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStatePropertiesNF.HEAT_FULL, (Comparable)Integer.valueOf(heat)).with((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)BlockStatePropertiesNF.HEAT_FULL, (Comparable)Integer.valueOf(heat)).with((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationY(90).addModel();
        }
    }

    public void unfiredPotteryBlock(FireablePartialBlock block) {
        this.getVariantBuilder((Block)block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), this.resource((Block)block.firedBlock.get()))).texture("all", this.resource((Block)block))).texture("particle", this.resource((Block)BlocksNF.CLAY.get()))).build());
    }

    public void unfiredAxisPotteryBlock(FireablePartialBlock block) {
        this.horizontalAxisBlock((Block)block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), this.resource((Block)block.firedBlock.get()))).texture("all", this.resource((Block)block))).texture("particle", this.resource((Block)BlocksNF.CLAY.get())));
    }

    public void horizontalBlockNF(Block block, ModelFile model, int angleOffset) {
        this.horizontalBlockNF(block, (BlockState $) -> model, angleOffset);
    }

    public void horizontalBlockNF(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        for (Direction dir : BlockStateProperties.f_61374_.m_6908_()) {
            this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)dir).modelForState().modelFile(modelFunc.apply((BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)dir))).rotationY(((int)dir.m_122435_() + angleOffset) % 360).addModel();
        }
    }

    public void directionalBlockNF(Block block, ModelFile model, int angleOffset) {
        this.directionalBlockNF(block, (BlockState $) -> model, angleOffset);
    }

    public void directionalBlockNF(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        for (Direction dir : BlockStateProperties.f_61372_.m_6908_()) {
            this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)dir).modelForState().modelFile(modelFunc.apply((BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)dir))).rotationX(dir == Direction.DOWN ? 90 : (dir == Direction.UP ? -90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122424_().m_122435_() + angleOffset) % 360).addModel();
        }
    }

    public void unfiredMoldBlock(Block unfiredMold, Block firedMold) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(unfiredMold), this.resource(firedMold))).texture("0", this.resource("clay_block"))).texture("1", this.resource("clay_darkened"))).texture("particle", this.resource("clay_block"));
        this.horizontalBlockNF(unfiredMold, (ModelFile)model, 0);
    }

    public void horizontalColumnBlock(Block block) {
        ModelBuilder horizontal = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("cube_column_horizontal"))).texture("side", this.resource(block))).texture("end", this.resource(block, "_top"));
        this.horizontalAxisBlock(block, (ModelFile)horizontal);
    }

    public void horizontalColumnBottomTopBlock(Block block, ResourceLocation bottom, ResourceLocation top) {
        ModelBuilder horizontal = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("cube_column_horizontal_bottom_top"))).texture("side", this.resource(block))).texture("end", this.resource(block, "_top"))).texture("bottom", bottom)).texture("top", top);
        this.horizontalAxisBlock(block, (ModelFile)horizontal);
    }

    public void horizontalAxisBlock(Block block, ModelFile model) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.Z).modelForState().modelFile(model).addModel()).partialState().with((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.X).modelForState().modelFile(model).rotationY(90).addModel();
    }

    public void anvilBlock(TieredAnvilBlock block) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), this.resource("anvil"))).texture("body", this.resource((Block)block))).texture("top", this.resource((Block)block, "_top"))).texture("particle", this.resource((Block)block))).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() % 360).build(), new Property[]{BlockStatePropertiesNF.WATER_LEVEL, BlockStatePropertiesNF.WATERLOG_TYPE, BlockStatePropertiesNF.RANDOM_TICKING});
    }

    public void ladderBlock(LadderBlockNF block) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), "ladder")).texture("texture", this.resource((Block)block))).texture("particle", this.resource((Block)block))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build(), new Property[]{BlockStatePropertiesNF.WATER_LEVEL, BlockStatePropertiesNF.WATERLOG_TYPE});
    }

    public void hatchBlock(HatchBlock block) {
        String baseName = this.name(block);
        ModelBuilder bottomLeft = ((BlockModelBuilder)this.models().withExistingParent(baseName, this.resource("hatch"))).texture("texture", this.resource(block));
        ModelBuilder bottomRight = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_rh", this.resource("hatch_rh"))).texture("texture", this.resource(block));
        this.hatchBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomRight);
    }

    public void hatchBlock(HatchBlock block, ModelFile bottomLeft, ModelFile bottomRight) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.m_61143_((Property)HatchBlock.FACING)).m_122435_() + 90;
            boolean rh = state.m_61143_(HatchBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)HatchBlock.OPEN);
            boolean right = rh ^ open;
            if (open) {
                yRot += 90;
            }
            if (rh && open) {
                yRot += 180;
            }
            return ConfiguredModel.builder().modelFile(right ? bottomRight : bottomLeft).rotationY(yRot %= 360).build();
        }, new Property[]{HatchBlock.WATER_LEVEL, HatchBlock.WATERLOG_TYPE});
    }

    public void doorBlock(DoorBlockNF block) {
        String baseName = block.getRegistryName().toString();
        ResourceLocation bottom = this.resource(block, "_bottom");
        ResourceLocation top = this.resource(block, "_top");
        ModelBuilder bottomLeft = this.models().doorBottomLeft(baseName + "_bottom", bottom, top);
        ModelBuilder bottomRight = this.models().doorBottomRight(baseName + "_bottom_hinge", bottom, top);
        ModelBuilder topLeft = this.models().doorTopLeft(baseName + "_top", bottom, top);
        ModelBuilder topRight = this.models().doorTopRight(baseName + "_top_hinge", bottom, top);
        this.doorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomRight, (ModelFile)topLeft, (ModelFile)topRight);
    }

    public void doorBlock(DoorBlockNF block, ModelFile bottomLeft, ModelFile bottomRight, ModelFile topLeft, ModelFile topRight) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122435_() + 90;
            boolean rh = state.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            boolean right = rh ^ open;
            if (open) {
                yRot += 90;
            }
            if (rh && open) {
                yRot += 180;
            }
            return ConfiguredModel.builder().modelFile(state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? (right ? bottomRight : bottomLeft) : (right ? topRight : topLeft)).rotationY(yRot %= 360).build();
        }, new Property[]{DoorBlock.f_52729_, DoorBlockNF.WATER_LEVEL, DoorBlockNF.WATERLOG_TYPE});
    }

    public void trapdoorBlock(TrapdoorBlockNF block) {
        this.trapdoorBlock(block, this.resource((Block)block), true);
    }

    public void trapdoorBlock(TrapDoorBlock block, ModelFile bottom, ModelFile top, ModelFile open, boolean orientable) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int xRot = 0;
            int yRot = (int)((Direction)state.m_61143_((Property)TrapDoorBlock.f_54117_)).m_122435_() + 180;
            boolean isOpen = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
            if (orientable && isOpen && state.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP) {
                xRot += 180;
                yRot += 180;
            }
            if (!orientable && !isOpen) {
                yRot = 0;
            }
            return ConfiguredModel.builder().modelFile(isOpen ? open : (state.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP ? top : bottom)).rotationX(xRot).rotationY(yRot %= 360).build();
        }, new Property[]{TrapDoorBlock.f_57516_, TrapDoorBlock.f_57517_, TrapdoorBlockNF.WATERLOG_TYPE, TrapdoorBlockNF.WATER_LEVEL});
    }

    public void logBlock(RotatedPillarBlock block, Block textureBlock) {
        ResourceLocation texture = this.blockTexture(textureBlock);
        this.axisBlock(block, texture, ResourceLocation.fromNamespaceAndPath((String)texture.m_135827_(), (String)(texture.m_135815_() + "_top")));
    }

    public void groundItemBlock(Block block, int textures) {
        ConfiguredModel.Builder builder = ConfiguredModel.builder();
        for (int i = 0; i < textures; ++i) {
            ResourceLocation texture = this.resource(block, "_" + i);
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + i, this.resource(block))).texture("0", texture)).texture("particle", texture);
            builder = builder.modelFile((ModelFile)model).nextModel().modelFile((ModelFile)model).rotationY(90).nextModel().modelFile((ModelFile)model).rotationY(180).nextModel().modelFile((ModelFile)model).rotationY(270);
            if (i >= textures - 1) continue;
            builder = builder.nextModel();
        }
        this.getVariantBuilder(block).partialState().addModels(builder.build());
    }

    public void clusterBlock(ClusterBlock block, ResourceLocation texture, String prefix) {
        for (int i = 1; i <= 4; ++i) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + i, this.resource(prefix + "_cluster_" + i))).texture("0", texture)).texture("particle", texture);
            this.getVariantBuilder(block).partialState().with((Property)ClusterBlock.COUNT, (Comparable)Integer.valueOf(i)).addModels(ConfiguredModel.builder().modelFile((ModelFile)model).nextModel().modelFile((ModelFile)model).rotationY(90).nextModel().modelFile((ModelFile)model).rotationY(180).nextModel().modelFile((ModelFile)model).rotationY(270).build());
        }
    }

    public void skaraNestBlock(Block block, ResourceLocation texture, String prefix) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource(prefix + "_cluster_4"))).texture("0", texture)).texture("particle", texture);
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model).nextModel().modelFile((ModelFile)model).rotationY(90).nextModel().modelFile((ModelFile)model).rotationY(180).nextModel().modelFile((ModelFile)model).rotationY(270).build());
    }

    public void eggNestBlock(EggNestBlock block) {
        for (int i = 0; i <= 4; ++i) {
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block) + "_" + i, this.resource("egg_nest_" + i))).texture("egg", this.resource((Block)block, "_egg"));
            this.getVariantBuilder((Block)block).partialState().with((Property)EggNestBlock.EGGS, (Comparable)Integer.valueOf(i)).addModels(ConfiguredModel.builder().modelFile((ModelFile)model).nextModel().modelFile((ModelFile)model).rotationY(90).nextModel().modelFile((ModelFile)model).rotationY(180).nextModel().modelFile((ModelFile)model).rotationY(270).build());
        }
    }

    public void pileBlock(PileBlock block, ResourceLocation texture, String baseModelPath) {
        for (int i = 1; i <= 8; ++i) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + i, this.resource(baseModelPath + "_" + i))).texture("all", texture)).texture("particle", texture);
            ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)PileBlock.COUNT, (Comparable)Integer.valueOf(i)).with(PileBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)PileBlock.COUNT, (Comparable)Integer.valueOf(i)).with(PileBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationY(90).addModel();
        }
    }

    public void campfireBlock(CampfireBlockNF campfire) {
        ModelFile.ExistingModelFile campfire4 = this.models().getExistingFile(this.resource("campfire_4"));
        ModelFile.ExistingModelFile campfire3 = this.models().getExistingFile(this.resource("campfire_3"));
        ModelFile.ExistingModelFile campfire2 = this.models().getExistingFile(this.resource("campfire_2"));
        ModelFile.ExistingModelFile campfire1 = this.models().getExistingFile(this.resource("campfire_1"));
        ModelFile.ExistingModelFile campfire0 = this.models().getExistingFile(this.resource("campfire_0"));
        ModelFile.ExistingModelFile sticks = this.models().getExistingFile(this.resource("campfire_sticks"));
        ModelFile.ExistingModelFile fire = this.models().getExistingFile(this.resource("campfire_fire"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(campfire).part().modelFile((ModelFile)campfire4).rotationY(90).addModel()).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition((Property)CampfireBlockNF.FIREWOOD, (Comparable[])new Integer[]{4}).end().part().modelFile((ModelFile)campfire4).addModel()).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition((Property)CampfireBlockNF.FIREWOOD, (Comparable[])new Integer[]{4}).end().part().modelFile((ModelFile)campfire3).rotationY(90).addModel()).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition((Property)CampfireBlockNF.FIREWOOD, (Comparable[])new Integer[]{3}).end().part().modelFile((ModelFile)campfire3).addModel()).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition((Property)CampfireBlockNF.FIREWOOD, (Comparable[])new Integer[]{3}).end().part().modelFile((ModelFile)campfire2).rotationY(90).addModel()).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition((Property)CampfireBlockNF.FIREWOOD, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)campfire2).addModel()).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition((Property)CampfireBlockNF.FIREWOOD, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)campfire1).rotationY(90).addModel()).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition((Property)CampfireBlockNF.FIREWOOD, (Comparable[])new Integer[]{1}).end().part().modelFile((ModelFile)campfire1).addModel()).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition((Property)CampfireBlockNF.FIREWOOD, (Comparable[])new Integer[]{1}).end().part().modelFile((ModelFile)campfire0).rotationY(90).addModel()).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition((Property)CampfireBlockNF.FIREWOOD, (Comparable[])new Integer[]{0}).end().part().modelFile((ModelFile)campfire0).addModel()).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition((Property)CampfireBlockNF.FIREWOOD, (Comparable[])new Integer[]{0}).end().part().modelFile((ModelFile)sticks).rotationY(90).addModel()).condition((Property)CampfireBlockNF.HAS_FOOD, (Comparable[])new Boolean[]{true}).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile((ModelFile)sticks).addModel()).condition((Property)CampfireBlockNF.HAS_FOOD, (Comparable[])new Boolean[]{true}).condition(CampfireBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end().part().modelFile((ModelFile)fire).addModel()).condition((Property)CampfireBlockNF.LIT, (Comparable[])new Boolean[]{true}).end();
    }

    public void cauldronBlock(CauldronBlockNF cauldron) {
        ModelFile done = this.templateModel(this.name(cauldron) + "_done", this.resource("cauldron_template_done"), Pair.of((Object)"all", (Object)this.resource(cauldron)), Pair.of((Object)"particle", (Object)this.resource((Block)BlocksNF.TERRACOTTA.get())));
        ModelFile cook = this.templateModel(this.name(cauldron) + "_cook", this.resource("cauldron_template_cook"), Pair.of((Object)"all", (Object)this.resource(cauldron)), Pair.of((Object)"particle", (Object)this.resource((Block)BlocksNF.TERRACOTTA.get())));
        ModelFile idle = this.templateModel(cauldron, this.resource("cauldron_template"), Pair.of((Object)"all", (Object)this.resource(cauldron)), Pair.of((Object)"particle", (Object)this.resource((Block)BlocksNF.TERRACOTTA.get())));
        ModelFile support = this.templateModel(this.name(cauldron) + "_support", this.resource("cauldron_template_support"), Pair.of((Object)"all", (Object)this.resource("campfire_sticks")));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(cauldron).part().modelFile(done).rotationY(90).addModel()).condition(CauldronBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition(CauldronBlockNF.TASK, (Comparable[])new Task[]{Task.DONE}).end().part().modelFile(done).addModel()).condition(CauldronBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition(CauldronBlockNF.TASK, (Comparable[])new Task[]{Task.DONE}).end().part().modelFile(cook).rotationY(90).addModel()).condition(CauldronBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition(CauldronBlockNF.TASK, (Comparable[])new Task[]{Task.COOK}).end().part().modelFile(cook).addModel()).condition(CauldronBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition(CauldronBlockNF.TASK, (Comparable[])new Task[]{Task.COOK}).end().part().modelFile(idle).rotationY(90).addModel()).condition(CauldronBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition(CauldronBlockNF.TASK, (Comparable[])new Task[]{Task.IDLE}).end().part().modelFile(idle).addModel()).condition(CauldronBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition(CauldronBlockNF.TASK, (Comparable[])new Task[]{Task.IDLE}).end().part().modelFile(support).rotationY(90).addModel()).condition((Property)CauldronBlockNF.SUPPORT, (Comparable[])new Boolean[]{true}).condition(CauldronBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile(support).addModel()).condition((Property)CauldronBlockNF.SUPPORT, (Comparable[])new Boolean[]{true}).condition(CauldronBlockNF.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end();
    }

    public void overlayBurrowBlock(OverlayBurrowBlock burrow) {
        this.getVariantBuilder((Block)burrow).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)burrow) + (state.m_61143_((Property)OverlayBurrowBlock.FACING) == Direction.DOWN ? "_down" : ""), this.resource("single_face"))).texture("0", state.m_61143_((Property)OverlayBurrowBlock.FACING) == Direction.DOWN ? this.resource((Block)burrow, "_down") : this.resource((Block)burrow))).texture("particle", this.resource("empty"))).rotationX(state.m_61143_((Property)OverlayBurrowBlock.FACING) == Direction.DOWN ? 90 : 0).rotationY(((int)((Direction)state.m_61143_((Property)OverlayBurrowBlock.FACING)).m_122435_() + 180) % 360).build());
    }

    public void singleFaceBlock(Block block, Direction facing) {
        this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.resource("single_face"))).texture("0", this.resource(block))).texture("particle", this.resource("empty"))).rotationX(facing == Direction.DOWN ? 90 : 0).rotationY(((int)facing.m_122435_() + 180) % 360).addModel();
    }

    public void tilledSoilBlock(Block block, ResourceLocation side) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with(BlockStatePropertiesNF.HUMIDITY, (Comparable)((Object)Humidity.DRY)).modelForState().modelFile((ModelFile)this.models().cubeTop(this.name(block) + "_dry", side, this.resource(block, "_dry"))).addModel()).partialState().with(BlockStatePropertiesNF.HUMIDITY, (Comparable)((Object)Humidity.MOIST)).modelForState().modelFile((ModelFile)this.models().cubeTop(this.name(block) + "_moist", side, this.resource(block, "_moist"))).addModel()).partialState().with(BlockStatePropertiesNF.HUMIDITY, (Comparable)((Object)Humidity.IRRIGATED)).modelForState().modelFile((ModelFile)this.models().cubeTop(this.name(block) + "_irrigated", side, this.resource(block, "_irrigated"))).addModel();
    }

    public void stagedCrossBlock(Block block, IntegerProperty property) {
        for (Integer i : property.m_6908_()) {
            this.getVariantBuilder(block).partialState().with((Property)property, (Comparable)i).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + i, "cross")).texture("cross", this.resource(block, "_" + i))).addModel();
        }
    }

    public void cropBlock(Block block, int ... texStages) {
        for (int i = 0; i < 8; ++i) {
            this.getVariantBuilder(block).partialState().with((Property)BlockStatePropertiesNF.STAGE_8, (Comparable)Integer.valueOf(i + 1)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + texStages[i], this.resource("crop"))).texture("all", this.resource(block, "_" + texStages[i]))).addModel();
        }
    }

    public void crossCropBlock(Block block, int ... texStages) {
        for (int i = 0; i < 8; ++i) {
            this.getVariantBuilder(block).partialState().with((Property)BlockStatePropertiesNF.STAGE_8, (Comparable)Integer.valueOf(i + 1)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + texStages[i], "cross")).texture("cross", this.resource(block, "_" + texStages[i]))).addModel();
        }
    }

    private void fireBlock(Block fire) {
        ModelFile floor0 = this.templateModel(this.name(fire) + "_floor_0", this.mcLoc("template_fire_floor"), Pair.of((Object)"fire", (Object)this.resource(fire, "_0")));
        ModelFile floor1 = this.templateModel(this.name(fire) + "_floor_1", this.mcLoc("template_fire_floor"), Pair.of((Object)"fire", (Object)this.resource(fire, "_1")));
        ModelFile side0 = this.templateModel(this.name(fire) + "_side_0", this.mcLoc("template_fire_side"), Pair.of((Object)"fire", (Object)this.resource(fire, "_0")));
        ModelFile side1 = this.templateModel(this.name(fire) + "_side_1", this.mcLoc("template_fire_side"), Pair.of((Object)"fire", (Object)this.resource(fire, "_1")));
        ModelFile side_alt0 = this.templateModel(this.name(fire) + "_side_alt_0", this.mcLoc("template_fire_side_alt"), Pair.of((Object)"fire", (Object)this.resource(fire, "_0")));
        ModelFile side_alt1 = this.templateModel(this.name(fire) + "_side_alt_1", this.mcLoc("template_fire_side_alt"), Pair.of((Object)"fire", (Object)this.resource(fire, "_1")));
        ModelFile up0 = this.templateModel(this.name(fire) + "_up_0", this.mcLoc("template_fire_up"), Pair.of((Object)"fire", (Object)this.resource(fire, "_0")));
        ModelFile up1 = this.templateModel(this.name(fire) + "_up_1", this.mcLoc("template_fire_up"), Pair.of((Object)"fire", (Object)this.resource(fire, "_1")));
        ModelFile up_alt0 = this.templateModel(this.name(fire) + "_up_alt_0", this.mcLoc("template_fire_up_alt"), Pair.of((Object)"fire", (Object)this.resource(fire, "_0")));
        ModelFile up_alt1 = this.templateModel(this.name(fire) + "_up_alt_1", this.mcLoc("template_fire_up_alt"), Pair.of((Object)"fire", (Object)this.resource(fire, "_1")));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(fire).part().modelFile(floor0).nextModel().modelFile(floor1).addModel()).condition((Property)FireBlock.f_53409_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53410_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53411_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53412_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53413_, (Comparable[])new Boolean[]{false}).end().part().modelFile(side0).nextModel().modelFile(side1).nextModel().modelFile(side_alt0).nextModel().modelFile(side_alt1).addModel()).useOr().nestedGroup().condition((Property)FireBlock.f_53409_, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)FireBlock.f_53409_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53410_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53411_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53412_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53413_, (Comparable[])new Boolean[]{false}).end().end().part().modelFile(side0).rotationY(90).nextModel().modelFile(side1).rotationY(90).nextModel().modelFile(side_alt0).rotationY(90).nextModel().modelFile(side_alt1).rotationY(90).addModel()).useOr().nestedGroup().condition((Property)FireBlock.f_53410_, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)FireBlock.f_53409_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53410_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53411_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53412_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53413_, (Comparable[])new Boolean[]{false}).end().end().part().modelFile(side0).rotationY(180).nextModel().modelFile(side1).rotationY(180).nextModel().modelFile(side_alt0).rotationY(180).nextModel().modelFile(side_alt1).rotationY(180).addModel()).useOr().nestedGroup().condition((Property)FireBlock.f_53411_, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)FireBlock.f_53409_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53410_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53411_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53412_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53413_, (Comparable[])new Boolean[]{false}).end().end().part().modelFile(side0).rotationY(270).nextModel().modelFile(side1).rotationY(270).nextModel().modelFile(side_alt0).rotationY(270).nextModel().modelFile(side_alt1).rotationY(270).addModel()).useOr().nestedGroup().condition((Property)FireBlock.f_53412_, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)FireBlock.f_53409_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53410_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53411_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53412_, (Comparable[])new Boolean[]{false}).condition((Property)FireBlock.f_53413_, (Comparable[])new Boolean[]{false}).end().end().part().modelFile(up0).nextModel().modelFile(up1).nextModel().modelFile(up_alt0).nextModel().modelFile(up_alt1).addModel()).condition((Property)FireBlock.f_53413_, (Comparable[])new Boolean[]{true}).end();
    }

    protected void registerStatesAndModels() {
        this.randomRotatedBlock((Block)BlocksNF.SILT.get());
        this.randomRotatedBlock((Block)BlocksNF.DIRT.get());
        this.randomRotatedBlock((Block)BlocksNF.LOAM.get());
        this.randomRotatedBlock((Block)BlocksNF.ASH.get());
        this.randomRotatedBlock((Block)BlocksNF.GRAVEL.get());
        this.randomRotatedBlock((Block)BlocksNF.BLUE_GRAVEL.get());
        this.randomRotatedBlock((Block)BlocksNF.BLACK_GRAVEL.get());
        for (RegistryObject<? extends CoveredSoilBlock> block : BlocksNF.getCoveredSoils()) {
            SoilCover cover = ((CoveredSoilBlock)block.get()).soilCover;
            if (cover == SoilCover.MOSS) {
                this.snowySoilBlock((CoveredSoilBlock)block.get(), block.getId().m_135815_().toString().replace(cover.prefix + "_", ""), cover.prefix + "_top");
                continue;
            }
            this.snowyTintedSoilBlock((CoveredSoilBlock)block.get(), block.getId().m_135815_().toString().replace(cover.prefix + "_", ""), cover.prefix + "_top");
        }
        this.tilledSoilBlock((Block)BlocksNF.TILLED_SILT.get(), this.resource((Block)BlocksNF.SILT.get()));
        this.tilledSoilBlock((Block)BlocksNF.TILLED_DIRT.get(), this.resource((Block)BlocksNF.DIRT.get()));
        this.tilledSoilBlock((Block)BlocksNF.TILLED_LOAM.get(), this.resource((Block)BlocksNF.LOAM.get()));
        this.randomRotatedBlock((Block)BlocksNF.SNOW.get(), this.templateModel((Block)BlocksNF.SNOW.get(), this.mcLoc("snow_height2"), Pair.of((Object)"texture", (Object)this.resource((Block)BlocksNF.SNOW.get())), Pair.of((Object)"particle", (Object)this.resource((Block)BlocksNF.SNOW.get()))));
        this.randomRotatedBlock((Block)BlocksNF.PACKED_SNOW.get(), (ModelFile)this.models().cubeAll(this.name((Block)BlocksNF.PACKED_SNOW.get()), this.resource((Block)BlocksNF.SNOW.get())));
        this.randomRotatedBlock((Block)BlocksNF.MUD.get());
        this.randomRotatedBlock((Block)BlocksNF.CLAY.get());
        this.randomRotatedBlock((Block)BlocksNF.FIRE_CLAY.get());
        this.fireBlock((Block)BlocksNF.FIRE.get());
        this.particleOnlyBlock((Block)BlocksNF.WATER.get(), this.resource("water_still"));
        this.particleOnlyBlock((Block)BlocksNF.SEAWATER.get(), this.resource("seawater_still"));
        this.particleOnlyBlock((Block)BlocksNF.LAVA.get(), this.resource("lava_still"));
        this.randomRotatedBlock((Block)BlocksNF.FRAZIL.get(), this.templateModel((Block)BlocksNF.FRAZIL.get(), this.resource("sunk_face"), Pair.of((Object)"0", (Object)this.resource((Block)BlocksNF.FRAZIL.get())), Pair.of((Object)"particle", (Object)this.resource((Block)BlocksNF.FRAZIL.get()))));
        this.randomRotatedBlock((Block)BlocksNF.SEA_FRAZIL.get(), this.templateModel((Block)BlocksNF.SEA_FRAZIL.get(), this.resource("sunk_face"), Pair.of((Object)"0", (Object)this.resource((Block)BlocksNF.SEA_FRAZIL.get())), Pair.of((Object)"particle", (Object)this.resource((Block)BlocksNF.SEA_FRAZIL.get()))));
        this.groundItemBlock((Block)BlocksNF.SEASHELL.get(), 4);
        this.tallTintedCrossBlock((Block)BlocksNF.TALL_GRASS.get());
        this.vinesBlock((Block)BlocksNF.VINES.get());
        this.crossBlock((Block)BlocksNF.DEAD_BUSH.get());
        this.crossBlock((Block)BlocksNF.DEAD_PLANT.get());
        this.cropBlock((Block)BlocksNF.DEAD_CROP.get(), 1, 1, 2, 2, 3, 3, 3, 4);
        this.cropBlock((Block)BlocksNF.POTATOES.get(), 1, 1, 2, 2, 3, 3, 3, 4);
        this.cropBlock((Block)BlocksNF.CARROTS.get(), 1, 1, 2, 2, 3, 3, 3, 4);
        this.cropBlock((Block)BlocksNF.FLAX.get(), 1, 2, 3, 4, 4, 5, 5, 6);
        this.crossCropBlock((Block)BlocksNF.YARROW.get(), 1, 1, 1, 2, 2, 2, 2, 3);
        this.stagedCrossBlock((Block)BlocksNF.BERRY_BUSH.get(), BlockStatePropertiesNF.STAGE_4);
        for (Stone stone : Stone.values()) {
            if (stone == Stone.PUMICE) {
                this.mirroredBlock((Block)BlocksNF.STONE_BLOCKS.get(stone).get());
            } else {
                ObjectArrayList ores;
                if (stone == Stone.MOONSTONE) {
                    ores = List.of(BlocksNF.METEORITE_ORE);
                } else {
                    ores = new ObjectArrayList();
                    if (BlocksNF.TIN_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.TIN_ORES.get(stone));
                    }
                    if (BlocksNF.COPPER_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.COPPER_ORES.get(stone));
                    }
                    if (BlocksNF.AZURITE_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.AZURITE_ORES.get(stone));
                    }
                    if (BlocksNF.HEMATITE_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.HEMATITE_ORES.get(stone));
                    }
                    if (BlocksNF.COAL_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.COAL_ORES.get(stone));
                    }
                    if (BlocksNF.HALITE_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.HALITE_ORES.get(stone));
                    }
                }
                if (stone == Stone.SLATE || stone == Stone.DEEPSLATE || stone == Stone.SANDSTONE || stone == Stone.SUNSCHIST || stone == Stone.AURGROT) {
                    this.mirroredColumnBlock((Block)BlocksNF.STONE_BLOCKS.get(stone).get());
                    for (RegistryObject ore : ores) {
                        this.mirroredColumnBlock((Block)ore.get());
                    }
                } else {
                    this.mirroredBlock((Block)BlocksNF.STONE_BLOCKS.get(stone).get());
                    for (RegistryObject ore : ores) {
                        this.mirroredBlock((Block)ore.get());
                    }
                }
            }
            this.clusterBlock((ClusterBlock)BlocksNF.ROCK_CLUSTERS.get(stone).get(), this.blockTexture((Block)BlocksNF.STONE_BLOCKS.get(stone).get()), "rock");
        }
        this.clusterBlock((ClusterBlock)BlocksNF.FLINT_CLUSTER.get(), this.resource("flint"), "rock");
        for (Enum enum_ : Tree.values()) {
            this.logBlock((RotatedPillarBlock)BlocksNF.LOGS.get(enum_).get());
            this.stemBlock((TreeStemBlock)((Object)BlocksNF.STEMS.get(enum_).get()), (RotatedPillarBlock)BlocksNF.LOGS.get(enum_).get());
            this.logBlock((RotatedPillarBlock)BlocksNF.STRIPPED_LOGS.get(enum_).get());
            if (enum_ == Tree.PALM) {
                this.rotatedLeavesBlock((Block)BlocksNF.LEAVES.get(enum_).get());
            } else {
                this.crossLeavesBlock((Block)BlocksNF.LEAVES.get(enum_).get());
            }
            this.trunkBlock((TreeTrunkBlock)BlocksNF.TRUNKS.get(enum_).get(), (Block)BlocksNF.LOGS.get(enum_).get());
            if (((Tree)enum_).isDeciduous()) {
                this.deciduousSaplingBlock((Block)BlocksNF.TREE_SEEDS.get(enum_).get());
            } else {
                this.evergreenSaplingBlock((Block)BlocksNF.TREE_SEEDS.get(enum_).get());
            }
            this.fourWayBlock((CrossCollisionBlockNF)BlocksNF.PLANK_FENCES.get(enum_).get(), this.templateModel(BlocksNF.PLANK_FENCES.get(enum_).getId().m_135815_() + "_post", this.resource("fence_post"), Pair.of((Object)"0", (Object)this.resource((Block)BlocksNF.PLANK_FENCES.get(enum_).get()))), this.templateModel(BlocksNF.PLANK_FENCES.get(enum_).getId().m_135815_() + "_side", this.resource("fence_side"), Pair.of((Object)"0", (Object)this.resource((Block)BlocksNF.PLANK_FENCES.get(enum_).get()))));
            this.fenceGateBlock((FenceGateBlockNF)BlocksNF.PLANK_FENCE_GATES.get(enum_).get(), this.resource((Block)BlocksNF.PLANK_FENCES.get(enum_).get()));
            this.doorBlock((DoorBlockNF)BlocksNF.PLANK_DOORS.get(enum_).get());
            this.hatchBlock((HatchBlock)BlocksNF.PLANK_HATCHES.get(enum_).get());
            this.trapdoorBlock((TrapdoorBlockNF)BlocksNF.PLANK_TRAPDOORS.get(enum_).get());
            this.ladderBlock((LadderBlockNF)BlocksNF.PLANK_LADDERS.get(enum_).get());
            this.particleOnlyBlock((Block)BlocksNF.PLANK_STANDING_SIGNS.get(enum_).get(), this.resource((Block)BlocksNF.PLANK_BLOCKS.get(enum_).get()));
            this.particleOnlyBlock((Block)BlocksNF.PLANK_WALL_SIGNS.get(enum_).get(), this.resource((Block)BlocksNF.PLANK_BLOCKS.get(enum_).get()));
            this.directionalBlockNF((Block)BlocksNF.WOODEN_ITEM_FRAMES.get(enum_).get(), this.templateModel((Block)BlocksNF.WOODEN_ITEM_FRAMES.get(enum_).get(), this.resource("item_frame"), Pair.of((Object)"0", (Object)this.resource((Block)BlocksNF.WOODEN_ITEM_FRAMES.get(enum_).get()))), 0);
            this.barrelBlock((BarrelBlockNF)BlocksNF.BARRELS.get(enum_).get());
            this.chestBlock((Block)BlocksNF.CHESTS.get(enum_).get(), this.resource((Block)BlocksNF.PLANK_BLOCKS.get(enum_).get()));
            this.horizontalBlockNF((Block)BlocksNF.RACKS.get(enum_).get(), this.templateModel((Block)BlocksNF.RACKS.get(enum_).get(), this.resource("rack"), Pair.of((Object)"all", (Object)this.resource((Block)BlocksNF.PLANK_BLOCKS.get(enum_).get()))), 0);
            this.horizontalBlockNF((Block)BlocksNF.SHELVES.get(enum_).get(), this.templateModel((Block)BlocksNF.SHELVES.get(enum_).get(), this.resource("shelf_simple"), Pair.of((Object)"all", (Object)this.resource((Block)BlocksNF.SHELVES.get(enum_).get()))), 0);
            this.chairBlock((ChairBlock)BlocksNF.CHAIRS.get(enum_).get(), this.resource((Block)BlocksNF.PLANK_BLOCKS.get(enum_).get()));
            this.troughBlock((TroughBlock)BlocksNF.TROUGHS.get(enum_).get(), this.resource((Block)BlocksNF.PLANK_BLOCKS.get(enum_).get()));
        }
        for (Tree type : BlocksNF.FRUIT_LEAVES.keySet()) {
            if (type.isDeciduous()) {
                this.tintedFruitLeavesBlock((Block)BlocksNF.LEAVES.get(type).get(), (Block)BlocksNF.FRUIT_LEAVES.get(type).get());
                continue;
            }
            if (type == Tree.PALM) {
                this.rotatedFruitLeavesBlock((Block)BlocksNF.LEAVES.get(type).get(), (Block)BlocksNF.FRUIT_LEAVES.get(type).get());
                continue;
            }
            this.fruitLeavesBlock((Block)BlocksNF.LEAVES.get(type).get(), (Block)BlocksNF.FRUIT_LEAVES.get(type).get());
        }
        for (Tree type : BlocksNF.BRANCHES.keySet()) {
            this.crossLeavesBlock((Block)BlocksNF.BRANCHES.get(type).get());
        }
        this.simpleBlock((Block)BlocksNF.GLASS_BLOCK.get());
        ResourceLocation glass = this.resource((Block)BlocksNF.GLASS_BLOCK.get());
        this.slabBlock((SlabBlockNF)BlocksNF.GLASS_SLAB.get(), glass, this.resource((Block)BlocksNF.GLASS_SLAB.get()), glass, glass);
        ResourceLocation glassSiding = this.resource((Block)BlocksNF.GLASS_SIDING.get());
        ResourceLocation glassQuartet = this.resource("glass_quartet");
        ResourceLocation resourceLocation = this.resource("glass_siding_inner_top");
        this.sidingBlock((SidingBlock)BlocksNF.GLASS_SIDING.get(), glass, glass, glassSiding, glassSiding, glassSiding, glassQuartet, glassQuartet, resourceLocation, resourceLocation, this.resource("glass_siding_inner_side"), false);
        this.templateBlock((Block)BlocksNF.TORCH.get(), this.mcLoc("template_torch"), Pair.of((Object)"torch", (Object)this.resource((Block)BlocksNF.TORCH.get())));
        this.templateBlock((Block)BlocksNF.TORCH_UNLIT.get(), this.mcLoc("template_torch"), Pair.of((Object)"torch", (Object)this.resource((Block)BlocksNF.TORCH_UNLIT.get())));
        this.wallTorchBlock((Block)BlocksNF.WALL_TORCH.get(), (Block)BlocksNF.TORCH.get());
        this.wallTorchBlock((Block)BlocksNF.WALL_TORCH_UNLIT.get(), (Block)BlocksNF.TORCH_UNLIT.get());
        this.templateBlock((Block)BlocksNF.WOODEN_BOWL.get(), this.resource("bowl"), Pair.of((Object)"all", (Object)this.resource((Block)BlocksNF.WOODEN_BOWL.get())), Pair.of((Object)"particle", (Object)this.resource((Block)BlocksNF.WOODEN_BOWL.get())));
        this.campfireBlock((CampfireBlockNF)BlocksNF.CAMPFIRE.get());
        this.cauldronBlock((CauldronBlockNF)BlocksNF.CAULDRON.get());
        this.unfiredAxisPotteryBlock((FireablePartialBlock)BlocksNF.UNFIRED_CAULDRON.get());
        this.templateBlock((Block)BlocksNF.POT.get(), this.resource("pot_template"), Pair.of((Object)"all", (Object)this.resource((Block)BlocksNF.POT.get())), Pair.of((Object)"particle", (Object)this.resource((Block)BlocksNF.TERRACOTTA.get())));
        this.unfiredPotteryBlock((FireablePartialBlock)BlocksNF.UNFIRED_POT.get());
        this.horizontalAxisBlock((Block)BlocksNF.WARDING_EFFIGY.get(), this.file((Block)BlocksNF.WARDING_EFFIGY.get()));
        for (RegistryObject<Block> registryObject : BlocksNF.INGOT_PILES.values()) {
            this.horizontalColumnBlock((Block)registryObject.get());
        }
        this.horizontalColumnBottomTopBlock((Block)BlocksNF.STEEL_INGOT_PILE_POOR.get(), this.resource((Block)BlocksNF.INGOT_PILES.get(Metal.IRON).get()), this.resource((Block)BlocksNF.INGOT_PILES.get(Metal.STEEL).get()));
        this.horizontalColumnBottomTopBlock((Block)BlocksNF.STEEL_INGOT_PILE_FAIR.get(), this.resource((Block)BlocksNF.INGOT_PILES.get(Metal.IRON).get()), this.resource((Block)BlocksNF.INGOT_PILES.get(Metal.STEEL).get()));
        for (RegistryObject registryObject : BlocksNF.LANTERNS.values()) {
            this.lanternBlock((Block)registryObject.get());
        }
        for (RegistryObject registryObject : BlocksNF.LANTERNS_UNLIT.values()) {
            this.lanternBlock((Block)registryObject.get());
        }
        for (Tree tree : BlocksNF.ANVILS_LOG.keySet()) {
            this.templateBlock((Block)BlocksNF.ANVILS_LOG.get(tree).get(), this.mcLoc("cube_bottom_top"), Pair.of((Object)"side", (Object)this.resource((Block)BlocksNF.LOGS.get(tree).get())), Pair.of((Object)"top", (Object)this.resource((Block)BlocksNF.STRIPPED_LOGS.get(tree).get(), "_top")), Pair.of((Object)"bottom", (Object)this.resource((Block)BlocksNF.LOGS.get(tree).get(), "_top")));
        }
        for (Stone stone : BlocksNF.ANVILS_STONE.keySet()) {
            this.templateBlock((Block)BlocksNF.ANVILS_STONE.get(stone).get(), this.mcLoc("cube_top"), Pair.of((Object)"side", (Object)this.resource((Block)BlocksNF.STONE_BLOCKS.get(stone).get())), Pair.of((Object)"top", (Object)this.resource((Block)BlocksNF.TILED_STONE.get(stone).get())));
        }
        for (RegistryObject registryObject : BlocksNF.ANVILS_METAL.values()) {
            this.anvilBlock((TieredAnvilBlock)registryObject.get());
        }
        for (RegistryObject registryObject : BlocksNF.ARMAMENT_MOLDS.values()) {
            this.horizontalBlockNF((Block)registryObject.get(), this.file((Block)registryObject.get()), 0);
        }
        this.horizontalBlockNF((Block)BlocksNF.INGOT_MOLD.get(), this.file((Block)BlocksNF.INGOT_MOLD.get()), 0);
        this.horizontalBlockNF((Block)BlocksNF.ARROWHEAD_MOLD.get(), this.file((Block)BlocksNF.ARROWHEAD_MOLD.get()), 0);
        for (Armament armament : BlocksNF.ARMAMENT_MOLDS.keySet()) {
            this.unfiredMoldBlock((Block)BlocksNF.UNFIRED_ARMAMENT_MOLDS.get(armament).get(), (Block)BlocksNF.ARMAMENT_MOLDS.get(armament).get());
        }
        this.unfiredMoldBlock((Block)BlocksNF.UNFIRED_INGOT_MOLD.get(), (Block)BlocksNF.INGOT_MOLD.get());
        this.unfiredMoldBlock((Block)BlocksNF.UNFIRED_ARROWHEAD_MOLD.get(), (Block)BlocksNF.ARROWHEAD_MOLD.get());
        this.simpleHeatableBlock((Block)BlocksNF.COKE_BURNING.get());
        this.simpleHeatableBlock((Block)BlocksNF.COAL_BURNING.get());
        this.horizontalColumnBlock((Block)BlocksNF.CHARCOAL.get());
        this.horizontalHeatableBlock((Block)BlocksNF.CHARCOAL_BURNING.get());
        this.horizontalColumnBlock((Block)BlocksNF.FIREWOOD.get());
        this.horizontalHeatableBlock((Block)BlocksNF.FIREWOOD_BURNING.get());
        this.crucibleBlock((Block)BlocksNF.CRUCIBLE.get());
        this.unfiredAxisPotteryBlock((FireablePartialBlock)BlocksNF.UNFIRED_CRUCIBLE.get());
        this.overlayBurrowBlock((OverlayBurrowBlock)BlocksNF.RABBIT_BURROW.get());
        this.multifaceBlock((Block)BlocksNF.SPIDER_WEB.get(), this.templateModel((Block)BlocksNF.SPIDER_WEB.get(), this.resource("cover"), Pair.of((Object)"0", (Object)this.resource((Block)BlocksNF.SPIDER_WEB.get())), Pair.of((Object)"particle", (Object)this.resource((Block)BlocksNF.SPIDER_WEB.get()))));
        this.columnBlock((Block)BlocksNF.SPIDER_NEST.get());
        this.cubeTopBlock((Block)BlocksNF.ANCHORING_RESIN.get());
        for (Stone stone : BlocksNF.STONE_TUNNELS.keySet()) {
            this.axisBlock((RotatedPillarBlock)BlocksNF.STONE_TUNNELS.get(stone).get(), this.resource((Block)BlocksNF.STONE_BLOCKS.get(stone).get()), this.resource((Block)BlocksNF.STONE_TUNNELS.get(stone).get()));
        }
        for (Stone stone : BlocksNF.SKARA_ROCK_CLUSTERS.keySet()) {
            this.skaraNestBlock((Block)BlocksNF.SKARA_ROCK_CLUSTERS.get(stone).get(), this.blockTexture((Block)BlocksNF.STONE_BLOCKS.get(stone).get()), "rock");
        }
        this.eggNestBlock((EggNestBlock)BlocksNF.DRAKEFOWL_NEST.get());
        for (RegistryObject registryObject : BlocksNF.BLOCKS.getEntries()) {
            if (this.registeredBlocks.containsKey(registryObject.get())) continue;
            if (Files.exists(this.getExternalImagePath(this.extendWithFolder(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)registryObject.getId().m_135815_()))), new LinkOption[0])) {
                this.fileBlock((Block)registryObject.get());
                continue;
            }
            Object object = registryObject.get();
            if (object instanceof StairBlockNF) {
                StairBlockNF stair = (StairBlockNF)object;
                this.stairBlock(stair, this.resource(stair.base));
                continue;
            }
            object = registryObject.get();
            if (object instanceof SlabBlockNF) {
                SlabBlockNF slab = (SlabBlockNF)object;
                this.slabBlock(slab, this.resource(slab.base));
                continue;
            }
            object = registryObject.get();
            if (object instanceof SidingBlock) {
                SidingBlock siding = (SidingBlock)object;
                this.sidingBlock(siding, this.resource(siding.base));
                continue;
            }
            this.simpleBlock((Block)registryObject.get());
        }
    }
}

