/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data;

import com.google.gson.JsonObject;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.block.block.pile.PileBlock;
import frostnox.nightfall.client.model.AnimatedItemModelBuilder;
import frostnox.nightfall.data.extensible.TransformTypeNF;
import frostnox.nightfall.item.Armament;
import frostnox.nightfall.item.IActionableItem;
import frostnox.nightfall.item.TieredArmorMaterial;
import frostnox.nightfall.item.TieredItemMaterial;
import frostnox.nightfall.item.item.BlockItemNF;
import frostnox.nightfall.item.item.MeleeWeaponItem;
import frostnox.nightfall.item.item.ProjectileItem;
import frostnox.nightfall.item.item.TieredArmorItem;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.ModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ItemModelProviderNF
extends ModelProvider<AnimatedItemModelBuilder> {
    protected final String externalPath;

    public ItemModelProviderNF(DataGenerator generator, String id, ExistingFileHelper helper) {
        super(generator, id, "item", AnimatedItemModelBuilder::new, helper);
        String outputString = generator.m_123916_().toString();
        this.externalPath = outputString.substring(0, outputString.lastIndexOf("\\src\\")) + "\\src\\main\\resources\\assets\\" + id + "\\models\\";
    }

    public AnimatedItemModelBuilder getUnsavedBuilder(String path) {
        AnimatedItemModelBuilder builder = (AnimatedItemModelBuilder)this.getBuilder(path);
        this.generatedModels.remove(this.extendWithFolder(path.contains(":") ? ResourceLocation.parse((String)path) : ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path)), (Object)builder);
        return builder;
    }

    protected Path getExternalImagePath(ResourceLocation loc) {
        return this.generator.m_123916_().getFileSystem().getPath(this.externalPath + loc.m_135815_() + ".json", new String[0]);
    }

    protected ResourceLocation extendWithFolder(ResourceLocation location) {
        if (location.m_135815_().contains("/")) {
            return location;
        }
        return ResourceLocation.fromNamespaceAndPath((String)location.m_135827_(), (String)(this.folder + "/" + location.m_135815_()));
    }

    protected ResourceLocation resource(Block block) {
        return ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("block/" + block.getRegistryName().m_135815_()));
    }

    protected ResourceLocation itemLoc(Item item) {
        return this.modLoc("item/" + item.getRegistryName().m_135815_());
    }

    protected ResourceLocation itemLoc(Item item, String suffix) {
        return this.modLoc("item/" + item.getRegistryName().m_135815_() + suffix);
    }

    protected ResourceLocation itemLoc(String name) {
        return this.modLoc("item/" + name);
    }

    protected ResourceLocation blockLoc(Block block) {
        return this.modLoc("block/" + block.getRegistryName().m_135815_());
    }

    protected ResourceLocation blockLoc(Block block, String suffix) {
        return this.modLoc("block/" + block.getRegistryName().m_135815_() + suffix);
    }

    protected ResourceLocation blockLoc(String name) {
        return this.modLoc("block/" + name);
    }

    protected void blockAsDoubleLayerItem(Item item) {
        ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.withExistingParent(item.getRegistryName().m_135815_(), this.modLoc("item/generated"))).texture("layer0", this.modLoc("block/" + item.getRegistryName().m_135815_()))).texture("layer1", this.modLoc("block/" + item.getRegistryName().m_135815_() + "_overlay"));
    }

    protected void doubleLayerItem(Item item) {
        this.doubleLayerItem(item, this.modLoc("item/" + item.getRegistryName().m_135815_()), this.modLoc("item/" + item.getRegistryName().m_135815_() + "_overlay"));
    }

    protected void doubleLayerItem(Item item, ResourceLocation loc1, ResourceLocation loc2) {
        ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.withExistingParent(item.getRegistryName().m_135815_(), this.modLoc("item/generated"))).texture("layer0", loc1)).texture("layer1", loc2);
    }

    protected void genericBlockAsItem(Item item) {
        ((AnimatedItemModelBuilder)this.withExistingParent(item.getRegistryName().m_135815_(), this.modLoc("item/generated"))).texture("layer0", this.modLoc("block/" + item.getRegistryName().m_135815_()));
    }

    protected void genericBlockAsItem(Item item, String texture) {
        ((AnimatedItemModelBuilder)this.withExistingParent(item.getRegistryName().m_135815_(), this.modLoc("item/generated"))).texture("layer0", this.modLoc("block/" + texture));
    }

    protected void handheldItem(Item item) {
        ((AnimatedItemModelBuilder)this.withExistingParent(item.getRegistryName().m_135815_(), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + item.getRegistryName().m_135815_()));
    }

    protected void templateItem(Item item, ResourceLocation parent) {
        ((AnimatedItemModelBuilder)this.withExistingParent(item.getRegistryName().m_135815_(), parent)).texture("layer0", this.modLoc("item/" + item.getRegistryName().m_135815_()));
    }

    protected void genericItem(Item item) {
        ((AnimatedItemModelBuilder)this.withExistingParent(item.getRegistryName().m_135815_(), this.modLoc("item/generated"))).texture("layer0", this.modLoc("item/" + item.getRegistryName().m_135815_()));
    }

    protected void genericItem(Item item, Item textureItem) {
        ((AnimatedItemModelBuilder)this.withExistingParent(item.getRegistryName().m_135815_(), this.modLoc("item/generated"))).texture("layer0", this.modLoc("item/" + textureItem.getRegistryName().m_135815_()));
    }

    protected void genericBlock(Item item) {
        this.withExistingParent(item.getRegistryName().m_135815_(), this.modLoc("block/" + item.getRegistryName().m_135815_()));
    }

    protected void genericBlock(Item item, String suffix) {
        this.withExistingParent(item.getRegistryName().m_135815_(), this.modLoc("block/" + item.getRegistryName().m_135815_() + suffix));
    }

    protected void chest(Tree type) {
        ((AnimatedItemModelBuilder)this.withExistingParent(ItemsNF.CHESTS.get(type).getId().m_135815_(), this.mcLoc("item/chest"))).texture("particle", this.modLoc("block/" + ItemsNF.PLANK_BLOCKS.get(type).getId().m_135815_()));
    }

    protected void sword(Item item) {
        this.doubleModelAnimatedItem(item, "sword", 0.6f, -0.6f);
    }

    protected void sabre(Item item) {
        this.doubleModelAnimatedItem(item, "sabre", 0.6f, -0.65f);
    }

    protected void mace(Item item) {
        this.doubleModelAnimatedItem(item, "mace", 0.6f, -0.65f);
    }

    protected void axe(Item item) {
        this.doubleModelAnimatedItem(item, "axe", 0.75f, -0.12f);
    }

    protected void dagger(Item item) {
        this.doubleModelAnimatedItem(item, "dagger");
    }

    protected void spear(Item item) {
        this.doubleModelAnimatedItem(item, "spear", 0.45f, -0.8f);
    }

    protected void chisel(Item item) {
        this.doubleModelAnimatedItem(item, "chisel");
    }

    protected void hammer(Item item) {
        this.doubleModelAnimatedItem(item, "hammer", 0.7f, -0.2f);
    }

    protected void shovel(Item item) {
        this.doubleModelAnimatedItem(item, "shovel", 0.6f, -0.6f);
    }

    protected void pickaxe(Item item) {
        this.doubleModelAnimatedItem(item, "pickaxe", 0.75f, -0.12f);
    }

    protected void adze(Item item) {
        this.doubleModelAnimatedItem(item, "adze", 0.8f, -0.1f);
    }

    protected void sickle(Item item) {
        this.doubleModelAnimatedItem(item, "sickle", 0.75f, -0.25f);
    }

    protected void shield(Item item) {
        JsonObject base = ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.getUnsavedBuilder(item.getRegistryName().m_135815_()).parent((ModelFile)this.getExistingFile(this.modLoc("item/shield")))).texture("layer0", this.itemLoc(item))).texture("layer1", this.itemLoc(item, "_overlay"))).texture("particle", this.itemLoc(item, "_inventory"))).transforms().transform(TransformTypeNF.RACK).rotation(0.0f, -90.0f, 0.0f).translation(5.0f, 2.0f, 0.0f).end().end()).toJson();
        JsonObject inventory = ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.getUnsavedBuilder(item.getRegistryName().m_135815_()).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.itemLoc(item, "_inventory"))).texture("layer1", this.itemLoc(item, "_inventory_overlay"))).toJson();
        ((AnimatedItemModelBuilder)this.getBuilder(item.getRegistryName().m_135815_())).base(base).inventory(inventory).animatedLoader();
    }

    protected void dyedShield(Item item) {
        String undyedLoc = item.getRegistryName().m_135815_().toString().replace("_dyed", "");
        JsonObject base = ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.getUnsavedBuilder(item.getRegistryName().m_135815_()).parent((ModelFile)this.getExistingFile(this.modLoc("item/shield")))).texture("layer0", this.itemLoc("shield_dyed"))).texture("layer1", this.itemLoc(undyedLoc + "_overlay"))).texture("particle", this.itemLoc(undyedLoc + "_inventory"))).transforms().transform(TransformTypeNF.RACK).rotation(0.0f, -90.0f, 0.0f).translation(5.0f, 2.0f, 0.0f).end().end()).toJson();
        JsonObject inventory = ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.getUnsavedBuilder(item.getRegistryName().m_135815_()).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.itemLoc("shield_dyed_inventory"))).texture("layer1", this.itemLoc(undyedLoc + "_inventory_overlay"))).toJson();
        ((AnimatedItemModelBuilder)this.getBuilder(item.getRegistryName().m_135815_())).base(base).inventory(inventory).animatedLoader();
    }

    protected void sling(Item item) {
        ModelBuilder swinging = ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.getBuilder(item.getRegistryName().m_135815_() + "_swinging")).parent((ModelFile)this.getExistingFile(this.modLoc("item/template_sling_swinging")))).texture("0", this.itemLoc(item))).texture("particle", this.itemLoc(item));
        JsonObject base = ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getUnsavedBuilder(item.getRegistryName().m_135815_()).itemModelBuilder().parent((ModelFile)this.getExistingFile(this.modLoc("item/template_sling")))).texture("0", this.itemLoc(item))).texture("particle", this.itemLoc(item, "_inventory"))).override().predicate(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"swinging"), 1.0f).model((ModelFile)swinging).end().toJson();
        JsonObject inventory = ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.getUnsavedBuilder(item.getRegistryName().m_135815_()).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.itemLoc(item, "_inventory"))).toJson();
        ((AnimatedItemModelBuilder)this.getBuilder(item.getRegistryName().m_135815_())).swapSpeed(1.0f).swapYOffset(0.0f).base(base).inventory(inventory).animatedLoader();
    }

    protected void doubleModelAnimatedItem(Item item, String baseModelName) {
        this.doubleModelAnimatedItem(item, baseModelName, 1.0f, 0.0f);
    }

    protected void doubleModelAnimatedItem(Item item, String baseModelName, float swapSpeed, float swapYOffset) {
        JsonObject base = ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.getUnsavedBuilder(item.getRegistryName().m_135815_()).parent((ModelFile)this.getExistingFile(this.modLoc("item/" + baseModelName)))).texture("base", this.itemLoc(item))).texture("particle", this.itemLoc(item, "_inventory"))).toJson();
        JsonObject inventory = ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.getUnsavedBuilder(item.getRegistryName().m_135815_()).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.itemLoc(item, "_inventory"))).toJson();
        ((AnimatedItemModelBuilder)this.getBuilder(item.getRegistryName().m_135815_())).swapSpeed(swapSpeed).swapYOffset(swapYOffset).base(base).inventory(inventory).animatedLoader();
    }

    protected void animatedItem(Item item) {
        AnimatedItemModelBuilder builder = (AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.getUnsavedBuilder(item.getRegistryName().m_135815_()).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.itemLoc(item));
        ((AnimatedItemModelBuilder)this.getBuilder(item.getRegistryName().m_135815_())).base(builder.toJson()).inventory(builder.toJson()).animatedLoader();
    }

    protected void bow(Item bow) {
        AnimatedItemModelBuilder builder = (AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.getUnsavedBuilder(bow.getRegistryName().m_135815_()).parent((ModelFile)this.getExistingFile(this.mcLoc("item/bow")))).texture("layer0", this.itemLoc(bow));
        this.bowOverride(builder.itemModelBuilder(), bow, (Item)ItemsNF.FLINT_ARROW.get(), ((ProjectileItem)ItemsNF.FLINT_ARROW.get()).getAmmoId());
        this.bowOverride(builder.itemModelBuilder(), bow, (Item)ItemsNF.BONE_ARROW.get(), ((ProjectileItem)ItemsNF.BONE_ARROW.get()).getAmmoId());
        this.bowOverride(builder.itemModelBuilder(), bow, (Item)ItemsNF.RUSTED_ARROW.get(), ((ProjectileItem)ItemsNF.RUSTED_ARROW.get()).getAmmoId());
        for (RegistryObject<ProjectileItem> arrow : ItemsNF.METAL_ARROWS.values()) {
            this.bowOverride(builder.itemModelBuilder(), bow, (Item)arrow.get(), ((ProjectileItem)arrow.get()).getAmmoId());
        }
        builder.transforms().transform(TransformTypeNF.RACK).rotation(0.0f, 180.0f, 0.0f).translation(-1.5f, 11.5f, 7.0f);
        ((AnimatedItemModelBuilder)this.getBuilder(bow.getRegistryName().m_135815_())).base(builder.toJson()).inventory(builder.toJson()).animatedLoader();
    }

    protected void bowOverride(ItemModelBuilder builder, Item bow, Item arrow, int index) {
        String name = bow.getRegistryName().m_135815_() + "_" + arrow.getRegistryName().m_135815_();
        ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.withExistingParent(name + "_pulling_0", this.mcLoc("item/bow"))).texture("layer0", this.itemLoc(bow, "_pulling_0"))).texture("layer1", this.itemLoc(arrow, "_nocked_0"));
        ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.withExistingParent(name + "_pulling_1", this.mcLoc("item/bow"))).texture("layer0", this.itemLoc(bow, "_pulling_1"))).texture("layer1", this.itemLoc(arrow, "_nocked_1"));
        ((AnimatedItemModelBuilder)((AnimatedItemModelBuilder)this.withExistingParent(name + "_pulling_2", this.mcLoc("item/bow"))).texture("layer0", this.itemLoc(bow, "_pulling_2"))).texture("layer1", this.itemLoc(arrow, "_nocked_2"));
        builder.override().predicate(this.modLoc("pull"), 0.001f).predicate(this.modLoc("ammo"), (float)index).model((ModelFile)this.getExistingFile(this.itemLoc(name + "_pulling_0"))).end().override().predicate(this.modLoc("pull"), 0.6f).predicate(this.modLoc("ammo"), (float)index).model((ModelFile)this.getExistingFile(this.itemLoc(name + "_pulling_1"))).end().override().predicate(this.modLoc("pull"), 0.9f).predicate(this.modLoc("ammo"), (float)index).model((ModelFile)this.getExistingFile(this.itemLoc(name + "_pulling_2"))).end();
    }

    protected void registerModels() {
        this.genericBlockAsItem((Item)ItemsNF.SHORT_GRASS.get());
        this.genericBlockAsItem((Item)ItemsNF.GRASS.get());
        this.genericBlockAsItem((Item)ItemsNF.TALL_GRASS.get());
        this.genericBlockAsItem((Item)ItemsNF.SMALL_FERN.get());
        this.genericBlockAsItem((Item)ItemsNF.FERN.get());
        this.genericBlockAsItem((Item)ItemsNF.LARGE_FERN.get());
        this.genericBlockAsItem((Item)ItemsNF.VINES.get());
        this.genericBlockAsItem((Item)ItemsNF.DEAD_BUSH.get());
        this.genericBlockAsItem((Item)ItemsNF.DEAD_PLANT.get());
        this.genericBlockAsItem((Item)ItemsNF.DEAD_CROP.get(), "dead_crop_1");
        this.genericItem((Item)ItemsNF.SEASHELL.get());
        this.genericItem((Item)ItemsNF.BERRY_BUSH.get());
        this.genericItem((Item)ItemsNF.POTATO_SEEDS.get());
        this.genericItem((Item)ItemsNF.CARROT_SEEDS.get());
        this.genericItem((Item)ItemsNF.FLAX_SEEDS.get());
        this.genericItem((Item)ItemsNF.YARROW_SEEDS.get());
        for (Stone stone : Stone.values()) {
            this.genericBlock((Item)ItemsNF.ROCK_CLUSTERS.get(stone).get(), "_3");
        }
        this.genericBlock((Item)ItemsNF.FLINT_CLUSTER.get(), "_3");
        for (Enum enum_ : Tree.values()) {
            this.templateItem((Item)ItemsNF.PLANKS.get(enum_).get(), this.modLoc("item/handheld_small"));
            this.genericItem((Item)ItemsNF.LOGS.get(enum_).get());
            this.genericItem((Item)ItemsNF.STRIPPED_LOGS.get(enum_).get());
            this.genericItem((Item)ItemsNF.TREE_SEEDS.get(enum_).get());
            ((AnimatedItemModelBuilder)this.withExistingParent(((BlockItemNF)((Object)ItemsNF.PLANK_FENCES.get(enum_).get())).getRegistryName().m_135815_(), this.blockLoc("fence_inventory"))).texture("0", this.resource((Block)BlocksNF.PLANK_FENCES.get(enum_).get()));
            ((AnimatedItemModelBuilder)this.withExistingParent(((BlockItemNF)((Object)ItemsNF.PLANK_FENCE_GATES.get(enum_).get())).getRegistryName().m_135815_(), this.blockLoc("template_fence_gate"))).texture("0", this.resource((Block)BlocksNF.PLANK_FENCES.get(enum_).get()));
            this.genericItem((Item)ItemsNF.PLANK_DOORS.get(enum_).get());
            this.genericBlock((Item)ItemsNF.PLANK_TRAPDOORS.get(enum_).get(), "_bottom");
            this.genericBlockAsItem((Item)ItemsNF.PLANK_LADDERS.get(enum_).get());
            this.genericItem((Item)ItemsNF.PLANK_SIGNS.get(enum_).get());
            this.genericItem((Item)ItemsNF.WOODEN_ITEM_FRAMES.get(enum_).get());
            this.genericItem((Item)ItemsNF.RACKS.get(enum_).get());
            this.genericItem((Item)ItemsNF.CHAIRS.get(enum_).get());
            this.genericBlock((Item)ItemsNF.TROUGHS.get(enum_).get(), "_0");
        }
        this.handheldItem((Item)ItemsNF.STICK.get());
        this.genericItem((Item)ItemsNF.SNOWBALL_THROWABLE.get(), (Item)ItemsNF.SNOWBALL.get());
        this.templateItem((Item)ItemsNF.TORCH.get(), this.modLoc("item/handheld_small_flipped"));
        this.templateItem((Item)ItemsNF.TORCH_UNLIT.get(), this.modLoc("item/handheld_small_flipped"));
        this.genericItem((Item)ItemsNF.ROPE.get());
        this.genericItem((Item)ItemsNF.WOODEN_BOWL.get());
        this.genericItem((Item)ItemsNF.CAMPFIRE.get());
        for (TieredItemMaterial tieredItemMaterial : ItemsNF.METAL_ARMAMENTS.keySet()) {
            Map<Armament, RegistryObject<MeleeWeaponItem>> set = ItemsNF.METAL_ARMAMENTS.get(tieredItemMaterial);
            this.adze((Item)set.get(Armament.ADZE).get());
            this.axe((Item)set.get(Armament.AXE).get());
            this.dagger((Item)set.get(Armament.DAGGER).get());
            this.chisel((Item)set.get(Armament.CHISEL).get());
            this.hammer((Item)set.get(Armament.HAMMER).get());
            this.mace((Item)set.get(Armament.MACE).get());
            this.pickaxe((Item)set.get(Armament.PICKAXE).get());
            this.sabre((Item)set.get(Armament.SABRE).get());
            this.sickle((Item)set.get(Armament.SICKLE).get());
            this.shovel((Item)set.get(Armament.SHOVEL).get());
            this.spear((Item)set.get(Armament.SPEAR).get());
            this.sword((Item)set.get(Armament.SWORD).get());
        }
        for (RegistryObject registryObject : ItemsNF.getTieredArmors()) {
            TieredArmorMaterial material = (TieredArmorMaterial)((TieredArmorItem)((Object)registryObject.get())).material;
            if (material == TieredArmorMaterial.LEATHER || material == TieredArmorMaterial.PADDED && ((TieredArmorItem)((Object)registryObject.get())).slot != EquipmentSlot.CHEST || material == TieredArmorMaterial.RAGGED && (((TieredArmorItem)((Object)registryObject.get())).slot == EquipmentSlot.HEAD || ((TieredArmorItem)((Object)registryObject.get())).slot == EquipmentSlot.FEET)) {
                this.genericItem((Item)registryObject.get());
                continue;
            }
            this.doubleLayerItem((Item)registryObject.get());
        }
        this.spear((Item)ItemsNF.FLINT_SPEAR.get());
        this.spear((Item)ItemsNF.RUSTED_SPEAR.get());
        this.sling((Item)ItemsNF.SLING.get());
        this.sling((Item)ItemsNF.SLING_REINFORCED.get());
        for (RegistryObject registryObject : ItemsNF.BOWS.values()) {
            this.bow((Item)registryObject.get());
        }
        this.bow((Item)ItemsNF.TWISTED_BOW.get());
        this.doubleLayerItem((Item)ItemsNF.POUCH.get());
        this.shield((Item)ItemsNF.IRONWOOD_SHIELD.get());
        this.dyedShield((Item)ItemsNF.IRONWOOD_SHIELD_DYED.get());
        this.genericItem((Item)ItemsNF.WARDING_EFFIGY.get());
        for (RegistryObject registryObject : ItemsNF.METAL_SHIELDS.values()) {
            this.shield((Item)registryObject.get());
        }
        for (RegistryObject registryObject : ItemsNF.METAL_SHIELDS_DYED.values()) {
            this.dyedShield((Item)registryObject.get());
        }
        for (RegistryObject registryObject : ItemsNF.LANTERNS_UNLIT.values()) {
            this.genericItem((Item)registryObject.get());
        }
        for (RegistryObject registryObject : ItemsNF.LANTERNS.values()) {
            this.genericItem((Item)registryObject.get());
        }
        for (RegistryObject registryObject : ItemsNF.ARMAMENT_MOLDS.values()) {
            this.genericItem((Item)registryObject.get());
        }
        this.genericItem((Item)ItemsNF.INGOT_MOLD.get());
        this.genericItem((Item)ItemsNF.ARROWHEAD_MOLD.get());
        for (RegistryObject registryObject : ItemsNF.UNFIRED_ARMAMENT_MOLDS.values()) {
            this.genericItem((Item)registryObject.get());
        }
        this.genericItem((Item)ItemsNF.UNFIRED_INGOT_MOLD.get());
        this.genericItem((Item)ItemsNF.UNFIRED_ARROWHEAD_MOLD.get());
        this.genericBlock((Item)ItemsNF.CRUCIBLE.get(), "_none");
        this.genericBlockAsItem((Item)ItemsNF.SPIDER_WEB.get());
        this.genericBlock((Item)ItemsNF.DRAKEFOWL_NEST.get(), "_0");
        for (RegistryObject registryObject : ItemsNF.ITEMS.getEntries()) {
            ResourceLocation loc = this.extendWithFolder(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)registryObject.getId().m_135815_()));
            if (this.generatedModels.containsKey(loc) || Files.exists(this.getExternalImagePath(loc), new LinkOption[0])) continue;
            Object object = registryObject.get();
            if (object instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)object;
                if (blockItem.m_40614_() instanceof PileBlock) {
                    this.genericBlock((Item)registryObject.get(), "_8");
                    continue;
                }
                this.genericBlock((Item)registryObject.get());
                continue;
            }
            if (registryObject.get() instanceof IActionableItem) {
                this.animatedItem((Item)registryObject.get());
                continue;
            }
            if (registryObject.get() instanceof SpawnEggItem) {
                this.withExistingParent(registryObject.getId().m_135815_(), this.modLoc("item/template_spawn_egg"));
                continue;
            }
            this.genericItem((Item)registryObject.get());
        }
    }

    public String m_6055_() {
        return "Item Models: " + this.modid;
    }
}

