/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data;

import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.action.player.PlayerActionSet;
import frostnox.nightfall.block.Metal;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.gui.CategoryToast;
import frostnox.nightfall.client.gui.EntryToast;
import frostnox.nightfall.client.gui.screen.container.CrucibleScreen;
import frostnox.nightfall.client.gui.screen.encyclopedia.EncyclopediaScreen;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryPuzzleScreen;
import frostnox.nightfall.data.recipe.CauldronRecipe;
import frostnox.nightfall.encyclopedia.Entry;
import frostnox.nightfall.encyclopedia.knowledge.Knowledge;
import frostnox.nightfall.entity.PlayerAttribute;
import frostnox.nightfall.item.Armament;
import frostnox.nightfall.item.TieredArmorMaterial;
import frostnox.nightfall.network.command.EntryCommand;
import frostnox.nightfall.network.command.GodModeCommand;
import frostnox.nightfall.network.command.KnowledgeCommand;
import frostnox.nightfall.network.command.ReselectAttributesCommand;
import frostnox.nightfall.registry.EntriesNF;
import frostnox.nightfall.registry.KnowledgeNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.registry.forge.FluidsNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.DataUtil;
import frostnox.nightfall.util.RenderUtil;
import frostnox.nightfall.world.ToolActionsNF;
import frostnox.nightfall.world.inventory.AccessorySlot;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.text.WordUtils;

public class LanguageProviderNF
extends LanguageProvider {
    protected final Set<Object> addedObjects = new HashSet<Object>();

    public LanguageProviderNF(DataGenerator gen, String id, String locale) {
        super(gen, id, locale);
    }

    public void add(Item key, String name) {
        super.add(key, name);
        this.addedObjects.add(key);
    }

    public void add(EntityType<?> key, String name) {
        super.add(key, name);
        this.addedObjects.add(key);
    }

    public void add(MobEffect key, String name) {
        super.add(key, name);
        this.addedObjects.add(key);
    }

    protected void addAttack(String name, String text) {
        this.add("death.attack." + name, text);
    }

    protected void addAttackItem(DamageType type, String text) {
        this.add("death.attack." + type.toString(), text);
        this.add("death.attack." + type.toString() + ".item", text + " using %3$s");
    }

    protected void addFluid(RegistryObject<? extends Fluid> fluid, String text) {
        this.add(((Fluid)fluid.get()).getAttributes().getTranslationKey(), text);
    }

    protected void addEntry(RegistryObject<? extends Entry> entry, String title) {
        this.add(((Entry)((Object)entry.get())).getDescriptionId(), title);
        this.addedObjects.add(entry.get());
    }

    protected void addItemClue(RegistryObject<? extends Entry> entry, int index, String text) {
        this.add("entry." + entry.getId().toString().replace(":", ".") + ".item_" + index, text);
    }

    protected void addKnowledgeClue(RegistryObject<? extends Entry> entry, int index, String text) {
        this.add("entry." + entry.getId().toString().replace(":", ".") + ".knowledge_" + index, text);
    }

    protected void addConditionClue(RegistryObject<? extends Entry> entry, int index, String text) {
        this.add("entry." + entry.getId().toString().replace(":", ".") + ".condition_" + index, text);
    }

    protected void addItemClues(RegistryObject<? extends Entry> entry, String ... text) {
        for (int i = 0; i < text.length; ++i) {
            this.addItemClue(entry, i, text[i]);
        }
    }

    protected void addKnowledgeClues(RegistryObject<? extends Entry> entry, String ... text) {
        for (int i = 0; i < text.length; ++i) {
            this.addKnowledgeClue(entry, i, text[i]);
        }
    }

    protected void addConditionClues(RegistryObject<? extends Entry> entry, String ... text) {
        for (int i = 0; i < text.length; ++i) {
            this.addConditionClue(entry, i, text[i]);
        }
    }

    protected void addSound(RegistryObject<? extends SoundEvent> sound, String text) {
        this.add(sound.getId().m_135827_() + "." + sound.getId().m_135815_(), text);
    }

    protected void addSound(SoundEvent sound, String text) {
        this.add(sound.getRegistryName().m_135827_() + "." + sound.getRegistryName().m_135815_(), text);
    }

    protected void addComponent(TranslatableComponent component, String text) {
        this.add(component.m_131328_(), text);
    }

    protected void addTranslations() {
        this.add("selectWorld.mapFeatures.info", "");
        this.add("selectWorld.gameMode.survival.line1", "Search for resources, craft,");
        this.add("selectWorld.gameMode.survival.line2", "and manage health and hunger");
        this.add("selectWorld.gameMode.hardcore.line1", "Same as Survival Mode, but");
        this.add("selectWorld.gameMode.hardcore.line2", "death is permanent");
        this.add("selectWorld.gameMode.creative.line1", "Unlimited resources, free flying,");
        this.add("selectWorld.gameMode.creative.line2", "and destroy blocks instantly");
        this.add("selectWorld.allowCommands.info", "Commands like /gamemode");
        this.add("nightfall.message.controls_command", "Thank you for playing Nightfall. Type '/nightfall controls' for info on the mod's controls.");
        this.add("commands.info.encyclopedia", "Open your encyclopedia with '%s'.");
        this.add("commands.info.dash", "Perform a directional dash with '%s'.");
        this.add("commands.info.crawl", "Start crawling by double-tapping the sneak key '%s'.");
        this.add("commands.info.climb", "Start climbing by holding the jump key '%s' against a ledge.");
        this.add("commands.info.prioritize_offhand", "Hold '%s' to attack/use offhand items.");
        this.add("commands.info.modify_item_behavior", "Hold '%s' with certain items (such as building materials) to modify their use behavior.");
        this.add("debug.error", "Cannot execute command in %s mode");
        this.add("season.spring", "Spring");
        this.add("season.summer", "Summer");
        this.add("season.fall", "Fall");
        this.add("season.winter", "Winter");
        this.add("weather.clear", "Clear");
        this.add("weather.clouds", "Clouds");
        this.add("weather.rain", "Rain");
        this.add("weather.snow", "Snow");
        this.add("weather.fog", "Fog");
        this.add("action.basic", "Basic");
        this.add("action.alternate", "Alternate");
        this.add("action.technique", "Technique");
        this.add("action.basic_paired", "Paired Basic");
        this.add("action.alternate_paired", "Paired Alternate");
        this.add("action.guard", "Guard");
        this.add("action.throw", "Throw");
        this.add("action.upset", "Upset");
        this.add("action.riposte", "Riposte");
        this.add("action.wrap", "Wrap");
        this.add("action.control", " (%s)");
        this.add("action.control_held", " (Hold %s)");
        this.add("block.holdable", "Carriable");
        this.add("block.holdable.control", "(Crouch and use with empty hand)");
        this.add("block.fireable", "Fires at ");
        this.add("block.capacity", "%s Capacity");
        this.add("block.crucible.pour", "Carry and use to pour fluids");
        this.add("block.warding_effigy.info", "Prevents nearby Undead occurrence");
        this.add("item.on_use", "On Use: ");
        this.add("item.toolactions", "Can perform ");
        this.add("item.integrity", "%s Integrity");
        this.add("item.dig_speed", "%s%% Dig Speed");
        this.add("item.nutrition", "%s Nutrition");
        this.add("item.low_saturation", "Scarce Meal");
        this.add("item.medium_saturation", "Fair Meal");
        this.add("item.high_saturation", "Ample Meal");
        this.add("item.pair", "Pairs with ");
        this.add("item.durability_penalty", "%s%% Durability Penalty");
        this.add("item.armor.style.survivor", "+10% Durability");
        this.add("item.armor.defense", "Defense");
        this.add("action.guard.block", "Blocks %1$s %2$s");
        this.add("action.guard.riposte_1", "Perform basic after successful");
        this.add("action.guard.riposte_2", "block to trigger riposte");
        this.add("action.fiber_bandage_use.info", "Cures 30s of Bleeding");
        this.add("action.bandage_use.info_0", "Cures Bleeding");
        this.add("action.bandage_use.info_1", "+10 Health");
        this.add("action.medicinal_bandage_use.info", "+40 Regenerating Health");
        this.add("tooltip.expand_prompt", "[Hold shift for more]");
        this.add("toolaction." + ToolActionsNF.REFINE.name(), WordUtils.capitalize((String)ToolActionsNF.REFINE.name()));
        this.add("toolaction." + ToolActionsNF.STRIP.name(), WordUtils.capitalize((String)ToolActionsNF.STRIP.name()));
        this.add("toolaction." + ToolActionsNF.TILL.name(), WordUtils.capitalize((String)ToolActionsNF.TILL.name()));
        this.add("toolaction." + ToolActionsNF.SKIN.name(), WordUtils.capitalize((String)ToolActionsNF.SKIN.name()));
        this.add("anvil.action.context", "Smithing: ");
        this.add("anvil.action.context_charged", "Smithing (Charged): ");
        this.add("anvil.action.punch.info", "Punch 1x1 area");
        this.add("anvil.action.punch_line.info", "Punch 3x1 area");
        this.add("anvil.action.punch_square.info", "Punch 3x3 area");
        this.add("anvil.action.bend.info", "Shifts line backwards");
        this.add("anvil.action.draw.info", "Draws 3x1 edge forwards");
        this.add("anvil.action.draw_line.info", "Draws entire edge forwards");
        this.add("anvil.action.upset.info", "Upsets 3x1 edge backwards");
        this.add("anvil.action.upset_line.info", "Upsets entire edge backwards");
        for (PlayerActionSet playerActionSet : PlayerActionSet.SETS) {
            this.add("action_set." + playerActionSet.toString(), WordUtils.capitalize((String)playerActionSet.toString().replace("_", " ")));
        }
        for (TieredHeat tieredHeat : TieredHeat.values()) {
            this.add("heat.tier." + tieredHeat.getTier(), "Heat Tier " + tieredHeat.getTier());
            this.add("block.heat_resistant." + tieredHeat.getTier(), "Heat Resistant " + tieredHeat.getTier());
        }
        this.add("item.nightfall.mask.info", "Hides name");
        this.add("item.nightfall.warding_charm.info", "Reduces nearby Undead occurrence");
        this.add("item.leading", "Use on tamed animals to lead");
        this.add("nightfall.anvil", "Anvil");
        this.add("nightfall.bowl_crushing", "Bowl");
        this.add("nightfall.building", "Building");
        this.add("nightfall.campfire", "Campfire");
        this.add("nightfall.cauldron", "Cauldron");
        this.add("nightfall.crucible", "Crucible");
        this.add("nightfall.held_tool", "Held Tool");
        this.add("nightfall.barrel", "Barrel");
        this.addComponent(CauldronRecipe.UNIT, "part");
        this.addComponent(CauldronRecipe.UNITS, "parts");
        this.add("nightfall.cauldron.min_phrase", "At least %s ");
        this.add("nightfall.cauldron.max_phrase", "At most %s ");
        this.add("nightfall.cauldron.range_phrase", "%1$s to %2$s ");
        for (Enum enum_ : Metal.values()) {
            this.add("metal." + enum_.getName(), WordUtils.capitalize((String)enum_.getName().replace("_", " ")));
        }
        this.add("food.small", "Small");
        this.add("food.medium", "Medium");
        this.add("food.large", "Large");
        this.add("nightfall.command.entry.forget.self", "Forgot entry %s");
        this.add("nightfall.command.entry.forget", "You forgot entry %s");
        this.add("nightfall.command.entry.forget.other", "%s forgot entry %s");
        this.addComponent(EntryCommand.FORGET_ALL_SELF, "Forgot all entries");
        this.addComponent(EntryCommand.FORGET_ALL, "You forgot all entries");
        this.add("nightfall.command.entry.forget_all.other", "%s forgot all entries");
        this.add("nightfall.command.entry.learn.self", "Learned entry %s");
        this.add("nightfall.command.entry.learn", "You learned entry %s");
        this.add("nightfall.command.entry.learn.other", "%s learned entry %s");
        this.addComponent(EntryCommand.LEARN_ALL_SELF, "Learned all entries");
        this.addComponent(EntryCommand.LEARN_ALL, "You learned all entries");
        this.add("nightfall.command.entry.learn_all.other", "%s learned all entries");
        this.add("nightfall.command.entry.not_found", "Invalid entry: %s");
        this.add("nightfall.command.knowledge.forget.self", "Forgot knowledge %s");
        this.add("nightfall.command.knowledge.forget", "You forgot knowledge %s");
        this.add("nightfall.command.knowledge.forget.other", "%s forgot knowledge %s");
        this.addComponent(KnowledgeCommand.FORGET_ALL_SELF, "Forgot all knowledge");
        this.addComponent(KnowledgeCommand.FORGET_ALL, "You forgot all knowledge");
        this.add("nightfall.command.knowledge.forget_all.other", "%s forgot all knowledge");
        this.add("nightfall.command.knowledge.learn.self", "Learned knowledge %s");
        this.add("nightfall.command.knowledge.learn", "You learned knowledge %s");
        this.add("nightfall.command.knowledge.learn.other", "%s learned knowledge %s");
        this.addComponent(KnowledgeCommand.LEARN_ALL_SELF, "Learned all knowledge");
        this.addComponent(KnowledgeCommand.LEARN_ALL, "You learned all knowledge");
        this.add("nightfall.command.knowledge.learn_all.other", "%s learned all knowledge");
        this.add("nightfall.command.knowledge.not_found", "Invalid knowledge: %s");
        this.addComponent(GodModeCommand.ENABLE, "Godmode enabled");
        this.addComponent(GodModeCommand.DISABLE, "Godmode disabled");
        this.add("commands.godmode.enable.other", "Godmode enabled for %s");
        this.add("commands.godmode.disable.other", "Godmode disabled for %s");
        this.addComponent(ReselectAttributesCommand.RESELECT, "Reselecting attributes...");
        this.add("commands.reselect_attributes.enable.other", "Prompted %s to reselect attributes");
        this.add("commands.time.season.query", "The season is %s");
        this.add("commands.time.season.set", "Set the season to %s");
        this.add("commands.time.weather.query", "The weather is %1$s with global intensity %2$s (%3$s moving to %4$s)");
        this.add("commands.time.weather.set", "Set the weather to %1$s with global intensity %2$s");
        this.add(ClientEngine.get().keyDash.m_90860_(), "Dash");
        this.add(ClientEngine.get().keyOffhand.m_90860_(), "Prioritize Offhand Interactions");
        this.add(ClientEngine.get().keyEncyclopedia.m_90860_(), "Open/Close Encyclopedia");
        this.add(ClientEngine.get().keyModify.m_90860_(), "Modify Item Behavior");
        this.add(ClientEngine.get().WYLDERY.name(), "Wyldery");
        this.add(ClientEngine.get().METALLURGY.name(), "Metallurgy");
        this.add("item.emits_light", "Emits light");
        for (Enum enum_ : EquipmentSlot.values()) {
            this.add(enum_.m_20751_(), WordUtils.capitalize((String)enum_.m_20751_()));
        }
        for (Enum enum_ : AccessorySlot.values()) {
            this.add(((AccessorySlot)enum_).toString(), WordUtils.capitalize((String)((AccessorySlot)enum_).toString()));
            this.add("item.modifiers." + (AccessorySlot)enum_, "When on " + WordUtils.capitalize((String)((AccessorySlot)enum_).toString()) + ":");
        }
        this.addComponent(RenderUtil.ATTRIBUTES_TEXT, "Attributes");
        this.addComponent(RenderUtil.RESISTANCES_TEXT, "Resistances");
        this.addComponent(RenderUtil.EFFECT_DEFENSE_TEXT, "Effects: ");
        this.addComponent(RenderUtil.ARMOR_DEFENSE_TEXT, "Armor average: ");
        this.addComponent(RenderUtil.FREE_POINTS_TEXT, "Free points: ");
        for (TranslatableComponent translatableComponent : RenderUtil.FOOD_GROUPS_TEXT) {
            this.addComponent(translatableComponent, DataUtil.toTitleCase(translatableComponent.m_131328_().substring(translatableComponent.m_131328_().lastIndexOf(46) + 1).replace("_", " ")));
        }
        for (PlayerAttribute playerAttribute : PlayerAttribute.values()) {
            if (playerAttribute == PlayerAttribute.WILLPOWER) {
                this.addComponent(RenderUtil.getAttributeText(playerAttribute), "???");
                continue;
            }
            this.addComponent(RenderUtil.getAttributeText(playerAttribute), WordUtils.capitalize((String)playerAttribute.toString()));
        }
        this.add("screen." + PlayerAttribute.VITALITY + ".info", "%s health");
        this.add("screen." + PlayerAttribute.ENDURANCE + ".info", "%1$s stamina / %2$s%% regeneration");
        this.add("screen." + PlayerAttribute.WILLPOWER + ".info", "???");
        this.add("screen." + PlayerAttribute.STRENGTH + ".info", "%s%% tool & weapon efficiency");
        this.add("screen." + PlayerAttribute.AGILITY + ".info", "%s%% movement speed");
        this.add("screen." + PlayerAttribute.PERCEPTION + ".info", "Influences rare item discovery");
        this.add("screen.finalize", "Finalize");
        for (DamageType damageType : DamageType.values()) {
            this.addComponent(RenderUtil.getDamageTypeText(damageType), WordUtils.capitalize((String)damageType.toString()));
        }
        for (Poise poise : Poise.values()) {
            this.add("poise." + poise.m_7912_(), WordUtils.capitalize((String)poise.m_7912_()));
        }
        for (RegistryObject registryObject : AttributesNF.ATTRIBUTES.getEntries()) {
            if (registryObject == AttributesNF.STAMINA_REDUCTION) {
                this.add(((Attribute)registryObject.get()).m_22087_(), "Stamina Used");
                continue;
            }
            this.add(((Attribute)registryObject.get()).m_22087_(), DataUtil.getLocalName(registryObject.getId().m_135815_()));
        }
        this.addComponent(EncyclopediaScreen.LOCKED_ENTRY, "???");
        this.addComponent(EntryPuzzleScreen.MISSING_KNOWLEDGE, "Knowledge requirements not met");
        this.addComponent(EntryPuzzleScreen.HIDDEN_KNOWLEDGE, "???");
        this.addComponent(CrucibleScreen.SOLID, "Solid");
        this.addComponent(CrucibleScreen.MOLTEN, "Molten");
        this.addComponent(CategoryToast.PREFIX, "Discovered ");
        this.addComponent(EntryToast.PREFIX, "Discovered ");
        this.addComponent(EntryToast.PREFIX_ADDENDUM, "Revised ");
        this.addComponent(EntryToast.PREFIX_HIDDEN, "Uncovered ");
        this.add("container.nightfall.search", "Search...");
        this.add("itemGroup.nightfall.natural_blocks", "Natural Blocks");
        this.add("itemGroup.nightfall.functional_blocks", "Functional Blocks");
        this.add("itemGroup.nightfall.building_materials", "Building Materials");
        this.add("itemGroup.nightfall.ingredients", "Ingredients");
        this.add("itemGroup.nightfall.food", "Foodstuffs");
        this.add("itemGroup.nightfall.armaments", "Armaments");
        this.add("itemGroup.nightfall.armor", "Armor");
        this.add("itemGroup.nightfall.utilities", "Utilities");
        this.add("itemGroup.nightfall.consumables", "Consumables");
        this.add("generator.nightfall.continental", "Continental");
        this.add("generator.nightfall.flat", "Superflat");
        this.add("nightfall.block.fall", "Block falls");
        this.addSound(SoundsNF.SIZZLE, "Something sizzles");
        this.addSound(SoundsNF.ICE_CRACKLE, "Ice crackles");
        this.addSound(SoundsNF.ANVIL_STRIKE, "Tool strikes anvil piece");
        this.addSound(SoundsNF.WOODEN_BOWL_CRUSH, "Something crushes in wooden bowl");
        this.addSound(SoundsNF.CRUCIBLE_POUR, "Metal pours from crucible");
        this.addSound(SoundsNF.FIRE_CRACKLE, "Fire crackles");
        this.addSound(SoundsNF.TROUGH_FILL, "Trough fills");
        this.add("nightfall.block.ceramic.open", "Ceramic vessel opens");
        this.addSound(SoundsNF.SWING, "Weapon whooshes");
        this.addSound(SoundsNF.SWING_CHARGED, "Weapon whooshes forcefully");
        this.addSound(SoundsNF.BLADE_SWING, "Blade whooshes");
        this.addSound(SoundsNF.BLADE_SWING_CHARGED, "Blade whooshes forcefully");
        this.addSound(SoundsNF.SHORT_BLADE_SWING, "Short blade whooshes");
        this.addSound(SoundsNF.SHORT_BLADE_SWING_CHARGED, "Short blade whooshes forcefully");
        this.addSound(SoundsNF.LONG_BLADE_SWING, "Long blade whooshes");
        this.addSound(SoundsNF.LONG_BLADE_SWING_CHARGED, "Long blade whooshes forcefully");
        this.addSound(SoundsNF.HEAVY_BLADE_SWING, "Heavy weapon whooshes");
        this.addSound(SoundsNF.HEAVY_BLADE_SWING_CHARGED, "Heavy weapon whooshes forcefully");
        this.addSound(SoundsNF.HAMMER_CHISEL_HIT, "Hammer hits chisel");
        this.addSound(SoundsNF.HAMMER_FLINT_CHISEL_HIT, "Hammer hits flint chisel");
        this.addSound(SoundsNF.BANDAGE_HEAL, "Bandage tightens");
        this.addSound(SoundsNF.BOW_PULL, "Bow stretches");
        this.addSound(SoundsNF.BOW_SHOOT, "Arrow fires");
        this.addSound(SoundsNF.BOW_SHOOT_CHARGED, "Arrow launches");
        this.addSound(SoundsNF.WEAPON_BLOCK, "Weapon clashes");
        this.addSound(SoundsNF.SLASH_FLESH, "Something slashes flesh");
        this.addSound(SoundsNF.SLASH_ARMOR, "Something slashes armor");
        this.addSound(SoundsNF.SLASH_BONE, "Something slashes bone");
        this.addSound(SoundsNF.SLASH_STONE, "Something slashes stone");
        this.addSound(SoundsNF.PIERCE_FLESH, "Something pierces flesh");
        this.addSound(SoundsNF.PIERCE_ARMOR, "Something pierces armor");
        this.addSound(SoundsNF.PIERCE_BONE, "Something pierces bone");
        this.addSound(SoundsNF.PIERCE_STONE, "Something pierces stone");
        this.addSound(SoundsNF.STRIKE_FLESH, "Something strikes flesh");
        this.addSound(SoundsNF.STRIKE_ARMOR, "Something strikes armor");
        this.addSound(SoundsNF.STRIKE_BONE, "Something strikes bone");
        this.addSound(SoundsNF.STRIKE_STONE, "Something strikes stone");
        this.addSound(SoundsNF.BLEEDING_HIT, "Bleeding hurts");
        this.addSound(SoundsNF.POISON_HIT, "Poison hurts");
        this.addSound(SoundsNF.TILL_SOIL, "Soil stirs");
        this.addSound(SoundsNF.STRIP_WOOD, "Bark peels");
        this.addSound(SoundsNF.SKIN_FLESH, "Skin peels");
        this.addSound(SoundsNF.DEER_DEATH, "Deer dies");
        this.addSound(SoundsNF.DEER_HURT, "Deer whines");
        this.addSound(SoundsNF.DRAKEFOWL_AMBIENT, "Drakefowl clucks");
        this.addSound(SoundsNF.DRAKEFOWL_DEATH, "Drakefowl dies");
        this.addSound(SoundsNF.DRAKEFOWL_HURT, "Drakefowl squawks");
        this.addSound(SoundsNF.DRAKEFOWL_FLAP, "Drakefowl flaps");
        this.addSound(SoundsNF.DRAKEFOWL_CROW, "Drakefowl Rooster crows");
        this.addSound(SoundsNF.DRAKEFOWL_SPIT, "Drakefowl Rooster spits");
        this.addSound(SoundsNF.DRAKEFOWL_EAT, "Drakefowl pecks");
        this.addSound(SoundsNF.DRAKEFOWL_BABY_AMBIENT, "Drakefowl Chick chirps");
        this.addSound(SoundsNF.DRAKEFOWL_BABY_DEATH, "Drakefowl Chick dies");
        this.addSound(SoundsNF.DRAKEFOWL_BABY_HURT, "Drakefowl Chick cries");
        this.addSound(SoundsNF.DREG_AMBIENT, "Dreg breathes");
        this.addSound(SoundsNF.DREG_DEATH, "Dreg collapses");
        this.addSound(SoundsNF.DREG_HURT, "Dreg wheezes");
        this.addSound(SoundsNF.DREG_RESURRECT, "Dreg resurrects undead");
        this.addSound(SoundsNF.HUSK_AMBIENT, "Husk groans");
        this.addSound(SoundsNF.HUSK_DEATH, "Husk collapses");
        this.addSound(SoundsNF.HUSK_HURT, "Husk grunts");
        this.addSound(SoundsNF.HUSK_SWING, "Husk swings");
        this.addSound(SoundsNF.SKELETON_AMBIENT, "Skeleton creaks");
        this.addSound(SoundsNF.SKELETON_DEATH, "Skeleton collapses");
        this.addSound(SoundsNF.SKELETON_HURT, "Skeleton grates");
        this.addSound(SoundsNF.SKELETON_THRUST, "Skeleton thrusts");
        this.addSound(SoundsNF.SKELETON_BOW_PULL, "Skeleton pulls bow");
        this.addSound(SoundsNF.SKELETON_BOW_SHOOT, "Skeleton shoots bow");
        this.addSound(SoundsNF.COCKATRICE_AMBIENT, "Cockatrice clucks");
        this.addSound(SoundsNF.COCKATRICE_DEATH, "Cockatrice dies");
        this.addSound(SoundsNF.COCKATRICE_HURT, "Cockatrice screeches");
        this.addSound(SoundsNF.COCKATRICE_FLAP, "Cockatrice flaps");
        this.addSound(SoundsNF.COCKATRICE_BITE, "Cockatrice pecks");
        this.addSound(SoundsNF.COCKATRICE_SPIT, "Cockatrice spits");
        this.addSound(SoundsNF.SPIDER_BITE, "Spider bites");
        this.addSound(SoundsNF.ROCKWORM_DEATH, "Rockworm dies");
        this.addSound(SoundsNF.ROCKWORM_HURT, "Rockworm screeches");
        this.addSound(SoundsNF.ROCKWORM_BITE, "Rockworm bites");
        this.addSound(SoundsNF.ROCKWORM_EMERGE, "Rockworm emerges");
        this.addSound(SoundsNF.ROCKWORM_BURROW, "Rockworm burrows");
        this.addSound(SoundsNF.PIT_DEVIL_DEATH, "Pit Devil dies");
        this.addSound(SoundsNF.PIT_DEVIL_HURT, "Pit Devil shrieks");
        this.addSound(SoundsNF.PIT_DEVIL_BITE, "Pit Devil chomps");
        this.addSound(SoundsNF.PIT_DEVIL_HOWL, "Something howls");
        this.addSound(SoundsNF.PIT_DEVIL_GROWL, "Pit Devil growls");
        this.addSound(SoundsNF.PIT_DEVIL_EAT, "Pit Devil devours");
        this.addSound(SoundsNF.ECTOPLASM_DEATH, "Ectoplasm ruptures");
        this.addSound(SoundsNF.ECTOPLASM_HURT, "Ectoplasm squishes");
        this.addSound(SoundsNF.ECTOPLASM_DEATH_SMALL, "Small Ectoplasm ruptures");
        this.addSound(SoundsNF.ECTOPLASM_HURT_SMALL, "Small Ectoplasm squishes");
        this.addSound(SoundsNF.ECTOPLASM_ATTACK, "Ectoplasm attacks");
        this.addSound(SoundsNF.SKARA_SWARM_AMBIENT, "Skara Swarm crawls");
        this.addSound(SoundsNF.SKARA_SWARM_DEATH, "Skara Swarm dies");
        this.addSound(SoundsNF.SKARA_SWARM_HURT, "Skara Swarm hisses");
        this.addSound(SoundsNF.JELLYFISH_DEATH, "Jellyfish ruptures");
        this.addSound(SoundsNF.JELLYFISH_HURT, "Jellyfish squishes");
        this.addSound(SoundsNF.JELLYFISH_STING, "Jellyfish stings");
        this.addSound(SoundsNF.PROJECTILE_POISON_IMPACT, "Poison corrodes");
        this.addSound(SoundsNF.PROJECTILE_FIRE_IMPACT, "Fire bursts");
        this.addSound(SoundsNF.PROJECTILE_ROCK_IMPACT, "Rock collides");
        this.addSound(SoundsNF.ROPE_KNOT_PLACE, "Rope knot tightens");
        this.addSound(SoundsNF.ROPE_KNOT_BREAK, "Rope knot breaks");
        this.addSound(SoundsNF.ENTITY_WARP, "Something warps");
        this.addSound(SoundsNF.UNDEAD_WARP, "Undead warps");
        this.addSound(SoundsNF.ESSENCE_EXPLODE, "Something warps explosively");
        this.addSound(SoundsNF.LOG_FALL, "Log falls");
        this.addSound(SoundsNF.BIG_TREE_FALL, "Big tree falls");
        this.addSound(SoundsNF.SMALL_TREE_FALL, "Small tree falls");
        this.addSound(SoundsNF.FIRE_WHOOSH, "Fire flares");
        this.addSound(SoundsNF.LIGHT_ARMOR_EQUIP, "Armor rustles");
        this.addSound(SoundsNF.SCALE_ARMOR_EQUIP, "Scale armor clatters");
        this.addSound(SoundsNF.PLATE_ARMOR_EQUIP, "Plate armor clanks");
        this.addSound(SoundsNF.CARVE_WOOD, "Wood carves");
        this.addSound(SoundsNF.CARVE_STONE, "Stone carves");
        this.addSound(SoundsNF.STICK_FIRE_STRIKE, "Stick strikes");
        this.addSound(SoundsNF.QUENCH, "Hot item quenches");
        this.addSound(SoundsNF.METAL_BREAK, "Metal item breaks");
        this.add((MobEffect)EffectsNF.STARVATION_1.get(), "Starvation");
        this.add((Item)ItemsNF.SNOWBALL_THROWABLE.get(), "Snowball");
        this.add((Item)ItemsNF.COKE_BLOCK.get(), "Coke Block");
        this.add((Item)ItemsNF.COAL_BLOCK.get(), "Coal Block");
        this.add((Item)ItemsNF.CHARCOAL_BLOCK.get(), "Charcoal Block");
        this.add((Item)ItemsNF.FIREWOOD_BLOCK.get(), "Firewood Block");
        this.add((Item)ItemsNF.AZURITE_BLOCK.get(), "Azurite Block");
        this.add((Item)ItemsNF.HEMATITE_BLOCK.get(), "Hematite Block");
        this.add((Item)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.LEATHER).get(), "Leather Tunic");
        this.add((Item)ItemsNF.LEGGINGS.get(TieredArmorMaterial.LEATHER).get(), "Leather Pants");
        this.add((Item)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.PADDED).get(), "Padded Tunic");
        this.add((Item)ItemsNF.LEGGINGS.get(TieredArmorMaterial.PADDED).get(), "Padded Pants");
        this.add((Item)ItemsNF.HELMETS.get(TieredArmorMaterial.RAGGED).get(), "Ragged Headwraps");
        this.add((Item)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.RAGGED).get(), "Ragged Tunic");
        this.add((Item)ItemsNF.LEGGINGS.get(TieredArmorMaterial.RAGGED).get(), "Ragged Pants");
        this.add((Item)ItemsNF.BOOTS.get(TieredArmorMaterial.RAGGED).get(), "Ragged Footwraps");
        this.add((Item)ItemsNF.TORCH_UNLIT.get(), "Unlit Torch");
        for (Map map : ItemsNF.ARMAMENT_HEADS.values()) {
            for (Armament armament : map.keySet()) {
                if (armament != Armament.DAGGER && armament != Armament.SABRE && armament != Armament.SICKLE && armament != Armament.SWORD) continue;
                this.add((Item)((RegistryObject)map.get(armament)).get(), WordUtils.capitalize((String)((RegistryObject)map.get(armament)).getId().m_135815_().replace("_head", " blade").replace("_", " ")));
            }
        }
        this.add((Item)ItemsNF.IRONWOOD_SHIELD_DYED.get(), "Ironwood Shield");
        for (RegistryObject registryObject : ItemsNF.METAL_BLOCKS.values()) {
            this.add((Item)registryObject.get(), WordUtils.capitalize((String)registryObject.getId().m_135815_().replace("_", " ")));
        }
        for (RegistryObject registryObject : ItemsNF.METAL_SHIELDS_DYED.values()) {
            this.add((Item)registryObject.get(), WordUtils.capitalize((String)registryObject.getId().m_135815_().replace("_dyed", "").replace("_", " ")));
        }
        for (RegistryObject registryObject : ItemsNF.BOATS.values()) {
            this.add((Item)registryObject.get(), WordUtils.capitalize((String)registryObject.getId().m_135815_().replace("_", " ").replace("boat", "rowboat")));
        }
        for (RegistryObject registryObject : FluidsNF.METAL.values()) {
            this.addFluid((RegistryObject<? extends Fluid>)registryObject, WordUtils.capitalize((String)registryObject.getId().m_135815_().replace("_", " ")));
        }
        this.addAttackItem(DamageType.STRIKING, "%1$s was crushed by %2$s");
        this.addAttackItem(DamageType.SLASHING, "%1$s was cut down by %2$s");
        this.addAttackItem(DamageType.PIERCING, "%1$s was impaled by %2$s");
        this.addAttackItem(DamageType.FIRE, "%1$s was incinerated by %2$s");
        this.addAttackItem(DamageType.FROST, "%1$s was frozen by %2$s");
        this.addAttackItem(DamageType.ELECTRIC, "%1$s was electrocuted by %2$s");
        this.addAttackItem(DamageType.ABSOLUTE, "%1$s was slain by %2$s");
        this.addAttack(DamageTypeSource.BLEEDING.m_19385_(), "%1$s bled out");
        this.addAttack(DamageTypeSource.POISON.m_19385_(), "%1$s succumbed to poison");
        this.addAttack("explosion", "%1$s was blown up");
        this.addAttack("explosion.entity", "%1$s was blown up by %2$s");
        this.addAttack("projectile", "%1$s was shot by %2$s");
        this.addAttack("bite", "%1$s was devoured by %2$s");
        this.addAttack("swipe", "%1$s was torn apart by %2$s");
        this.addAttack("maul", "%1$s was mauled by %2$s");
        this.addAttack("sting", "%1$s was stung by %2$s");
        this.addAttack("stomp", "%1$s was stomped by %2$s");
        this.addAttack("claw", "%1$s was clawed by %2$s");
        this.addItemClues(EntriesNF.TOOLS, "A hard, brittle rock", "A wooden handle", "A binding");
        this.addItemClues(EntriesNF.SLING, "Twisted fibers", "A round projectile");
        this.addKnowledgeClues(EntriesNF.TAMING, "Tame a wild animal with force or temptation");
        this.addItemClues(EntriesNF.WOODCARVING, "Fallen timber");
        this.addItemClues(EntriesNF.WOODWORKING, "A split plank of clean wood");
        this.addItemClues(EntriesNF.ADVANCED_WOODWORKING, "A plank of soft wood", "A plank of hard wood", "A plank of wood neither hard nor soft");
        this.addItemClues(EntriesNF.WOODEN_SHIELD, "A plank of exceptional hardness");
        this.addItemClues(EntriesNF.TANNING, "An animal hide or pelt", "Clean water", "Purifying earths", "Seeping wood");
        this.addKnowledgeClues(EntriesNF.CAMPFIRE, "Use a pair of items to spark a fire");
        this.addItemClues(EntriesNF.CAMPFIRE, "A split piece of timber");
        this.addKnowledgeClues(EntriesNF.POTTERY, "Find wet clay");
        this.addItemClues(EntriesNF.POTTERY, "An earthy material resistant to at least tier 1 heat");
        this.addConditionClues(EntriesNF.POTTERY, "A nearby heat source");
        this.addKnowledgeClues(EntriesNF.COOKING, "Collect water", "Roast a meat", "Roast a vegetable");
        this.addItemClues(EntriesNF.WEAVING, "Hardy plant fibers");
        this.addItemClues(EntriesNF.MEDICINAL_BANDAGE, "A flowery herb, crushed");
        this.addItemClues(EntriesNF.BOW_AND_ARROW, "A plank of hard yet flexible wood", "An arrow fletching");
        this.addItemClues(EntriesNF.WARDING_CHARM, "A lingering presence... a desire to carve...");
        this.addItemClues(EntriesNF.WARDING_EFFIGY, "A structure...", "An essence...", "A body...");
        this.addKnowledgeClues(EntriesNF.CASTING, "Melt a strong metal");
        this.addKnowledgeClues(EntriesNF.SMITHING, "Melt a hard, mundane metal", "Create an improvised anvil from a sturdy block");
        this.addItemClues(EntriesNF.SMELTING, "A material resistant to at least tier 2 heat");
        this.addKnowledgeClues(EntriesNF.IRONWORKING, "Work an iron ore into an iron ingot");
        this.addItemClues(EntriesNF.SABRE, "A sabre");
        this.addItemClues(EntriesNF.SICKLE, "A sickle");
        this.addItemClues(EntriesNF.BUCKET, "A metal resistant to water corrosion");
        this.addConditionClues(EntriesNF.BUCKET, "A nearby water source");
        this.addItemClues(EntriesNF.PLATE_ARMOR, "A material to cushion rigid metal plates");
        this.addItemClues(EntriesNF.CHAINMAIL_ARMOR, "A metal easily worked by hand into chains");
        this.addItemClues(EntriesNF.SCALE_ARMOR, "An ideal metal shape to smith a number of scales from", "A tough material fit for attaching scales");
        this.addItemClues(EntriesNF.MACE, "An early prototype");
        this.addItemClues(EntriesNF.SHIELD, "A functioning wooden shield", "A metal rim");
        this.addItemClues(EntriesNF.SLAYER_PLATE, "A piece of slayer plate armor");
        this.addItemClues(EntriesNF.SLAYER_CHAINMAIL, "A piece of slayer chainmail armor");
        this.addItemClues(EntriesNF.SLAYER_SCALE, "A piece of slayer scale armor");
        this.addItemClues(EntriesNF.EXPLORER_PLATE, "A piece of explorer plate armor");
        this.addItemClues(EntriesNF.EXPLORER_CHAINMAIL, "A piece of explorer chainmail armor");
        this.addItemClues(EntriesNF.EXPLORER_SCALE, "A piece of explorer scale armor");
        for (RegistryObject registryObject : ItemsNF.ITEMS.getEntries()) {
            if (this.addedObjects.contains(registryObject.get())) continue;
            this.add(((Item)registryObject.get()).m_5524_(), WordUtils.capitalize((String)registryObject.getId().m_135815_().replace("_block", "").replace("_", " ")));
        }
        for (RegistryObject registryObject : EntitiesNF.ENTITIES.getEntries()) {
            if (this.addedObjects.contains(registryObject.get())) continue;
            this.add(((EntityType)registryObject.get()).m_20675_(), WordUtils.capitalize((String)registryObject.getId().m_135815_().replace("_", " ")));
        }
        for (RegistryObject registryObject : EffectsNF.EFFECTS.getEntries()) {
            if (this.addedObjects.contains(registryObject.get())) continue;
            this.add(((MobEffect)registryObject.get()).m_19481_(), WordUtils.capitalize((String)registryObject.getId().m_135815_().replace("_", " ")));
        }
        for (RegistryObject registryObject : EntriesNF.ENTRIES.getEntries()) {
            if (this.addedObjects.contains(registryObject.get())) continue;
            this.add(((Entry)((Object)registryObject.get())).getDescriptionId(), WordUtils.capitalize((String)registryObject.getId().m_135815_().replace("_", " ").replace(" and ", " & ")));
        }
        for (RegistryObject registryObject : KnowledgeNF.KNOWLEDGE.getEntries()) {
            if (this.addedObjects.contains(registryObject.get())) continue;
            this.add(((Knowledge)((Object)registryObject.get())).getDescriptionId(), WordUtils.capitalize((String)registryObject.getId().m_135815_().replace("_", " ")));
        }
    }
}

