/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.Metal;
import frostnox.nightfall.block.Soil;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.block.block.ClusterBlock;
import frostnox.nightfall.block.block.CoveredSoilBlock;
import frostnox.nightfall.block.block.FruitBushBlock;
import frostnox.nightfall.block.block.SidingBlock;
import frostnox.nightfall.block.block.eggnest.EggNestBlock;
import frostnox.nightfall.block.block.pile.PileBlock;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.loot.ActionTagCondition;
import frostnox.nightfall.data.loot.DamageTypeCondition;
import frostnox.nightfall.data.loot.LootItemEntityCondition;
import frostnox.nightfall.data.loot.PerceptionCheckFunction;
import frostnox.nightfall.data.loot.PerceptionCountFunction;
import frostnox.nightfall.data.loot.SetItemColorFunction;
import frostnox.nightfall.entity.entity.animal.DeerEntity;
import frostnox.nightfall.entity.entity.animal.RabbitEntity;
import frostnox.nightfall.entity.entity.monster.CockatriceEntity;
import frostnox.nightfall.item.Armament;
import frostnox.nightfall.item.TieredArmorMaterial;
import frostnox.nightfall.item.TieredItemMaterial;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.vanilla.LootTablesNF;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.ChestLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class LootTableProviderNF
extends LootTableProvider {
    public static final int TREE_SEED_STANDARD = -58;
    public static final int TREE_SEED_RARE = -88;
    public static final int TREE_SEED_COMMON = -28;
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = ImmutableList.of((Object)Pair.of(BlockLootNF::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(EntityLootNF::new, (Object)LootContextParamSets.f_81415_), (Object)Pair.of(ChestLootNF::new, (Object)LootContextParamSets.f_81411_));

    public LootTableProviderNF(DataGenerator generator) {
        super(generator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return this.tables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    private static PoolEntry entry(ItemLike item, float min, float max, int weight, List<LootItemFunction.Builder> functions, LootItemCondition.Builder ... conditions) {
        return new PoolEntry(item, min, max, weight, functions, conditions);
    }

    private static PoolEntry entry(ItemLike item, float min, float max, List<LootItemFunction.Builder> functions, LootItemCondition.Builder ... conditions) {
        return LootTableProviderNF.entry(item, min, max, 1, functions, conditions);
    }

    private static PoolEntry entry(ItemLike item, float min, float max, LootItemCondition.Builder ... conditions) {
        return LootTableProviderNF.entry(item, min, max, List.of(), conditions);
    }

    private static PoolEntry entry(ItemLike item, float min, float max, int weight, LootItemCondition.Builder ... conditions) {
        return LootTableProviderNF.entry(item, min, max, weight, List.of(), conditions);
    }

    private static LootPool.Builder pool(PoolEntry ... entries) {
        return LootTableProviderNF.pool(1.0f, entries);
    }

    private static LootPool.Builder pool(float rolls, PoolEntry ... entries) {
        return LootTableProviderNF.pool((NumberProvider)ConstantValue.m_165692_((float)rolls), entries);
    }

    private static LootPool.Builder pool(NumberProvider rolls, PoolEntry ... entries) {
        LootPool.Builder pool = LootPool.m_79043_().m_165133_(rolls);
        for (PoolEntry entry : entries) {
            LootPoolSingletonContainer.Builder itemBuilder = LootItem.m_79579_((ItemLike)entry.item).m_79707_(entry.weight).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)(entry.min == entry.max ? ConstantValue.m_165692_((float)entry.min) : UniformGenerator.m_165780_((float)entry.min, (float)entry.max))));
            for (LootItemFunction.Builder function : entry.functions) {
                itemBuilder = itemBuilder.m_5577_(function);
            }
            for (LootItemCondition.Builder condition : entry.conditions) {
                itemBuilder = (LootPoolSingletonContainer.Builder)itemBuilder.m_6509_(condition);
            }
            pool.m_79076_((LootPoolEntryContainer.Builder)itemBuilder);
        }
        return pool;
    }

    private record PoolEntry(ItemLike item, float min, float max, int weight, List<LootItemFunction.Builder> functions, LootItemCondition.Builder[] conditions) {
    }

    private static class ChestLootNF
    extends ChestLoot {
        private ChestLootNF() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> builder) {
            builder.accept(LootTablesNF.COTTAGE_RUINS_LOOT, LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.TERRACOTTA_SHARD.get(), 8.0f, 16.0f, 5, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.COAL.get(), 3.0f, 6.0f, 2, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.BONE_SHARD.get(), 3.0f, 7.0f, 1, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.COPPER_NUGGET.get(), 5.0f, 7.0f, 3, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.BRONZE).get(Armament.ADZE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.BRONZE).get(Armament.AXE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.BRONZE).get(Armament.SHOVEL).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.BRONZE).get(Armament.SICKLE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.ADZE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.AXE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.SHOVEL).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.SICKLE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0])).m_5577_(PerceptionCheckFunction.with(0.5f, 0.04f))));
            builder.accept(LootTablesNF.DESERTED_CAMP_LOOT, LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(4.0f, LootTableProviderNF.entry((ItemLike)ItemsNF.STICK.get(), 3.0f, 6.0f, 2, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.PLANT_FIBERS.get(), 6.0f, 8.0f, 2, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.FLINT.get(), 2.0f, 4.0f, 1, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(2.0f, LootTableProviderNF.entry((ItemLike)ItemsNF.SCARLET_FEATHER.get(), 6.0f, 8.0f, 1, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.CLAY.get(), 20.0f, 26.0f, 2, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METEORITE_NUGGET.get(), 3.0f, 5.0f, 1, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METEORITE_CHUNK.get(), 1.0f, 1.0f, 1, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.RABBIT_PELTS.get((Object)RabbitEntity.Type.BRUSH).get(), 1.0f, 2.0f, 2, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.DEER_HIDES.get((Object)DeerEntity.Type.SPOTTED).get(), 1.0f, 1.0f, 1, new LootItemCondition.Builder[0])).m_5577_(PerceptionCheckFunction.with(0.5f, 0.04f))));
            builder.accept(LootTablesNF.SLAYER_RUINS_BARREL_LOOT, LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(2.0f, LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARROWS.get(TieredItemMaterial.IRON).get(), 2.0f, 4.0f, 3, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.ROPE.get(), 6.0f, 9.0f, 1, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.SPEAR).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.15f, (float)0.25f))), new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(1.0f, LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARROWS.get(TieredItemMaterial.IRON).get(), 2.0f, 4.0f, 1, new LootItemCondition.Builder[0])).m_5577_(PerceptionCheckFunction.with(0.5f, 0.04f))));
            builder.accept(LootTablesNF.SLAYER_RUINS_CHEST_LOOT, LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(3.0f, LootTableProviderNF.entry((ItemLike)ItemsNF.BANDAGE.get(), 1.0f, 2.0f, 3, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARROWS.get(TieredItemMaterial.IRON).get(), 4.0f, 6.0f, 4, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.BOWS.get(Tree.OAK).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.BOWS.get(Tree.PALM).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.SWORD).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.15f, (float)0.2f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.MACE).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.15f, (float)0.2f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_SHIELDS_DYED.get(Metal.IRON).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.2f, (float)0.25f)), SetItemColorFunction.color(0x844545)), new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(1.0f, LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.SABRE).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.15f, (float)0.2f))), new LootItemCondition.Builder[0])).m_5577_(PerceptionCheckFunction.with(0.5f, 0.04f))));
            builder.accept(LootTablesNF.EXPLORER_RUINS_LOOT, LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(1.0f, LootTableProviderNF.entry((ItemLike)ItemsNF.TERRACOTTA_SHARD.get(), 8.0f, 16.0f, 7, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.COAL.get(), 3.0f, 6.0f, 3, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.BRONZE).get(Armament.AXE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.AXE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.BRONZE).get(Armament.PICKAXE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.PICKAXE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.BRONZE).get(Armament.SICKLE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.SICKLE).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.BRONZE).get(Armament.SHOVEL).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.IRON).get(Armament.SHOVEL).get(), 1.0f, 1.0f, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f))), new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(1.0f, LootTableProviderNF.entry((ItemLike)ItemsNF.HELMETS.get(TieredArmorMaterial.BRONZE_CHAINMAIL_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.HELMETS.get(TieredArmorMaterial.IRON_CHAINMAIL_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.BRONZE_CHAINMAIL_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.IRON_CHAINMAIL_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.HELMETS.get(TieredArmorMaterial.BRONZE_PLATE_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.HELMETS.get(TieredArmorMaterial.IRON_PLATE_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.BRONZE_PLATE_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.IRON_PLATE_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.HELMETS.get(TieredArmorMaterial.BRONZE_SCALE_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.HELMETS.get(TieredArmorMaterial.IRON_SCALE_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.BRONZE_SCALE_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.IRON_SCALE_EXPLORER).get(), 1.0f, 1.0f, 1, List.of(SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.15f)), SetItemColorFunction.color(14930341)), new LootItemCondition.Builder[0])).m_5577_(PerceptionCheckFunction.with(0.35f, 0.028f))));
        }
    }

    private static class EntityLootNF
    extends EntityLoot {
        private EntityLootNF() {
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(e -> e.getRegistryName().m_135827_().equals("nightfall")).toList();
        }

        protected void addTables() {
            this.m_124371_((EntityType)EntitiesNF.RABBIT.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RAW_GAME.get(), 2.0f, 3.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RABBIT_PELTS.get((Object)RabbitEntity.Type.BRUSH).get(), 1.0f, 1.0f, LootItemEntityCondition.of(LootItemEntityCondition.Test.RABBIT_BRUSH)))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RABBIT_PELTS.get((Object)RabbitEntity.Type.COTTONTAIL).get(), 1.0f, 1.0f, LootItemEntityCondition.of(LootItemEntityCondition.Test.RABBIT_COTTONTAIL)))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RABBIT_PELTS.get((Object)RabbitEntity.Type.ARCTIC).get(), 1.0f, 1.0f, LootItemEntityCondition.of(LootItemEntityCondition.Test.RABBIT_ARCTIC)))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RABBIT_PELTS.get((Object)RabbitEntity.Type.STRIPED).get(), 1.0f, 1.0f, LootItemEntityCondition.of(LootItemEntityCondition.Test.RABBIT_STRIPED)))));
            this.m_124371_((EntityType)EntitiesNF.DEER.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RAW_VENISON.get(), 3.0f, 4.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.DEER_HIDES.get((Object)DeerEntity.Type.BRIAR).get(), 1.0f, 1.0f, LootItemEntityCondition.of(LootItemEntityCondition.Test.DEER_BRIAR)))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.DEER_HIDES.get((Object)DeerEntity.Type.RED).get(), 1.0f, 1.0f, LootItemEntityCondition.of(LootItemEntityCondition.Test.DEER_RED)))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.DEER_HIDES.get((Object)DeerEntity.Type.SPOTTED).get(), 1.0f, 1.0f, LootItemEntityCondition.of(LootItemEntityCondition.Test.DEER_SPOTTED)))));
            this.m_124371_((EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RAW_POULTRY.get(), 2.0f, 2.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.SCARLET_FEATHER.get(), 5.0f, 6.0f, new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.DRAKEFOWL_HEN.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RAW_POULTRY.get(), 2.0f, 2.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.SCARLET_FEATHER.get(), 5.0f, 6.0f, new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.DRAKEFOWL_CHICK.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RAW_POULTRY.get(), 1.0f, 1.0f, new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.HUSK.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.ROTTEN_FLESH.get(), 1.0f, 2.0f, new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.SKELETON.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.BONE_SHARD.get(), 1.0f, 2.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.BONE_SHARD.get(), 1.0f, 2.0f, DamageTypeCondition.of(DamageType.STRIKING)))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.LIVING_BONE.get(), 0.0f, 0.0f, List.of(PerceptionCountFunction.with(1, 0.35f, 0.04f)), new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.DREG.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.ROTTEN_FLESH.get(), 0.0f, 1.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.DREG_HEART.get(), 0.0f, 0.0f, List.of(PerceptionCountFunction.with(1, 0.25f, 0.02f)), new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.CREEPER.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.SULFUR.get(), 2.0f, 3.0f, new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.COCKATRICE.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.COCKATRICE_SKINS.get((Object)CockatriceEntity.Type.BRONZE).get(), 1.0f, 1.0f, LootItemEntityCondition.of(LootItemEntityCondition.Test.COCKATRICE_BRONZE)))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.COCKATRICE_SKINS.get((Object)CockatriceEntity.Type.EMERALD).get(), 1.0f, 1.0f, LootItemEntityCondition.of(LootItemEntityCondition.Test.COCKATRICE_EMERALD)))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.SCARLET_FEATHER.get(), 8.0f, 10.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RAW_GAME.get(), 1.0f, 2.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RAW_POULTRY.get(), 2.0f, 2.0f, new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.SPIDER.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.SILK.get(), 1.0f, 2.0f, new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.ROCKWORM.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RAW_PALE_FLESH.get(), 1.0f, 2.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.ROCKY_SCALE.get(), 3.0f, 4.0f, List.of(PerceptionCountFunction.with(1, 0.5f, 0.05f)), new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.PIT_DEVIL.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RAW_GAME.get(), 2.0f, 3.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.ROCKY_SCALE.get(), 2.0f, 3.0f, List.of(PerceptionCountFunction.with(1, 0.5f, 0.05f)), new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.PIT_DEVIL_TOOTH.get(), 1.0f, 1.0f, List.of(PerceptionCountFunction.with(1, 0.5f, 0.05f)), new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.ECTOPLASM_LARGE.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.BONE_SHARD.get(), 2.0f, 3.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.BONE.get(), 0.0f, 1.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.ECTOPLASM.get(), 1.0f, 1.0f, List.of(PerceptionCountFunction.with(1, 0.5f, 0.05f)), new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.ECTOPLASM_MEDIUM.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.BONE_SHARD.get(), 1.0f, 2.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.ECTOPLASM.get(), 1.0f, 1.0f, List.of(PerceptionCheckFunction.with(0.4f, 0.04f)), new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.ECTOPLASM_SMALL.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.BONE_SHARD.get(), 0.0f, 1.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.ECTOPLASM.get(), 1.0f, 1.0f, List.of(PerceptionCheckFunction.with(0.3f, 0.03f)), new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.SCORPION.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.SILK.get(), 1.0f, 2.0f, new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.SKARA_SWARM.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.SKARA_SHELLS.get(), 1.0f, 1.0f, List.of(PerceptionCountFunction.with(1, 0.5f, 0.05f)), new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.TROLL.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.SILK.get(), 1.0f, 2.0f, new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.OLMUR.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.SILK.get(), 1.0f, 2.0f, new LootItemCondition.Builder[0]))));
            this.m_124371_((EntityType)EntitiesNF.JELLYFISH.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.RAW_JELLYFISH.get(), 1.0f, 1.0f, new LootItemCondition.Builder[0]))));
        }
    }

    private static class BlockLootNF
    extends BlockLoot {
        private final Set<Block> addedBlocks = new HashSet<Block>();

        private BlockLootNF() {
        }

        protected void m_124165_(Block pBlock, LootTable.Builder pLootTableBuilder) {
            super.m_124165_(pBlock, pLootTableBuilder);
            this.addedBlocks.add(pBlock);
        }

        public Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block.getRegistryName().m_135827_().equals("nightfall") && !block.m_60589_().equals((Object)BuiltInLootTables.f_78712_) && !block.m_49966_().m_204336_(TagsNF.TECHNICAL)).collect(Collectors.toSet());
        }

        protected void addTables() {
            this.dropOther((Block)BlocksNF.SILT.get(), (ItemLike)ItemsNF.SOILS.get(Soil.SILT).get(), 4);
            this.dropOther((Block)BlocksNF.DIRT.get(), (ItemLike)ItemsNF.SOILS.get(Soil.DIRT).get(), 4);
            this.dropOther((Block)BlocksNF.LOAM.get(), (ItemLike)ItemsNF.SOILS.get(Soil.LOAM).get(), 4);
            this.dropOther((Block)BlocksNF.ASH.get(), (ItemLike)ItemsNF.SOILS.get(Soil.ASH).get(), 4);
            this.dropOthersRandomReplace((Block)BlocksNF.GRAVEL.get(), (ItemLike)ItemsNF.SOILS.get(Soil.GRAVEL).get(), 3, (ItemLike)ItemsNF.FLINT.get(), 0.125f, 1);
            this.dropOthersRandomReplace((Block)BlocksNF.BLUE_GRAVEL.get(), (ItemLike)ItemsNF.SOILS.get(Soil.BLUE_GRAVEL).get(), 3, (ItemLike)ItemsNF.FLINT.get(), 0.125f, 1);
            this.dropOthersRandomReplace((Block)BlocksNF.BLACK_GRAVEL.get(), (ItemLike)ItemsNF.SOILS.get(Soil.BLACK_GRAVEL).get(), 3, (ItemLike)ItemsNF.FLINT.get(), 0.125f, 1);
            this.dropOther((Block)BlocksNF.SAND.get(), (ItemLike)ItemsNF.SOILS.get(Soil.SAND).get(), 4);
            this.dropOther((Block)BlocksNF.RED_SAND.get(), (ItemLike)ItemsNF.SOILS.get(Soil.RED_SAND).get(), 4);
            this.dropOther((Block)BlocksNF.WHITE_SAND.get(), (ItemLike)ItemsNF.SOILS.get(Soil.WHITE_SAND).get(), 4);
            for (RegistryObject<? extends CoveredSoilBlock> registryObject : BlocksNF.COVERED_SILT.values()) {
                this.dropOther((Block)registryObject.get(), (ItemLike)ItemsNF.SOILS.get(Soil.SILT).get(), 4);
            }
            for (RegistryObject<? extends CoveredSoilBlock> registryObject : BlocksNF.COVERED_DIRT.values()) {
                this.dropOther((Block)registryObject.get(), (ItemLike)ItemsNF.SOILS.get(Soil.DIRT).get(), 4);
            }
            for (RegistryObject<? extends CoveredSoilBlock> registryObject : BlocksNF.COVERED_LOAM.values()) {
                this.dropOther((Block)registryObject.get(), (ItemLike)ItemsNF.SOILS.get(Soil.LOAM).get(), 4);
            }
            this.dropOther((Block)BlocksNF.TILLED_SILT.get(), (ItemLike)ItemsNF.SOILS.get(Soil.SILT).get(), 4);
            this.dropOther((Block)BlocksNF.TILLED_DIRT.get(), (ItemLike)ItemsNF.SOILS.get(Soil.DIRT).get(), 4);
            this.dropOther((Block)BlocksNF.TILLED_LOAM.get(), (ItemLike)ItemsNF.SOILS.get(Soil.LOAM).get(), 4);
            for (Soil soil : BlocksNF.STRANGE_SOILS.keySet()) {
                this.dropOther((Block)BlocksNF.STRANGE_SOILS.get(soil).get(), (ItemLike)ItemsNF.SOILS.get(soil).get(), 3);
            }
            this.dropOtherRequireLiving((Block)BlocksNF.SNOW.get(), (ItemLike)ItemsNF.SNOWBALL.get(), 1);
            this.dropOther((Block)BlocksNF.PACKED_SNOW.get(), (ItemLike)ItemsNF.SNOWBALL.get(), 8);
            this.dropOther((Block)BlocksNF.MUD.get(), (ItemLike)ItemsNF.MUD.get(), 4);
            this.dropOther((Block)BlocksNF.CLAY.get(), (ItemLike)ItemsNF.CLAY.get(), 4);
            this.dropOther((Block)BlocksNF.FIRE_CLAY.get(), (ItemLike)ItemsNF.FIRE_CLAY.get(), 4);
            for (Stone stone : BlocksNF.STONE_BLOCKS.keySet()) {
                this.dropStone((Block)BlocksNF.STONE_BLOCKS.get(stone).get(), stone, 4);
            }
            for (Stone stone : BlocksNF.STONE_TUNNELS.keySet()) {
                this.dropStone((Block)BlocksNF.STONE_TUNNELS.get(stone).get(), stone, 4);
            }
            for (Stone stone : BlocksNF.ROCK_CLUSTERS.keySet()) {
                this.dropCluster((ClusterBlock)BlocksNF.ROCK_CLUSTERS.get(stone).get());
            }
            this.dropCluster((ClusterBlock)BlocksNF.FLINT_CLUSTER.get());
            for (RegistryObject registryObject : BlocksNF.TIN_ORES.values()) {
                this.dropOthersPerception((Block)registryObject.get(), (ItemLike)ItemsNF.TIN_CHUNK.get(), 1, (ItemLike)ItemsNF.TIN_NUGGET.get(), 1, 0.25f, 0.025f, 4);
            }
            for (RegistryObject registryObject : BlocksNF.COPPER_ORES.values()) {
                this.dropOthersPerception((Block)registryObject.get(), (ItemLike)ItemsNF.COPPER_CHUNK.get(), 1, (ItemLike)ItemsNF.COPPER_NUGGET.get(), 1, 0.2f, 0.02f, 3);
            }
            for (RegistryObject registryObject : BlocksNF.AZURITE_ORES.values()) {
                this.dropOthersPerception((Block)registryObject.get(), (ItemLike)ItemsNF.AZURITE_CHUNK.get(), 1, (ItemLike)ItemsNF.AZURITE_NUGGET.get(), 1, 0.2f, 0.02f, 3);
            }
            for (RegistryObject registryObject : BlocksNF.HEMATITE_ORES.values()) {
                this.dropOthersPerception((Block)registryObject.get(), (ItemLike)ItemsNF.HEMATITE_CHUNK.get(), 1, (ItemLike)ItemsNF.HEMATITE_NUGGET.get(), 1, 0.2f, 0.02f, 3);
            }
            for (RegistryObject registryObject : BlocksNF.COAL_ORES.values()) {
                this.dropOtherPerception((Block)registryObject.get(), (ItemLike)ItemsNF.COAL.get(), 1, 1, 0.2f, 0.02f, 1);
            }
            for (RegistryObject registryObject : BlocksNF.HALITE_ORES.values()) {
                this.dropOtherPerception((Block)registryObject.get(), (ItemLike)ItemsNF.SALT.get(), 3, 1, 0.5f, 0.05f, 1);
            }
            this.dropOthersPerception((Block)BlocksNF.METEORITE_ORE.get(), (ItemLike)ItemsNF.METEORITE_CHUNK.get(), 1, (ItemLike)ItemsNF.METEORITE_NUGGET.get(), 1, 0.2f, 0.02f, 3);
            this.dropOtherPerception((Block)BlocksNF.OBSIDIAN.get(), (ItemLike)ItemsNF.OBSIDIAN_SHARD.get(), 2, 1, 0.5f, 0.05f, 1);
            this.dropOtherRequireLiving((Block)BlocksNF.SHORT_GRASS.get(), (ItemLike)ItemsNF.PLANT_FIBERS.get(), 2);
            this.dropOtherPerceptionRequireLiving((Block)BlocksNF.GRASS.get(), (ItemLike)ItemsNF.PLANT_FIBERS.get(), 2, 1, 0.5f, 0.02f, 1);
            this.dropOtherPerceptionRequireLiving((Block)BlocksNF.TALL_GRASS.get(), (ItemLike)ItemsNF.PLANT_FIBERS.get(), 3, 1, 0.5f, 0.025f, 1);
            this.dropOtherRequireLiving((Block)BlocksNF.SMALL_FERN.get(), (ItemLike)ItemsNF.PLANT_FIBERS.get(), 1);
            this.dropOtherPerceptionRequireLiving((Block)BlocksNF.FERN.get(), (ItemLike)ItemsNF.PLANT_FIBERS.get(), 1, 1, 0.3f, 0.012f, 1);
            this.dropOtherPerceptionRequireLiving((Block)BlocksNF.LARGE_FERN.get(), (ItemLike)ItemsNF.PLANT_FIBERS.get(), 2, 1, 0.3f, 0.015f, 1);
            this.dropOtherPerceptionRequireLiving((Block)BlocksNF.VINES.get(), (ItemLike)ItemsNF.PLANT_FIBERS.get(), 3, 1, 0.5f, 0.025f, 1);
            this.dropOther((Block)BlocksNF.DEAD_BUSH.get(), (ItemLike)ItemsNF.STICK.get(), 1);
            this.dropVegetableCrop((Block)BlocksNF.POTATOES.get(), (ItemLike)ItemsNF.POTATO.get(), 2.0f, 4.0f, (ItemLike)ItemsNF.POTATO_SEEDS.get(), 0.15f, 0.025f);
            this.dropVegetableCrop((Block)BlocksNF.CARROTS.get(), (ItemLike)ItemsNF.CARROT.get(), 2.0f, 3.0f, (ItemLike)ItemsNF.CARROT_SEEDS.get(), 0.15f, 0.025f);
            this.dropVegetableCrop((Block)BlocksNF.FLAX.get(), (ItemLike)ItemsNF.FLAX_FIBERS.get(), 2.0f, 3.0f, (ItemLike)ItemsNF.FLAX_SEEDS.get(), 0.5f, 0.025f);
            this.dropVegetableCrop((Block)BlocksNF.YARROW.get(), (ItemLike)ItemsNF.YARROW.get(), 2.0f, 3.0f, (ItemLike)ItemsNF.YARROW_SEEDS.get(), 0.35f, 0.025f);
            this.dropFruitBush((FruitBushBlock)BlocksNF.BERRY_BUSH.get(), 1, 1, 2, 3, 0.5f, 0.025f);
            for (Iterator<Object> iterator : Tree.values()) {
                this.dropOther((Block)BlocksNF.TRUNKS.get(iterator).get(), (ItemLike)BlocksNF.LOGS.get(iterator).get(), 1);
                this.dropOther((Block)BlocksNF.STEMS.get(iterator).get(), (ItemLike)BlocksNF.LOGS.get(iterator).get(), 1);
                int min = -68;
                if (iterator == Tree.PALM) {
                    min = -28;
                } else if (iterator == Tree.LARCH || iterator == Tree.SPRUCE) {
                    min = -88;
                } else if (iterator == Tree.BIRCH || iterator == Tree.ACACIA) {
                    min = -48;
                } else if (iterator == Tree.REDWOOD) {
                    min = -38;
                }
                this.dropLeaves((Block)BlocksNF.LEAVES.get(iterator).get(), (ItemLike)ItemsNF.TREE_SEEDS.get(iterator).get(), min, 1, 1, (ItemLike)ItemsNF.STICK.get(), -1, 1);
                if (BlocksNF.BRANCHES.containsKey(iterator)) {
                    this.dropBranches((Block)BlocksNF.BRANCHES.get(iterator).get(), (ItemLike)ItemsNF.STICK.get(), -1, 1);
                }
                this.dropSpecialAction((Block)BlocksNF.LOGS.get(iterator).get(), (ItemLike)BlocksNF.LOGS.get(iterator).get(), 1, TagsNF.CHOPPING_ACTION, (ItemLike)ItemsNF.FIREWOOD.get(), 4);
                this.dropSpecialAction((Block)BlocksNF.STRIPPED_LOGS.get(iterator).get(), (ItemLike)BlocksNF.STRIPPED_LOGS.get(iterator).get(), 1, TagsNF.CHOPPING_ACTION, (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 8);
                this.dropOther((Block)BlocksNF.PLANK_BLOCKS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 4);
                this.dropOther((Block)BlocksNF.PLANK_STAIRS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 3);
                this.dropSlab((Block)BlocksNF.PLANK_SLABS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 2);
                this.dropSiding((Block)BlocksNF.PLANK_SIDINGS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 2);
                this.dropOther((Block)BlocksNF.PLANK_FENCES.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 3);
                this.dropOther((Block)BlocksNF.PLANK_FENCE_GATES.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 3);
                this.m_124165_((Block)BlocksNF.PLANK_DOORS.get(iterator).get(), BlockLootNF.createDoubleBlockDrops((Block)BlocksNF.PLANK_DOORS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 6));
                this.dropOther((Block)BlocksNF.PLANK_TRAPDOORS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 3);
                this.dropOther((Block)BlocksNF.PLANK_HATCHES.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 3);
                this.dropOther((Block)BlocksNF.PLANK_LADDERS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 3);
                this.dropOther((Block)BlocksNF.PLANK_STANDING_SIGNS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 3);
                this.dropOther((Block)BlocksNF.PLANK_WALL_SIGNS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 3);
                this.dropOther((Block)BlocksNF.WOODEN_ITEM_FRAMES.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 2);
                this.dropOther((Block)BlocksNF.BARRELS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 16);
                this.dropOther((Block)BlocksNF.CHESTS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 16);
                this.dropOther((Block)BlocksNF.RACKS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 4);
                this.dropOther((Block)BlocksNF.SHELVES.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 8);
                this.m_124165_((Block)BlocksNF.CHAIRS.get(iterator).get(), BlockLootNF.createDoubleBlockDrops((Block)BlocksNF.CHAIRS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 4));
                this.dropOther((Block)BlocksNF.TROUGHS.get(iterator).get(), (ItemLike)ItemsNF.PLANKS.get(iterator).get(), 8);
            }
            this.dropFruitLeaves((Block)BlocksNF.FRUIT_LEAVES.get(Tree.JUNGLE).get(), (ItemLike)ItemsNF.TREE_SEEDS.get(Tree.JUNGLE).get(), -68, 1, 1, (ItemLike)ItemsNF.STICK.get(), -1, 1, (ItemLike)ItemsNF.COCOA_POD.get());
            this.dropFruitLeaves((Block)BlocksNF.FRUIT_LEAVES.get(Tree.OAK).get(), (ItemLike)ItemsNF.TREE_SEEDS.get(Tree.OAK).get(), -68, 1, 1, (ItemLike)ItemsNF.STICK.get(), -1, 1, (ItemLike)ItemsNF.APPLE.get());
            this.dropFruitLeaves((Block)BlocksNF.FRUIT_LEAVES.get(Tree.PALM).get(), (ItemLike)ItemsNF.TREE_SEEDS.get(Tree.PALM).get(), -28, 1, 1, (ItemLike)ItemsNF.STICK.get(), -1, 1, (ItemLike)ItemsNF.COCONUT.get());
            for (Iterator<Object> iterator : Stone.values()) {
                this.dropStone((Block)BlocksNF.TILED_STONE.get(iterator).get(), (Stone)((Object)iterator), 4);
                this.dropStone((Block)BlocksNF.POLISHED_STONE.get(iterator).get(), (Stone)((Object)iterator), 4);
                this.dropStone((Block)BlocksNF.POLISHED_STONE_STAIRS.get(iterator).get(), (Stone)((Object)iterator), 3);
                this.dropStoneSlab((Block)BlocksNF.POLISHED_STONE_SLABS.get(iterator).get(), (Stone)((Object)iterator), 2);
                this.dropStoneSiding((Block)BlocksNF.POLISHED_STONE_SIDINGS.get(iterator).get(), (Stone)((Object)iterator), 2);
                this.dropOther((Block)BlocksNF.STACKED_STONE.get(iterator).get(), (ItemLike)ItemsNF.ROCKS.get(iterator).get(), 4);
                this.dropOther((Block)BlocksNF.STACKED_STONE_STAIRS.get(iterator).get(), (ItemLike)ItemsNF.ROCKS.get(iterator).get(), 3);
                this.dropSlab((Block)BlocksNF.STACKED_STONE_SLABS.get(iterator).get(), (ItemLike)ItemsNF.ROCKS.get(iterator).get(), 2);
                this.dropSiding((Block)BlocksNF.STACKED_STONE_SIDINGS.get(iterator).get(), (ItemLike)ItemsNF.ROCKS.get(iterator).get(), 2);
                this.dropOther((Block)BlocksNF.COBBLED_STONE.get(iterator).get(), (ItemLike)ItemsNF.ROCKS.get(iterator).get(), 4);
                this.dropOther((Block)BlocksNF.COBBLED_STONE_STAIRS.get(iterator).get(), (ItemLike)ItemsNF.ROCKS.get(iterator).get(), 3);
                this.dropSlab((Block)BlocksNF.COBBLED_STONE_SLABS.get(iterator).get(), (ItemLike)ItemsNF.ROCKS.get(iterator).get(), 2);
                this.dropSiding((Block)BlocksNF.COBBLED_STONE_SIDINGS.get(iterator).get(), (ItemLike)ItemsNF.ROCKS.get(iterator).get(), 2);
                this.dropOther((Block)BlocksNF.STONE_BRICK_BLOCKS.get(iterator).get(), (ItemLike)ItemsNF.STONE_BRICKS.get(iterator).get(), 4);
                this.dropOther((Block)BlocksNF.STONE_BRICK_STAIRS.get(iterator).get(), (ItemLike)ItemsNF.STONE_BRICKS.get(iterator).get(), 3);
                this.dropSlab((Block)BlocksNF.STONE_BRICK_SLABS.get(iterator).get(), (ItemLike)ItemsNF.STONE_BRICKS.get(iterator).get(), 2);
                this.dropSiding((Block)BlocksNF.STONE_BRICK_SIDINGS.get(iterator).get(), (ItemLike)ItemsNF.STONE_BRICKS.get(iterator).get(), 2);
            }
            this.dropOther((Block)BlocksNF.TERRACOTTA.get(), (ItemLike)ItemsNF.TERRACOTTA_SHARD.get(), 8);
            this.dropOther((Block)BlocksNF.TERRACOTTA_TILES.get(), (ItemLike)ItemsNF.TERRACOTTA_SHARD.get(), 4);
            this.dropOther((Block)BlocksNF.TERRACOTTA_TILE_STAIRS.get(), (ItemLike)ItemsNF.TERRACOTTA_SHARD.get(), 3);
            this.dropSiding((Block)BlocksNF.TERRACOTTA_TILE_SIDING.get(), (ItemLike)ItemsNF.TERRACOTTA_SHARD.get(), 2);
            this.dropSlab((Block)BlocksNF.TERRACOTTA_TILE_SLAB.get(), (ItemLike)ItemsNF.TERRACOTTA_SHARD.get(), 2);
            this.dropOther((Block)BlocksNF.TERRACOTTA_MOSAIC.get(), (ItemLike)ItemsNF.TERRACOTTA_SHARD.get(), 4);
            this.dropOther((Block)BlocksNF.TERRACOTTA_MOSAIC_STAIRS.get(), (ItemLike)ItemsNF.TERRACOTTA_SHARD.get(), 3);
            this.dropSiding((Block)BlocksNF.TERRACOTTA_MOSAIC_SIDING.get(), (ItemLike)ItemsNF.TERRACOTTA_SHARD.get(), 2);
            this.dropSlab((Block)BlocksNF.TERRACOTTA_MOSAIC_SLAB.get(), (ItemLike)ItemsNF.TERRACOTTA_SHARD.get(), 2);
            this.dropOther((Block)BlocksNF.MUD_BRICKS.get(), (ItemLike)ItemsNF.MUD_BRICK.get(), 4);
            this.dropOther((Block)BlocksNF.MUD_BRICK_STAIRS.get(), (ItemLike)ItemsNF.MUD_BRICK.get(), 3);
            this.dropSiding((Block)BlocksNF.MUD_BRICK_SIDING.get(), (ItemLike)ItemsNF.MUD_BRICK.get(), 2);
            this.dropSlab((Block)BlocksNF.MUD_BRICK_SLAB.get(), (ItemLike)ItemsNF.MUD_BRICK.get(), 2);
            this.dropOther((Block)BlocksNF.BRICKS.get(), (ItemLike)ItemsNF.BRICK.get(), 4);
            this.dropOther((Block)BlocksNF.BRICK_STAIRS.get(), (ItemLike)ItemsNF.BRICK.get(), 3);
            this.dropSlab((Block)BlocksNF.BRICK_SLAB.get(), (ItemLike)ItemsNF.BRICK.get(), 2);
            this.dropSiding((Block)BlocksNF.BRICK_SIDING.get(), (ItemLike)ItemsNF.BRICK.get(), 2);
            this.dropOther((Block)BlocksNF.FIRE_BRICKS.get(), (ItemLike)ItemsNF.FIRE_BRICK.get(), 4);
            this.dropOther((Block)BlocksNF.FIRE_BRICK_STAIRS.get(), (ItemLike)ItemsNF.FIRE_BRICK.get(), 3);
            this.dropSiding((Block)BlocksNF.FIRE_BRICK_SIDING.get(), (ItemLike)ItemsNF.FIRE_BRICK.get(), 2);
            this.dropSlab((Block)BlocksNF.FIRE_BRICK_SLAB.get(), (ItemLike)ItemsNF.FIRE_BRICK.get(), 2);
            this.dropOther((Block)BlocksNF.THATCH.get(), (ItemLike)ItemsNF.PLANT_FIBERS.get(), 4);
            this.dropOther((Block)BlocksNF.THATCH_STAIRS.get(), (ItemLike)ItemsNF.PLANT_FIBERS.get(), 3);
            this.dropSlab((Block)BlocksNF.THATCH_SLAB.get(), (ItemLike)ItemsNF.PLANT_FIBERS.get(), 2);
            this.dropSiding((Block)BlocksNF.THATCH_SIDING.get(), (ItemLike)ItemsNF.PLANT_FIBERS.get(), 2);
            this.dropOther((Block)BlocksNF.WET_MUD_BRICKS.get(), (ItemLike)ItemsNF.MUD.get(), 4);
            this.dropOther((Block)BlocksNF.CLAY_BRICKS.get(), (ItemLike)ItemsNF.CLAY.get(), 4);
            this.dropOther((Block)BlocksNF.FIRE_CLAY_BRICKS.get(), (ItemLike)ItemsNF.FIRE_CLAY.get(), 4);
            this.dropCampfire((Block)BlocksNF.CAMPFIRE.get());
            this.dropOther((Block)BlocksNF.UNFIRED_POT.get(), (ItemLike)ItemsNF.CLAY.get(), 8);
            this.dropOther((Block)BlocksNF.UNFIRED_CAULDRON.get(), (ItemLike)ItemsNF.CLAY.get(), 6);
            this.dropOther((Block)BlocksNF.UNFIRED_CRUCIBLE.get(), (ItemLike)ItemsNF.CLAY.get(), 4);
            for (RegistryObject registryObject : BlocksNF.UNFIRED_ARMAMENT_MOLDS.values()) {
                this.dropOther((Block)registryObject.get(), (ItemLike)ItemsNF.CLAY.get(), 4);
            }
            this.dropOther((Block)BlocksNF.UNFIRED_INGOT_MOLD.get(), (ItemLike)ItemsNF.CLAY.get(), 4);
            this.dropOther((Block)BlocksNF.UNFIRED_ARROWHEAD_MOLD.get(), (ItemLike)ItemsNF.CLAY.get(), 4);
            this.m_124147_((Block)BlocksNF.TORCH.get(), (ItemLike)ItemsNF.TORCH.get());
            this.m_124147_((Block)BlocksNF.TORCH_UNLIT.get(), (ItemLike)ItemsNF.STICK.get());
            for (Tree tree : BlocksNF.ANVILS_LOG.keySet()) {
                this.dropSpecialAction((Block)BlocksNF.ANVILS_LOG.get(tree).get(), (ItemLike)BlocksNF.LOGS.get(tree).get(), 1, TagsNF.CHOPPING_ACTION, (ItemLike)ItemsNF.FIREWOOD.get(), 4);
            }
            for (Stone stone : BlocksNF.ANVILS_STONE.keySet()) {
                this.dropStone((Block)BlocksNF.ANVILS_STONE.get(stone).get(), stone, 4);
            }
            for (Metal metal : BlocksNF.INGOT_PILES.keySet()) {
                this.dropOther((Block)BlocksNF.INGOT_PILES.get(metal).get(), (ItemLike)ItemsNF.INGOTS.get(metal).get(), 4);
            }
            this.dropOthers((Block)BlocksNF.STEEL_INGOT_PILE_POOR.get(), LootTableProviderNF.entry((ItemLike)ItemsNF.INGOTS.get(Metal.STEEL).get(), 2.0f, 2.0f, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.INGOTS.get(Metal.IRON).get(), 2.0f, 2.0f, new LootItemCondition.Builder[0]));
            this.dropOthers((Block)BlocksNF.STEEL_INGOT_PILE_FAIR.get(), LootTableProviderNF.entry((ItemLike)ItemsNF.INGOTS.get(Metal.STEEL).get(), 3.0f, 3.0f, new LootItemCondition.Builder[0]), LootTableProviderNF.entry((ItemLike)ItemsNF.INGOTS.get(Metal.IRON).get(), 1.0f, 1.0f, new LootItemCondition.Builder[0]));
            this.dropOther((Block)BlocksNF.COKE.get(), (ItemLike)ItemsNF.COKE.get(), 4);
            this.dropOtherRandom((Block)BlocksNF.COKE_BURNING.get(), (ItemLike)ItemsNF.COKE.get(), 1, -1, 1, 1);
            this.dropOther((Block)BlocksNF.COAL.get(), (ItemLike)ItemsNF.COAL.get(), 4);
            this.dropOtherRandom((Block)BlocksNF.COAL_BURNING.get(), (ItemLike)ItemsNF.COAL.get(), 1, -1, 1, 1);
            this.dropOther((Block)BlocksNF.CHARCOAL.get(), (ItemLike)ItemsNF.CHARCOAL.get(), 4);
            this.dropOtherRandom((Block)BlocksNF.CHARCOAL_BURNING.get(), (ItemLike)ItemsNF.CHARCOAL.get(), 1, -1, 1, 1);
            this.dropOther((Block)BlocksNF.FIREWOOD.get(), (ItemLike)ItemsNF.FIREWOOD.get(), 8);
            this.dropOtherRandom((Block)BlocksNF.FIREWOOD_BURNING.get(), (ItemLike)ItemsNF.FIREWOOD.get(), 1, -1, 1, 1);
            this.dropOther((Block)BlocksNF.SLAG.get(), (ItemLike)ItemsNF.SLAG.get(), 4);
            this.dropOther((Block)BlocksNF.AZURITE.get(), (ItemLike)ItemsNF.AZURITE_CHUNK.get(), 4);
            this.dropOther((Block)BlocksNF.HEMATITE.get(), (ItemLike)ItemsNF.HEMATITE_CHUNK.get(), 4);
            this.addExplodable((Block)BlocksNF.SMELTED_AZURITE.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.SLAG.get(), 2.0f, 2.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.AZURITE_CHUNK.get(), 2.0f, 2.0f, new LootItemCondition.Builder[0]))));
            this.addExplodable((Block)BlocksNF.SMELTED_HEMATITE.get(), LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.SLAG.get(), 2.0f, 2.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.IRON_BLOOM.get(), 2.0f, 2.0f, new LootItemCondition.Builder[0]))).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.STEEL_NUGGET.get(), 0.0f, 0.0f, List.of(PerceptionCountFunction.with(1, 0.15f, 0.01f)), new LootItemCondition.Builder[0]))));
            this.dropOthers((Block)BlocksNF.SPIDER_WEB.get(), LootTableProviderNF.entry((ItemLike)ItemsNF.SILK.get(), -1.0f, 1.0f, new LootItemCondition.Builder[0]));
            this.dropOthers((Block)BlocksNF.SPIDER_NEST.get(), LootTableProviderNF.entry((ItemLike)ItemsNF.SILK.get(), 10.0f, 12.0f, new LootItemCondition.Builder[0]));
            this.dropOtherPerception((Block)BlocksNF.ANCHORING_RESIN.get(), (ItemLike)ItemsNF.ANCHORING_RESIN.get(), 3, 1, 0.5f, 0.1f, 1);
            for (Stone stone : BlocksNF.SKARA_ROCK_CLUSTERS.keySet()) {
                this.dropStone((Block)BlocksNF.SKARA_ROCK_CLUSTERS.get(stone).get(), stone, 4);
            }
            this.dropEggNest((EggNestBlock)BlocksNF.DRAKEFOWL_NEST.get());
            for (Block block : this.getKnownBlocks()) {
                if (this.addedBlocks.contains(block)) continue;
                this.m_124288_(block);
            }
        }

        protected void addExplodable(Block block, LootTable.Builder table) {
            this.m_124165_(block, (LootTable.Builder)BlockLootNF.m_124131_((ItemLike)block, (FunctionUserBuilder)table));
        }

        protected void dropOther(Block block, ItemLike drop, int amount) {
            this.m_124165_(block, BlockLootNF.createSingleItemTable(drop, amount));
        }

        protected void dropOtherRequireLiving(Block block, ItemLike drop, int amount) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLootNF.m_124134_((ItemLike)drop, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)amount)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop)).m_6509_((LootItemCondition.Builder)LootItemEntityCondition.of(LootItemEntityCondition.Test.LIVING_PRESENT)))));
        }

        protected void dropOthers(Block block, PoolEntry ... drops) {
            LootTable.Builder table = LootTable.m_79147_();
            for (PoolEntry entry : drops) {
                table = table.m_79161_(LootTableProviderNF.pool(entry));
            }
            this.m_124165_(block, (LootTable.Builder)BlockLootNF.m_124131_((ItemLike)block, (FunctionUserBuilder)table));
        }

        protected void dropOtherPerception(Block block, ItemLike drop, int amount, int pAmount, float chance, float increment, int pRolls) {
            this.dropOthersPerception(block, drop, amount, drop, pAmount, chance, increment, pRolls);
        }

        protected void dropOtherPerceptionRequireLiving(Block block, ItemLike drop, int amount, int pAmount, float chance, float increment, int pRolls) {
            this.dropOthersPerceptionRequireLiving(block, drop, amount, drop, pAmount, chance, increment, pRolls);
        }

        protected void dropOthersPerception(Block block, ItemLike drop, int amount, ItemLike pDrop, int pAmount, float chance, float increment, int pRolls) {
            this.m_124165_(block, BlockLootNF.createSingleItemTable(drop, amount).m_79161_((LootPool.Builder)BlockLootNF.m_124134_((ItemLike)pDrop, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)pRolls)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)pDrop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)0.0f))).m_5577_(PerceptionCountFunction.with(pAmount, chance, increment))))));
        }

        protected void dropOthersPerceptionRequireLiving(Block block, ItemLike drop, int amount, ItemLike pDrop, int pAmount, float chance, float increment, int pRolls) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLootNF.m_124134_((ItemLike)drop, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)amount)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop)).m_6509_((LootItemCondition.Builder)LootItemEntityCondition.of(LootItemEntityCondition.Test.LIVING_PRESENT)))).m_79161_((LootPool.Builder)BlockLootNF.m_124134_((ItemLike)pDrop, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)pRolls)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)pDrop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)0.0f))).m_5577_(PerceptionCountFunction.with(pAmount, chance, increment))).m_6509_((LootItemCondition.Builder)LootItemEntityCondition.of(LootItemEntityCondition.Test.LIVING_PRESENT)))));
        }

        protected void dropLeaves(Block block, ItemLike drop, int rMin, int rMax, int rRolls, ItemLike pDrop, int pMin, int pMax) {
            this.m_124165_(block, (LootTable.Builder)BlockLootNF.m_124131_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)rRolls)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)rMin, (float)rMax))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)pDrop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)pMin, (float)pMax)))).m_6509_((LootItemCondition.Builder)LootItemEntityCondition.of(LootItemEntityCondition.Test.LIVING_PRESENT)))));
        }

        protected void dropFruitLeaves(Block block, ItemLike drop, int rMin, int rMax, int rRolls, ItemLike pDrop, int pMin, int pMax, ItemLike fruit) {
            this.m_124165_(block, (LootTable.Builder)BlockLootNF.m_124131_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)rRolls)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)rMin, (float)rMax))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)fruit))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)pDrop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)pMin, (float)pMax)))).m_6509_((LootItemCondition.Builder)LootItemEntityCondition.of(LootItemEntityCondition.Test.LIVING_PRESENT)))));
        }

        protected void dropBranches(Block block, ItemLike pDrop, int pMin, int pMax) {
            this.m_124165_(block, (LootTable.Builder)BlockLootNF.m_124131_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)pDrop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)pMin, (float)pMax)))).m_6509_((LootItemCondition.Builder)LootItemEntityCondition.of(LootItemEntityCondition.Test.LIVING_PRESENT)))));
        }

        protected void dropStone(Block block, Stone type, int amount) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.ROCKS.get(type).get(), (float)amount, (float)amount, new LootItemCondition.Builder[0])).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(TagsNF.CHISEL_METAL)).m_81807_())).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.STONE_BRICKS.get(type).get(), (float)amount, (float)amount, new LootItemCondition.Builder[0])).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(TagsNF.CHISEL_METAL)))));
        }

        protected void dropStoneSlab(Block block, Stone type, int amount) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.ROCKS.get(type).get(), (float)amount, (float)amount, new LootItemCondition.Builder[0])).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)(amount * 2))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(TagsNF.CHISEL_METAL)).m_81807_())).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.STONE_BRICKS.get(type).get(), (float)amount, (float)amount, new LootItemCondition.Builder[0])).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)(amount * 2))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(TagsNF.CHISEL_METAL)))));
        }

        protected void dropStoneSiding(Block block, Stone type, int amount) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.ROCKS.get(type).get(), (float)amount, (float)amount, new LootItemCondition.Builder[0])).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)(amount * 2))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.DOUBLE))))).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(TagsNF.CHISEL_METAL)).m_81807_())).m_79161_(LootTableProviderNF.pool(LootTableProviderNF.entry((ItemLike)ItemsNF.STONE_BRICKS.get(type).get(), (float)amount, (float)amount, new LootItemCondition.Builder[0])).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)(amount * 2))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.DOUBLE))))).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(TagsNF.CHISEL_METAL)))));
        }

        protected void dropOtherRandom(Block block, ItemLike drop, int amount, int rMin, int rMax, int rRolls) {
            this.dropOthersRandom(block, drop, amount, drop, rMin, rMax, rRolls);
        }

        protected void dropOthersRandom(Block block, ItemLike drop, int amount, ItemLike rDrop, int rMin, int rMax, int rRolls) {
            this.m_124165_(block, BlockLootNF.createSingleItemTable(drop, amount).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)rRolls)).m_79076_((LootPoolEntryContainer.Builder)BlockLootNF.m_124131_((ItemLike)rDrop, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)rDrop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)0.0f))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)rMin, (float)rMax)))))));
        }

        protected void dropOthersRandomReplace(Block block, ItemLike drop, int amount, ItemLike rDrop, float chance, int rRolls) {
            this.m_124165_(block, BlockLootNF.createSingleItemTable(drop, amount).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)rRolls)).m_79076_((LootPoolEntryContainer.Builder)BlockLootNF.m_124134_((ItemLike)rDrop, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)rDrop).m_6509_(LootItemRandomChanceCondition.m_81927_((float)chance))).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop))))));
        }

        protected void dropSlab(Block block, ItemLike drop, int amount) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BlockLootNF.m_124131_((ItemLike)drop, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)drop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)amount)).m_6509_(LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)).m_81807_())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)(amount * 2))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))))))));
        }

        protected void dropSiding(Block block, ItemLike drop, int amount) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BlockLootNF.m_124131_((ItemLike)drop, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)drop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)amount)).m_6509_(LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.DOUBLE))).m_81807_())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)(amount * 2))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.DOUBLE)))))))));
        }

        protected void dropCampfire(Block block) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BlockLootNF.m_124131_((ItemLike)((ItemLike)ItemsNF.FIREWOOD.get()), (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsNF.FIREWOOD.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)0.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.FIREWOOD, 0)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.FIREWOOD, 2)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.FIREWOOD, 3)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.FIREWOOD, 4))))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BlockLootNF.m_124131_((ItemLike)((ItemLike)ItemsNF.CHARCOAL.get()), (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsNF.CHARCOAL.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)0.0f)).m_6509_(LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.FIREWOOD, 0)).m_81807_()))))));
        }

        protected void dropCluster(ClusterBlock block) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BlockLootNF.m_124131_((ItemLike)((ItemLike)block.drop.get()), (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)block.drop.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)ClusterBlock.COUNT, 2)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)ClusterBlock.COUNT, 3)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)ClusterBlock.COUNT, 4))))))));
        }

        protected void dropEggNest(EggNestBlock block) {
            this.m_124165_((Block)block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BlockLootNF.m_124131_((ItemLike)((ItemLike)block.eggItem.get()), (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)block.eggItem.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)0.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)EggNestBlock.EGGS, 0)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)EggNestBlock.EGGS, 1)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)EggNestBlock.EGGS, 2)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)EggNestBlock.EGGS, 3)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)EggNestBlock.EGGS, 4))))))));
        }

        protected void dropPile(PileBlock block) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BlockLootNF.m_124131_((ItemLike)((ItemLike)block.drop.get()), (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)block.drop.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PileBlock.COUNT, 2)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PileBlock.COUNT, 3)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PileBlock.COUNT, 4)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)5.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PileBlock.COUNT, 5)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)6.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PileBlock.COUNT, 6)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)7.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PileBlock.COUNT, 7)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)8.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PileBlock.COUNT, 8))))))));
        }

        protected void dropSpecialAction(Block block, ItemLike drop, int amount, TagKey<Action> tag, ItemLike actionDrop, int actionAmount) {
            this.m_124165_(block, (LootTable.Builder)BlockLootNF.m_124131_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)amount)))).m_6509_(ActionTagCondition.of(tag).m_81807_())).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)actionDrop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)actionAmount)))).m_6509_((LootItemCondition.Builder)ActionTagCondition.of(tag)))));
        }

        protected void dropVegetableCrop(Block block, ItemLike vegetable, float min, float max, ItemLike seeds, float pChance, float pIncrement) {
            this.m_124165_(block, (LootTable.Builder)BlockLootNF.m_124131_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)seeds))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)vegetable).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_8, 8))).m_6509_(LootItemEntityCondition.of(LootItemEntityCondition.Test.HUNGRY).m_81807_())).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)seeds).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)0.0f))).m_5577_(PerceptionCountFunction.with(1, pChance, pIncrement))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_8, 8))).m_6509_(LootItemEntityCondition.of(LootItemEntityCondition.Test.HUNGRY).m_81807_()))));
        }

        protected void dropFruitBush(FruitBushBlock block, int stage3Min, int stage3Max, int stage4Min, int stage4Max, float pChance, float pIncrement) {
            this.m_124165_((Block)block, (LootTable.Builder)BlockLootNF.m_124131_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_4, 2)).m_7818_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_4, 3))).m_7818_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_4, 4)))).m_6509_((LootItemCondition.Builder)MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(TagsNF.SHOVEL)).m_7818_(LootItemEntityCondition.of(LootItemEntityCondition.Test.LIVING_PRESENT).m_81807_()))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsNF.STICK.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_4, 2)).m_7818_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_4, 3))).m_7818_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_4, 4)))).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(TagsNF.SHOVEL)).m_81807_()).m_6509_((LootItemCondition.Builder)LootItemEntityCondition.of(LootItemEntityCondition.Test.LIVING_PRESENT))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsNF.STICK.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_4, 1)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)block.fruitItem.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)stage3Min, (float)stage3Max)))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_4, 3))).m_6509_(LootItemEntityCondition.of(LootItemEntityCondition.Test.HUNGRY).m_81807_())).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)block.fruitItem.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)stage4Min, (float)stage4Max)))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_4, 4))).m_6509_(LootItemEntityCondition.of(LootItemEntityCondition.Test.HUNGRY).m_81807_())).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)block.fruitItem.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)0.0f))).m_5577_(PerceptionCountFunction.with(1, pChance, pIncrement))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_4, 3)).m_7818_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStatePropertiesNF.STAGE_4, 4)))).m_6509_(LootItemEntityCondition.of(LootItemEntityCondition.Test.HUNGRY).m_81807_()))));
        }

        protected static LootTable.Builder createSingleItemTable(ItemLike item, int amount) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLootNF.m_124134_((ItemLike)item, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)amount)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item))));
        }

        protected static LootTable.Builder createDoubleBlockDrops(Block block, ItemLike drop, int amount) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)amount)).m_79076_((LootPoolEntryContainer.Builder)BlockLootNF.m_124131_((ItemLike)block, (FunctionUserBuilder)((FunctionUserBuilder)LootItem.m_79579_((ItemLike)drop).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER)))))));
        }
    }
}

