/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data;

import frostnox.nightfall.block.Metal;
import frostnox.nightfall.block.MicroGridShape;
import frostnox.nightfall.block.Soil;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.BowlCrushingRecipe;
import frostnox.nightfall.data.recipe.HeldToolRecipe;
import frostnox.nightfall.data.recipe.builder.BarrelRecipeBuilder;
import frostnox.nightfall.data.recipe.builder.BuildingRecipeBuilder;
import frostnox.nightfall.data.recipe.builder.CraftingRecipeBuilder;
import frostnox.nightfall.data.recipe.builder.MixtureRecipeBuilder;
import frostnox.nightfall.data.recipe.builder.SingleRecipeBuilder;
import frostnox.nightfall.data.recipe.builder.TieredAnvilRecipeBuilder;
import frostnox.nightfall.encyclopedia.Entry;
import frostnox.nightfall.item.Armament;
import frostnox.nightfall.item.ArmorType;
import frostnox.nightfall.item.IStyle;
import frostnox.nightfall.item.ITieredArmorMaterial;
import frostnox.nightfall.item.Style;
import frostnox.nightfall.item.TieredArmorMaterial;
import frostnox.nightfall.item.TieredItemMaterial;
import frostnox.nightfall.item.item.BlockItemNF;
import frostnox.nightfall.item.item.BuildingMaterialItem;
import frostnox.nightfall.item.item.MeleeWeaponItem;
import frostnox.nightfall.registry.EntriesNF;
import frostnox.nightfall.registry.KnowledgeNF;
import frostnox.nightfall.registry.forge.FluidsNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.RegistryObject;

public class RecipeProviderNF
extends RecipeProvider {
    private static final int DAY_LENGTH = 48000;

    public RecipeProviderNF(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        BuildingRecipeBuilder.base((Item)ItemsNF.CLAY.get(), 4, (Item)ItemsNF.CLAY_BLOCK.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.CLAY.get(), 4, (Item)ItemsNF.CLAY_BRICKS.get()).order(1).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.CLAY.get(), 8, (Item)ItemsNF.UNFIRED_POT.get()).order(2).requirement(EntriesNF.POTTERY).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.CLAY.get(), 6, (Item)ItemsNF.UNFIRED_CAULDRON.get()).order(3).requirement(EntriesNF.COOKING).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.CLAY.get(), 4, (Item)ItemsNF.UNFIRED_CRUCIBLE.get()).order(4).requirement(EntriesNF.POTTERY).save(consumer);
        for (Armament type : ItemsNF.UNFIRED_ARMAMENT_MOLDS.keySet()) {
            BuildingRecipeBuilder.base((Item)ItemsNF.CLAY.get(), 4, (Item)ItemsNF.UNFIRED_ARMAMENT_MOLDS.get(type).get()).requirement(type == Armament.CHISEL ? EntriesNF.CHISEL_MOLD : (type == Armament.SICKLE ? EntriesNF.SICKLE : EntriesNF.CASTING)).save(consumer);
        }
        BuildingRecipeBuilder.base((Item)ItemsNF.CLAY.get(), 4, (Item)ItemsNF.UNFIRED_INGOT_MOLD.get()).requirement(EntriesNF.CASTING).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.CLAY.get(), 4, (Item)ItemsNF.UNFIRED_ARROWHEAD_MOLD.get()).requirement(EntriesNF.ARROWHEAD_MOLD).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.FIRE_CLAY.get(), 4, (Item)ItemsNF.FIRE_CLAY_BLOCK.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.FIRE_CLAY.get(), 4, (Item)ItemsNF.FIRE_CLAY_BRICKS.get()).order(1).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.MUD.get(), 4, (Item)ItemsNF.MUD_BLOCK.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.MUD.get(), 4, (Item)ItemsNF.WET_MUD_BRICKS.get()).order(1).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.SNOWBALL.get(), 1, (Item)ItemsNF.SNOWBALL_THROWABLE.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.SNOWBALL.get(), 1, (Item)ItemsNF.SNOW.get()).order(1).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.SNOWBALL.get(), 8, (Item)ItemsNF.PACKED_SNOW.get()).order(2).save(consumer);
        for (Soil soil : Soil.values()) {
            Item soil2 = (Item)ItemsNF.SOILS.get(soil).get();
            BlockItemNF blockItemNF = switch (soil) {
                default -> throw new IncompatibleClassChangeError();
                case Soil.SILT -> (BlockItemNF)((Object)ItemsNF.SILT.get());
                case Soil.DIRT -> (BlockItemNF)((Object)ItemsNF.DIRT.get());
                case Soil.LOAM -> (BlockItemNF)((Object)ItemsNF.LOAM.get());
                case Soil.ASH -> (BlockItemNF)((Object)ItemsNF.ASH.get());
                case Soil.GRAVEL -> (BlockItemNF)((Object)ItemsNF.GRAVEL.get());
                case Soil.BLUE_GRAVEL -> (BlockItemNF)((Object)ItemsNF.BLUE_GRAVEL.get());
                case Soil.BLACK_GRAVEL -> (BlockItemNF)((Object)ItemsNF.BLACK_GRAVEL.get());
                case Soil.SAND -> (BlockItemNF)((Object)ItemsNF.SAND.get());
                case Soil.RED_SAND -> (BlockItemNF)((Object)ItemsNF.RED_SAND.get());
                case Soil.WHITE_SAND -> (BlockItemNF)((Object)ItemsNF.WHITE_SAND.get());
            };
            BuildingRecipeBuilder.base(soil2, 4, (Item)blockItemNF).order(0).save(consumer);
        }
        for (Enum enum_ : Stone.values()) {
            Item rock = (Item)ItemsNF.ROCKS.get(enum_).get();
            Item item = (Item)ItemsNF.STONE_BRICKS.get(enum_).get();
            BuildingRecipeBuilder.base(rock, 1, (Item)ItemsNF.ROCK_CLUSTERS.get(enum_).get()).order(0).save(consumer);
            BuildingRecipeBuilder.base(rock, 4, (Item)ItemsNF.STACKED_STONE.get(enum_).get()).order(1).save(consumer);
            BuildingRecipeBuilder.base(rock, 3, (Item)ItemsNF.STACKED_STONE_STAIRS.get(enum_).get()).order(2).save(consumer);
            BuildingRecipeBuilder.base(rock, 2, (Item)ItemsNF.STACKED_STONE_SLABS.get(enum_).get()).order(3).save(consumer);
            BuildingRecipeBuilder.base(rock, 2, (Item)ItemsNF.STACKED_STONE_SIDINGS.get(enum_).get()).order(4).save(consumer);
            BuildingRecipeBuilder.base(rock, 4, (Item)ItemsNF.COBBLED_STONE.get(enum_).get()).addExtra(TagsNF.COBBLE_MORTAR).order(5).save(consumer);
            BuildingRecipeBuilder.base(rock, 3, (Item)ItemsNF.COBBLED_STONE_STAIRS.get(enum_).get()).addExtra(TagsNF.COBBLE_MORTAR).order(6).save(consumer);
            BuildingRecipeBuilder.base(rock, 2, (Item)ItemsNF.COBBLED_STONE_SLABS.get(enum_).get()).addExtra(TagsNF.COBBLE_MORTAR).order(7).save(consumer);
            BuildingRecipeBuilder.base(rock, 2, (Item)ItemsNF.COBBLED_STONE_SIDINGS.get(enum_).get()).addExtra(TagsNF.COBBLE_MORTAR).order(8).save(consumer);
            BuildingRecipeBuilder.base(item, 4, (Item)ItemsNF.STONE_BRICK_BLOCKS.get(enum_).get()).order(0).save(consumer);
            BuildingRecipeBuilder.base(item, 3, (Item)ItemsNF.STONE_BRICK_STAIRS.get(enum_).get()).order(1).save(consumer);
            BuildingRecipeBuilder.base(item, 2, (Item)ItemsNF.STONE_BRICK_SLABS.get(enum_).get()).order(2).save(consumer);
            BuildingRecipeBuilder.base(item, 2, (Item)ItemsNF.STONE_BRICK_SIDINGS.get(enum_).get()).order(3).save(consumer);
            HeldToolRecipe.saveHeldTool(Ingredient.m_43929_((ItemLike[])new ItemLike[]{rock}), Ingredient.m_204132_(TagsNF.CHISEL_METAL), (ItemLike)item, 1, RecipeProviderNF.entryKnowledge(EntriesNF.TOOLS), consumer);
        }
        for (Enum enum_ : Tree.values()) {
            Item plank = (Item)ItemsNF.PLANKS.get(enum_).get();
            BuildingRecipeBuilder.base(plank, 4, (Item)ItemsNF.PLANK_BLOCKS.get(enum_).get()).order(0).save(consumer);
            BuildingRecipeBuilder.base(plank, 3, (Item)ItemsNF.PLANK_STAIRS.get(enum_).get()).order(1).save(consumer);
            BuildingRecipeBuilder.base(plank, 2, (Item)ItemsNF.PLANK_SLABS.get(enum_).get()).order(2).save(consumer);
            BuildingRecipeBuilder.base(plank, 2, (Item)ItemsNF.PLANK_SIDINGS.get(enum_).get()).order(3).save(consumer);
            BuildingRecipeBuilder.base(plank, 3, (Item)ItemsNF.PLANK_FENCES.get(enum_).get()).order(4).requirement(EntriesNF.WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 3, (Item)ItemsNF.PLANK_FENCE_GATES.get(enum_).get()).order(5).requirement(EntriesNF.WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 6, (Item)ItemsNF.PLANK_DOORS.get(enum_).get()).order(6).requirement(EntriesNF.WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 3, (Item)ItemsNF.PLANK_TRAPDOORS.get(enum_).get()).order(7).requirement(EntriesNF.ADVANCED_WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 3, (Item)ItemsNF.PLANK_HATCHES.get(enum_).get()).order(8).requirement(EntriesNF.ADVANCED_WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 3, (Item)ItemsNF.PLANK_LADDERS.get(enum_).get()).order(9).requirement(EntriesNF.WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 3, (Item)ItemsNF.PLANK_SIGNS.get(enum_).get()).order(11).requirement(EntriesNF.WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 2, (Item)ItemsNF.WOODEN_ITEM_FRAMES.get(enum_).get()).requirement(EntriesNF.ADVANCED_WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 12, (Item)ItemsNF.ARMOR_STANDS.get(enum_).get()).requirement(EntriesNF.ADVANCED_WOODWORKING).save(consumer);
            if (ItemsNF.BOATS.containsKey(enum_)) {
                BuildingRecipeBuilder.base(plank, 16, (Item)ItemsNF.BOATS.get(enum_).get()).requirement(EntriesNF.ADVANCED_WOODWORKING).save(consumer);
            }
            BuildingRecipeBuilder.base(plank, 16, (Item)ItemsNF.BARRELS.get(enum_).get()).requirement(EntriesNF.TANNING).save(consumer);
            BuildingRecipeBuilder.base(plank, 16, (Item)ItemsNF.CHESTS.get(enum_).get()).order(10).requirement(EntriesNF.ADVANCED_WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 4, (Item)ItemsNF.RACKS.get(enum_).get()).requirement(EntriesNF.WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 8, (Item)ItemsNF.SHELVES.get(enum_).get()).requirement(EntriesNF.WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 4, (Item)ItemsNF.CHAIRS.get(enum_).get()).requirement(EntriesNF.ADVANCED_WOODWORKING).save(consumer);
            BuildingRecipeBuilder.base(plank, 8, (Item)ItemsNF.TROUGHS.get(enum_).get()).requirement(EntriesNF.TROUGH).save(consumer);
            if (!ItemsNF.BOWS.containsKey(enum_)) continue;
            CraftingRecipeBuilder.base((ItemLike)ItemsNF.BOWS.get(enum_).get(), EntriesNF.BOW_AND_ARROW).define(Character.valueOf('P'), (ItemLike)plank).define(Character.valueOf('L'), (ItemLike)ItemsNF.FLAX_FIBERS.get()).pattern(" PL").pattern("P L").pattern(" PL").save(consumer);
        }
        for (Metal type : ItemsNF.INGOTS.keySet()) {
            BuildingRecipeBuilder.base((Item)ItemsNF.INGOTS.get(type).get(), 4, (Item)ItemsNF.INGOT_PILES.get(type).get()).order(0).save(consumer);
        }
        BuildingRecipeBuilder.base((Item)ItemsNF.TERRACOTTA_SHARD.get(), 4, (Item)ItemsNF.TERRACOTTA_TILES.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.TERRACOTTA_SHARD.get(), 3, (Item)ItemsNF.TERRACOTTA_TILE_STAIRS.get()).order(1).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.TERRACOTTA_SHARD.get(), 2, (Item)ItemsNF.TERRACOTTA_TILE_SLAB.get()).order(2).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.TERRACOTTA_SHARD.get(), 2, (Item)ItemsNF.TERRACOTTA_TILE_SIDING.get()).order(3).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.TERRACOTTA_SHARD.get(), 4, (Item)ItemsNF.TERRACOTTA_MOSAIC.get()).order(4).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.TERRACOTTA_SHARD.get(), 3, (Item)ItemsNF.TERRACOTTA_MOSAIC_STAIRS.get()).order(5).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.TERRACOTTA_SHARD.get(), 2, (Item)ItemsNF.TERRACOTTA_MOSAIC_SLAB.get()).order(6).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.TERRACOTTA_SHARD.get(), 2, (Item)ItemsNF.TERRACOTTA_MOSAIC_SIDING.get()).order(7).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.BRICK.get(), 4, (Item)ItemsNF.BRICKS.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.BRICK.get(), 3, (Item)ItemsNF.BRICK_STAIRS.get()).order(1).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.BRICK.get(), 2, (Item)ItemsNF.BRICK_SLAB.get()).order(2).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.BRICK.get(), 2, (Item)ItemsNF.BRICK_SIDING.get()).order(3).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.MUD_BRICK.get(), 4, (Item)ItemsNF.MUD_BRICKS.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.MUD_BRICK.get(), 3, (Item)ItemsNF.MUD_BRICK_STAIRS.get()).order(1).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.MUD_BRICK.get(), 2, (Item)ItemsNF.MUD_BRICK_SLAB.get()).order(2).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.MUD_BRICK.get(), 2, (Item)ItemsNF.MUD_BRICK_SIDING.get()).order(3).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.FIRE_BRICK.get(), 4, (Item)ItemsNF.FIRE_BRICKS.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.FIRE_BRICK.get(), 3, (Item)ItemsNF.FIRE_BRICK_STAIRS.get()).order(1).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.FIRE_BRICK.get(), 2, (Item)ItemsNF.FIRE_BRICK_SLAB.get()).order(2).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.FIRE_BRICK.get(), 2, (Item)ItemsNF.FIRE_BRICK_SIDING.get()).order(3).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.PLANT_FIBERS.get(), 4, (Item)ItemsNF.THATCH.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.PLANT_FIBERS.get(), 3, (Item)ItemsNF.THATCH_STAIRS.get()).order(1).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.PLANT_FIBERS.get(), 2, (Item)ItemsNF.THATCH_SLAB.get()).order(2).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.PLANT_FIBERS.get(), 2, (Item)ItemsNF.THATCH_SIDING.get()).order(3).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.GLASS.get(), 4, (Item)ItemsNF.GLASS_BLOCK.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.GLASS.get(), 2, (Item)ItemsNF.GLASS_SLAB.get()).order(1).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.GLASS.get(), 2, (Item)ItemsNF.GLASS_SIDING.get()).order(2).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.FIREWOOD.get(), 8, (Item)ItemsNF.FIREWOOD_BLOCK.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.FIREWOOD.get(), 4, (Item)ItemsNF.CAMPFIRE.get()).order(1).requirement(EntriesNF.CAMPFIRE).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.COAL.get(), 4, (Item)ItemsNF.COAL_BLOCK.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.CHARCOAL.get(), 4, (Item)ItemsNF.CHARCOAL_BLOCK.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.COKE.get(), 4, (Item)ItemsNF.COKE_BLOCK.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.SLAG.get(), 4, (Item)ItemsNF.SLAG_BLOCK.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.AZURITE_CHUNK.get(), 4, (Item)ItemsNF.AZURITE_BLOCK.get()).order(0).save(consumer);
        BuildingRecipeBuilder.base((Item)ItemsNF.HEMATITE_CHUNK.get(), 4, (Item)ItemsNF.HEMATITE_BLOCK.get()).order(0).save(consumer);
        SingleRecipeBuilder.base((ItemLike)ItemsNF.ROASTED_POTATO.get(), 1).input((ItemLike)ItemsNF.POTATO.get()).cookTime(1200).requirement(EntriesNF.CAMPFIRE.getId()).saveCampfire(consumer);
        SingleRecipeBuilder.base((ItemLike)ItemsNF.ROASTED_CARROT.get(), 1).input((ItemLike)ItemsNF.CARROT.get()).cookTime(1200).requirement(EntriesNF.CAMPFIRE.getId()).saveCampfire(consumer);
        SingleRecipeBuilder.base((ItemLike)ItemsNF.COOKED_GAME.get(), 1).input((ItemLike)ItemsNF.RAW_GAME.get()).cookTime(1200).requirement(EntriesNF.CAMPFIRE.getId()).saveCampfire(consumer);
        SingleRecipeBuilder.base((ItemLike)ItemsNF.COOKED_VENISON.get(), 1).input((ItemLike)ItemsNF.RAW_VENISON.get()).cookTime(1200).requirement(EntriesNF.CAMPFIRE.getId()).saveCampfire(consumer);
        SingleRecipeBuilder.base((ItemLike)ItemsNF.COOKED_POULTRY.get(), 1).input((ItemLike)ItemsNF.RAW_POULTRY.get()).cookTime(1200).requirement(EntriesNF.CAMPFIRE.getId()).saveCampfire(consumer);
        SingleRecipeBuilder.base((ItemLike)ItemsNF.COOKED_PALE_FLESH.get(), 1).input((ItemLike)ItemsNF.RAW_PALE_FLESH.get()).cookTime(1200).requirement(EntriesNF.CAMPFIRE.getId()).saveCampfire(consumer);
        MixtureRecipeBuilder.base((ItemLike)ItemsNF.MEAT_STEW.get()).addIngredient((ItemLike)ItemsNF.WATER.get(), 1.0f, 1.0f).addIngredient(TagsNF.MEAT, 3.0f, Float.MAX_VALUE).unitsPerOutput(4).cookTime(3000).requirement(RecipeProviderNF.itemKnowledge(ItemsNF.MEAT_STEW)).saveCauldron(consumer);
        MixtureRecipeBuilder.base((ItemLike)ItemsNF.VEGETABLE_STEW.get()).addIngredient((ItemLike)ItemsNF.WATER.get(), 1.0f, 1.0f).addIngredient(TagsNF.MEAT, 0.0f, 1.0f).addIngredient(TagsNF.VEGETABLE, 2.0f, Float.MAX_VALUE).unitsPerOutput(4).cookTime(3000).requirement(RecipeProviderNF.itemKnowledge(ItemsNF.VEGETABLE_STEW)).saveCauldron(consumer);
        MixtureRecipeBuilder.base((ItemLike)ItemsNF.HEARTY_STEW.get()).addIngredient((ItemLike)ItemsNF.WATER.get(), 1.0f, 1.0f).addIngredient(TagsNF.MEAT, 2.0f, Float.MAX_VALUE).addIngredient(TagsNF.VEGETABLE, 1.0f, Float.MAX_VALUE).unitsPerOutput(4).cookTime(3000).requirement(RecipeProviderNF.itemKnowledge(ItemsNF.HEARTY_STEW)).saveCauldron(consumer);
        MixtureRecipeBuilder.base((ItemLike)ItemsNF.BOILED_EGG.get()).addIngredient((ItemLike)ItemsNF.WATER.get(), 1.0f, 1.0f).addIngredient(TagsNF.EGG, 2.0f, Float.MAX_VALUE).unitsPerOutput(3).cookTime(3000).requirement(KnowledgeNF.ITEM_TAGS.get(TagsNF.EGG).getId()).saveCauldron(consumer);
        MixtureRecipeBuilder.base((ItemLike)ItemsNF.SOUFFLE.get()).addIngredient((ItemLike)ItemsNF.WATER.get(), 0.0f, 0.0f).addIngredient(TagsNF.EGG, 2.0f, Float.MAX_VALUE).unitsPerOutput(4).cookTime(3000).requirement(RecipeProviderNF.itemKnowledge(ItemsNF.SOUFFLE)).saveCauldron(consumer);
        MixtureRecipeBuilder.base((ItemLike)ItemsNF.FRUIT_SOUFFLE.get()).addIngredient((ItemLike)ItemsNF.WATER.get(), 0.0f, 0.0f).addIngredient(TagsNF.EGG, 2.0f, Float.MAX_VALUE).addIngredient(TagsNF.FRUIT, 2.0f, Float.MAX_VALUE).unitsPerOutput(4).cookTime(3000).requirement(RecipeProviderNF.itemKnowledge(ItemsNF.FRUIT_SOUFFLE)).saveCauldron(consumer);
        MixtureRecipeBuilder.base((ItemLike)ItemsNF.SAVORY_SOUFFLE.get()).addIngredient((ItemLike)ItemsNF.WATER.get(), 0.0f, 0.0f).addIngredient(TagsNF.EGG, 2.0f, Float.MAX_VALUE).addIngredient(TagsNF.FRUIT_OR_VEGETABLE, 1.0f, Float.MAX_VALUE).addIngredient(TagsNF.MEAT, 1.0f, Float.MAX_VALUE).unitsPerOutput(4).cookTime(3000).requirement(RecipeProviderNF.itemKnowledge(ItemsNF.SAVORY_SOUFFLE)).saveCauldron(consumer);
        BowlCrushingRecipe.saveBowl(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.YARROW.get()}), Ingredient.m_204132_(TagsNF.CHISEL), (ItemLike)ItemsNF.YARROW_POWDER.get(), 1, EntriesNF.WOODCARVING.getId(), consumer);
        BowlCrushingRecipe.saveBowl(Ingredient.m_204132_(TagsNF.CRUSHABLE_TO_LIME), Ingredient.m_204132_(TagsNF.CHISEL_OR_HAMMER), (ItemLike)ItemsNF.LIME.get(), 1, EntriesNF.WOODCARVING.getId(), consumer);
        BowlCrushingRecipe.saveBowl(Ingredient.m_204132_(TagsNF.CRUSHABLE_TO_BONE_SHARD), Ingredient.m_204132_(TagsNF.HAMMER), (ItemLike)ItemsNF.BONE_SHARD.get(), 2, EntriesNF.WOODCARVING.getId(), consumer);
        HeldToolRecipe.saveHeldTool(Ingredient.m_204132_((TagKey)ItemTags.f_13182_), Ingredient.m_204132_(TagsNF.ADZE), (ItemLike)ItemsNF.WOODEN_BOWL.get(), 1, EntriesNF.WOODCARVING.getId(), consumer);
        HeldToolRecipe.saveHeldTool(Ingredient.m_204132_((TagKey)ItemTags.f_13182_), Ingredient.m_204132_(TagsNF.AXE), (ItemLike)ItemsNF.WOODEN_CLUB.get(), 1, EntriesNF.WOODCARVING.getId(), consumer);
        HeldToolRecipe.saveHeldTool(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.COCONUT.get()}), Ingredient.m_204132_(TagsNF.DAGGER), (ItemLike)ItemsNF.COCONUT_HALF.get(), 2, RecipeProviderNF.entryKnowledge(EntriesNF.TOOLS), consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.FLINT_ADZE.get(), EntriesNF.TOOLS).define(Character.valueOf('F'), (ItemLike)ItemsNF.FLINT.get()).define(Character.valueOf('X'), (ItemLike)ItemsNF.PLANT_FIBERS.get()).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).pattern(" X").pattern("FS").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.FLINT_AXE.get(), EntriesNF.TOOLS).define(Character.valueOf('F'), (ItemLike)ItemsNF.FLINT.get()).define(Character.valueOf('X'), (ItemLike)ItemsNF.PLANT_FIBERS.get()).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).pattern("FX").pattern(" S").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.FLINT_DAGGER.get(), EntriesNF.TOOLS).define(Character.valueOf('F'), (ItemLike)ItemsNF.FLINT.get()).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).pattern("F").pattern("S").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.FLINT_HAMMER.get(), EntriesNF.TOOLS).define(Character.valueOf('F'), (ItemLike)ItemsNF.FLINT.get()).define(Character.valueOf('X'), (ItemLike)ItemsNF.PLANT_FIBERS.get()).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).pattern("FXF").pattern(" S ").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.FLINT_SHOVEL.get(), EntriesNF.TOOLS).define(Character.valueOf('F'), (ItemLike)ItemsNF.FLINT.get()).define(Character.valueOf('X'), (ItemLike)ItemsNF.PLANT_FIBERS.get()).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).pattern("F").pattern("X").pattern("S").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.FLINT_SPEAR.get(), EntriesNF.TOOLS).define(Character.valueOf('F'), (ItemLike)ItemsNF.FLINT.get()).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).pattern("F  ").pattern(" S ").pattern("  S").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.ROPE.get(), EntriesNF.TOOLS).define(Character.valueOf('F'), (ItemLike)ItemsNF.PLANT_FIBERS.get()).pattern("F").pattern("F").pattern("F").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.FIBER_BANDAGE.get(), EntriesNF.TOOLS).define(Character.valueOf('F'), (ItemLike)ItemsNF.PLANT_FIBERS.get()).pattern("FF").pattern("FF").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.FLINT_CHISEL.get(), EntriesNF.TOOLS).define(Character.valueOf('F'), (ItemLike)ItemsNF.FLINT.get()).pattern("F").pattern("F").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.WOODEN_BUCKET.get(), EntriesNF.WOODWORKING).define(Character.valueOf('P'), TagsNF.PLANK).define(Character.valueOf('R'), (ItemLike)ItemsNF.ROPE.get()).pattern(" R ").pattern("P P").pattern("PPP").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.IRONWOOD_SHIELD.get(), EntriesNF.WOODEN_SHIELD).define(Character.valueOf('P'), (ItemLike)ItemsNF.PLANKS.get(Tree.IRONWOOD).get()).pattern("PPP").pattern("PPP").pattern("PPP").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.TORCH_UNLIT.get(), EntriesNF.CAMPFIRE).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).define(Character.valueOf('F'), (ItemLike)ItemsNF.PLANT_FIBERS.get()).pattern("F").pattern("S").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.HELMETS.get(TieredArmorMaterial.LEATHER).get(), EntriesNF.TANNING).define(Character.valueOf('A'), (ItemLike)ItemsNF.LEATHER.get()).pattern("AAA").pattern("A A").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.LEATHER).get(), EntriesNF.TANNING).define(Character.valueOf('A'), (ItemLike)ItemsNF.LEATHER.get()).pattern("A A").pattern("AAA").pattern("AAA").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.LEGGINGS.get(TieredArmorMaterial.LEATHER).get(), EntriesNF.TANNING).define(Character.valueOf('A'), (ItemLike)ItemsNF.LEATHER.get()).pattern("AAA").pattern("A A").pattern("A A").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.BOOTS.get(TieredArmorMaterial.LEATHER).get(), EntriesNF.TANNING).define(Character.valueOf('A'), (ItemLike)ItemsNF.LEATHER.get()).pattern("A A").pattern("A A").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.BACKPACK.get(), EntriesNF.TANNING).define(Character.valueOf('A'), (ItemLike)ItemsNF.LEATHER.get()).pattern("AA").pattern("AA").pattern("AA").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.LINEN.get(), EntriesNF.WEAVING).define(Character.valueOf('L'), (ItemLike)ItemsNF.FLAX_FIBERS.get()).pattern("LL").pattern("LL").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.MASK.get(), EntriesNF.WEAVING).define(Character.valueOf('L'), (ItemLike)ItemsNF.LINEN.get()).pattern("LLL").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.POUCH.get(), EntriesNF.WEAVING).define(Character.valueOf('L'), (ItemLike)ItemsNF.LINEN.get()).pattern("L L").pattern(" L ").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.BANDAGE.get(), EntriesNF.WEAVING).define(Character.valueOf('L'), (ItemLike)ItemsNF.LINEN.get()).pattern("L").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.HELMETS.get(TieredArmorMaterial.PADDED).get(), EntriesNF.WEAVING).define(Character.valueOf('A'), (ItemLike)ItemsNF.LINEN.get()).pattern("AAA").pattern("A A").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.PADDED).get(), EntriesNF.WEAVING).define(Character.valueOf('A'), (ItemLike)ItemsNF.LINEN.get()).pattern("A A").pattern("AAA").pattern("AAA").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.LEGGINGS.get(TieredArmorMaterial.PADDED).get(), EntriesNF.WEAVING).define(Character.valueOf('A'), (ItemLike)ItemsNF.LINEN.get()).pattern("AAA").pattern("A A").pattern("A A").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.BOOTS.get(TieredArmorMaterial.PADDED).get(), EntriesNF.WEAVING).define(Character.valueOf('A'), (ItemLike)ItemsNF.LINEN.get()).pattern("A A").pattern("A A").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.MEDICINAL_BANDAGE.get(), EntriesNF.MEDICINAL_BANDAGE).define(Character.valueOf('B'), (ItemLike)ItemsNF.BANDAGE.get()).define(Character.valueOf('M'), (ItemLike)ItemsNF.YARROW_POWDER.get()).pattern("M").pattern("B").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.FLINT_ARROW.get(), EntriesNF.BOW_AND_ARROW).define(Character.valueOf('A'), (ItemLike)ItemsNF.FLINT.get()).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).define(Character.valueOf('F'), TagsNF.FLETCHING).pattern("A").pattern("S").pattern("F").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.BONE_ARROW.get(), EntriesNF.BONE_ARROW).define(Character.valueOf('A'), (ItemLike)ItemsNF.BONE_SHARD.get()).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).define(Character.valueOf('F'), TagsNF.FLETCHING).pattern("A").pattern("S").pattern("F").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.SLING.get(), EntriesNF.SLING).define(Character.valueOf('F'), (ItemLike)ItemsNF.ROPE.get()).pattern(" FF").pattern("F F").pattern(" F ").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.SLING_REINFORCED.get(), EntriesNF.REINFORCED_SLING).define(Character.valueOf('F'), (ItemLike)ItemsNF.ROPE.get()).define(Character.valueOf('L'), (ItemLike)ItemsNF.LEATHER.get()).pattern(" FL").pattern("F F").pattern(" F ").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.WARDING_CHARM.get(), EntriesNF.WARDING_CHARM).define(Character.valueOf('F'), (ItemLike)ItemsNF.PLANT_FIBERS.get()).define(Character.valueOf('B'), (ItemLike)ItemsNF.LIVING_BONE.get()).pattern(" F ").pattern("F F").pattern(" B ").save(consumer);
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.WARDING_EFFIGY.get(), EntriesNF.WARDING_EFFIGY).define(Character.valueOf('F'), (ItemLike)ItemsNF.ROTTEN_FLESH.get()).define(Character.valueOf('B'), (ItemLike)ItemsNF.LIVING_BONE.get()).define(Character.valueOf('H'), (ItemLike)ItemsNF.DREG_HEART.get()).pattern("FFF").pattern("BHB").pattern("FBF").save(consumer);
        for (TieredItemMaterial material : ItemsNF.METAL_ARMAMENTS.keySet()) {
            Map<Armament, RegistryObject<MeleeWeaponItem>> armaments = ItemsNF.METAL_ARMAMENTS.get(material);
            for (Armament armament : armaments.keySet()) {
                RegistryObject<BuildingMaterialItem> registryObject;
                if (armament == Armament.CHISEL) {
                    RegistryObject<Item> registryObject2 = ItemsNF.ARMAMENT_HEADS.get(material).get(armament);
                    CraftingRecipeBuilder.base((ItemLike)armaments.get(armament).get(), KnowledgeNF.ITEMS.get(registryObject2)).define(Character.valueOf('H'), (ItemLike)registryObject2.get()).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).pattern("H").pattern("S").save(consumer);
                    continue;
                }
                Object object = registryObject = armament == Armament.HAMMER ? ItemsNF.INGOTS.get(material.getMetal()) : ItemsNF.ARMAMENT_HEADS.get(material).get(armament);
                if (material.getTier() < 3) {
                    CraftingRecipeBuilder.base((ItemLike)armaments.get(armament).get(), KnowledgeNF.ITEMS.get(registryObject)).define(Character.valueOf('H'), (ItemLike)registryObject.get()).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).define(Character.valueOf('X'), (ItemLike)ItemsNF.PLANT_FIBERS.get()).pattern("H").pattern("X").pattern("S").save(consumer);
                    continue;
                }
                CraftingRecipeBuilder.base((ItemLike)armaments.get(armament).get()).define(Character.valueOf('H'), (ItemLike)registryObject.get()).define(Character.valueOf('S'), (ItemLike)ItemsNF.STICK.get()).define(Character.valueOf('X'), (ItemLike)ItemsNF.LEATHER.get()).pattern("H").pattern("X").pattern("S").save(consumer);
            }
        }
        for (Metal metal : ItemsNF.CHAINMAIL.keySet()) {
            CraftingRecipeBuilder.base((ItemLike)ItemsNF.CHAINMAIL.get(metal).get(), EntriesNF.CHAINMAIL_ARMOR).define(Character.valueOf('W'), (ItemLike)ItemsNF.WIRES.get(metal).get()).pattern("WW").pattern("WW").save(consumer);
        }
        CraftingRecipeBuilder.base((ItemLike)ItemsNF.BRONZE_BUCKET.get(), EntriesNF.BUCKET).define(Character.valueOf('P'), (ItemLike)ItemsNF.PLATES.get(Metal.BRONZE).get()).define(Character.valueOf('W'), (ItemLike)ItemsNF.WIRES.get(Metal.BRONZE).get()).pattern("W").pattern("P").save(consumer);
        for (TieredArmorMaterial tieredArmorMaterial : TieredArmorMaterial.values()) {
            ITieredArmorMaterial baseMat;
            RegistryObject<Entry> entry;
            Metal metal = (Metal)Metal.fromString(tieredArmorMaterial.getName());
            ArmorType armorType = tieredArmorMaterial.getArmorType();
            if (metal == null || armorType == null) continue;
            IStyle style = tieredArmorMaterial.getStyle();
            if (style == Style.SURVIVOR) {
                Item armorMat = switch (armorType) {
                    default -> throw new IncompatibleClassChangeError();
                    case ArmorType.PLATE -> (Item)ItemsNF.PLATES.get(metal).get();
                    case ArmorType.SCALE -> (Item)ItemsNF.SCALES.get(metal).get();
                    case ArmorType.CHAINMAIL -> (Item)ItemsNF.CHAINMAIL.get(metal).get();
                };
                entry = switch (armorType) {
                    default -> throw new IncompatibleClassChangeError();
                    case ArmorType.PLATE -> EntriesNF.PLATE_ARMOR;
                    case ArmorType.SCALE -> EntriesNF.SCALE_ARMOR;
                    case ArmorType.CHAINMAIL -> EntriesNF.CHAINMAIL_ARMOR;
                };
                baseMat = armorType == ArmorType.SCALE ? TieredArmorMaterial.LEATHER : TieredArmorMaterial.PADDED;
                CraftingRecipeBuilder.base((ItemLike)ItemsNF.HELMETS.get(tieredArmorMaterial).get(), entry).define(Character.valueOf('A'), (ItemLike)armorMat).define(Character.valueOf('B'), (ItemLike)ItemsNF.HELMETS.get(baseMat).get()).pattern("ABA").save(consumer);
                CraftingRecipeBuilder.base((ItemLike)ItemsNF.CHESTPLATES.get(tieredArmorMaterial).get(), entry).define(Character.valueOf('A'), (ItemLike)armorMat).define(Character.valueOf('B'), (ItemLike)ItemsNF.CHESTPLATES.get(baseMat).get()).pattern(" A ").pattern("ABA").pattern(" A ").save(consumer);
                CraftingRecipeBuilder.base((ItemLike)ItemsNF.LEGGINGS.get(tieredArmorMaterial).get(), entry).define(Character.valueOf('A'), (ItemLike)armorMat).define(Character.valueOf('B'), (ItemLike)ItemsNF.LEGGINGS.get(baseMat).get()).pattern(" A ").pattern("ABA").save(consumer);
                CraftingRecipeBuilder.base((ItemLike)ItemsNF.BOOTS.get(tieredArmorMaterial).get(), entry).define(Character.valueOf('A'), (ItemLike)armorMat).define(Character.valueOf('B'), (ItemLike)ItemsNF.BOOTS.get(baseMat).get()).pattern("ABA").save(consumer);
                continue;
            }
            Ingredient styleMat = null;
            entry = null;
            if (style == Style.EXPLORER) {
                styleMat = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.RAWHIDE.get()});
                entry = switch (armorType) {
                    default -> throw new IncompatibleClassChangeError();
                    case ArmorType.PLATE -> EntriesNF.EXPLORER_PLATE;
                    case ArmorType.SCALE -> EntriesNF.EXPLORER_SCALE;
                    case ArmorType.CHAINMAIL -> EntriesNF.EXPLORER_CHAINMAIL;
                };
            } else if (style == Style.SLAYER) {
                styleMat = Ingredient.m_204132_(TagsNF.MONSTER_HIDE);
                entry = switch (armorType) {
                    default -> throw new IncompatibleClassChangeError();
                    case ArmorType.PLATE -> EntriesNF.SLAYER_PLATE;
                    case ArmorType.SCALE -> EntriesNF.SLAYER_SCALE;
                    case ArmorType.CHAINMAIL -> EntriesNF.SLAYER_CHAINMAIL;
                };
            }
            baseMat = TieredArmorMaterial.fromString(metal.getName() + "_" + armorType.name().toLowerCase() + "_survivor");
            CraftingRecipeBuilder.base((ItemLike)ItemsNF.HELMETS.get(tieredArmorMaterial).get(), entry).define(Character.valueOf('S'), styleMat).define(Character.valueOf('B'), (ItemLike)ItemsNF.HELMETS.get(baseMat).get()).pattern("S").pattern("B").save(consumer);
            CraftingRecipeBuilder.base((ItemLike)ItemsNF.CHESTPLATES.get(tieredArmorMaterial).get(), entry).define(Character.valueOf('S'), styleMat).define(Character.valueOf('B'), (ItemLike)ItemsNF.CHESTPLATES.get(baseMat).get()).pattern("S").pattern("B").save(consumer);
            CraftingRecipeBuilder.base((ItemLike)ItemsNF.LEGGINGS.get(tieredArmorMaterial).get(), entry).define(Character.valueOf('S'), styleMat).define(Character.valueOf('B'), (ItemLike)ItemsNF.LEGGINGS.get(baseMat).get()).pattern("S").pattern("B").save(consumer);
            CraftingRecipeBuilder.base((ItemLike)ItemsNF.BOOTS.get(tieredArmorMaterial).get(), entry).define(Character.valueOf('S'), styleMat).define(Character.valueOf('B'), (ItemLike)ItemsNF.BOOTS.get(baseMat).get()).pattern("S").pattern("B").save(consumer);
        }
        for (Metal metal : ItemsNF.METAL_SHIELDS.keySet()) {
            CraftingRecipeBuilder.base((ItemLike)ItemsNF.METAL_SHIELDS.get(metal).get(), EntriesNF.SHIELD).define(Character.valueOf('S'), TagsNF.WOODEN_SHIELD).define(Character.valueOf('W'), (ItemLike)ItemsNF.WIRES.get(metal).get()).pattern("WWW").pattern("WSW").pattern("WWW").save(consumer);
        }
        SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(Metal.COPPER).get(), 20).input((ItemLike)ItemsNF.COPPER_NUGGET.get()).cookTime(100).saveCrucible(consumer);
        SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(Metal.COPPER).get(), 100).input((ItemLike)ItemsNF.COPPER_CHUNK.get()).cookTime(400).saveCrucible(consumer);
        SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(Metal.TIN).get(), 20).input((ItemLike)ItemsNF.TIN_NUGGET.get()).cookTime(100).saveCrucible(consumer);
        SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(Metal.TIN).get(), 100).input((ItemLike)ItemsNF.TIN_CHUNK.get()).cookTime(400).saveCrucible(consumer);
        SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(Metal.COPPER).get(), 10).input((ItemLike)ItemsNF.AZURITE_NUGGET.get()).cookTime(100).saveCrucible(consumer);
        SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(Metal.COPPER).get(), 50).input((ItemLike)ItemsNF.AZURITE_CHUNK.get()).cookTime(400).saveCrucible(consumer);
        SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(Metal.IRON).get(), 10).input((ItemLike)ItemsNF.HEMATITE_NUGGET.get()).cookTime(100).saveCrucible(consumer);
        SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(Metal.IRON).get(), 50).input((ItemLike)ItemsNF.HEMATITE_CHUNK.get()).cookTime(400).saveCrucible(consumer);
        SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(Metal.METEORITE).get(), 20).input((ItemLike)ItemsNF.METEORITE_NUGGET.get()).cookTime(100).saveCrucible(consumer);
        SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(Metal.METEORITE).get(), 100).input((ItemLike)ItemsNF.METEORITE_CHUNK.get()).cookTime(400).saveCrucible(consumer);
        SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(Metal.STEEL).get(), 20).input((ItemLike)ItemsNF.STEEL_NUGGET.get()).cookTime(100).saveCrucible(consumer);
        for (Metal metal : ItemsNF.INGOTS.keySet()) {
            SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(metal).get(), 100).input((ItemLike)ItemsNF.INGOTS.get(metal).get()).cookTime(400).saveCrucible(consumer);
        }
        for (Metal metal : ItemsNF.BILLETS.keySet()) {
            SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(metal).get(), 200).input((ItemLike)ItemsNF.BILLETS.get(metal).get()).cookTime(1200).saveCrucible(consumer);
        }
        for (Metal metal : ItemsNF.PLATES.keySet()) {
            SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(metal).get(), 100).input((ItemLike)ItemsNF.PLATES.get(metal).get()).cookTime(400).saveCrucible(consumer);
        }
        for (Metal metal : ItemsNF.WIRES.keySet()) {
            SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(metal).get(), 10).input((ItemLike)ItemsNF.WIRES.get(metal).get()).cookTime(60).saveCrucible(consumer);
        }
        for (Metal metal : ItemsNF.CHAINMAIL.keySet()) {
            SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(metal).get(), 40).input((ItemLike)ItemsNF.CHAINMAIL.get(metal).get()).cookTime(120).saveCrucible(consumer);
        }
        for (Metal metal : ItemsNF.SCALES.keySet()) {
            SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(metal).get(), 40).input((ItemLike)ItemsNF.SCALES.get(metal).get()).cookTime(200).saveCrucible(consumer);
        }
        for (TieredItemMaterial material : ItemsNF.ARMAMENT_HEADS.keySet()) {
            Metal metal = (Metal)material.getMetal();
            Map<Armament, RegistryObject<Item>> map = ItemsNF.ARMAMENT_HEADS.get(material);
            for (RegistryObject registryObject : map.values()) {
                SingleRecipeBuilder.base((Fluid)FluidsNF.METAL.get(metal).get(), 100).input((ItemLike)registryObject.get()).cookTime(400).saveCrucible(consumer);
            }
        }
        SingleRecipeBuilder.base((ItemLike)ItemsNF.GLASS.get(), 1).input(TagsNF.SAND_ITEM).cookTime(60).requirement(RecipeProviderNF.entryKnowledge(EntriesNF.CASTING)).saveCrucible(consumer);
        SingleRecipeBuilder.base((ItemLike)ItemsNF.SALT.get(), 1).input((ItemLike)ItemsNF.SEAWATER.get()).cookTime(3000).requirement(RecipeProviderNF.entryKnowledge(EntriesNF.CASTING)).saveCrucible(consumer);
        BarrelRecipeBuilder.base((ItemLike)ItemsNF.RAWHIDE.get(), 1).input(TagsNF.ANIMAL_HIDE_SMALL).input((ItemLike)ItemsNF.LIME.get()).input((ItemLike)ItemsNF.WATER.get()).soakTime(24000).requirement(EntriesNF.TANNING.getId()).save(consumer);
        BarrelRecipeBuilder.base((ItemLike)ItemsNF.RAWHIDE.get(), 2).input(TagsNF.ANIMAL_HIDE_MEDIUM).input((ItemLike)ItemsNF.LIME.get()).input((ItemLike)ItemsNF.WATER.get()).soakTime(24000).requirement(EntriesNF.TANNING.getId()).save(consumer);
        BarrelRecipeBuilder.base((ItemLike)ItemsNF.RAWHIDE.get(), 4).input(TagsNF.ANIMAL_HIDE_LARGE).input((ItemLike)ItemsNF.LIME.get()).input((ItemLike)ItemsNF.WATER.get()).soakTime(24000).requirement(EntriesNF.TANNING.getId()).save(consumer);
        BarrelRecipeBuilder.base((ItemLike)ItemsNF.LEATHER.get(), 2).input(TagsNF.RAWHIDE_SMALL).input(TagsNF.TANNIN).input((ItemLike)ItemsNF.WATER.get()).soakTime(48000).requirement(EntriesNF.TANNING.getId()).save(consumer);
        BarrelRecipeBuilder.base((ItemLike)ItemsNF.LEATHER.get(), 4).input(TagsNF.RAWHIDE_MEDIUM).input(TagsNF.TANNIN).input((ItemLike)ItemsNF.WATER.get()).soakTime(48000).requirement(EntriesNF.TANNING.getId()).save(consumer);
        BarrelRecipeBuilder.base((ItemLike)ItemsNF.LEATHER.get(), 8).input(TagsNF.RAWHIDE_LARGE).input(TagsNF.TANNIN).input((ItemLike)ItemsNF.WATER.get()).soakTime(48000).requirement(EntriesNF.TANNING.getId()).save(consumer);
        BarrelRecipeBuilder.base((ItemLike)ItemsNF.CURED_GAME.get(), 1).input((ItemLike)ItemsNF.SALT.get()).input((ItemLike)ItemsNF.RAW_GAME.get()).input((ItemLike)ItemsNF.SALT.get()).soakTime(48000).fixedSoakTime().requirement(EntriesNF.CURING.getId()).save(consumer);
        BarrelRecipeBuilder.base((ItemLike)ItemsNF.CURED_VENISON.get(), 1).input((ItemLike)ItemsNF.SALT.get()).input((ItemLike)ItemsNF.RAW_VENISON.get()).input((ItemLike)ItemsNF.SALT.get()).soakTime(96000).fixedSoakTime().requirement(EntriesNF.CURING.getId()).save(consumer);
        BarrelRecipeBuilder.base((ItemLike)ItemsNF.CURED_POULTRY.get(), 1).input((ItemLike)ItemsNF.SALT.get()).input((ItemLike)ItemsNF.RAW_POULTRY.get()).input((ItemLike)ItemsNF.SALT.get()).soakTime(48000).fixedSoakTime().requirement(EntriesNF.CURING.getId()).save(consumer);
        BarrelRecipeBuilder.base((ItemLike)ItemsNF.CURED_JELLYFISH.get(), 1).input((ItemLike)ItemsNF.SALT.get()).input((ItemLike)ItemsNF.RAW_JELLYFISH.get()).input((ItemLike)ItemsNF.SALT.get()).soakTime(24000).fixedSoakTime().requirement(EntriesNF.CURING.getId()).save(consumer);
        BarrelRecipeBuilder.base((ItemLike)ItemsNF.CURED_PALE_FLESH.get(), 1).input((ItemLike)ItemsNF.SALT.get()).input((ItemLike)ItemsNF.RAW_PALE_FLESH.get()).input((ItemLike)ItemsNF.SALT.get()).soakTime(48000).fixedSoakTime().requirement(EntriesNF.CURING.getId()).save(consumer);
        for (TieredItemMaterial material : ItemsNF.ARMAMENT_HEADS.keySet()) {
            Metal metal = (Metal)material.getMetal();
            Ingredient ingredient = switch (metal) {
                case Metal.COPPER -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.COPPER_CHUNK.get()});
                case Metal.METEORITE -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.METEORITE_CHUNK.get()});
                default -> null;
            };
            Ingredient ingot = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.INGOTS.get(metal).get()});
            ObjectArrayList objectArrayList = new ObjectArrayList();
            objectArrayList.add(new AnvilEntry(ingot, MicroGridShape.INGOT, 0, 1024));
            if (ingredient != null) {
                objectArrayList.add(new AnvilEntry(ingredient, MicroGridShape.CHUNK, 4, 10));
            }
            for (AnvilEntry entry : objectArrayList) {
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ARMAMENT_HEADS.get(material).get(Armament.ADZE).get(), material.getTier()).addIngredient(entry.item).randRange(entry.randMin, entry.randMax).addStartShape(entry.shape).addFinishShape(MicroGridShape.ADZE).requirement(EntriesNF.SMITHING).save(consumer);
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ARMAMENT_HEADS.get(material).get(Armament.AXE).get(), material.getTier()).addIngredient(entry.item).randRange(entry.randMin, entry.randMax).addStartShape(entry.shape).addFinishShape(MicroGridShape.AXE).requirement(EntriesNF.SMITHING).save(consumer);
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ARMAMENT_HEADS.get(material).get(Armament.CHISEL).get(), material.getTier()).addIngredient(entry.item).randRange(entry.randMin, entry.randMax).addStartShape(entry.shape).addFinishShape(MicroGridShape.CHISEL).requirement(EntriesNF.SMITHING).save(consumer);
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ARMAMENT_HEADS.get(material).get(Armament.DAGGER).get(), material.getTier()).addIngredient(entry.item).randRange(entry.randMin, entry.randMax).addStartShape(entry.shape).addFinishShape(MicroGridShape.DAGGER).requirement(EntriesNF.SMITHING).save(consumer);
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ARMAMENT_HEADS.get(material).get(Armament.MACE).get(), material.getTier()).addIngredient(entry.item).randRange(entry.randMin, entry.randMax).addStartShape(entry.shape).addFinishShape(MicroGridShape.MACE).requirement(EntriesNF.MACE).save(consumer);
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ARMAMENT_HEADS.get(material).get(Armament.PICKAXE).get(), material.getTier()).addIngredient(entry.item).randRange(entry.randMin, entry.randMax).addStartShape(entry.shape).addFinishShape(MicroGridShape.PICKAXE).requirement(EntriesNF.SMITHING).save(consumer);
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ARMAMENT_HEADS.get(material).get(Armament.SABRE).get(), material.getTier()).addIngredient(entry.item).randRange(entry.randMin, entry.randMax).addStartShape(entry.shape).addFinishShape(MicroGridShape.SABRE).requirement(EntriesNF.SABRE).save(consumer);
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ARMAMENT_HEADS.get(material).get(Armament.SHOVEL).get(), material.getTier()).addIngredient(entry.item).randRange(entry.randMin, entry.randMax).addStartShape(entry.shape).addFinishShape(MicroGridShape.SHOVEL).requirement(EntriesNF.SMITHING).save(consumer);
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ARMAMENT_HEADS.get(material).get(Armament.SICKLE).get(), material.getTier()).addIngredient(entry.item).randRange(entry.randMin, entry.randMax).addStartShape(entry.shape).addFinishShape(MicroGridShape.SICKLE).requirement(EntriesNF.SICKLE_SMITHING).save(consumer);
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ARMAMENT_HEADS.get(material).get(Armament.SPEAR).get(), material.getTier()).addIngredient(entry.item).randRange(entry.randMin, entry.randMax).addStartShape(entry.shape).addFinishShape(MicroGridShape.SPEAR).requirement(EntriesNF.SMITHING).save(consumer);
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ARMAMENT_HEADS.get(material).get(Armament.SWORD).get(), material.getTier()).addIngredient(entry.item).randRange(entry.randMin, entry.randMax).addStartShape(entry.shape).addFinishShape(MicroGridShape.SWORD).requirement(EntriesNF.SMITHING).save(consumer);
            }
        }
        for (Metal metal : Metal.values()) {
            Ingredient chunk;
            switch (metal) {
                case TIN: {
                    Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.TIN_CHUNK.get()});
                    break;
                }
                case COPPER: {
                    Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.COPPER_CHUNK.get()});
                    break;
                }
                case METEORITE: {
                    Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.METEORITE_CHUNK.get()});
                    break;
                }
                default: {
                    Ingredient ingredient = chunk = null;
                }
            }
            if (chunk != null) {
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.INGOTS.get(metal).get(), metal.getWorkTier()).addIngredient(chunk).randRange(4, 10).addStartShape(MicroGridShape.CHUNK).addFinishShape(MicroGridShape.INGOT).requirement(EntriesNF.SMITHING).save(consumer);
            }
            Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.INGOTS.get(metal).get()});
            Ingredient plate = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.PLATES.get(metal).get()});
            Ingredient wire = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.WIRES.get(metal).get()});
            Ingredient billet = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsNF.BILLETS.get(metal).get()});
            TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.PLATES.get(metal).get(), metal.getWorkTier()).addIngredient(ingredient).addStartShape(MicroGridShape.INGOT).addFinishShape(MicroGridShape.PLATE).requirement(EntriesNF.SMITHING).save(consumer);
            TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.WIRES.get(metal).get(), 8, metal.getWorkTier()).addIngredient(plate).addStartShape(MicroGridShape.PLATE).addFinishShape(MicroGridShape.WIRES).requirement(EntriesNF.SMITHING).save(consumer);
            TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.BILLETS.get(metal).get(), metal.getWorkTier()).addIngredient(ingredient).addIngredient(TagsNF.FLUX).addIngredient(ingredient).addStartShape(MicroGridShape.DOUBLE_INGOT_TALL).addFinishShape(MicroGridShape.BILLET).requirement(EntriesNF.SMITHING).save(consumer);
            TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.METAL_BLOCKS.get(metal).get(), metal.getWorkTier()).addIngredient(billet).addIngredient(TagsNF.FLUX).addIngredient(billet).addStartShape(MicroGridShape.DOUBLE_BILLET_TALL).addFinishShape(MicroGridShape.BLOCK).requirement(EntriesNF.SMITHING).save(consumer);
            if (ItemsNF.ANVILS_METAL.containsKey(metal)) {
                TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.ANVILS_METAL.get(metal).get(), metal.getWorkTier()).addIngredient(billet).addIngredient(TagsNF.FLUX).addIngredient(billet).addStartShape(MicroGridShape.DOUBLE_BILLET_TALL).addFinishShape(MicroGridShape.ANVIL).requirement(EntriesNF.SMITHING).save(consumer);
            }
            if (!ItemsNF.SCALES.containsKey(metal)) continue;
            TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.SCALES.get(metal).get(), 2, metal.getWorkTier()).addIngredient(plate).addStartShape(MicroGridShape.PLATE).addFinishShape(MicroGridShape.SCALES).requirement(EntriesNF.SCALE_ARMOR).save(consumer);
        }
        TieredAnvilRecipeBuilder.base((ItemLike)ItemsNF.INGOTS.get(Metal.IRON).get(), Metal.IRON.getWorkTier()).addIngredient((ItemLike)ItemsNF.IRON_BLOOM.get()).slagChance(0.7f).randRange(4, 10).addStartShape(MicroGridShape.CHUNK).addFinishShape(MicroGridShape.INGOT).requirement(RecipeProviderNF.itemKnowledge(ItemsNF.IRON_BLOOM)).save(consumer);
    }

    private static ResourceLocation itemKnowledge(RegistryObject<? extends Item> item) {
        return KnowledgeNF.ITEMS.get(item).getId();
    }

    private static ResourceLocation entryKnowledge(RegistryObject<Entry> entry) {
        return KnowledgeNF.get(entry).getId();
    }

    private record AnvilEntry(Ingredient item, MicroGridShape shape, int randMin, int randMax) {
    }
}

