/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public abstract class TextureProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final String temp;
    protected final DataGenerator generator;
    protected final Map<ResourceLocation, BufferedImage> images = new LinkedHashMap<ResourceLocation, BufferedImage>();
    protected final Map<ResourceLocation, Path> mcmetaPaths = new LinkedHashMap<ResourceLocation, Path>();
    protected final String modId;
    protected final String inputPath;
    protected final String externalPath;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;

    protected TextureProvider(DataGenerator pGenerator, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this.generator = pGenerator;
        this.modId = modId;
        String outputString = this.generator.m_123916_().toString();
        this.inputPath = outputString.substring(0, outputString.lastIndexOf("\\generated\\")) + "\\main\\resources\\assets\\";
        this.externalPath = outputString.substring(0, outputString.lastIndexOf("\\src\\")) + "\\textures\\";
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures");
        this.temp = "_" + modId + "_texture_provider_temporary";
    }

    protected abstract void addTextures();

    protected void add(ResourceLocation loc, ResourceLocation baseImageLoc, BufferedImage image) {
        if (this.images.put(loc, image) != null) {
            throw new IllegalStateException("Duplicate image location " + loc);
        }
        Path metaPath = this.findMetaPath(baseImageLoc);
        if (Files.exists(metaPath, new LinkOption[0])) {
            this.mcmetaPaths.put(loc, metaPath);
        }
    }

    protected Path getExternalImagePath(ResourceLocation loc) {
        return this.generator.m_123916_().getFileSystem().getPath(this.externalPath + loc.m_135815_() + ".png", new String[0]);
    }

    protected Path getExistingImagePath(ResourceLocation loc) {
        return this.generator.m_123916_().getFileSystem().getPath(this.inputPath + loc.m_135827_() + "\\textures\\" + loc.m_135815_() + ".png", new String[0]);
    }

    private Path getPath(ResourceLocation loc) {
        return this.generator.m_123916_().resolve("assets/" + loc.m_135827_() + "/textures/" + loc.m_135815_() + ".png");
    }

    private Path getExternalImageMetaPath(ResourceLocation loc) {
        return this.generator.m_123916_().getFileSystem().getPath(this.externalPath + loc.m_135815_() + ".png.mcmeta", new String[0]);
    }

    private Path getExistingImageMetaPath(ResourceLocation loc) {
        return this.generator.m_123916_().getFileSystem().getPath(this.inputPath + loc.m_135827_() + "\\textures\\" + loc.m_135815_() + ".png.mcmeta", new String[0]);
    }

    private Path findMetaPath(ResourceLocation loc) {
        if (this.mcmetaPaths.containsKey(loc)) {
            return this.mcmetaPaths.get(loc);
        }
        Path path = this.getExternalImageMetaPath(loc);
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        return this.getExistingImageMetaPath(loc);
    }

    protected BufferedImage getImage(ResourceLocation loc) {
        BufferedImage image;
        if (this.images.containsKey(loc)) {
            return this.deepCopyImage(loc);
        }
        String externalPath = this.getExternalImagePath(loc).toString();
        try {
            image = ImageIO.read(new File(externalPath));
        }
        catch (IOException ioException) {
            String inputPath = this.getExistingImagePath(loc).toString();
            try {
                image = ImageIO.read(new File(inputPath));
            }
            catch (IOException ioException2) {
                throw new IllegalStateException("Couldn't read image at path " + inputPath, ioException2);
            }
        }
        return image;
    }

    private BufferedImage deepCopyImage(ResourceLocation loc) {
        BufferedImage copy = new BufferedImage(this.images.get(loc).getWidth(), this.images.get(loc).getHeight(), this.images.get(loc).getType());
        Graphics2D graphics = copy.createGraphics();
        graphics.drawImage((Image)this.images.get(loc), 0, 0, null);
        graphics.dispose();
        return copy;
    }

    protected void blankImage(ResourceLocation loc, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        if (this.images.put(loc, image) != null) {
            throw new IllegalStateException("Duplicate image location " + loc);
        }
    }

    protected void blankImage(ResourceLocation loc) {
        this.blankImage(loc, 16, 16);
    }

    protected void colorizeImageRGB(ResourceLocation loc, ResourceLocation baseImageLoc, Color color) {
        BufferedImage image = this.getImage(baseImageLoc);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int rgb = image.getRGB(x, y);
                int alpha = (rgb & 0xFF000000) >>> 24;
                if (alpha == 0) continue;
                float fAlpha = (float)alpha / 255.0f;
                float red = (float)((rgb & 0xFF0000) >> 16) / 255.0f * ((float)color.getRed() / 255.0f);
                float green = (float)((rgb & 0xFF00) >> 8) / 255.0f * ((float)color.getGreen() / 255.0f);
                float blue = (float)(rgb & 0xFF) / 255.0f * ((float)color.getBlue() / 255.0f);
                image.setRGB(x, y, new Color(red, green, blue, fAlpha).getRGB());
            }
        }
        this.add(loc, baseImageLoc, image);
    }

    protected void rotateImage(ResourceLocation loc, ResourceLocation baseImageLoc, int degrees) {
        BufferedImage baseImage = this.getImage(baseImageLoc);
        BufferedImage image = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), baseImage.getType());
        Graphics2D graphics = image.createGraphics();
        graphics.rotate(Math.toRadians(degrees), image.getWidth() / 2, image.getHeight() / 2);
        graphics.drawImage(baseImage, null, 0, 0);
        graphics.dispose();
        this.add(loc, baseImageLoc, image);
    }

    @SafeVarargs
    protected final void replaceImagePalette(ResourceLocation loc, ResourceLocation baseImageLoc, List<Integer> ... palettes) {
        BufferedImage image = this.getImage(baseImageLoc);
        ArrayList<Integer> newColors = new ArrayList<Integer>();
        for (List<Integer> palette : palettes) {
            if (palette == null) continue;
            newColors.addAll(palette);
        }
        ArrayList<Integer> grayColors = new ArrayList<Integer>();
        ArrayList<PixelData> grayPixels = new ArrayList<PixelData>();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int rgb = image.getRGB(x, y);
                int alpha = (rgb & 0xFF000000) >>> 24;
                if (alpha == 0) continue;
                int red = (rgb & 0xFF0000) >> 16;
                int green = (rgb & 0xFF00) >> 8;
                int blue = rgb & 0xFF;
                if (red != green || green != blue) continue;
                if (!grayColors.contains(blue)) {
                    grayColors.add(blue);
                }
                grayPixels.add(new PixelData(x, y, blue, alpha));
            }
        }
        if (grayColors.size() != newColors.size()) {
            throw new IllegalStateException("Palette size " + newColors.size() + " of " + loc + " does not match " + grayColors.size() + " unique gray colors in " + baseImageLoc);
        }
        grayColors.sort(Integer::compareTo);
        LinkedHashMap<Integer, Integer> paletteMap = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < newColors.size(); ++i) {
            paletteMap.put((Integer)grayColors.get(i), (Integer)newColors.get(i) << 8 >>> 8);
        }
        for (PixelData pixel : grayPixels) {
            image.setRGB(pixel.x, pixel.y, pixel.alpha << 24 | (Integer)((HashMap)paletteMap).get(pixel.color));
        }
        this.add(loc, baseImageLoc, image);
    }

    protected void layerImages(ResourceLocation loc, ResourceLocation baseImageLoc, ResourceLocation layerImageLoc) {
        BufferedImage baseImage = this.getImage(baseImageLoc);
        BufferedImage layerImage = this.getImage(layerImageLoc);
        if (layerImage.getWidth() % baseImage.getWidth() != 0 || layerImage.getHeight() % baseImage.getHeight() != 0) {
            throw new IllegalStateException("Base image " + baseImageLoc + " and layer image " + layerImageLoc + " do not have compatible dimensions");
        }
        for (int x = 0; x < layerImage.getWidth(); ++x) {
            for (int y = 0; y < layerImage.getHeight(); ++y) {
                int rgbLayer = layerImage.getRGB(x, y);
                float alphaL = (float)((rgbLayer & 0xFF000000) >>> 24) / 255.0f;
                float redL = (float)((rgbLayer & 0xFF0000) >> 16) / 255.0f;
                float greenL = (float)((rgbLayer & 0xFF00) >> 8) / 255.0f;
                float blueL = (float)(rgbLayer & 0xFF) / 255.0f;
                int rgbBase = baseImage.getRGB(x % baseImage.getWidth(), y % baseImage.getHeight());
                float alphaB = (float)((rgbBase & 0xFF000000) >>> 24) / 255.0f;
                if (alphaB == 0.0f && alphaL == 0.0f) continue;
                float redB = (float)((rgbBase & 0xFF0000) >> 16) / 255.0f;
                float greenB = (float)((rgbBase & 0xFF00) >> 8) / 255.0f;
                float blueB = (float)(rgbBase & 0xFF) / 255.0f;
                float alpha = 1.0f - (1.0f - alphaL) * (1.0f - alphaB);
                float red = redL * alphaL / alpha + redB * alphaB * (1.0f - alphaL) / alpha;
                float green = greenL * alphaL / alpha + greenB * alphaB * (1.0f - alphaL) / alpha;
                float blue = blueL * alphaL / alpha + blueB * alphaB * (1.0f - alphaL) / alpha;
                layerImage.setRGB(x, y, new Color(red, green, blue, alpha).getRGB());
            }
        }
        this.add(loc, layerImageLoc, layerImage);
    }

    protected void splitImageBySaturation(float minSaturation, float maxSaturation, ResourceLocation incImageLoc, ResourceLocation excImageLoc, ResourceLocation baseImageLoc) {
        if (minSaturation < 0.0f || minSaturation > 1.0f || maxSaturation < 0.0f || maxSaturation > 1.0f) {
            throw new IllegalArgumentException("Saturation threshold values must be between 0 and 1, but min was " + minSaturation + " and max was " + maxSaturation);
        }
        BufferedImage baseImage = this.getImage(baseImageLoc);
        BufferedImage grayImage = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 2);
        BufferedImage colorImage = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 2);
        ArrayList<PixelData> grayPixels = new ArrayList<PixelData>();
        ArrayList<PixelData> colorPixels = new ArrayList<PixelData>();
        for (int x = 0; x < baseImage.getWidth(); ++x) {
            for (int y = 0; y < baseImage.getHeight(); ++y) {
                int rgb = baseImage.getRGB(x, y);
                int alpha = (rgb & 0xFF000000) >>> 24;
                if (alpha == 0) continue;
                int red = (rgb & 0xFF0000) >> 16;
                int green = (rgb & 0xFF00) >> 8;
                int blue = rgb & 0xFF;
                float[] hsb = new float[3];
                Color.RGBtoHSB(red, green, blue, hsb);
                if (minSaturation <= maxSaturation) {
                    if (hsb[1] >= minSaturation && hsb[1] <= maxSaturation) {
                        grayPixels.add(new PixelData(x, y, rgb, alpha));
                        continue;
                    }
                    colorPixels.add(new PixelData(x, y, rgb, alpha));
                    continue;
                }
                if (hsb[1] >= minSaturation || hsb[1] <= maxSaturation) {
                    grayPixels.add(new PixelData(x, y, rgb, alpha));
                    continue;
                }
                colorPixels.add(new PixelData(x, y, rgb, alpha));
            }
        }
        for (PixelData pixel : grayPixels) {
            grayImage.setRGB(pixel.x, pixel.y, pixel.color);
        }
        for (PixelData pixel : colorPixels) {
            colorImage.setRGB(pixel.x, pixel.y, pixel.color);
        }
        this.add(incImageLoc, baseImageLoc, grayImage);
        this.add(excImageLoc, baseImageLoc, colorImage);
    }

    public void m_6865_(HashCache pCache) {
        this.images.clear();
        this.addTextures();
        this.images.forEach((loc, image) -> {
            if (loc.m_135815_().contains(this.temp)) {
                return;
            }
            if (this.existingFileHelper != null && this.existingFileHelper.exists(loc, this.resourceType)) {
                throw new IllegalArgumentException("Couldn't create image since texture already exists at location " + loc.toString());
            }
            Path path = this.getPath((ResourceLocation)loc);
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "png", bytes);
                String hash = f_123918_.hashBytes(bytes.toByteArray()).toString();
                if (!Files.exists(path, new LinkOption[0]) || !Objects.equals(pCache.m_123938_(path), hash)) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try {
                        ImageIO.write((RenderedImage)image, "png", path.toFile());
                    }
                    catch (IOException ioException) {
                        LOGGER.error("Failed to write image to {}", (Object)path, (Object)ioException);
                    }
                }
                pCache.m_123940_(path, hash);
            }
            catch (IOException ioException) {
                LOGGER.error("Couldn't save textures to {}", (Object)path, (Object)ioException);
            }
            if (this.mcmetaPaths.containsKey(loc)) {
                try {
                    Path metaTarget = Path.of(path + ".mcmeta", new String[0]);
                    Path metaSource = this.mcmetaPaths.get(loc);
                    String hash = f_123918_.hashBytes(Files.readAllBytes(metaSource)).toString();
                    if (!Files.exists(metaTarget, new LinkOption[0]) || !Objects.equals(pCache.m_123938_(metaTarget), hash)) {
                        Files.copy(metaSource, metaTarget, StandardCopyOption.REPLACE_EXISTING);
                    }
                    pCache.m_123940_(metaTarget, hash);
                }
                catch (IOException ioException) {
                    LOGGER.error("Couldn't copy mcmeta file to {}", (Object)Path.of(path + ".mcmeta", new String[0]), (Object)ioException);
                }
            }
            if (this.existingFileHelper != null) {
                this.existingFileHelper.trackGenerated(loc, this.resourceType);
            }
        });
    }

    public String m_6055_() {
        return "Textures";
    }

    protected ResourceLocation block(RegistryObject<?> block) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("block/" + block.getId().m_135815_()));
    }

    protected ResourceLocation block(RegistryObject<?> block, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("block/" + block.getId().m_135815_() + suffix));
    }

    protected ResourceLocation block(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("block/" + name));
    }

    protected ResourceLocation tempBlock(RegistryObject<?> block) {
        return this.block(block, this.temp);
    }

    protected ResourceLocation tempBlock(RegistryObject<?> block, String suffix) {
        return this.block(block, this.temp + suffix);
    }

    protected ResourceLocation tempBlock(String name) {
        return this.block(name + this.temp);
    }

    protected ResourceLocation item(RegistryObject<?> item) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("item/" + item.getId().m_135815_()));
    }

    protected ResourceLocation item(RegistryObject<?> item, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("item/" + item.getId().m_135815_() + suffix));
    }

    protected ResourceLocation item(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("item/" + name));
    }

    protected ResourceLocation tempItem(RegistryObject<?> item) {
        return this.item(item, this.temp);
    }

    protected ResourceLocation tempItem(RegistryObject<?> item, String suffix) {
        return this.item(item, this.temp + suffix);
    }

    protected ResourceLocation tempItem(String name) {
        return this.item(name + this.temp);
    }

    protected ResourceLocation entity(RegistryObject<?> entity, String folder) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("entity/" + folder + "/" + entity.getId().m_135815_()));
    }

    protected ResourceLocation entity(RegistryObject<?> entity, String folder, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("entity/" + folder + "/" + entity.getId().m_135815_() + suffix));
    }

    protected ResourceLocation entity(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("entity/" + name));
    }

    protected ResourceLocation tempEntity(RegistryObject<?> entity, String folder) {
        return this.entity(entity, folder, this.temp);
    }

    protected ResourceLocation tempEntity(RegistryObject<?> entity, String folder, String suffix) {
        return this.entity(entity, folder, this.temp + suffix);
    }

    protected ResourceLocation tempEntity(String name) {
        return this.entity(name + this.temp);
    }

    protected ResourceLocation blank(RegistryObject<?> object) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)object.getId().m_135815_());
    }

    protected ResourceLocation blank(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name);
    }

    protected record PixelData(int x, int y, int color, int alpha) {
    }
}

