/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data;

import frostnox.nightfall.block.IMetal;
import frostnox.nightfall.block.Metal;
import frostnox.nightfall.block.Soil;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.StoneType;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.data.TextureProvider;
import frostnox.nightfall.item.Armament;
import frostnox.nightfall.item.ArmorType;
import frostnox.nightfall.item.ITieredArmorMaterial;
import frostnox.nightfall.item.Style;
import frostnox.nightfall.item.TieredArmorMaterial;
import frostnox.nightfall.item.TieredItemMaterial;
import frostnox.nightfall.item.item.ProjectileItem;
import frostnox.nightfall.item.item.ShieldItemNF;
import frostnox.nightfall.item.item.TieredArmorItem;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class TextureProviderNF
extends TextureProvider {
    private int y = 0;
    private final EnumMap<TieredHeat, List<Integer>> HEAT_PALETTES = new EnumMap(TieredHeat.class);
    private final List<Integer> WATER;
    private final List<Integer> SEAWATER;
    private final List<Integer> LAVA;
    private final List<Integer> STICK;
    private final List<Integer> STICK5;
    private final List<Integer> STICK3;
    private final List<Integer> STICK2;
    private final List<Integer> TREATED_STICK;
    private final List<Integer> TREATED_STICK_REDUCED;
    private final List<Integer> FIBER;
    private final List<Integer> TWINE;
    private final List<Integer> TWINE_LIGHT2;
    private final List<Integer> TWINE3;
    private final List<Integer> TWINE2;
    private final List<Integer> LEATHER;
    private final List<Integer> LEATHER3;
    private final List<Integer> LEATHER2;
    private final List<Integer> FLINT;
    private final List<Integer> FLINT4;
    private final List<Integer> FLINT5;
    private final List<Integer> SNOW;
    private final List<Integer> SNOW_LIGHT;
    private final List<Integer> CLAY;
    private final List<Integer> TERRACOTTA;
    private final List<Integer> METAL_GENERIC_LIGHT;
    private final List<Integer> METAL_GENERIC_DARK;
    private final Map<Metal, List<Integer>> METAL_PALETTES = new HashMap<Metal, List<Integer>>();
    private final Map<Metal, List<Integer>> METAL_REDUCED_PALETTES = new HashMap<Metal, List<Integer>>();
    private final Map<Metal, List<Integer>> METAL_DULL_PALETTES = new HashMap<Metal, List<Integer>>();
    private final Map<Metal, List<Integer>> METAL5_PALETTES = new HashMap<Metal, List<Integer>>();
    private final Map<Metal, List<Integer>> METAL6_PALETTES = new HashMap<Metal, List<Integer>>();
    private final Map<Metal, List<Integer>> METAL_NUGGET_PALETTES = new HashMap<Metal, List<Integer>>();
    private final Map<Metal, List<Integer>> METAL_SCALE_PALETTES = new HashMap<Metal, List<Integer>>();
    private final Map<Metal, List<Integer>> METAL_PLATE_PALETTES = new HashMap<Metal, List<Integer>>();
    private final Map<Metal, List<Integer>> METAL_CHAINMAIL_PALETTES = new HashMap<Metal, List<Integer>>();
    private final Map<Metal, List<Integer>> LANTERN_PALETTES = new HashMap<Metal, List<Integer>>();
    private final Map<Stone, List<Integer>> STONE_PALETTES = new HashMap<Stone, List<Integer>>();
    private final Map<Stone, List<Integer>> RAW_STONE_PALETTES = new HashMap<Stone, List<Integer>>();
    private final Map<Stone, List<Integer>> STONE7_PALETTES = new HashMap<Stone, List<Integer>>();
    private final Map<Stone, List<Integer>> DARK_STONE_PALETTES = new HashMap<Stone, List<Integer>>();
    private final Map<Stone, List<Integer>> STONE_BRICK_ITEM_PALETTES = new HashMap<Stone, List<Integer>>();
    private final Map<Tree, List<Integer>> WOOD_FULL_PALETTES = new HashMap<Tree, List<Integer>>();
    private final Map<Tree, List<Integer>> WOOD_PALETTES = new HashMap<Tree, List<Integer>>();
    private final Map<Tree, List<Integer>> BOW_PALETTES = new HashMap<Tree, List<Integer>>();
    private final Map<Tree, List<Integer>> STRIPPED_WOOD_PALETTES = new HashMap<Tree, List<Integer>>();
    private final Map<Tree, List<Integer>> STRIPPED_WOOD_ITEM_PALETTES = new HashMap<Tree, List<Integer>>();
    private final Map<Tree, List<Integer>> WOOD_REDUCED_PALETTES = new HashMap<Tree, List<Integer>>();
    private final Map<Tree, List<Integer>> BARREL_OPEN_PALETTES = new HashMap<Tree, List<Integer>>();

    public TextureProviderNF(DataGenerator pGenerator, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(pGenerator, modId, existingFileHelper);
        BufferedImage image;
        String palettePath = this.getExternalImagePath(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"palette")).toString();
        try {
            image = ImageIO.read(new File(palettePath));
        }
        catch (IOException ioException) {
            throw new IllegalStateException("No palette image at path " + palettePath);
        }
        for (TieredHeat tieredHeat : TieredHeat.values()) {
            if (tieredHeat == TieredHeat.NONE) continue;
            this.HEAT_PALETTES.put(tieredHeat, this.fill(image));
        }
        this.WATER = this.fill(image);
        this.SEAWATER = this.fill(image);
        this.LAVA = this.fill(image);
        this.STICK = this.fill(image);
        this.STICK5 = TextureProviderNF.subset(this.STICK, 5, 1);
        this.STICK3 = TextureProviderNF.subset(this.STICK, 3, 0);
        this.STICK2 = TextureProviderNF.subset(this.STICK, 2, 0);
        this.TREATED_STICK = this.fill(image);
        this.TREATED_STICK_REDUCED = TextureProviderNF.subset(this.TREATED_STICK, 2, 0);
        this.FIBER = this.fill(image);
        this.TWINE = this.fill(image);
        this.TWINE_LIGHT2 = TextureProviderNF.subset(this.TWINE, 2, 2);
        this.TWINE3 = TextureProviderNF.subset(this.TWINE, 3, 0);
        this.TWINE2 = TextureProviderNF.subset(this.TWINE, 2, 0);
        this.LEATHER = this.fill(image);
        this.LEATHER3 = TextureProviderNF.subset(this.LEATHER, 3, 0);
        this.LEATHER2 = TextureProviderNF.subset(this.LEATHER, 2, 0);
        this.FLINT = this.fill(image);
        this.FLINT5 = TextureProviderNF.subset(this.FLINT, 5, 1);
        this.FLINT4 = TextureProviderNF.subset(this.FLINT, 4, 2);
        this.SNOW = this.fill(image);
        this.SNOW_LIGHT = TextureProviderNF.subset(this.SNOW, 3, 3);
        this.CLAY = this.fill(image);
        this.TERRACOTTA = this.fill(image);
        this.METAL_GENERIC_LIGHT = this.fill(image);
        this.METAL_GENERIC_DARK = this.fill(image);
        for (Enum enum_ : Metal.values()) {
            this.METAL_PALETTES.put((Metal)enum_, this.fill(image));
            List<Integer> metal = this.METAL_PALETTES.get(enum_);
            this.METAL_REDUCED_PALETTES.put((Metal)enum_, TextureProviderNF.subset(this.METAL_PALETTES.get(enum_), 6, 2));
            this.METAL_DULL_PALETTES.put((Metal)enum_, TextureProviderNF.subset(this.METAL_PALETTES.get(enum_), 5, 2));
            this.METAL5_PALETTES.put((Metal)enum_, TextureProviderNF.subset(this.METAL_PALETTES.get(enum_), 5, 0));
            this.METAL6_PALETTES.put((Metal)enum_, TextureProviderNF.subset(this.METAL_PALETTES.get(enum_), 6, 0));
            this.METAL_NUGGET_PALETTES.put((Metal)enum_, List.of(metal.get(0), metal.get(1), metal.get(2), metal.get(4), metal.get(5), metal.get(7)));
            this.METAL_SCALE_PALETTES.put((Metal)enum_, List.of(metal.get(0), metal.get(1), metal.get(3), metal.get(4), metal.get(5), metal.get(6)));
            this.METAL_PLATE_PALETTES.put((Metal)enum_, List.of(metal.get(0), metal.get(1), metal.get(3), metal.get(4), metal.get(5), metal.get(6), metal.get(7)));
            this.METAL_CHAINMAIL_PALETTES.put((Metal)enum_, List.of(metal.get(0), metal.get(1), metal.get(3), metal.get(4), metal.get(5), metal.get(6), metal.get(7)));
            this.LANTERN_PALETTES.put((Metal)enum_, List.of(metal.get(0), metal.get(1), metal.get(2), metal.get(3), metal.get(5)));
        }
        for (Enum enum_ : Stone.values()) {
            this.STONE_PALETTES.put((Stone)enum_, this.fill(image));
            List<Integer> stone = this.STONE_PALETTES.get(enum_);
            this.DARK_STONE_PALETTES.put((Stone)enum_, TextureProviderNF.subset(this.STONE_PALETTES.get(enum_), 3, 2));
            if (enum_ == Stone.SHALE || enum_ == Stone.LIMESTONE || enum_ == Stone.MARBLE || enum_ == Stone.BASALT || enum_ == Stone.NIXWACKE || enum_ == Stone.STYGFEL || enum_ == Stone.PUMICE) {
                this.RAW_STONE_PALETTES.put((Stone)enum_, TextureProviderNF.subset(this.STONE_PALETTES.get(enum_), 4, 4));
            } else {
                this.RAW_STONE_PALETTES.put((Stone)enum_, TextureProviderNF.subset(this.STONE_PALETTES.get(enum_), 5, 3));
            }
            this.STONE7_PALETTES.put((Stone)enum_, TextureProviderNF.combine(List.of(stone.get(0), stone.get(1)), TextureProviderNF.subset(this.STONE_PALETTES.get(enum_), 5, 3)));
            this.STONE_BRICK_ITEM_PALETTES.put((Stone)enum_, List.of(stone.get(0), stone.get(1), stone.get(3), stone.get(4), stone.get(5), stone.get(7)));
        }
        for (Enum enum_ : Tree.values()) {
            this.WOOD_FULL_PALETTES.put((Tree)enum_, this.fill(image));
            this.BOW_PALETTES.put((Tree)enum_, TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(enum_), 8, 0));
            this.WOOD_PALETTES.put((Tree)enum_, TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(enum_), 8, 1));
            List<Integer> base = this.WOOD_PALETTES.get(enum_);
            this.STRIPPED_WOOD_PALETTES.put((Tree)enum_, TextureProviderNF.subset(base, 5, 3));
            this.STRIPPED_WOOD_ITEM_PALETTES.put((Tree)enum_, TextureProviderNF.subset(base, 7, 1));
            this.WOOD_REDUCED_PALETTES.put((Tree)enum_, TextureProviderNF.subset(base, 6, 1));
            this.BARREL_OPEN_PALETTES.put((Tree)enum_, TextureProviderNF.combine(TextureProviderNF.subset(base, 3, 0), TextureProviderNF.subset(base, 3, 4)));
        }
    }

    protected ResourceLocation itemInv(RegistryObject<?> item) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("item/" + item.getId().m_135815_() + "_inventory"));
    }

    protected ResourceLocation armor(ITieredArmorMaterial material) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("models/armor/" + material.getName()));
    }

    protected ResourceLocation armor(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("models/armor/" + name));
    }

    protected ResourceLocation tempArmor(String name) {
        return this.armor(name + this.temp);
    }

    protected ResourceLocation equipment(RegistryObject<?> item) {
        return this.equipment(item.getId().m_135815_());
    }

    protected ResourceLocation equipment(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("models/equipment/" + name));
    }

    protected ResourceLocation tempEquipment(RegistryObject<?> item) {
        return this.tempEquipment(item.getId().m_135815_());
    }

    protected ResourceLocation tempEquipment(String name) {
        return this.equipment(name + this.temp);
    }

    private List<Integer> fill(BufferedImage image) {
        int rgb;
        int alpha;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int x = 0; x < image.getWidth() && (alpha = ((rgb = image.getRGB(x, this.y)) & 0xFF000000) >>> 24) != 0; ++x) {
            list.add(rgb);
        }
        this.y += 3;
        return list;
    }

    @SafeVarargs
    private static List<Integer> combine(List<Integer> ... sets) {
        ArrayList<Integer> newSet = new ArrayList<Integer>();
        for (List<Integer> set : sets) {
            newSet.addAll(set);
        }
        return newSet;
    }

    private static List<Integer> subset(List<Integer> set, int size, int offset) {
        ArrayList<Integer> subset = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            subset.add(set.get(i + offset));
        }
        return subset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addTextures() {
        for (Soil soil : List.of(Soil.SILT, Soil.DIRT, Soil.LOAM)) {
            this.replaceImagePalette(this.tempBlock("snowy_" + soil.getName() + "_side_overlay"), this.block("snowy_" + soil.getName() + "_side_overlay"), this.SNOW);
            this.layerImages(this.block("snowy_" + soil.getName() + "_side"), this.block("grassy_" + soil.getName() + "_side"), this.tempBlock("snowy_" + soil.getName() + "_side_overlay"));
        }
        for (Soil soil : BlocksNF.STRANGE_SOILS.keySet()) {
            this.layerImages(this.block(BlocksNF.STRANGE_SOILS.get(soil)), this.block(soil.getName() + "_block"), this.block(BlocksNF.STRANGE_SOILS.get(soil)));
        }
        this.replaceImagePalette(this.block(BlocksNF.SNOW), this.block(BlocksNF.SNOW), this.SNOW_LIGHT);
        this.replaceImagePalette(this.item(ItemsNF.SNOWBALL), this.item(ItemsNF.SNOWBALL), this.SNOW);
        for (Stone stone : Stone.values()) {
            String category = stone.getType().name().toLowerCase(Locale.ROOT);
            if (stone == Stone.PUMICE) {
                this.replaceImagePalette(this.block(BlocksNF.STONE_BLOCKS.get(stone)), this.block(BlocksNF.STONE_BLOCKS.get(stone)), this.RAW_STONE_PALETTES.get(stone));
            } else {
                ObjectArrayList ores;
                this.replaceImagePalette(this.block(BlocksNF.STONE_BLOCKS.get(stone)), this.block(BlocksNF.STONE_BLOCKS.get(stone)), this.RAW_STONE_PALETTES.get(stone));
                if (stone == Stone.MOONSTONE) {
                    ores = List.of(BlocksNF.METEORITE_ORE);
                } else {
                    ores = new ObjectArrayList();
                    if (BlocksNF.TIN_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.TIN_ORES.get(stone));
                    }
                    if (BlocksNF.COPPER_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.COPPER_ORES.get(stone));
                    }
                    if (BlocksNF.AZURITE_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.AZURITE_ORES.get(stone));
                    }
                    if (BlocksNF.HEMATITE_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.HEMATITE_ORES.get(stone));
                    }
                    if (BlocksNF.COAL_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.COAL_ORES.get(stone));
                    }
                    if (BlocksNF.HALITE_ORES.containsKey(stone)) {
                        ores.add(BlocksNF.HALITE_ORES.get(stone));
                    }
                }
                for (RegistryObject ore : ores) {
                    String metal = ore.getId().m_135815_().replace(stone.getName() + "_", "");
                    this.replaceImagePalette(this.tempBlock(ore, "_overlay"), this.block(metal + "_overlay"), this.DARK_STONE_PALETTES.get(stone));
                    this.layerImages(this.block(ore), this.block(BlocksNF.STONE_BLOCKS.get(stone)), this.tempBlock(ore, "_overlay"));
                }
                if (Files.exists(this.getExternalImagePath(this.block(BlocksNF.STONE_BLOCKS.get(stone), "_top")), new LinkOption[0])) {
                    if (stone == Stone.AURGROT) {
                        this.replaceImagePalette(this.block(BlocksNF.STONE_BLOCKS.get(stone), "_top"), this.block(BlocksNF.STONE_BLOCKS.get(stone), "_top"), TextureProviderNF.subset(this.RAW_STONE_PALETTES.get(stone), 4, 0));
                    } else {
                        this.replaceImagePalette(this.block(BlocksNF.STONE_BLOCKS.get(stone), "_top"), this.block(BlocksNF.STONE_BLOCKS.get(stone), "_top"), this.RAW_STONE_PALETTES.get(stone));
                    }
                    for (RegistryObject ore : ores) {
                        this.layerImages(this.block(ore, "_top"), this.block(BlocksNF.STONE_BLOCKS.get(stone), "_top"), this.tempBlock(ore, "_overlay"));
                    }
                }
            }
            if (stone.getType() == StoneType.IGNEOUS) {
                this.replaceImagePalette(this.block(BlocksNF.POLISHED_STONE.get(stone)), this.block("polished_stone_igneous"), TextureProviderNF.subset(this.STONE_PALETTES.get(stone), 4, 4));
            } else {
                this.replaceImagePalette(this.block(BlocksNF.POLISHED_STONE.get(stone)), this.block("polished_stone"), TextureProviderNF.subset(this.STONE_PALETTES.get(stone), 3, 5));
            }
            this.replaceImagePalette(this.block(BlocksNF.TILED_STONE.get(stone)), this.block("tiled_stone"), TextureProviderNF.subset(this.STONE_PALETTES.get(stone), 5, 3));
            this.replaceImagePalette(this.block(BlocksNF.STACKED_STONE.get(stone)), this.block("stacked_stone_" + category), this.STONE7_PALETTES.get(stone));
            this.replaceImagePalette(this.block(BlocksNF.COBBLED_STONE.get(stone)), this.block("cobbled_stone_" + category), this.STONE7_PALETTES.get(stone));
            this.replaceImagePalette(this.block(BlocksNF.STONE_BRICK_BLOCKS.get(stone)), this.block("stone_bricks_" + category), this.STONE7_PALETTES.get(stone));
            Object rock = "rock";
            if (stone == Stone.SLATE || stone == Stone.DEEPSLATE || stone == Stone.SUNSCHIST || stone == Stone.AURGROT) {
                rock = (String)rock + "_plane";
            } else if (stone == Stone.PUMICE || stone == Stone.LIMESTONE || stone == Stone.NIXWACKE || stone == Stone.BASALT) {
                rock = (String)rock + "_porous";
            }
            this.replaceImagePalette(this.item(ItemsNF.ROCKS.get(stone)), this.item((String)rock), this.STONE7_PALETTES.get(stone));
            this.replaceImagePalette(this.item(ItemsNF.STONE_BRICKS.get(stone)), this.item("stone_brick"), this.STONE_BRICK_ITEM_PALETTES.get(stone));
        }
        for (Enum enum_ : Tree.values()) {
            this.replaceImagePalette(this.tempItem(ItemsNF.LOGS.get(enum_)), this.item("log_top"), this.STRIPPED_WOOD_PALETTES.get(enum_));
            this.layerImages(this.item(ItemsNF.LOGS.get(enum_)), this.item(ItemsNF.LOGS.get(enum_)), this.tempItem(ItemsNF.LOGS.get(enum_)));
            this.replaceImagePalette(this.item(ItemsNF.STRIPPED_LOGS.get(enum_)), this.item("stripped_log"), this.STRIPPED_WOOD_ITEM_PALETTES.get(enum_));
        }
        for (Tree tree : BlocksNF.PLANK_BLOCKS.keySet()) {
            void var4_48;
            List[] palette;
            String style = "_" + tree.getStyle();
            if (tree.getHardness() > 1.6f) {
                String string = "_hard";
            } else if (tree.getHardness() < 1.0f) {
                String string = "_soft";
            } else {
                String string = "";
            }
            List<Integer> metal = this.METAL_GENERIC_LIGHT;
            if (style.contains("medieval")) {
                palette = new List[2];
                if (tree == Tree.LARCH) {
                    metal = this.METAL_GENERIC_DARK;
                }
            } else {
                palette = new List[1];
            }
            this.replaceImagePalette(this.block(BlocksNF.PLANK_BLOCKS.get(tree)), this.block("planks" + (String)var4_48), this.WOOD_REDUCED_PALETTES.get(tree));
            palette[0] = this.WOOD_PALETTES.get(tree);
            if (palette.length == 2) {
                palette[1] = List.of(metal.get(0), metal.get(1), metal.get(4));
            }
            this.replaceImagePalette(this.block(BlocksNF.PLANK_DOORS.get(tree), "_bottom"), this.block("door_bottom" + style), palette);
            if (palette.length == 2) {
                palette[1] = List.of(metal.get(1), metal.get(4));
            }
            this.replaceImagePalette(this.block(BlocksNF.PLANK_DOORS.get(tree), "_top"), this.block("door_top" + style), palette);
            palette[0] = TextureProviderNF.combine(TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 2, 1), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 4, 3));
            if (palette.length == 2) {
                palette[1] = List.of(metal.get(0), metal.get(1), metal.get(4));
            }
            this.replaceImagePalette(this.item(ItemsNF.PLANK_DOORS.get(tree)), this.item("door" + style), palette);
            palette[0] = this.WOOD_PALETTES.get(tree);
            if (palette.length == 2) {
                palette[1] = List.of(metal.get(1), metal.get(4));
            }
            this.replaceImagePalette(this.block(BlocksNF.PLANK_HATCHES.get(tree)), this.block("hatch" + style), palette);
            this.rotateImage(this.block(BlocksNF.PLANK_TRAPDOORS.get(tree)), this.block(BlocksNF.PLANK_HATCHES.get(tree)), 90);
            palette[0] = this.WOOD_PALETTES.get(tree);
            if (palette.length == 2) {
                palette[1] = List.of(metal.get(3));
            }
            this.replaceImagePalette(this.block(BlocksNF.PLANK_LADDERS.get(tree)), this.block("ladder" + style), palette);
            this.replaceImagePalette(this.block(BlocksNF.WOODEN_ITEM_FRAMES.get(tree)), this.block("item_frame_wooden"), this.WOOD_REDUCED_PALETTES.get(tree));
            this.replaceImagePalette(this.item(BlocksNF.WOODEN_ITEM_FRAMES.get(tree)), this.item("item_frame_wooden"), this.WOOD_REDUCED_PALETTES.get(tree));
            this.replaceImagePalette(this.block(BlocksNF.BARRELS.get(tree), "_end"), this.block("barrel_end"), this.WOOD_REDUCED_PALETTES.get(tree));
            this.replaceImagePalette(this.block(BlocksNF.BARRELS.get(tree), "_open"), this.block("barrel_open"), this.BARREL_OPEN_PALETTES.get(tree));
            this.replaceImagePalette(this.block(BlocksNF.BARRELS.get(tree), "_side"), this.block("barrel_side"), this.WOOD_REDUCED_PALETTES.get(tree));
            palette[0] = this.WOOD_FULL_PALETTES.get(tree);
            if (palette.length == 2) {
                palette[1] = metal;
            }
            this.replaceImagePalette(this.entity(BlocksNF.CHESTS.get(tree), "chest", "_single"), this.entity("chest/chest_single" + style), palette);
            this.replaceImagePalette(this.entity(BlocksNF.CHESTS.get(tree), "chest", "_left"), this.entity("chest/chest_left" + style), palette);
            this.replaceImagePalette(this.entity(BlocksNF.CHESTS.get(tree), "chest", "_right"), this.entity("chest/chest_right" + style), palette);
            String signStyle = tree.getHardness() >= Tree.MAPLE.getHardness() ? "_single" : "_multiple";
            this.replaceImagePalette(this.entity("sign/" + tree.getName() + "_plank"), this.entity("sign/plank" + signStyle), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 5, 2));
            this.replaceImagePalette(this.block(BlocksNF.SHELVES.get(tree)), this.block("shelf_simple"), this.WOOD_PALETTES.get(tree));
            List<Integer> list = palette[0] = style.contains("patterned") ? this.WOOD_PALETTES.get(tree) : this.WOOD_REDUCED_PALETTES.get(tree);
            if (palette.length == 2) {
                palette[1] = List.of(metal.get(2));
            }
            this.replaceImagePalette(this.block(BlocksNF.CHAIRS.get(tree)), this.block("chair" + style), palette);
            palette[0] = TextureProviderNF.combine(TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 2, 1), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 3, 3));
            if (palette.length == 2) {
                palette[1] = List.of(metal.get(2));
            }
            this.replaceImagePalette(this.item(ItemsNF.CHAIRS.get(tree)), this.item("chair" + style), palette);
            this.replaceImagePalette(this.item(ItemsNF.RACKS.get(tree)), this.item("rack"), TextureProviderNF.combine(TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 2, 1), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 4, 3)));
            this.replaceImagePalette(this.item(ItemsNF.PLANKS.get(tree)), this.item("plank"), this.WOOD_REDUCED_PALETTES.get(tree));
            this.replaceImagePalette(this.item(ItemsNF.PLANK_SIGNS.get(tree)), this.item("plank_sign" + signStyle), TextureProviderNF.combine(TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 2, 1), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 4, 3)));
            this.replaceImagePalette(this.block(BlocksNF.PLANK_FENCES.get(tree)), this.block("fence"), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 5, 2));
            this.replaceImagePalette(this.block(BlocksNF.TROUGHS.get(tree)), this.block("trough"), this.WOOD_REDUCED_PALETTES.get(tree));
            this.replaceImagePalette(this.block(BlocksNF.TROUGHS.get(tree), "_bottom"), this.block("trough_bottom"), this.WOOD_REDUCED_PALETTES.get(tree));
            this.replaceImagePalette(this.block(BlocksNF.TROUGHS.get(tree), "_side"), this.block("trough_side"), this.WOOD_REDUCED_PALETTES.get(tree));
        }
        for (Tree tree : BlocksNF.STRIPPED_LOGS.keySet()) {
            this.replaceImagePalette(this.block(BlocksNF.STRIPPED_LOGS.get(tree)), this.block("log_stripped"), this.STRIPPED_WOOD_PALETTES.get(tree));
            this.replaceImagePalette(this.block(BlocksNF.STRIPPED_LOGS.get(tree), "_top"), this.block("log_stripped_top"), this.STRIPPED_WOOD_PALETTES.get(tree));
            if (!BlocksNF.LOGS.containsKey(tree)) continue;
            this.layerImages(this.block(BlocksNF.LOGS.get(tree), "_top"), this.block(BlocksNF.STRIPPED_LOGS.get(tree), "_top"), this.block(BlocksNF.LOGS.get(tree), "_top"));
        }
        for (Tree tree : ItemsNF.BOWS.keySet()) {
            this.replaceImagePalette(this.item(ItemsNF.BOWS.get(tree)), this.item("bow"), this.BOW_PALETTES.get(tree));
            this.replaceImagePalette(this.item(ItemsNF.BOWS.get(tree), "_pulling_0"), this.item("bow_pulling_0"), this.BOW_PALETTES.get(tree));
            this.replaceImagePalette(this.item(ItemsNF.BOWS.get(tree), "_pulling_1"), this.item("bow_pulling_1"), this.BOW_PALETTES.get(tree));
            this.replaceImagePalette(this.item(ItemsNF.BOWS.get(tree), "_pulling_2"), this.item("bow_pulling_2"), this.BOW_PALETTES.get(tree));
        }
        for (Metal metal : BlocksNF.METAL_BLOCKS.keySet()) {
            this.replaceImagePalette(this.block(BlocksNF.METAL_BLOCKS.get(metal)), this.block("metal_block"), TextureProviderNF.subset(this.METAL_PALETTES.get(metal), 6, 2));
        }
        for (Metal metal : BlocksNF.INGOT_PILES.keySet()) {
            this.replaceImagePalette(this.block(BlocksNF.INGOT_PILES.get(metal)), this.block("ingot_pile"), TextureProviderNF.subset(this.METAL_PALETTES.get(metal), 6, 2));
            this.replaceImagePalette(this.block(BlocksNF.INGOT_PILES.get(metal), "_top"), this.block("ingot_pile_top"), TextureProviderNF.subset(this.METAL_PALETTES.get(metal), 6, 2));
        }
        this.replaceImagePalette(this.tempBlock(BlocksNF.STEEL_INGOT_PILE_POOR), this.block("ingot_pile_poor_overlay"), TextureProviderNF.subset(this.METAL_PALETTES.get(Metal.STEEL), 6, 2));
        this.layerImages(this.block(BlocksNF.STEEL_INGOT_PILE_POOR), this.block(BlocksNF.INGOT_PILES.get(Metal.IRON)), this.tempBlock(BlocksNF.STEEL_INGOT_PILE_POOR));
        this.replaceImagePalette(this.tempBlock(BlocksNF.STEEL_INGOT_PILE_POOR, "_top"), this.block("ingot_pile_top_poor_overlay"), TextureProviderNF.subset(this.METAL_PALETTES.get(Metal.STEEL), 6, 2));
        this.layerImages(this.block(BlocksNF.STEEL_INGOT_PILE_POOR, "_top"), this.block(BlocksNF.INGOT_PILES.get(Metal.IRON), "_top"), this.tempBlock(BlocksNF.STEEL_INGOT_PILE_POOR, "_top"));
        this.replaceImagePalette(this.tempBlock(BlocksNF.STEEL_INGOT_PILE_FAIR), this.block("ingot_pile_fair_overlay"), TextureProviderNF.subset(this.METAL_PALETTES.get(Metal.STEEL), 6, 2));
        this.layerImages(this.block(BlocksNF.STEEL_INGOT_PILE_FAIR), this.block(BlocksNF.INGOT_PILES.get(Metal.IRON)), this.tempBlock(BlocksNF.STEEL_INGOT_PILE_FAIR));
        this.replaceImagePalette(this.tempBlock(BlocksNF.STEEL_INGOT_PILE_FAIR, "_top"), this.block("ingot_pile_top_fair_overlay"), TextureProviderNF.subset(this.METAL_PALETTES.get(Metal.STEEL), 6, 2));
        this.layerImages(this.block(BlocksNF.STEEL_INGOT_PILE_FAIR, "_top"), this.block(BlocksNF.INGOT_PILES.get(Metal.IRON), "_top"), this.tempBlock(BlocksNF.STEEL_INGOT_PILE_FAIR, "_top"));
        for (Metal metal : BlocksNF.LANTERNS.keySet()) {
            String base = "lantern_" + metal.getCategory().name().toLowerCase(Locale.ROOT);
            this.replaceImagePalette(this.block(BlocksNF.LANTERNS_UNLIT.get(metal)), this.block(base), this.LANTERN_PALETTES.get(metal));
            this.layerImages(this.block(BlocksNF.LANTERNS.get(metal)), this.block(BlocksNF.LANTERNS_UNLIT.get(metal)), this.block(base + "_overlay"));
            this.replaceImagePalette(this.equipment(ItemsNF.LANTERNS_UNLIT.get(metal)), this.equipment(base), this.LANTERN_PALETTES.get(metal));
            this.layerImages(this.equipment(ItemsNF.LANTERNS.get(metal)), this.equipment(ItemsNF.LANTERNS_UNLIT.get(metal)), this.equipment(base + "_overlay"));
            this.replaceImagePalette(this.item(ItemsNF.LANTERNS_UNLIT.get(metal)), this.item(base), this.LANTERN_PALETTES.get(metal));
            this.layerImages(this.item(ItemsNF.LANTERNS.get(metal)), this.item(ItemsNF.LANTERNS_UNLIT.get(metal)), this.item(base + "_overlay"));
        }
        for (Metal metal : BlocksNF.ANVILS_METAL.keySet()) {
            this.replaceImagePalette(this.block(BlocksNF.ANVILS_METAL.get(metal)), this.block("anvil"), this.METAL5_PALETTES.get(metal));
            this.replaceImagePalette(this.block(BlocksNF.ANVILS_METAL.get(metal), "_top"), this.block("anvil_top"), this.METAL5_PALETTES.get(metal));
        }
        for (TieredHeat tieredHeat : this.HEAT_PALETTES.keySet()) {
            this.replaceImagePalette(this.tempBlock(BlocksNF.COAL_BURNING, "_overlay_" + tieredHeat), this.block(BlocksNF.COAL_BURNING, "_overlay"), this.HEAT_PALETTES.get((Object)tieredHeat));
            this.layerImages(this.block(BlocksNF.COAL_BURNING, "_" + tieredHeat), this.block(BlocksNF.COAL), this.tempBlock(BlocksNF.COAL_BURNING, "_overlay_" + tieredHeat));
            this.layerImages(this.block(BlocksNF.COKE_BURNING, "_" + tieredHeat), this.block(BlocksNF.COKE), this.tempBlock(BlocksNF.COAL_BURNING, "_overlay_" + tieredHeat));
            this.replaceImagePalette(this.tempBlock(BlocksNF.CHARCOAL_BURNING, "_overlay_" + tieredHeat), this.block(BlocksNF.CHARCOAL_BURNING, "_overlay"), this.HEAT_PALETTES.get((Object)tieredHeat));
            this.layerImages(this.block(BlocksNF.CHARCOAL_BURNING, "_" + tieredHeat), this.block(BlocksNF.CHARCOAL), this.tempBlock(BlocksNF.CHARCOAL_BURNING, "_overlay_" + tieredHeat));
            this.replaceImagePalette(this.tempBlock(BlocksNF.CHARCOAL_BURNING, "_top_overlay_" + tieredHeat), this.block(BlocksNF.CHARCOAL_BURNING, "_top_overlay"), this.HEAT_PALETTES.get((Object)tieredHeat));
            this.layerImages(this.block(BlocksNF.CHARCOAL_BURNING, "_top_" + tieredHeat), this.block(BlocksNF.CHARCOAL, "_top"), this.tempBlock(BlocksNF.CHARCOAL_BURNING, "_top_overlay_" + tieredHeat));
            this.layerImages(this.block(BlocksNF.FIREWOOD_BURNING, "_" + tieredHeat), this.block(BlocksNF.FIREWOOD), this.tempBlock(BlocksNF.CHARCOAL_BURNING, "_overlay_" + tieredHeat));
            this.layerImages(this.block(BlocksNF.FIREWOOD_BURNING, "_top_" + tieredHeat), this.block(BlocksNF.FIREWOOD, "_top"), this.tempBlock(BlocksNF.CHARCOAL_BURNING, "_top_overlay_" + tieredHeat));
            this.replaceImagePalette(this.tempBlock(BlocksNF.CRUCIBLE, "_" + tieredHeat), this.block(BlocksNF.CRUCIBLE, "_overlay"), this.HEAT_PALETTES.get((Object)tieredHeat));
            this.layerImages(this.block(BlocksNF.CRUCIBLE, "_" + tieredHeat), this.block(BlocksNF.CRUCIBLE, "_none"), this.tempBlock(BlocksNF.CRUCIBLE, "_" + tieredHeat));
        }
        this.replaceImagePalette(this.tempBlock(BlocksNF.SMELTED_AZURITE), this.block(BlocksNF.SMELTED_AZURITE, "_overlay"), TextureProviderNF.subset(this.METAL_PALETTES.get(Metal.COPPER), 7, 0));
        this.layerImages(this.block(BlocksNF.SMELTED_AZURITE), this.block(BlocksNF.SLAG), this.tempBlock(BlocksNF.SMELTED_AZURITE));
        this.layerImages(this.block(BlocksNF.SMELTED_HEMATITE), this.block(BlocksNF.SLAG), this.block(BlocksNF.SMELTED_HEMATITE, "_overlay"));
        for (Stone stone : BlocksNF.STONE_TUNNELS.keySet()) {
            this.layerImages(this.block(BlocksNF.STONE_TUNNELS.get(stone)), this.block(BlocksNF.STONE_BLOCKS.get(stone)), this.block("hole"));
        }
        this.replaceImagePalette(this.item(ItemsNF.STICK), this.item(ItemsNF.STICK), this.STICK);
        this.replaceImagePalette(this.item(ItemsNF.LEATHER), this.item(ItemsNF.LEATHER), TextureProviderNF.subset(this.LEATHER, 6, 1));
        this.replaceImagePalette(this.item(ItemsNF.TORCH), this.item(ItemsNF.TORCH), this.STICK);
        this.replaceImagePalette(this.item(ItemsNF.TORCH_UNLIT), this.item(ItemsNF.TORCH_UNLIT), this.STICK);
        this.replaceImagePalette(this.block(BlocksNF.TORCH), this.block(BlocksNF.TORCH), this.STICK3);
        this.replaceImagePalette(this.block(BlocksNF.TORCH_UNLIT), this.block(BlocksNF.TORCH_UNLIT), this.STICK3);
        this.replaceImagePalette(this.tempItem("seawater_bucket_overlay"), this.item("water_bucket_overlay"), this.SEAWATER);
        this.replaceImagePalette(this.tempItem("water_bucket_overlay"), this.item("water_bucket_overlay"), this.WATER);
        this.replaceImagePalette(this.tempItem("lava_bucket_overlay"), this.item("lava_bucket_overlay"), this.LAVA);
        this.replaceImagePalette(this.item(ItemsNF.WOODEN_BUCKET), this.item("empty_wooden_bucket"), this.WOOD_REDUCED_PALETTES.get(Tree.OAK));
        this.layerImages(this.item(ItemsNF.WOODEN_SEAWATER_BUCKET), this.item(ItemsNF.WOODEN_BUCKET), this.tempItem("seawater_bucket_overlay"));
        this.layerImages(this.item(ItemsNF.WOODEN_WATER_BUCKET), this.item(ItemsNF.WOODEN_BUCKET), this.tempItem("water_bucket_overlay"));
        this.replaceImagePalette(this.item(ItemsNF.BRONZE_BUCKET), this.item("empty_bronze_bucket"), this.METAL_PALETTES.get(Metal.BRONZE));
        this.layerImages(this.item(ItemsNF.BRONZE_SEAWATER_BUCKET), this.item(ItemsNF.BRONZE_BUCKET), this.tempItem("seawater_bucket_overlay"));
        this.layerImages(this.item(ItemsNF.BRONZE_WATER_BUCKET), this.item(ItemsNF.BRONZE_BUCKET), this.tempItem("water_bucket_overlay"));
        this.replaceImagePalette(this.item(ItemsNF.ALKIMIUM_BUCKET), this.item("empty_bronze_bucket"), this.METAL_PALETTES.get(Metal.BRONZE));
        this.layerImages(this.item(ItemsNF.ALKIMIUM_SEAWATER_BUCKET), this.item(ItemsNF.ALKIMIUM_BUCKET), this.tempItem("seawater_bucket_overlay"));
        this.layerImages(this.item(ItemsNF.ALKIMIUM_WATER_BUCKET), this.item(ItemsNF.ALKIMIUM_BUCKET), this.tempItem("water_bucket_overlay"));
        this.layerImages(this.item(ItemsNF.ALKIMIUM_LAVA_BUCKET), this.item(ItemsNF.ALKIMIUM_BUCKET), this.tempItem("lava_bucket_overlay"));
        this.replaceImagePalette(this.item(ItemsNF.FLINT_ADZE), this.item("flint_adze"), this.FLINT4, this.STICK5, this.FIBER);
        this.replaceImagePalette(this.itemInv(ItemsNF.FLINT_ADZE), this.item("flint_adze_inventory"), this.FLINT, this.STICK, this.FIBER);
        this.replaceImagePalette(this.item(ItemsNF.FLINT_AXE), this.item("flint_axe"), this.FLINT5, this.STICK5, this.FIBER);
        this.replaceImagePalette(this.itemInv(ItemsNF.FLINT_AXE), this.item("flint_axe_inventory"), this.FLINT, this.STICK, this.FIBER);
        this.replaceImagePalette(this.item(ItemsNF.FLINT_DAGGER), this.item("flint_dagger"), this.FLINT4, this.STICK5, this.FIBER);
        this.replaceImagePalette(this.itemInv(ItemsNF.FLINT_DAGGER), this.item("flint_dagger_inventory"), this.FLINT4, this.STICK, this.FIBER);
        this.replaceImagePalette(this.item(ItemsNF.FLINT_CHISEL), this.item("flint_chisel"), this.FLINT5);
        this.replaceImagePalette(this.itemInv(ItemsNF.FLINT_CHISEL), this.item("flint_chisel_inventory"), this.FLINT);
        this.replaceImagePalette(this.item(ItemsNF.FLINT_HAMMER), this.item("flint_hammer"), this.FLINT4, this.STICK5, this.FIBER);
        this.replaceImagePalette(this.itemInv(ItemsNF.FLINT_HAMMER), this.item("flint_hammer_inventory"), TextureProviderNF.subset(this.FLINT, 5, 0), this.STICK, this.FIBER);
        this.replaceImagePalette(this.item(ItemsNF.FLINT_SHOVEL), this.item("flint_shovel"), TextureProviderNF.subset(this.FLINT, 4, 0), this.STICK5, this.FIBER);
        this.replaceImagePalette(this.itemInv(ItemsNF.FLINT_SHOVEL), this.item("flint_shovel_inventory"), TextureProviderNF.subset(this.FLINT, 5, 0), this.STICK, this.FIBER);
        this.replaceImagePalette(this.item(ItemsNF.FLINT_SPEAR), this.item("flint_spear"), this.FLINT4, this.STICK5, this.FIBER);
        this.replaceImagePalette(this.itemInv(ItemsNF.FLINT_SPEAR), this.item("flint_spear_inventory"), this.FLINT, this.STICK, this.FIBER);
        this.replaceImagePalette(this.item(ItemsNF.IRONWOOD_SHIELD), this.item("shield"), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(Tree.IRONWOOD), 6, 2));
        this.replaceImagePalette(this.itemInv(ItemsNF.IRONWOOD_SHIELD), this.item("shield_inventory"), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(Tree.IRONWOOD), 6, 2));
        this.replaceImagePalette(this.item(ItemsNF.IRONWOOD_SHIELD, "_inventory_overlay"), this.item("ironwood_shield_inventory_overlay"), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(Tree.IRONWOOD), 2, 0));
        this.replaceImagePalette(this.item(ItemsNF.IRONWOOD_SHIELD, "_overlay"), this.item("ironwood_shield_overlay"), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(Tree.IRONWOOD), 6, 2));
        for (Metal metal : ItemsNF.INGOTS.keySet()) {
            this.replaceImagePalette(this.item(ItemsNF.INGOTS.get(metal)), this.item("ingot"), this.METAL_PALETTES.get(metal));
            this.replaceImagePalette(this.item(ItemsNF.BILLETS.get(metal)), this.item("billet"), this.METAL_PALETTES.get(metal));
        }
        for (Metal metal : ItemsNF.WIRES.keySet()) {
            this.replaceImagePalette(this.item(ItemsNF.WIRES.get(metal)), this.item("wire"), this.METAL_PALETTES.get(metal));
        }
        for (Metal metal : ItemsNF.PLATES.keySet()) {
            this.replaceImagePalette(this.item(ItemsNF.PLATES.get(metal)), this.item("plate"), this.METAL_PALETTES.get(metal));
        }
        for (Metal metal : ItemsNF.CHAINMAIL.keySet()) {
            this.replaceImagePalette(this.item(ItemsNF.CHAINMAIL.get(metal)), this.item("chainmail"), this.METAL_PALETTES.get(metal));
        }
        for (Metal metal : ItemsNF.SCALES.keySet()) {
            this.replaceImagePalette(this.item(ItemsNF.SCALES.get(metal)), this.item("scales"), this.METAL_PALETTES.get(metal));
        }
        for (TieredItemMaterial tieredItemMaterial : ItemsNF.METAL_ARROWHEADS.keySet()) {
            List<Integer> palette = this.METAL_PALETTES.get(tieredItemMaterial.getMetal());
            this.replaceImagePalette(this.item(ItemsNF.METAL_ARROWHEADS.get(tieredItemMaterial)), this.item("metal_arrowhead"), List.of(palette.get(1), palette.get(2), palette.get(3), palette.get(4), palette.get(5), palette.get(7)));
        }
        for (Metal metal : ItemsNF.METAL_SHIELDS.keySet()) {
            RegistryObject<ShieldItemNF> item = ItemsNF.METAL_SHIELDS.get(metal);
            this.replaceImagePalette(this.item(item), this.item("shield"), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(Tree.IRONWOOD), 6, 2));
            this.replaceImagePalette(this.itemInv(item), this.item("shield_inventory"), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(Tree.IRONWOOD), 6, 2));
            this.replaceImagePalette(this.tempItem(item, "_inventory_overlay"), this.item("shield_inventory_overlay"), TextureProviderNF.subset(this.METAL_PALETTES.get(metal), 7, 0));
            this.layerImages(this.item(item, "_inventory_overlay"), this.item(ItemsNF.IRONWOOD_SHIELD, "_inventory_overlay"), this.tempItem(item, "_inventory_overlay"));
            this.replaceImagePalette(this.tempItem(item, "_overlay"), this.item("shield_overlay"), TextureProviderNF.subset(this.METAL_PALETTES.get(metal), 4, 3));
            this.layerImages(this.item(item, "_overlay"), this.item(ItemsNF.IRONWOOD_SHIELD, "_overlay"), this.tempItem(item, "_overlay"));
        }
        for (TieredItemMaterial tieredItemMaterial : ItemsNF.ARMAMENT_HEADS.keySet()) {
            for (Armament armament : ItemsNF.ARMAMENT_HEADS.get(tieredItemMaterial).keySet()) {
                RegistryObject<Item> item = ItemsNF.ARMAMENT_HEADS.get(tieredItemMaterial).get(armament);
                List<Integer> head = armament == Armament.HAMMER || armament == Armament.SHOVEL ? this.METAL_DULL_PALETTES.get(tieredItemMaterial.getMetal()) : this.METAL_REDUCED_PALETTES.get(tieredItemMaterial.getMetal());
                this.replaceImagePalette(this.item(item), this.item(armament.getName() + "_head"), head);
            }
        }
        for (Armament armament : ItemsNF.UNFIRED_ARMAMENT_MOLDS.keySet()) {
            this.replaceImagePalette(this.item(ItemsNF.UNFIRED_ARMAMENT_MOLDS.get(armament)), this.item(ItemsNF.ARMAMENT_MOLDS.get(armament)), this.CLAY);
        }
        this.replaceImagePalette(this.item(ItemsNF.UNFIRED_INGOT_MOLD), this.item(ItemsNF.INGOT_MOLD), this.CLAY);
        this.replaceImagePalette(this.item(ItemsNF.UNFIRED_ARROWHEAD_MOLD), this.item(ItemsNF.ARROWHEAD_MOLD), this.CLAY);
        for (RegistryObject registryObject : ItemsNF.ARMAMENT_MOLDS.values()) {
            this.replaceImagePalette(this.item(registryObject), this.item(registryObject), this.TERRACOTTA);
        }
        this.replaceImagePalette(this.item(ItemsNF.INGOT_MOLD), this.item(ItemsNF.INGOT_MOLD), this.TERRACOTTA);
        this.replaceImagePalette(this.item(ItemsNF.ARROWHEAD_MOLD), this.item(ItemsNF.ARROWHEAD_MOLD), this.TERRACOTTA);
        for (TieredItemMaterial tieredItemMaterial : ItemsNF.METAL_ARROWS.keySet()) {
            RegistryObject<ProjectileItem> item = ItemsNF.METAL_ARROWS.get(tieredItemMaterial);
            List<Integer> list = this.METAL_PALETTES.get(tieredItemMaterial.getMetal());
            this.replaceImagePalette(this.item(item), this.item("metal_arrow"), List.of(list.get(1), list.get(2), list.get(3), list.get(4), list.get(5), list.get(7)));
            for (int i = 0; i <= 2; ++i) {
                this.replaceImagePalette(this.item(item, "_nocked_" + i), this.item("metal_arrow_nocked_" + i), List.of(list.get(1), list.get(2), list.get(3), list.get(5), list.get(7)));
            }
            this.replaceImagePalette(this.entity(item, "arrow"), this.entity("arrow/metal_arrow"), List.of(list.get(1), list.get(2), list.get(3), list.get(5), list.get(7)));
        }
        for (TieredItemMaterial tieredItemMaterial : ItemsNF.METAL_ARMAMENTS.keySet()) {
            int tier3 = tieredItemMaterial.getTier() > 2 ? 1 : 0;
            Metal metal = (Metal)Metal.fromString(tieredItemMaterial.getName());
            for (Armament armament : ItemsNF.METAL_ARMAMENTS.get(tieredItemMaterial).keySet()) {
                List<Integer> head;
                List<Integer> wrapping;
                List<Integer> handleReduced = tier3 != 0 ? this.TREATED_STICK_REDUCED : this.STICK2;
                List<Integer> handle = tier3 != 0 ? this.TREATED_STICK : this.STICK3;
                List<Integer> wrappingReduced = tier3 != 0 ? this.LEATHER2 : this.TWINE2;
                List<Integer> list = wrapping = tier3 != 0 ? this.LEATHER3 : this.TWINE3;
                if (armament == Armament.HAMMER || armament == Armament.SHOVEL) {
                    head = this.METAL_DULL_PALETTES.get(metal);
                } else if (armament == Armament.DAGGER || armament == Armament.SWORD || armament == Armament.SABRE) {
                    head = this.METAL_PALETTES.get(metal);
                    if (tier3 != 0) {
                        handle = wrapping;
                        handleReduced = wrappingReduced;
                    }
                } else if (armament == Armament.MACE) {
                    head = this.METAL_PALETTES.get(metal);
                } else if (armament == Armament.CHISEL) {
                    head = this.METAL_REDUCED_PALETTES.get(metal);
                    wrapping = null;
                    wrappingReduced = null;
                } else {
                    head = this.METAL_REDUCED_PALETTES.get(metal);
                }
                this.replaceImagePalette(this.item(ItemsNF.METAL_ARMAMENTS.get(tieredItemMaterial).get(armament)), this.item(armament.getName()), handleReduced, head, wrappingReduced);
                this.replaceImagePalette(this.itemInv(ItemsNF.METAL_ARMAMENTS.get(tieredItemMaterial).get(armament)), this.item(armament.getName() + "_inventory"), handle, head, wrapping);
            }
        }
        for (Style style : Style.values()) {
            for (String material : style.getMaterials()) {
                String name = material + "_" + style.getName();
                this.splitImageBySaturation(0.5f, 0.0f, this.tempArmor(name), this.armor(name + "_overlay"), this.armor(name));
            }
        }
        for (RegistryObject registryObject : ItemsNF.getTieredArmors()) {
            if (Files.exists(this.getExternalImagePath(this.item(registryObject)), new LinkOption[0])) continue;
            TieredArmorItem tieredArmorItem = (TieredArmorItem)((Object)registryObject.get());
            ITieredArmorMaterial iTieredArmorMaterial = tieredArmorItem.material;
            IMetal metal = Metal.fromString(iTieredArmorMaterial.getName());
            if (metal == null) continue;
            List<Integer> palette = this.METAL_PALETTES.get(metal);
            EquipmentSlot slot = tieredArmorItem.slot;
            if (iTieredArmorMaterial.getStyle() == Style.SLAYER) {
                palette = TextureProviderNF.subset(this.METAL_PALETTES.get(metal), 7, 0);
            } else if (iTieredArmorMaterial.getArmorType() == ArmorType.SCALE) {
                if (iTieredArmorMaterial.getStyle() == Style.SURVIVOR && slot != EquipmentSlot.HEAD) {
                    palette = this.METAL_SCALE_PALETTES.get(metal);
                } else if (iTieredArmorMaterial.getStyle() == Style.EXPLORER) {
                    if (slot == EquipmentSlot.HEAD || slot == EquipmentSlot.LEGS) {
                        palette = TextureProviderNF.subset(this.METAL_PALETTES.get(metal), 7, 0);
                    } else if (slot == EquipmentSlot.CHEST) {
                        palette = List.of(palette.get(0), palette.get(1), palette.get(3), palette.get(4), palette.get(5), palette.get(6));
                    }
                }
            } else if (iTieredArmorMaterial.getArmorType() == ArmorType.PLATE) {
                if (iTieredArmorMaterial.getStyle() == Style.SURVIVOR && slot != EquipmentSlot.CHEST) {
                    palette = this.METAL_PLATE_PALETTES.get(metal);
                } else if (iTieredArmorMaterial.getStyle() == Style.EXPLORER) {
                    if (slot == EquipmentSlot.LEGS) {
                        palette = TextureProviderNF.subset(this.METAL_PALETTES.get(metal), 7, 0);
                    } else if (slot == EquipmentSlot.FEET) {
                        palette = List.of(palette.get(0), palette.get(1), palette.get(3), palette.get(4), palette.get(5), palette.get(6), palette.get(7));
                    }
                }
            } else if (iTieredArmorMaterial.getArmorType() == ArmorType.CHAINMAIL) {
                if (iTieredArmorMaterial.getStyle() == Style.SURVIVOR) {
                    palette = this.METAL_CHAINMAIL_PALETTES.get(metal);
                } else if (iTieredArmorMaterial.getStyle() == Style.EXPLORER && (slot == EquipmentSlot.HEAD || slot == EquipmentSlot.LEGS)) {
                    palette = List.of(palette.get(0), palette.get(1), palette.get(2), palette.get(3), palette.get(4), palette.get(6), palette.get(7));
                }
            }
            String base = registryObject.getId().m_135815_().replace(metal.getName() + "_", "");
            this.splitImageBySaturation(0.5f, 0.0f, this.tempItem(registryObject), this.item(registryObject), this.item(base));
            this.replaceImagePalette(this.item(registryObject, "_overlay"), this.tempItem(registryObject), palette);
        }
        for (TieredArmorMaterial tieredArmorMaterial : TieredArmorMaterial.values()) {
            IMetal metal = Metal.fromString(tieredArmorMaterial.getName());
            if (metal == null || Files.exists(this.getExternalImagePath(this.armor(tieredArmorMaterial)), new LinkOption[0])) continue;
            this.replaceImagePalette(this.armor(tieredArmorMaterial), this.tempArmor(tieredArmorMaterial.getStyledArmorName()), this.METAL_PALETTES.get(metal));
        }
        for (Tree tree : ItemsNF.ARMOR_STANDS.keySet()) {
            this.replaceImagePalette(this.item(ItemsNF.ARMOR_STANDS.get(tree)), this.item("armor_stand"), TextureProviderNF.combine(TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 2, 1), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 4, 3)));
            this.replaceImagePalette(this.entity("armorstand/" + tree.getName() + "_plank"), this.entity("armorstand/plank"), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 6, 2));
        }
        for (Tree tree : ItemsNF.BOATS.keySet()) {
            this.replaceImagePalette(this.item(ItemsNF.BOATS.get(tree)), this.item("boat"), TextureProviderNF.combine(TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 2, 1), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 4, 3)));
            this.replaceImagePalette(this.entity("boat/" + tree.getName() + "_plank"), this.entity("boat/plank"), TextureProviderNF.subset(this.WOOD_FULL_PALETTES.get(tree), 6, 2));
        }
        this.layerImages(this.item(ItemsNF.MEAT_STEW), this.item(ItemsNF.WOODEN_BOWL), this.item(ItemsNF.MEAT_STEW));
        this.layerImages(this.item(ItemsNF.VEGETABLE_STEW), this.item(ItemsNF.WOODEN_BOWL), this.item(ItemsNF.VEGETABLE_STEW));
        this.layerImages(this.item(ItemsNF.HEARTY_STEW), this.item(ItemsNF.WOODEN_BOWL), this.item(ItemsNF.HEARTY_STEW));
        this.layerImages(this.item(ItemsNF.SUSPICIOUS_STEW), this.item(ItemsNF.WOODEN_BOWL), this.item(ItemsNF.SUSPICIOUS_STEW));
    }
}

