/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.registry.vanilla.LootItemConditionTypesNF;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class ActionTagCondition
implements LootItemCondition {
    private final TagKey<Action> tag;

    private ActionTagCondition(TagKey<Action> tag) {
        this.tag = tag;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81455_);
    }

    public LootItemConditionType m_7940_() {
        return LootItemConditionTypesNF.ACTION_TAG;
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity != null && ActionTracker.isPresent(entity)) {
            return ActionTracker.get(entity).getAction().is(this.tag);
        }
        return false;
    }

    public static Builder of(TagKey<Action> tag) {
        return new Builder(tag);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final TagKey<Action> type;

        public Builder(TagKey<Action> type) {
            this.type = type;
        }

        public LootItemCondition m_6409_() {
            return new ActionTagCondition(this.type);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ActionTagCondition> {
        public void serialize(JsonObject json, ActionTagCondition condition, JsonSerializationContext context) {
            json.addProperty("tag", condition.tag.f_203868_().toString());
        }

        public ActionTagCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            ResourceLocation tagName = ResourceLocation.parse((String)GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            return new ActionTagCondition((TagKey<Action>)TagKey.m_203882_(RegistriesNF.ACTIONS_KEY, (ResourceLocation)tagName));
        }
    }
}

