/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.registry.vanilla.LootItemConditionTypesNF;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class DamageTypeCondition
implements LootItemCondition {
    private final DamageType type;

    private DamageTypeCondition(DamageType type) {
        this.type = type;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81457_);
    }

    public LootItemConditionType m_7940_() {
        return LootItemConditionTypesNF.DAMAGE_TYPE;
    }

    public boolean test(LootContext context) {
        DamageSource source = (DamageSource)context.m_165124_(LootContextParams.f_81457_);
        DamageTypeSource typeSource = source instanceof DamageTypeSource ? (DamageTypeSource)source : DamageTypeSource.convertFromVanilla(source);
        for (DamageType sourceType : typeSource.types) {
            if (sourceType != this.type) continue;
            return true;
        }
        return false;
    }

    public static Builder of(DamageType type) {
        return new Builder(type);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final DamageType type;

        public Builder(DamageType type) {
            this.type = type;
        }

        public LootItemCondition m_6409_() {
            return new DamageTypeCondition(this.type);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<DamageTypeCondition> {
        public void serialize(JsonObject json, DamageTypeCondition condition, JsonSerializationContext context) {
            json.addProperty("type", condition.type.toString());
        }

        public DamageTypeCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            String typeName = GsonHelper.m_13906_((JsonObject)json, (String)"type");
            DamageType type = null;
            for (DamageType t : DamageType.values()) {
                if (!t.toString().equals(typeName)) continue;
                type = t;
                break;
            }
            if (type == null) {
                throw new IllegalStateException("Failed to deserialize unknown type '" + typeName + "' in " + DamageTypeCondition.class.getSimpleName());
            }
            return new DamageTypeCondition(type);
        }
    }
}

