/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import frostnox.nightfall.entity.IHungerEntity;
import frostnox.nightfall.entity.entity.animal.DeerEntity;
import frostnox.nightfall.entity.entity.animal.RabbitEntity;
import frostnox.nightfall.entity.entity.monster.CockatriceEntity;
import frostnox.nightfall.registry.vanilla.LootItemConditionTypesNF;
import java.util.Locale;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class LootItemEntityCondition
implements LootItemCondition {
    private final LootContext.EntityTarget entityTarget;
    private final Test test;

    private LootItemEntityCondition(LootContext.EntityTarget entityTarget, Test test) {
        this.entityTarget = entityTarget;
        this.test = test;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)this.entityTarget.m_79003_());
    }

    public LootItemConditionType m_7940_() {
        return LootItemConditionTypesNF.ENTITY;
    }

    public boolean test(LootContext context) {
        if (!context.m_78936_(this.entityTarget.m_79003_())) {
            return false;
        }
        return switch (this.test) {
            default -> throw new IncompatibleClassChangeError();
            case Test.LIVING_PRESENT -> context.m_165124_(this.entityTarget.m_79003_()) instanceof LivingEntity;
            case Test.HUNGRY -> {
                IHungerEntity hungerEntity;
                Object var3_2 = context.m_165124_(this.entityTarget.m_79003_());
                if (var3_2 instanceof IHungerEntity && (hungerEntity = (IHungerEntity)var3_2).isHungry()) {
                    yield true;
                }
                yield false;
            }
            case Test.RABBIT_BRUSH -> {
                RabbitEntity rabbit;
                Object var3_3 = context.m_165124_(this.entityTarget.m_79003_());
                if (var3_3 instanceof RabbitEntity && (rabbit = (RabbitEntity)var3_3).getRabbitType() == RabbitEntity.Type.BRUSH) {
                    yield true;
                }
                yield false;
            }
            case Test.RABBIT_ARCTIC -> {
                RabbitEntity rabbit;
                Object var3_4 = context.m_165124_(this.entityTarget.m_79003_());
                if (var3_4 instanceof RabbitEntity && (rabbit = (RabbitEntity)var3_4).getRabbitType() == RabbitEntity.Type.ARCTIC) {
                    yield true;
                }
                yield false;
            }
            case Test.RABBIT_COTTONTAIL -> {
                RabbitEntity rabbit;
                Object var3_5 = context.m_165124_(this.entityTarget.m_79003_());
                if (var3_5 instanceof RabbitEntity && (rabbit = (RabbitEntity)var3_5).getRabbitType() == RabbitEntity.Type.COTTONTAIL) {
                    yield true;
                }
                yield false;
            }
            case Test.RABBIT_STRIPED -> {
                RabbitEntity rabbit;
                Object var3_6 = context.m_165124_(this.entityTarget.m_79003_());
                if (var3_6 instanceof RabbitEntity && (rabbit = (RabbitEntity)var3_6).getRabbitType() == RabbitEntity.Type.STRIPED) {
                    yield true;
                }
                yield false;
            }
            case Test.DEER_BRIAR -> {
                DeerEntity deer;
                Object var3_7 = context.m_165124_(this.entityTarget.m_79003_());
                if (var3_7 instanceof DeerEntity && (deer = (DeerEntity)var3_7).getDeerType() == DeerEntity.Type.BRIAR) {
                    yield true;
                }
                yield false;
            }
            case Test.DEER_RED -> {
                DeerEntity deer;
                Object var3_8 = context.m_165124_(this.entityTarget.m_79003_());
                if (var3_8 instanceof DeerEntity && (deer = (DeerEntity)var3_8).getDeerType() == DeerEntity.Type.RED) {
                    yield true;
                }
                yield false;
            }
            case Test.DEER_SPOTTED -> {
                DeerEntity deer;
                Object var3_9 = context.m_165124_(this.entityTarget.m_79003_());
                if (var3_9 instanceof DeerEntity && (deer = (DeerEntity)var3_9).getDeerType() == DeerEntity.Type.SPOTTED) {
                    yield true;
                }
                yield false;
            }
            case Test.COCKATRICE_BRONZE -> {
                CockatriceEntity cockatrice;
                Object var3_10 = context.m_165124_(this.entityTarget.m_79003_());
                if (var3_10 instanceof CockatriceEntity && (cockatrice = (CockatriceEntity)var3_10).getCockatriceType() == CockatriceEntity.Type.BRONZE) {
                    yield true;
                }
                yield false;
            }
            case Test.COCKATRICE_EMERALD -> {
                CockatriceEntity cockatrice;
                Object var3_11 = context.m_165124_(this.entityTarget.m_79003_());
                yield var3_11 instanceof CockatriceEntity && (cockatrice = (CockatriceEntity)var3_11).getCockatriceType() == CockatriceEntity.Type.EMERALD;
            }
        };
    }

    public static Builder of(Test test) {
        return new Builder(test);
    }

    public static enum Test {
        LIVING_PRESENT,
        HUNGRY,
        RABBIT_BRUSH,
        RABBIT_COTTONTAIL,
        RABBIT_ARCTIC,
        RABBIT_STRIPED,
        DEER_BRIAR,
        DEER_RED,
        DEER_SPOTTED,
        COCKATRICE_BRONZE,
        COCKATRICE_EMERALD;

        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String toString() {
            return this.name;
        }
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Test test;

        public Builder(Test test) {
            this.test = test;
        }

        public LootItemCondition m_6409_() {
            return new LootItemEntityCondition(LootContext.EntityTarget.THIS, this.test);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LootItemEntityCondition> {
        public void serialize(JsonObject json, LootItemEntityCondition condition, JsonSerializationContext context) {
            json.add("entity", context.serialize((Object)condition.entityTarget));
            json.addProperty("test", condition.test.toString());
        }

        public LootItemEntityCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            LootContext.EntityTarget entityTarget = (LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class);
            String testName = GsonHelper.m_13906_((JsonObject)json, (String)"test");
            Test test = null;
            for (Test t : Test.values()) {
                if (!t.toString().equals(testName)) continue;
                test = t;
                break;
            }
            if (test == null) {
                throw new IllegalStateException("Failed to deserialize unknown test '" + testName + "' in " + LootItemEntityCondition.class.getSimpleName());
            }
            return new LootItemEntityCondition(entityTarget, test);
        }
    }
}

