/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.vanilla.LootItemFunctionTypesNF;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class PerceptionCountFunction
extends LootItemConditionalFunction {
    private final int count;
    private final float chance;
    private final float increment;

    protected PerceptionCountFunction(LootItemCondition[] pConditions, int count, float chance, float increment) {
        super(pConditions);
        this.count = count;
        this.chance = chance;
        this.increment = increment;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        Entity entity;
        Entity entity2 = entity = context.m_78936_(LootContextParams.f_81458_) ? (Entity)context.m_78953_(LootContextParams.f_81458_) : (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int perception = AttributesNF.getPerceptionInfluence(livingEntity);
            if (context.m_78933_().nextFloat() < this.chance + (float)perception * this.increment) {
                stack.m_41769_(this.count);
            }
        }
        return stack;
    }

    public LootItemFunctionType m_7162_() {
        return LootItemFunctionTypesNF.PERCEPTION_COUNT;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81455_);
    }

    public static LootItemConditionalFunction.Builder<?> with(int count, float chance, float increment) {
        return PerceptionCountFunction.m_80683_(conditions -> new PerceptionCountFunction((LootItemCondition[])conditions, count, chance, increment));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<PerceptionCountFunction> {
        public void serialize(JsonObject json, PerceptionCountFunction func, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)func, context);
            json.addProperty("count", (Number)func.count);
            json.addProperty("chance", (Number)Float.valueOf(func.chance));
            json.addProperty("increment", (Number)Float.valueOf(func.increment));
        }

        public PerceptionCountFunction deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            int count = GsonHelper.m_13927_((JsonObject)json, (String)"count");
            float chance = GsonHelper.m_13915_((JsonObject)json, (String)"chance");
            float increment = GsonHelper.m_13915_((JsonObject)json, (String)"increment");
            return new PerceptionCountFunction(conditions, count, chance, increment);
        }
    }
}

