/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.recipe.EncyclopediaRecipe;
import frostnox.nightfall.data.recipe.IRenderableRecipe;
import frostnox.nightfall.util.LevelUtil;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BarrelRecipe
extends EncyclopediaRecipe<RecipeWrapper>
implements IRenderableRecipe {
    public static final RecipeType<BarrelRecipe> TYPE = RecipeType.m_44119_((String)"nightfall:barrel");
    public static final Serializer SERIALIZER = new Serializer();
    public static final ResourceLocation RECIPE_VIEWER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/screen/recipe_barrel.png");
    private final NonNullList<Ingredient> input;
    private final ItemStack output;
    private final int soakTime;
    private final boolean fixedSoakTime;

    public BarrelRecipe(ResourceLocation id, ResourceLocation requirementId, NonNullList<Ingredient> input, ItemStack output, int soakTime, boolean fixedSoakTime) {
        super(id, requirementId);
        this.input = input;
        this.output = output;
        this.soakTime = soakTime;
        this.fixedSoakTime = fixedSoakTime;
    }

    public boolean hasFixedSoakTime() {
        return this.fixedSoakTime;
    }

    public int getSoakTime() {
        return this.soakTime;
    }

    public boolean matches(RecipeWrapper container, Level level) {
        if (!super.m_5818_(container, level) || container.m_7983_()) {
            return false;
        }
        IntArraySet matchingIngredients = new IntArraySet(this.input.size());
        IntArraySet[] sets = new IntArraySet[container.m_6643_()];
        for (int i = 0; i < sets.length; ++i) {
            sets[i] = new IntArraySet(this.input.size());
        }
        int inputSize = 0;
        for (int j = 0; j < container.m_6643_(); ++j) {
            ItemStack item = container.m_8020_(j);
            if (item.m_41619_()) continue;
            if (inputSize == 0) {
                inputSize = item.m_41613_();
            } else if (item.m_41613_() != inputSize) {
                return false;
            }
            for (int i = 0; i < this.input.size(); ++i) {
                Ingredient ingredient = (Ingredient)this.input.get(i);
                if (!ingredient.test(item)) continue;
                sets[j].add(i);
                matchingIngredients.add(i);
            }
            if (!sets[j].isEmpty()) continue;
            return false;
        }
        if (matchingIngredients.size() != this.input.size()) {
            return false;
        }
        Object2IntArrayMap setCounts = new Object2IntArrayMap(sets.length);
        for (int j = 0; j < sets.length; ++j) {
            if (sets[j].isEmpty()) continue;
            setCounts.merge(sets[j], 1, Integer::sum);
        }
        for (Map.Entry entry : setCounts.entrySet()) {
            if ((Integer)entry.getValue() <= ((IntSet)entry.getKey()).size()) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(RecipeWrapper container) {
        int inputSize = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (item.m_41619_()) continue;
            inputSize = item.m_41613_();
            break;
        }
        return new ItemStack((ItemLike)this.output.m_41720_(), this.output.m_41613_() * inputSize);
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= this.input.size();
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.input;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    @Override
    public void render(PoseStack poseStack, Screen screen, int mouseX, int mouseY, float partial, int xOffset, int yOffset) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RECIPE_VIEWER_LOCATION);
        int x = 9;
        int y = 6;
        int u = 38;
        int height = 18;
        switch (this.input.size()) {
            case 1: {
                y += 27;
                break;
            }
            case 2: {
                y += 18;
                u += 18;
                height += 18;
                break;
            }
            case 3: {
                y += 9;
                u += 36;
                height += 36;
                break;
            }
            default: {
                u += 54;
                height += 54;
            }
        }
        Screen.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)u, (float)0.0f, (int)18, (int)height, (int)122, (int)81);
        Screen.m_93133_((PoseStack)poseStack, (int)30, (int)32, (float)0.0f, (float)0.0f, (int)37, (int)20, (int)122, (int)81);
        x += 1 + xOffset;
        y += 1 + yOffset;
        for (Ingredient ingredient : this.input) {
            ItemStack item = LevelUtil.chooseUnlockedIngredient(ingredient, ClientEngine.get().getPlayer());
            Minecraft.m_91087_().m_91291_().m_115203_(item, x, y);
            if (this.onItem(x, y, mouseX, mouseY)) {
                screen.m_169388_(poseStack, screen.m_96555_(item), item.m_150921_(), mouseX - xOffset, mouseY - yOffset);
            }
            y += 18;
        }
        x = xOffset + 50;
        y = yOffset + 34;
        Minecraft.m_91087_().m_91291_().m_115203_(this.output, x, y);
        Minecraft.m_91087_().m_91291_().m_115169_(Minecraft.m_91087_().f_91062_, this.output, x, y);
        if (this.onItem(x, y, mouseX, mouseY)) {
            screen.m_169388_(poseStack, screen.m_96555_(this.output), this.output.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
    }

    @Override
    public ItemStack clickItem(Screen screen, int mouseX, int mouseY) {
        int x = 10;
        int y = 7;
        switch (this.input.size()) {
            case 1: {
                y += 27;
                break;
            }
            case 2: {
                y += 18;
                break;
            }
            case 3: {
                y += 9;
            }
        }
        for (Ingredient ingredient : this.input) {
            if (this.onItem(x, y, mouseX, mouseY)) {
                return LevelUtil.chooseUnlockedIngredient(ingredient, ClientEngine.get().getPlayer());
            }
            y += 18;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public TranslatableComponent getTitle() {
        return new TranslatableComponent("nightfall.barrel");
    }

    @Override
    public boolean showInRecipeViewer() {
        return this.getRequirementId() != null;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<BarrelRecipe> {
        Serializer() {
            this.setRegistryName(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"barrel"));
        }

        public BarrelRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonArray inputJson = GsonHelper.m_13933_((JsonObject)json, (String)"input");
            Object[] ingredients = new Ingredient[inputJson.size()];
            for (int i = 0; i < inputJson.size(); ++i) {
                ingredients[i] = Ingredient.m_43917_((JsonElement)inputJson.getAsJsonArray().get(i));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            int soakTime = GsonHelper.m_13824_((JsonObject)json, (String)"soakTime", (int)0);
            boolean fixedSoakTime = GsonHelper.m_13855_((JsonObject)json, (String)"fixedSoakTime", (boolean)false);
            ResourceLocation requirement = json.has("requirement") ? ResourceLocation.parse((String)json.get("requirement").getAsString()) : null;
            return new BarrelRecipe(id, requirement, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients), output, soakTime, fixedSoakTime);
        }

        public BarrelRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int inputSize = buf.m_130242_();
            Object[] ingredients = new Ingredient[inputSize];
            for (int i = 0; i < inputSize; ++i) {
                ingredients[i] = Ingredient.m_43940_((FriendlyByteBuf)buf);
            }
            ResourceLocation requirement = buf.m_130281_();
            return new BarrelRecipe(id, requirement.m_135815_().equals("empty") ? null : requirement, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients), buf.m_130267_(), buf.m_130242_(), buf.readBoolean());
        }

        public void toNetwork(FriendlyByteBuf buf, BarrelRecipe recipe) {
            buf.m_130130_(recipe.input.size());
            for (Ingredient ingredient : recipe.input) {
                ingredient.m_43923_(buf);
            }
            buf.m_130085_(recipe.getRequirementId() == null ? ResourceLocation.parse((String)"empty") : recipe.getRequirementId());
            buf.m_130055_(recipe.output);
            buf.m_130130_(recipe.soakTime);
            buf.writeBoolean(recipe.fixedSoakTime);
        }
    }
}

