/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.recipe.EncyclopediaRecipe;
import frostnox.nightfall.data.recipe.IRenderableRecipe;
import frostnox.nightfall.util.LevelUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BuildingRecipe
extends EncyclopediaRecipe<RecipeWrapper>
implements IRenderableRecipe {
    public static final RecipeType<BuildingRecipe> TYPE = RecipeType.m_44119_((String)"nightfall:building");
    public static final Serializer SERIALIZER = new Serializer();
    public static final ResourceLocation RECIPE_VIEWER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/screen/recipe_building.png");
    private final String group;
    public final Item baseItem;
    public final Ingredient extraIngredient;
    public final int baseAmount;
    public final int extraAmount;
    public final int menuOrder;
    public final Item output;
    private final ItemStack baseItemStack;
    private final ItemStack outputStack;

    public BuildingRecipe(ResourceLocation id, ResourceLocation requirementId, String group, Item baseItem, Ingredient extraIngredient, int baseAmount, int extraAmount, int menuOrder, Item output) {
        super(id, requirementId);
        this.group = group;
        this.baseItem = baseItem;
        this.extraIngredient = extraIngredient;
        this.baseAmount = baseAmount;
        this.extraAmount = extraAmount;
        this.menuOrder = menuOrder;
        this.output = output;
        this.baseItemStack = new ItemStack((ItemLike)baseItem, baseAmount);
        this.outputStack = new ItemStack((ItemLike)output);
    }

    public boolean hasExtraIngredient() {
        return this.extraAmount > 0;
    }

    public boolean matches(RecipeWrapper inventory, Level level) {
        IPlayerData capP;
        ItemStack heldItem;
        Player player;
        if (super.m_5818_(inventory, level) && (player = ForgeHooks.getCraftingPlayer()) != null && (heldItem = player.m_21120_((capP = PlayerData.get(player)).getActiveHand())).m_150930_(this.baseItem) && heldItem.m_41613_() >= this.baseAmount) {
            if (this.hasExtraIngredient()) {
                for (int i = 0; i < inventory.m_6643_(); ++i) {
                    ItemStack item = inventory.m_8020_(i);
                    if (!this.extraIngredient.test(item) || item.m_41613_() < this.extraAmount) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public ItemStack assemble(RecipeWrapper inventory) {
        return new ItemStack((ItemLike)this.output);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public String m_6076_() {
        return this.group;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.baseItem}));
        if (this.hasExtraIngredient()) {
            list.add((Object)this.extraIngredient);
        }
        return list;
    }

    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.output);
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public static Item itemFromJson(JsonObject pItemObject, String name) {
        String s = GsonHelper.m_13906_((JsonObject)pItemObject, (String)name);
        Item item = (Item)Registry.f_122827_.m_6612_(ResourceLocation.parse((String)s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + s);
        }
        return item;
    }

    @Override
    public void render(PoseStack poseStack, Screen screen, int mouseX, int mouseY, float partial, int xOffset, int yOffset) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RECIPE_VIEWER_LOCATION);
        Screen.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)26, (int)81, (int)122, (int)81);
        if (this.hasExtraIngredient()) {
            Screen.m_93133_((PoseStack)poseStack, (int)26, (int)34, (float)8.0f, (float)34.0f, (int)18, (int)18, (int)122, (int)81);
            Screen.m_93133_((PoseStack)poseStack, (int)44, (int)0, (float)26.0f, (float)0.0f, (int)78, (int)81, (int)122, (int)81);
        } else {
            Screen.m_93133_((PoseStack)poseStack, (int)26, (int)0, (float)26.0f, (float)0.0f, (int)96, (int)81, (int)122, (int)81);
        }
        int x = xOffset + 10;
        int y = yOffset + 34;
        Minecraft.m_91087_().m_91291_().m_115203_(this.baseItemStack, x, y);
        Minecraft.m_91087_().m_91291_().m_115169_(Minecraft.m_91087_().f_91062_, this.baseItemStack, x, y);
        if (this.onItem(x, y, mouseX, mouseY)) {
            screen.m_169388_(poseStack, screen.m_96555_(this.baseItemStack), this.baseItemStack.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
        if (this.hasExtraIngredient()) {
            ItemStack extraItem = LevelUtil.chooseUnlockedIngredient(this.extraIngredient, ClientEngine.get().getPlayer());
            extraItem.m_41764_(this.extraAmount);
            Minecraft.m_91087_().m_91291_().m_115203_(extraItem, x += 18, y);
            Minecraft.m_91087_().m_91291_().m_115169_(Minecraft.m_91087_().f_91062_, extraItem, x, y);
            if (this.onItem(x, y, mouseX, mouseY)) {
                screen.m_169388_(poseStack, screen.m_96555_(extraItem), extraItem.m_150921_(), mouseX - xOffset, mouseY - yOffset);
            }
        }
        Minecraft.m_91087_().m_91291_().m_115203_(this.outputStack, x += 40, y);
        if (this.onItem(x, y, mouseX, mouseY)) {
            screen.m_169388_(poseStack, screen.m_96555_(this.outputStack), this.outputStack.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
    }

    @Override
    public ItemStack clickItem(Screen screen, int mouseX, int mouseY) {
        int x = 10;
        int y = 34;
        if (this.onItem(x, y, mouseX, mouseY)) {
            return this.baseItemStack;
        }
        if (this.hasExtraIngredient() && this.onItem(x += 18, y, mouseX, mouseY)) {
            return LevelUtil.chooseUnlockedIngredient(this.extraIngredient, ClientEngine.get().getPlayer());
        }
        return ItemStack.f_41583_;
    }

    @Override
    public TranslatableComponent getTitle() {
        return new TranslatableComponent("nightfall.building");
    }

    @Override
    public boolean showInRecipeViewer() {
        return this.getRequirementId() != null;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<BuildingRecipe> {
        Serializer() {
            this.setRegistryName(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"building"));
        }

        public BuildingRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"type", (String)"");
            ResourceLocation requirement = null;
            if (json.has("requirement")) {
                requirement = ResourceLocation.parse((String)json.get("requirement").getAsString());
            }
            Item baseItem = ShapedRecipe.m_151278_((JsonObject)json);
            int baseAmount = GsonHelper.m_13927_((JsonObject)json, (String)"baseAmount");
            int extraAmount = GsonHelper.m_13824_((JsonObject)json, (String)"extraAmount", (int)0);
            Ingredient extraIngredient = extraAmount > 0 ? Ingredient.m_43917_((JsonElement)json.get("extraIngredient")) : null;
            Item output = BuildingRecipe.itemFromJson(json, "outputItem");
            int menuOrder = GsonHelper.m_13824_((JsonObject)json, (String)"menuOrder", (int)-1);
            if (baseAmount < 1) {
                throw new IllegalStateException("Base ingredient amount is less than 1 for building recipe " + id);
            }
            return new BuildingRecipe(id, requirement, group, baseItem, extraIngredient, baseAmount, extraAmount, menuOrder, output);
        }

        public BuildingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            ResourceLocation requirement = buf.m_130281_();
            int baseAmount = buf.m_130242_();
            ResourceLocation itemLoc = buf.m_130281_();
            Item baseItem = (Item)Registry.f_122827_.m_6612_(itemLoc).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + itemLoc + "'"));
            int extraAmount = buf.m_130242_();
            Ingredient extraIngredient = extraAmount > 0 ? Ingredient.m_43940_((FriendlyByteBuf)buf) : null;
            ResourceLocation outputLoc = buf.m_130281_();
            Item output = (Item)Registry.f_122827_.m_6612_(outputLoc).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + outputLoc + "'"));
            int menuOrder = buf.m_130242_();
            return new BuildingRecipe(id, requirement.m_135815_().equals("empty") ? null : requirement, group, baseItem, extraIngredient, baseAmount, extraAmount, menuOrder, output);
        }

        public void toNetwork(FriendlyByteBuf buf, BuildingRecipe recipe) {
            buf.m_130070_(recipe.m_6076_());
            buf.m_130085_(recipe.getRequirementId() == null ? ResourceLocation.parse((String)"empty") : recipe.getRequirementId());
            buf.m_130130_(recipe.baseAmount);
            buf.m_130085_(recipe.baseItem.getRegistryName());
            buf.m_130130_(recipe.extraAmount);
            if (recipe.extraAmount > 0) {
                recipe.extraIngredient.m_43923_(buf);
            }
            buf.m_130085_(recipe.output.getRegistryName());
            buf.m_130130_(recipe.menuOrder);
        }
    }
}

