/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe;

import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.FlatMixtureRecipe;
import frostnox.nightfall.data.recipe.MixtureRecipe;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.RenderUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import oshi.util.tuples.Pair;

public class CauldronRecipe
extends FlatMixtureRecipe {
    public static final int COOK_TIME = 3000;
    public static final RecipeType<CauldronRecipe> TYPE = RecipeType.m_44119_((String)"nightfall:cauldron");
    public static final MixtureRecipe.Serializer<CauldronRecipe> SERIALIZER = new MixtureRecipe.Serializer<CauldronRecipe>(CauldronRecipe::new, "cauldron");
    public static final TranslatableComponent UNIT = new TranslatableComponent("nightfall.cauldron.unit");
    public static final TranslatableComponent UNITS = new TranslatableComponent("nightfall.cauldron.units");
    public static final String MIN_PHRASE = "nightfall.cauldron.min_phrase";
    public static final String MAX_PHRASE = "nightfall.cauldron.max_phrase";
    public static final String RANGE_PHRASE = "nightfall.cauldron.range_phrase";

    public CauldronRecipe(ResourceLocation id, ResourceLocation requirement, NonNullList<Pair<Ingredient, Vec2>> input, ItemStack itemOutput, FluidStack fluidOutput, int unitsPerOutput, int cookTime) {
        super(id, requirement, input, itemOutput, fluidOutput, unitsPerOutput, cookTime);
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    @Override
    public void render(PoseStack poseStack, Screen screen, int mouseX, int mouseY, float partial, int xOffset, int yOffset) {
        int x = 4;
        int y = 15;
        Font font = Minecraft.m_91087_().f_91062_;
        if (!this.itemOutput.m_41619_()) {
            Component outputText = this.itemOutput.m_41786_();
            if (outputText instanceof MutableComponent) {
                MutableComponent mutableText = (MutableComponent)outputText;
                mutableText.m_6270_(outputText.m_7383_().m_131157_(ChatFormatting.UNDERLINE));
            }
            font.m_92889_(poseStack, outputText, (float)x, (float)y, 3420462);
        }
        y += 15;
        poseStack.m_85841_(0.85714287f, 0.875f, 1.0f);
        for (Pair part : this.input) {
            boolean multiple;
            TranslatableComponent text;
            Ingredient ingredient = (Ingredient)part.getA();
            Vec2 range = (Vec2)part.getB();
            if (range.f_82471_ == 0.0f) continue;
            if (range.f_82470_ == 0.0f) {
                text = new TranslatableComponent(MAX_PHRASE, new Object[]{(int)range.f_82471_});
                multiple = range.f_82471_ > 1.0f;
            } else if (range.f_82471_ == Float.MAX_VALUE) {
                text = new TranslatableComponent(MIN_PHRASE, new Object[]{(int)range.f_82470_});
                multiple = range.f_82470_ > 1.0f;
            } else if (range.f_82470_ == range.f_82471_) {
                text = new TextComponent((int)range.f_82470_ + " ");
                multiple = range.f_82470_ > 1.0f;
            } else {
                text = new TranslatableComponent(RANGE_PHRASE, new Object[]{(int)range.f_82470_, (int)range.f_82471_});
                multiple = true;
            }
            font.m_92889_(poseStack, (Component)text, (float)x, (float)y, 3420462);
            int xOff = font.m_92724_(text.m_7532_());
            if (multiple) {
                font.m_92889_(poseStack, (Component)UNITS, (float)(x + xOff), (float)y, 3420462);
                xOff += font.m_92852_((FormattedText)UNITS);
            } else {
                font.m_92889_(poseStack, (Component)UNIT, (float)(x + xOff), (float)y, 3420462);
                xOff += font.m_92852_((FormattedText)UNIT);
            }
            xOff += font.m_92895_(" ");
            Component itemText = null;
            for (int i = 0; i < TagsNF.FOOD_GROUPS.size(); ++i) {
                boolean match = true;
                ITag tag = ForgeRegistries.ITEMS.tags().getTag(TagsNF.FOOD_GROUPS.get(i));
                for (ItemStack item : ingredient.m_43908_()) {
                    if (tag.contains((Object)item.m_41720_())) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                itemText = (Component)RenderUtil.FOOD_GROUPS_TEXT.get(i);
                break;
            }
            if (itemText == null) {
                itemText = LevelUtil.chooseUnlockedIngredient(ingredient, ClientEngine.get().getPlayer()).m_41786_();
            }
            font.m_92889_(poseStack, itemText, (float)(x + xOff), (float)y, 3420462);
            poseStack.m_85837_(0.0, 10.0, 0.0);
        }
    }

    @Override
    public ItemStack clickItem(Screen screen, int mouseX, int mouseY) {
        return ItemStack.f_41583_;
    }

    @Override
    public TranslatableComponent getTitle() {
        return new TranslatableComponent("nightfall.cauldron");
    }
}

