/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.recipe.EncyclopediaRecipe;
import frostnox.nightfall.data.recipe.IRenderableRecipe;
import frostnox.nightfall.util.LevelUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CraftingRecipeNF
extends EncyclopediaRecipe<CraftingContainer>
implements CraftingRecipe,
IShapedRecipe<CraftingContainer>,
IRenderableRecipe {
    public static RecipeType<CraftingRecipeNF> TYPE = RecipeType.m_44119_((String)"nightfall:crafting");
    public static final Serializer SERIALIZER = new Serializer();
    public static final ResourceLocation RECIPE_VIEWER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/screen/recipe_crafting.png");
    private final NonNullList<Ingredient> input;
    private final ItemStack output;
    private final int width;
    private final int height;

    public CraftingRecipeNF(ResourceLocation id, int width, int height, NonNullList<Ingredient> input, ItemStack output, ResourceLocation requirement) {
        super(id, requirement);
        this.width = width;
        this.height = height;
        this.input = input;
        this.output = output;
    }

    public boolean matches(CraftingContainer inventory, Level level) {
        if (super.m_5818_(inventory, level)) {
            for (int i = 0; i <= 3 - this.width; ++i) {
                for (int j = 0; j <= 3 - this.height; ++j) {
                    if (this.matches(inventory, i, j, true)) {
                        return true;
                    }
                    if (!this.matches(inventory, i, j, false)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer inventory, int p_44172_, int p_44173_, boolean p_44174_) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i - p_44172_;
                int l = j - p_44173_;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = p_44174_ ? (Ingredient)this.input.get(this.width - k - 1 + l * this.width) : (Ingredient)this.input.get(k + l * this.width);
                }
                if (ingredient.test(inventory.m_8020_(i + j * 3))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inventory) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.input;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        return NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
    }

    @Override
    public void render(PoseStack poseStack, Screen screen, int mouseX, int mouseY, float partial, int xOffset, int yOffset) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RECIPE_VIEWER_LOCATION);
        Screen.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)122, (int)81, (int)122, (int)81);
        int xPos = xOffset + 10;
        int yPos = yOffset + 16;
        for (int i = 0; i < this.input.size(); ++i) {
            if (((Ingredient)this.input.get(i)).m_43947_()) continue;
            int x = xPos + i % this.width * 18;
            int y = yPos + i / this.width * 18;
            ItemStack item = LevelUtil.chooseUnlockedIngredient((Ingredient)this.input.get(i), ClientEngine.get().getPlayer());
            Minecraft.m_91087_().m_91291_().m_115203_(item, x, y);
            if (!this.onItem(x, y, mouseX, mouseY)) continue;
            screen.m_169388_(poseStack, screen.m_96555_(item), item.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
        Minecraft.m_91087_().m_91291_().m_115203_(this.output, xOffset + 86, yOffset + 34);
        if (this.onItem(xOffset + 86, yOffset + 34, mouseX, mouseY)) {
            screen.m_169388_(poseStack, screen.m_96555_(this.output), this.output.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
    }

    @Override
    public ItemStack clickItem(Screen screen, int mouseX, int mouseY) {
        int xPos = 10;
        int yPos = 16;
        for (int i = 0; i < this.input.size(); ++i) {
            int y;
            int x;
            if (((Ingredient)this.input.get(i)).m_43947_() || !this.onItem(x = xPos + i % this.width * 18, y = yPos + i / this.width * 18, mouseX, mouseY)) continue;
            return LevelUtil.chooseUnlockedIngredient((Ingredient)this.input.get(i), ClientEngine.get().getPlayer());
        }
        return ItemStack.f_41583_;
    }

    @Override
    public TranslatableComponent getTitle() {
        return new TranslatableComponent("container.crafting");
    }

    @Override
    public boolean showInRecipeViewer() {
        return this.getRequirementId() != null;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<CraftingRecipeNF> {
        Serializer() {
            this.setRegistryName(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"crafting"));
        }

        public CraftingRecipeNF fromJson(ResourceLocation id, JsonObject json) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry entry : GsonHelper.m_13930_((JsonObject)json, (String)"key").entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
            }
            map.put(" ", Ingredient.f_43901_);
            JsonArray patterns = GsonHelper.m_13933_((JsonObject)json, (String)"pattern");
            String[] patternsString = new String[patterns.size()];
            if (patternsString.length > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
            }
            if (patternsString.length == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            for (int i = 0; i < patternsString.length; ++i) {
                String s = GsonHelper.m_13805_((JsonElement)patterns.get(i), (String)("pattern[" + i + "]"));
                if (s.length() > 3) {
                    throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
                }
                if (i > 0 && patternsString[0].length() != s.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
                }
                patternsString[i] = s;
            }
            int width = patternsString[0].length();
            int height = patternsString.length;
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            HashSet keys = Sets.newHashSet(map.keySet());
            keys.remove(" ");
            for (int m = 0; m < patternsString.length; ++m) {
                for (int n = 0; n < patternsString[m].length(); ++n) {
                    String s = patternsString[m].substring(n, n + 1);
                    Ingredient ingredient = (Ingredient)map.get(s);
                    if (ingredient == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                    }
                    keys.remove(s);
                    ingredients.set(n + width * m, (Object)ingredient);
                }
            }
            if (!keys.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            ResourceLocation requirement = null;
            if (json.has("requirement")) {
                requirement = ResourceLocation.parse((String)json.get("requirement").getAsString());
            }
            return new CraftingRecipeNF(id, width, height, (NonNullList<Ingredient>)ingredients, result, requirement);
        }

        public CraftingRecipeNF fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int width = buf.m_130242_();
            int height = buf.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            ResourceLocation requirementId = buf.m_130281_();
            return new CraftingRecipeNF(id, width, height, (NonNullList<Ingredient>)ingredients, result, requirementId.m_135815_().equals("empty") ? null : requirementId);
        }

        public void toNetwork(FriendlyByteBuf buf, CraftingRecipeNF recipe) {
            buf.m_130130_(recipe.getRecipeWidth());
            buf.m_130130_(recipe.getRecipeHeight());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_());
            buf.m_130085_(recipe.getRequirementId() == null ? ResourceLocation.parse((String)"empty") : recipe.getRequirementId());
        }
    }
}

