/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe;

import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.data.recipe.IEncyclopediaRecipe;
import frostnox.nightfall.encyclopedia.EntryStage;
import frostnox.nightfall.registry.RegistriesNF;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public abstract class EncyclopediaRecipe<T extends Container>
implements Recipe<T>,
IEncyclopediaRecipe {
    private final ResourceLocation id;
    private final ResourceLocation requirementId;

    public EncyclopediaRecipe(ResourceLocation id, ResourceLocation requirementId) {
        this.id = id;
        this.requirementId = requirementId;
    }

    public boolean m_5818_(T pContainer, Level level) {
        return this.isUnlocked(ForgeHooks.getCraftingPlayer());
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public ResourceLocation getRequirementId() {
        return this.requirementId;
    }

    @Override
    public NonNullList<Ingredient> getUnlockIngredients() {
        return this.m_7527_();
    }

    @Override
    public boolean isUnlocked(@Nullable Player player) {
        if (player == null) {
            return true;
        }
        IPlayerData capP = PlayerData.get(player);
        if (this.requirementId == null || (RegistriesNF.getEntries().containsKey(this.requirementId) ? capP.hasEntryStage(this.requirementId, EntryStage.COMPLETED) : capP.hasKnowledge(this.requirementId))) {
            for (Ingredient ingredient : this.getUnlockIngredients()) {
                if (ingredient.m_43947_()) continue;
                boolean hasAny = false;
                for (ItemStack item : ingredient.m_43908_()) {
                    ResourceLocation location = ResourceLocation.parse((String)(item.m_41720_().getRegistryName().toString() + "_item"));
                    if (RegistriesNF.getKnowledge().containsKey(location) && !capP.hasKnowledge(location)) continue;
                    hasAny = true;
                    break;
                }
                if (hasAny) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

