/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.EncyclopediaRecipe;
import frostnox.nightfall.data.recipe.IRenderableRecipe;
import frostnox.nightfall.util.DataUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import oshi.util.tuples.Pair;

public abstract class MixtureRecipe
extends EncyclopediaRecipe<RecipeWrapper>
implements Recipe<RecipeWrapper>,
IRenderableRecipe {
    protected final NonNullList<Pair<Ingredient, Vec2>> input;
    protected final ItemStack itemOutput;
    protected final FluidStack fluidOutput;
    protected final int unitsPerOutput;
    protected final int cookTime;

    protected MixtureRecipe(ResourceLocation id, ResourceLocation requirement, NonNullList<Pair<Ingredient, Vec2>> input, ItemStack itemOutput, FluidStack fluidOutput, int unitsPerOutput, int cookTime) {
        super(id, requirement);
        this.input = input;
        this.itemOutput = itemOutput;
        this.fluidOutput = fluidOutput;
        this.unitsPerOutput = unitsPerOutput;
        this.cookTime = cookTime;
    }

    public abstract ItemStack assembleItem(@Nullable RecipeWrapper var1, @Nullable List<FluidStack> var2);

    public abstract FluidStack assembleFluid(@Nullable RecipeWrapper var1, @Nullable List<FluidStack> var2);

    public FluidStack getResultFluid() {
        return this.fluidOutput.copy();
    }

    public NonNullList<Pair<Ingredient, Vec2>> getInput() {
        return this.input;
    }

    public int getUnitsPerOutput() {
        return this.unitsPerOutput;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public float getTemperature() {
        if (!this.fluidOutput.isEmpty() && !this.itemOutput.m_41619_()) {
            return Math.max((float)this.fluidOutput.getRawFluid().getAttributes().getTemperature(), TieredHeat.getMinimumTemp(this.itemOutput));
        }
        if (!this.itemOutput.m_41619_()) {
            return TieredHeat.getMinimumTemp(this.itemOutput);
        }
        return this.fluidOutput.getRawFluid().getAttributes().getTemperature();
    }

    public ItemStack assemble(RecipeWrapper inventory) {
        return this.itemOutput.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height <= this.input.size();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < this.input.size(); ++i) {
            ingredients.add((Object)((Ingredient)((Pair)this.input.get(i)).getA()));
        }
        return ingredients;
    }

    public ItemStack m_8043_() {
        return this.itemOutput.m_41777_();
    }

    @Override
    public boolean showInRecipeViewer() {
        return this.getRequirementId() != null;
    }

    public static int getUnitsOf(ItemStack stack) {
        if (stack.m_204117_(TagsNF.MIXTURE_INGREDIENT)) {
            int sum = 0;
            if (stack.m_204117_(TagsNF.MIXTURE_1)) {
                ++sum;
            }
            if (stack.m_204117_(TagsNF.MIXTURE_2)) {
                sum += 2;
            }
            if (stack.m_204117_(TagsNF.MIXTURE_3)) {
                sum += 3;
            }
            if (stack.m_204117_(TagsNF.MIXTURE_4)) {
                sum += 4;
            }
            if (stack.m_204117_(TagsNF.MIXTURE_5)) {
                sum += 5;
            }
            if (stack.m_204117_(TagsNF.MIXTURE_10)) {
                sum += 10;
            }
            if (stack.m_204117_(TagsNF.MIXTURE_20)) {
                sum += 20;
            }
            if (stack.m_204117_(TagsNF.MIXTURE_30)) {
                sum += 30;
            }
            if (stack.m_204117_(TagsNF.MIXTURE_40)) {
                sum += 40;
            }
            if (stack.m_204117_(TagsNF.MIXTURE_50)) {
                sum += 50;
            }
            if (stack.m_204117_(TagsNF.MIXTURE_100)) {
                sum += 100;
            }
            return Math.max(1, sum) * stack.m_41613_();
        }
        return stack.m_41613_();
    }

    public static class Serializer<T extends MixtureRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        private final Factory<T> factory;

        Serializer(Factory<T> factory, String name) {
            this.factory = factory;
            this.setRegistryName(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)name));
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            NonNullList inputs = NonNullList.m_122779_();
            JsonArray input = GsonHelper.m_13933_((JsonObject)json, (String)"input");
            for (int i = 0; i < input.size(); i += 3) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)input.getAsJsonArray().get(i));
                float min = input.get(i + 1).getAsFloat();
                float max = input.get(i + 2).getAsFloat();
                if (ingredient.m_43947_()) continue;
                inputs.add((Object)new Pair((Object)ingredient, (Object)new Vec2(min, max)));
            }
            if (inputs.isEmpty()) {
                throw new JsonSyntaxException("No ingredients defined for mixture recipe.");
            }
            ItemStack itemResult = json.has("itemResult") ? ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"itemResult")) : ItemStack.f_41583_;
            FluidStack fluidResult = json.has("fluidResult") ? DataUtil.fluidStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"fluidResult")) : FluidStack.EMPTY;
            int unitsPerOutput = GsonHelper.m_13824_((JsonObject)json, (String)"units", (int)1);
            int cookTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookTime", (int)1);
            ResourceLocation requirement = null;
            if (json.has("requirement")) {
                requirement = ResourceLocation.parse((String)json.get("requirement").getAsString());
            }
            return this.factory.create(id, requirement, (NonNullList<Pair<Ingredient, Vec2>>)inputs, itemResult, fluidResult, unitsPerOutput, cookTime);
        }

        public T fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ResourceLocation requirement = buf.m_130281_();
            int ingredientsAmount = buf.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientsAmount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            NonNullList ranges = NonNullList.m_122780_((int)ingredientsAmount, (Object)Vec2.f_82462_);
            for (int i = 0; i < ranges.size(); ++i) {
                ranges.set(i, (Object)new Vec2(buf.readFloat(), buf.readFloat()));
            }
            NonNullList inputs = NonNullList.m_182647_((int)ingredientsAmount);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.add(i, (Object)new Pair((Object)((Ingredient)ingredients.get(i)), (Object)((Vec2)ranges.get(i))));
            }
            ItemStack item = buf.m_130267_();
            FluidStack fluid = buf.readFluidStack();
            int unitsPerOutput = buf.m_130242_();
            int cookTime = buf.m_130242_();
            return this.factory.create(id, requirement.m_135815_().equals("empty") ? null : requirement, (NonNullList<Pair<Ingredient, Vec2>>)inputs, item, fluid, unitsPerOutput, cookTime);
        }

        public void toNetwork(FriendlyByteBuf buf, T recipe) {
            buf.m_130085_(((EncyclopediaRecipe)recipe).getRequirementId() == null ? ResourceLocation.parse((String)"empty") : ((EncyclopediaRecipe)recipe).getRequirementId());
            buf.m_130130_(((MixtureRecipe)recipe).input.size());
            for (Ingredient ingredient : ((MixtureRecipe)recipe).m_7527_()) {
                ingredient.m_43923_(buf);
            }
            for (int i = 0; i < ((MixtureRecipe)recipe).input.size(); ++i) {
                Vec2 range = (Vec2)((Pair)((MixtureRecipe)recipe).input.get(i)).getB();
                buf.writeFloat(range.f_82470_);
                buf.writeFloat(range.f_82471_);
            }
            buf.m_130055_(((MixtureRecipe)recipe).m_8043_());
            buf.writeFluidStack(((MixtureRecipe)recipe).getResultFluid());
            buf.m_130130_(((MixtureRecipe)recipe).getUnitsPerOutput());
            buf.m_130130_(((MixtureRecipe)recipe).getCookTime());
        }

        static interface Factory<T extends MixtureRecipe> {
            public T create(ResourceLocation var1, ResourceLocation var2, NonNullList<Pair<Ingredient, Vec2>> var3, ItemStack var4, FluidStack var5, int var6, int var7);
        }
    }
}

