/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe;

import frostnox.nightfall.data.recipe.MixtureRecipe;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import oshi.util.tuples.Pair;

public abstract class PercentageMixtureRecipe
extends MixtureRecipe {
    protected PercentageMixtureRecipe(ResourceLocation id, ResourceLocation requirement, NonNullList<Pair<Ingredient, Vec2>> input, ItemStack itemOutput, FluidStack fluidOutput, int unitsPerOutput, int cookTime) {
        super(id, requirement, input, itemOutput, fluidOutput, unitsPerOutput, cookTime);
    }

    public boolean matches(RecipeWrapper inventory, Level level) {
        if (!super.m_5818_(inventory, level)) {
            return false;
        }
        HashMap<Ingredient, Integer> amounts = new HashMap<Ingredient, Integer>();
        int totalAmount = 0;
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack stack = inventory.m_8020_(j);
            if (stack.m_41619_()) continue;
            boolean found = false;
            for (int i = 0; i < this.input.size(); ++i) {
                Ingredient ingredient = (Ingredient)((Pair)this.input.get(i)).getA();
                if (!ingredient.test(stack)) continue;
                found = true;
                totalAmount += PercentageMixtureRecipe.getUnitsOf(stack);
                if (amounts.containsKey(ingredient)) {
                    amounts.put(ingredient, (Integer)amounts.get(ingredient) + stack.m_41613_());
                    continue;
                }
                amounts.put(ingredient, stack.m_41613_());
            }
            if (found) continue;
            return false;
        }
        for (int i = 0; i < this.input.size(); ++i) {
            Ingredient ingredient = (Ingredient)((Pair)this.input.get(i)).getA();
            if (amounts.containsKey(ingredient)) {
                float percentage = (float)((Integer)amounts.get(ingredient)).intValue() / (float)totalAmount;
                Vec2 range = (Vec2)((Pair)this.input.get(i)).getB();
                if (!(percentage < range.f_82470_) && !(percentage > range.f_82471_)) continue;
                return false;
            }
            if (!(((Vec2)((Pair)this.input.get((int)i)).getB()).f_82470_ > 0.0f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack assembleItem(@Nullable RecipeWrapper inventory, @Nullable List<FluidStack> fluids) {
        ItemStack item;
        int units = 0;
        if (inventory != null) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                units += PercentageMixtureRecipe.getUnitsOf(inventory.m_8020_(i));
            }
        }
        if (fluids != null) {
            for (FluidStack fluid : fluids) {
                units += fluid.getAmount();
            }
        }
        if (!(item = this.itemOutput.m_41777_()).m_41619_()) {
            item.m_41764_(units / this.unitsPerOutput);
        }
        return item;
    }

    @Override
    public FluidStack assembleFluid(@Nullable RecipeWrapper inventory, @Nullable List<FluidStack> fluids) {
        FluidStack fluid;
        int units = 0;
        if (inventory != null) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                units += PercentageMixtureRecipe.getUnitsOf(inventory.m_8020_(i));
            }
        }
        if (fluids != null) {
            for (FluidStack fluid2 : fluids) {
                units += fluid2.getAmount();
            }
        }
        if (!(fluid = this.fluidOutput.copy()).isEmpty()) {
            fluid.setAmount(units / this.unitsPerOutput);
        }
        return fluid;
    }
}

