/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.recipe.EncyclopediaRecipe;
import frostnox.nightfall.data.recipe.IRenderableRecipe;
import frostnox.nightfall.util.DataUtil;
import frostnox.nightfall.util.LevelUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class SingleRecipe
extends EncyclopediaRecipe<RecipeWrapper>
implements IRenderableRecipe {
    public static final ResourceLocation RECIPE_VIEWER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/screen/recipe_single.png");
    private final Ingredient input;
    private final ItemStack output;
    private final FluidStack fluidOutput;
    private final int cookTime;

    protected SingleRecipe(ResourceLocation id, ResourceLocation requirement, Ingredient input, ItemStack output, FluidStack fluidOutput, int cookTime) {
        super(id, requirement);
        this.input = input;
        this.output = output;
        this.fluidOutput = fluidOutput;
        this.cookTime = cookTime;
    }

    public boolean matches(RecipeWrapper inventory, Level level) {
        if (super.m_5818_(inventory, level)) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack item = inventory.m_8020_(i);
                if (!this.input.test(item)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack assemble(RecipeWrapper container) {
        int count = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            count += item.m_41613_();
        }
        return new ItemStack((ItemLike)this.output.m_41720_(), this.output.m_41613_() * count);
    }

    public FluidStack assembleFluid(RecipeWrapper container) {
        int count = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            count += item.m_41613_();
        }
        return new FluidStack(this.fluidOutput.getFluid(), this.fluidOutput.getAmount() * count);
    }

    public float getTemperature() {
        if (!this.fluidOutput.isEmpty() && !this.output.m_41619_()) {
            return Math.max((float)this.fluidOutput.getRawFluid().getAttributes().getTemperature(), TieredHeat.getMinimumTemp(this.output));
        }
        if (!this.output.m_41619_()) {
            return TieredHeat.getMinimumTemp(this.output);
        }
        return this.fluidOutput.getRawFluid().getAttributes().getTemperature();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth >= 1 && pHeight >= 1;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public FluidStack getResultFluid() {
        return this.fluidOutput.copy();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    public int getCookTime() {
        return this.cookTime;
    }

    @Override
    public boolean showInRecipeViewer() {
        return this.getRequirementId() != null;
    }

    @Override
    public void render(PoseStack poseStack, Screen screen, int mouseX, int mouseY, float partial, int xOffset, int yOffset) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RECIPE_VIEWER_LOCATION);
        Screen.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)26, (int)81, (int)122, (int)81);
        Screen.m_93133_((PoseStack)poseStack, (int)26, (int)0, (float)26.0f, (float)0.0f, (int)96, (int)81, (int)122, (int)81);
        int x = xOffset + 10;
        int y = yOffset + 34;
        ItemStack inputStack = LevelUtil.chooseUnlockedIngredient(this.input, ClientEngine.get().getPlayer());
        Minecraft.m_91087_().m_91291_().m_115203_(inputStack, x, y);
        if (this.onItem(x, y, mouseX, mouseY)) {
            screen.m_169388_(poseStack, screen.m_96555_(inputStack), inputStack.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
        Minecraft.m_91087_().m_91291_().m_115203_(this.output, x += 40, y);
        if (this.onItem(x, y, mouseX, mouseY)) {
            screen.m_169388_(poseStack, screen.m_96555_(this.output), this.output.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
    }

    @Override
    public ItemStack clickItem(Screen screen, int mouseX, int mouseY) {
        int x = 10;
        int y = 34;
        if (this.onItem(x, y, mouseX, mouseY)) {
            return LevelUtil.chooseUnlockedIngredient(this.input, ClientEngine.get().getPlayer());
        }
        return ItemStack.f_41583_;
    }

    public static class Serializer<T extends SingleRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        private final Factory<T> factory;

        Serializer(Factory<T> factory, String name) {
            this.factory = factory;
            this.setRegistryName(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)name));
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            ResourceLocation requirement = null;
            if (json.has("requirement")) {
                requirement = ResourceLocation.parse((String)json.get("requirement").getAsString());
            }
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            ItemStack output = json.has("output") ? ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output")) : ItemStack.f_41583_;
            FluidStack fluidOutput = json.has("fluidOutput") ? DataUtil.fluidStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"fluidOutput")) : FluidStack.EMPTY;
            int cookTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookTime", (int)0);
            return this.factory.create(id, requirement, input, output, fluidOutput, cookTime);
        }

        public T fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ResourceLocation requirement = buf.m_130281_();
            return this.factory.create(id, requirement.m_135815_().equals("empty") ? null : requirement, Ingredient.m_43940_((FriendlyByteBuf)buf), buf.m_130267_(), buf.readFluidStack(), buf.m_130242_());
        }

        public void toNetwork(FriendlyByteBuf buf, T recipe) {
            buf.m_130085_(((EncyclopediaRecipe)recipe).getRequirementId() == null ? ResourceLocation.parse((String)"empty") : ((EncyclopediaRecipe)recipe).getRequirementId());
            ((SingleRecipe)recipe).getInput().m_43923_(buf);
            buf.m_130055_(((SingleRecipe)recipe).m_8043_());
            buf.writeFluidStack(((SingleRecipe)recipe).getResultFluid());
            buf.m_130130_(((SingleRecipe)recipe).getCookTime());
        }

        static interface Factory<T extends SingleRecipe> {
            public T create(ResourceLocation var1, ResourceLocation var2, Ingredient var3, ItemStack var4, FluidStack var5, int var6);
        }
    }
}

