/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.recipe.EncyclopediaRecipe;
import frostnox.nightfall.data.recipe.IRenderableRecipe;
import frostnox.nightfall.util.LevelUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TieredAnvilRecipe
extends EncyclopediaRecipe<RecipeWrapper>
implements IRenderableRecipe {
    public static final RecipeType<TieredAnvilRecipe> TYPE = RecipeType.m_44119_((String)"nightfall:anvil");
    public static final Serializer SERIALIZER = new Serializer();
    public static final ResourceLocation RECIPE_VIEWER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/screen/recipe_tiered_anvil.png");
    private final int[][][] startShape;
    private final boolean[][][] finishShape;
    private final NonNullList<Ingredient> input;
    private final ItemStack output;
    private final int tier;
    private final int randMin;
    private final int randMax;
    private final float slagChance;

    public TieredAnvilRecipe(ResourceLocation id, ResourceLocation requirement, int[][][] startShape, boolean[][][] finishShape, NonNullList<Ingredient> input, ItemStack output, int tier, int randMin, int randMax, float slagChance) {
        super(id, requirement);
        this.startShape = startShape;
        this.finishShape = finishShape;
        this.input = input;
        this.output = output;
        this.tier = tier;
        this.randMin = randMin;
        this.randMax = randMax;
        this.slagChance = slagChance;
    }

    public int getTier() {
        return this.tier;
    }

    public int getRandMin() {
        return this.randMin;
    }

    public int getRandMax() {
        return this.randMax;
    }

    public float getSlagChance() {
        return this.slagChance;
    }

    public int[][][] getStartShape() {
        return this.startShape;
    }

    public boolean[][][] getFinishShape() {
        return this.finishShape;
    }

    public boolean matches(RecipeWrapper inventory, Level level) {
        if (!super.m_5818_(inventory, level)) {
            return false;
        }
        ItemStack stack1 = inventory.m_8020_(0);
        ItemStack stack2 = inventory.m_8020_(1);
        ItemStack stack3 = inventory.m_8020_(2);
        int empty = 0;
        if (stack1.m_41619_()) {
            ++empty;
        }
        if (stack2.m_41619_()) {
            ++empty;
        }
        if (stack3.m_41619_()) {
            ++empty;
        }
        Ingredient ingredient1 = (Ingredient)this.input.get(0);
        if (this.input.size() == 3) {
            if (empty != 0) {
                return false;
            }
            return ingredient1.test(stack1) && ((Ingredient)this.input.get(1)).test(stack2) && ((Ingredient)this.input.get(2)).test(stack3);
        }
        if (this.input.size() == 2) {
            if (empty != 1) {
                return false;
            }
            Ingredient ingredient2 = (Ingredient)this.input.get(1);
            if (ingredient1.test(stack1)) {
                return ingredient2.test(stack2);
            }
            if (ingredient1.test(stack2)) {
                return ingredient2.test(stack3);
            }
            return false;
        }
        if (empty != 2) {
            return false;
        }
        return ingredient1.test(stack1) || ingredient1.test(stack2) || ingredient1.test(stack3);
    }

    public ItemStack assemble(RecipeWrapper inventory) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width == 1 && height <= this.input.size();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.input;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    @Override
    public void render(PoseStack poseStack, Screen screen, int mouseX, int mouseY, float partial, int xOffset, int yOffset) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RECIPE_VIEWER_LOCATION);
        Screen.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)122, (int)81, (int)122, (int)81);
        int xPos = xOffset + 10;
        int yPos = yOffset + 16;
        for (int i = 0; i < this.input.size(); ++i) {
            if (((Ingredient)this.input.get(i)).m_43947_()) continue;
            int y = yPos + i * 18;
            ItemStack item = LevelUtil.chooseUnlockedIngredient((Ingredient)this.input.get(i), ClientEngine.get().getPlayer());
            Minecraft.m_91087_().m_91291_().m_115203_(item, xPos, y);
            if (!this.onItem(xPos, y, mouseX, mouseY)) continue;
            screen.m_169388_(poseStack, screen.m_96555_(item), item.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
        Minecraft.m_91087_().m_91291_().m_115203_(this.output, xOffset + 50, yOffset + 34);
        if (this.onItem(xOffset + 50, yOffset + 34, mouseX, mouseY)) {
            screen.m_169388_(poseStack, screen.m_96555_(this.output), this.output.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
    }

    @Override
    public ItemStack clickItem(Screen screen, int mouseX, int mouseY) {
        int xPos = 10;
        int yPos = 16;
        for (int i = 0; i < this.input.size(); ++i) {
            int y;
            if (((Ingredient)this.input.get(i)).m_43947_() || !this.onItem(xPos, y = yPos + i * 18, mouseX, mouseY)) continue;
            return LevelUtil.chooseUnlockedIngredient((Ingredient)this.input.get(i), ClientEngine.get().getPlayer());
        }
        return ItemStack.f_41583_;
    }

    @Override
    public TranslatableComponent getTitle() {
        return new TranslatableComponent("nightfall.anvil");
    }

    @Override
    public boolean showInRecipeViewer() {
        return this.getRequirementId() != null;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<TieredAnvilRecipe> {
        Serializer() {
            this.setRegistryName(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"anvil"));
        }

        public TieredAnvilRecipe fromJson(ResourceLocation id, JsonObject json) {
            int[][][] gridStart = this.buildIntGrid(json, "gridStart");
            boolean[][][] gridFinish = this.buildBooleanGrid(json, "gridFinish");
            NonNullList ingredients = NonNullList.m_122779_();
            JsonArray input = GsonHelper.m_13933_((JsonObject)json, (String)"input");
            for (int i = 0; i < input.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)input.get(i));
                if (ingredient.m_43947_()) continue;
                ingredients.add((Object)ingredient);
            }
            if (ingredients.isEmpty()) {
                throw new JsonSyntaxException("No ingredients defined for anvil recipe.");
            }
            if (ingredients.size() > 3) {
                throw new JsonSyntaxException("Amount of ingredients exceeds maximum of 3 for anvil recipe.");
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int tier = GsonHelper.m_13927_((JsonObject)json, (String)"tier");
            if (tier < 0) {
                throw new JsonSyntaxException("Invalid tier: must be at least 0");
            }
            ResourceLocation requirement = null;
            if (json.has("requirement")) {
                requirement = ResourceLocation.parse((String)json.get("requirement").getAsString());
            }
            int randMin = GsonHelper.m_13824_((JsonObject)json, (String)"randMin", (int)0);
            int randMax = GsonHelper.m_13824_((JsonObject)json, (String)"randMax", (int)1024);
            float slagChance = GsonHelper.m_13820_((JsonObject)json, (String)"slagChance", (float)0.0f);
            if (slagChance < 0.0f || slagChance > 1.0f) {
                throw new JsonSyntaxException("Slag chance " + slagChance + " must be between 0 and 1.");
            }
            return new TieredAnvilRecipe(id, requirement, gridStart, gridFinish, (NonNullList<Ingredient>)ingredients, result, tier, randMin, randMax, slagChance);
        }

        private int[][][] buildIntGrid(JsonObject json, String name) {
            int[][][] grid = new int[14][6][8];
            JsonArray levels = GsonHelper.m_13933_((JsonObject)json, (String)name);
            if (levels.size() > 6) {
                throw new JsonSyntaxException("Amount of grid levels exceeds maximum of 6 for anvil recipe.");
            }
            for (int y = 0; y < levels.size(); ++y) {
                String level = GsonHelper.m_13805_((JsonElement)levels.get(y), (String)(name + "[" + y + "]"));
                if (level.length() != 112) {
                    throw new JsonSyntaxException("Grid shape for level " + y + " in anvil recipe is not fully defined.");
                }
                for (int i = 0; i < level.length(); ++i) {
                    if (level.charAt(i) == 'o') continue;
                    int x = i % 14;
                    int z = i / 14;
                    grid[x][y][z] = level.charAt(i) == 'X' ? 1 : 2;
                }
            }
            return grid;
        }

        private boolean[][][] buildBooleanGrid(JsonObject json, String name) {
            boolean[][][] grid = new boolean[14][6][8];
            JsonArray levels = GsonHelper.m_13933_((JsonObject)json, (String)name);
            if (levels.size() > 6) {
                throw new JsonSyntaxException("Amount of grid levels exceeds maximum of 6 for anvil recipe.");
            }
            for (int y = 0; y < levels.size(); ++y) {
                String level = GsonHelper.m_13805_((JsonElement)levels.get(y), (String)(name + "[" + y + "]"));
                if (level.length() != 112) {
                    throw new JsonSyntaxException("Grid shape for level " + y + " in anvil recipe is not fully defined.");
                }
                for (int i = 0; i < level.length(); ++i) {
                    if (level.charAt(i) != 'X') continue;
                    int x = i % 14;
                    int z = i / 14;
                    grid[x][y][z] = true;
                }
            }
            return grid;
        }

        public TieredAnvilRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ResourceLocation requirement = buf.m_130281_();
            int[][][] startShape = new int[14][6][8];
            boolean[][][] finishShape = new boolean[14][6][8];
            for (int x = 0; x < 14; ++x) {
                for (int y = 0; y < 6; ++y) {
                    for (int z = 0; z < 8; ++z) {
                        startShape[x][y][z] = buf.m_130242_();
                        finishShape[x][y][z] = buf.readBoolean();
                    }
                }
            }
            int ingredientsAmount = buf.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientsAmount, (Object)Ingredient.f_43901_);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            int tier = buf.m_130242_();
            return new TieredAnvilRecipe(id, requirement.m_135815_().equals("empty") ? null : requirement, startShape, finishShape, (NonNullList<Ingredient>)ingredients, result, tier, buf.m_130242_(), buf.m_130242_(), buf.readFloat());
        }

        public void toNetwork(FriendlyByteBuf buf, TieredAnvilRecipe recipe) {
            buf.m_130085_(recipe.getRequirementId() == null ? ResourceLocation.parse((String)"empty") : recipe.getRequirementId());
            for (int x = 0; x < 14; ++x) {
                for (int y = 0; y < 6; ++y) {
                    for (int z = 0; z < 8; ++z) {
                        buf.m_130130_(recipe.startShape[x][y][z]);
                        buf.writeBoolean(recipe.finishShape[x][y][z]);
                    }
                }
            }
            buf.m_130130_(recipe.input.size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_());
            buf.m_130130_(recipe.tier);
            buf.m_130130_(recipe.randMin);
            buf.m_130130_(recipe.randMax);
            buf.writeFloat(recipe.slagChance);
        }
    }
}

