/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.recipe.BowlCrushingRecipe;
import frostnox.nightfall.data.recipe.EncyclopediaRecipe;
import frostnox.nightfall.data.recipe.HeldToolRecipe;
import frostnox.nightfall.data.recipe.IRenderableRecipe;
import frostnox.nightfall.util.LevelUtil;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ToolIngredientRecipe
extends EncyclopediaRecipe<RecipeWrapper>
implements IRenderableRecipe {
    public static final ResourceLocation RECIPE_VIEWER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/screen/recipe_tool.png");
    private final Ingredient input;
    private final Ingredient tool;
    private final ItemStack output;

    protected ToolIngredientRecipe(ResourceLocation id, ResourceLocation requirement, Ingredient input, Ingredient tool, ItemStack output) {
        super(id, requirement);
        this.input = input;
        this.tool = tool;
        this.output = output;
    }

    public boolean matches(RecipeWrapper inventory, Level level) {
        if (this.tool.test(PlayerData.get(ForgeHooks.getCraftingPlayer()).getHeldItemForRecipe())) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack item = inventory.m_8020_(i);
                if (!this.input.test(item)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack assemble(RecipeWrapper pContainer) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth >= 1 && pHeight >= 1;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    @Override
    public NonNullList<Ingredient> getUnlockIngredients() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input, this.tool});
    }

    @Override
    public boolean showInRecipeViewer() {
        return this.getRequirementId() != null;
    }

    @Override
    public void render(PoseStack poseStack, Screen screen, int mouseX, int mouseY, float partial, int xOffset, int yOffset) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RECIPE_VIEWER_LOCATION);
        Screen.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)26, (int)81, (int)122, (int)81);
        Screen.m_93133_((PoseStack)poseStack, (int)26, (int)0, (float)26.0f, (float)0.0f, (int)96, (int)81, (int)122, (int)81);
        int x = xOffset + 10;
        int y = yOffset + 34;
        ItemStack toolStack = LevelUtil.chooseUnlockedIngredient(this.tool, ClientEngine.get().getPlayer());
        Minecraft.m_91087_().m_91291_().m_115203_(toolStack, x, y);
        if (this.onItem(x, y, mouseX, mouseY)) {
            screen.m_169388_(poseStack, screen.m_96555_(toolStack), toolStack.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
        ItemStack inputStack = LevelUtil.chooseUnlockedIngredient(this.input, ClientEngine.get().getPlayer());
        Minecraft.m_91087_().m_91291_().m_115203_(inputStack, x += 36, y);
        if (this.onItem(x, y, mouseX, mouseY)) {
            screen.m_169388_(poseStack, screen.m_96555_(inputStack), inputStack.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
        Minecraft.m_91087_().m_91291_().m_115203_(this.output, x += 40, y);
        if (this.onItem(x, y, mouseX, mouseY)) {
            screen.m_169388_(poseStack, screen.m_96555_(this.output), this.output.m_150921_(), mouseX - xOffset, mouseY - yOffset);
        }
    }

    @Override
    public ItemStack clickItem(Screen screen, int mouseX, int mouseY) {
        int x = 10;
        int y = 34;
        if (this.onItem(x, y, mouseX, mouseY)) {
            return LevelUtil.chooseUnlockedIngredient(this.tool, ClientEngine.get().getPlayer());
        }
        if (this.onItem(x += 36, y, mouseX, mouseY)) {
            return LevelUtil.chooseUnlockedIngredient(this.input, ClientEngine.get().getPlayer());
        }
        return ItemStack.f_41583_;
    }

    public static void saveBowl(Ingredient input, Ingredient tool, ItemLike output, int count, @Nullable ResourceLocation requirement, Consumer<FinishedRecipe> consumer) {
        ToolIngredientRecipe.saveBowl(input, tool, output, count, requirement, consumer, "nightfall");
    }

    public static void saveBowl(Ingredient input, Ingredient tool, ItemLike output, int count, @Nullable ResourceLocation requirement, Consumer<FinishedRecipe> consumer, String namespace) {
        ToolIngredientRecipe.save(BowlCrushingRecipe.SERIALIZER, input, tool, output, count, requirement, consumer, namespace);
    }

    public static void saveHeldTool(Ingredient input, Ingredient tool, ItemLike output, int count, @Nullable ResourceLocation requirement, Consumer<FinishedRecipe> consumer) {
        ToolIngredientRecipe.saveHeldTool(input, tool, output, count, requirement, consumer, "nightfall");
    }

    public static void saveHeldTool(Ingredient input, Ingredient tool, ItemLike output, int count, @Nullable ResourceLocation requirement, Consumer<FinishedRecipe> consumer, String namespace) {
        ToolIngredientRecipe.save(HeldToolRecipe.SERIALIZER, input, tool, output, count, requirement, consumer, namespace);
    }

    public static void save(Serializer<?> serializer, Ingredient input, Ingredient tool, ItemLike output, int count, @Nullable ResourceLocation requirement, Consumer<FinishedRecipe> consumer, String namespace) {
        Item outputItem = output.m_5456_();
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(serializer.getRegistryName().m_135815_() + "_" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)outputItem).m_135815_()));
        if (input.m_43947_()) {
            throw new IllegalStateException("No ingredient defined for held tool recipe " + id);
        }
        if (tool.m_43947_()) {
            throw new IllegalStateException("No tool defined for held tool recipe " + id);
        }
        consumer.accept(new Result(serializer, id, requirement, input, tool, outputItem, count));
    }

    public static class Serializer<T extends ToolIngredientRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        private final Factory<T> factory;

        Serializer(Factory<T> factory, String name) {
            this.factory = factory;
            this.setRegistryName(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)name));
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            ResourceLocation requirement = null;
            if (json.has("requirement")) {
                requirement = ResourceLocation.parse((String)json.get("requirement").getAsString());
            }
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            Ingredient tool = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"tool"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            return this.factory.create(id, requirement, input, tool, output);
        }

        public T fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ResourceLocation requirement = buf.m_130281_();
            return this.factory.create(id, requirement.m_135815_().equals("empty") ? null : requirement, Ingredient.m_43940_((FriendlyByteBuf)buf), Ingredient.m_43940_((FriendlyByteBuf)buf), buf.m_130267_());
        }

        public void toNetwork(FriendlyByteBuf buf, ToolIngredientRecipe recipe) {
            buf.m_130085_(recipe.getRequirementId() == null ? ResourceLocation.parse((String)"empty") : recipe.getRequirementId());
            recipe.getInput().m_43923_(buf);
            recipe.getTool().m_43923_(buf);
            buf.m_130055_(recipe.m_8043_());
        }

        static interface Factory<T extends ToolIngredientRecipe> {
            public T create(ResourceLocation var1, ResourceLocation var2, Ingredient var3, Ingredient var4, ItemStack var5);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final Serializer<?> serializer;
        private final ResourceLocation id;
        private final ResourceLocation requirement;
        private final Ingredient input;
        private final Ingredient tool;
        private final Item output;
        private final int count;

        public Result(Serializer<?> serializer, ResourceLocation id, ResourceLocation requirement, Ingredient input, Ingredient tool, Item output, int count) {
            this.serializer = serializer;
            this.id = id;
            this.requirement = requirement;
            this.input = input;
            this.tool = tool;
            this.output = output;
            this.count = count;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", this.input.m_43942_());
            json.add("tool", this.tool.m_43942_());
            JsonObject result = new JsonObject();
            result.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output).toString());
            if (this.count > 1) {
                result.addProperty("count", (Number)this.count);
            }
            json.add("output", (JsonElement)result);
            if (this.requirement != null) {
                json.addProperty("requirement", this.requirement.toString());
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

