/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import frostnox.nightfall.data.recipe.BarrelRecipe;
import frostnox.nightfall.util.DataUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BarrelRecipeBuilder {
    private static final HashMap<String, Integer> IDS = new HashMap();
    @Nullable
    private ResourceLocation requirement;
    private final List<Ingredient> input = new ObjectArrayList(4);
    private ItemStack output;
    private int soakTime;
    private boolean fixedSoakTime = false;

    private BarrelRecipeBuilder(ItemStack output) {
        this.output = output;
    }

    public static BarrelRecipeBuilder base(ItemLike itemResult, int count) {
        return new BarrelRecipeBuilder(new ItemStack(itemResult, count));
    }

    public BarrelRecipeBuilder input(TagKey<Item> itemTag) {
        this.input.add(Ingredient.m_204132_(itemTag));
        return this;
    }

    public BarrelRecipeBuilder input(ItemLike item) {
        this.input.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public BarrelRecipeBuilder soakTime(int soakTime) {
        if (soakTime < 0) {
            throw new IllegalArgumentException("Soak time for barrel recipe must be greater than 0");
        }
        this.soakTime = soakTime;
        return this;
    }

    public BarrelRecipeBuilder fixedSoakTime() {
        this.fixedSoakTime = true;
        return this;
    }

    public BarrelRecipeBuilder requirement(ResourceLocation requirement) {
        this.requirement = requirement;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, "nightfall");
    }

    public void save(Consumer<FinishedRecipe> consumer, String namespace) {
        this.save(consumer, BarrelRecipe.SERIALIZER, namespace);
    }

    public void save(Consumer<FinishedRecipe> consumer, BarrelRecipe.Serializer serializer, String namespace) {
        String name = serializer.getRegistryName().m_135815_() + "_" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output.m_41720_()).m_135815_();
        int number = 0;
        if (IDS.containsKey(name)) {
            number = IDS.get(name);
            ++number;
        }
        IDS.put(name, number);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(name + "_" + number));
        if (this.input.isEmpty()) {
            throw new IllegalStateException("No input defined for barrel recipe " + id);
        }
        consumer.accept(new Result(serializer, id, this.requirement, this.input, this.output, this.soakTime, this.fixedSoakTime));
    }

    public static class Result
    implements FinishedRecipe {
        private final BarrelRecipe.Serializer serializer;
        private final ResourceLocation id;
        private final ResourceLocation requirement;
        private final List<Ingredient> input;
        private final ItemStack output;
        private final int soakTime;
        private final boolean fixedSoakTime;

        public Result(BarrelRecipe.Serializer serializer, ResourceLocation id, ResourceLocation requirement, List<Ingredient> input, ItemStack output, int soakTime, boolean fixedSoakTime) {
            this.serializer = serializer;
            this.id = id;
            this.requirement = requirement;
            this.input = input;
            this.output = output;
            this.soakTime = soakTime;
            this.fixedSoakTime = fixedSoakTime;
        }

        public void m_7917_(JsonObject json) {
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingredient : this.input) {
                ingredients.add(ingredient.m_43942_());
            }
            json.add("input", (JsonElement)ingredients);
            json.add("output", (JsonElement)DataUtil.itemStackToJson(this.output));
            if (this.soakTime > 0) {
                json.addProperty("soakTime", (Number)this.soakTime);
            }
            json.addProperty("fixedSoakTime", Boolean.valueOf(this.fixedSoakTime));
            if (this.requirement != null) {
                json.addProperty("requirement", this.requirement.toString());
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

