/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe.builder;

import com.google.gson.JsonObject;
import frostnox.nightfall.data.recipe.BuildingRecipe;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class BuildingRecipeBuilder {
    private Item baseItem;
    private Ingredient extraIngredient;
    private int baseAmount;
    private int extraAmount;
    private int menuOrder = -1;
    private final Item output;
    @Nullable
    private ResourceLocation requirement;

    public BuildingRecipeBuilder(Item baseItem, int baseAmount, Item output) {
        this.baseItem = baseItem;
        this.baseAmount = baseAmount;
        this.output = output;
    }

    public static BuildingRecipeBuilder base(Item baseItem, Item output) {
        return new BuildingRecipeBuilder(baseItem, 1, output);
    }

    public static BuildingRecipeBuilder base(Item baseItem, int baseAmount, Item output) {
        return new BuildingRecipeBuilder(baseItem, baseAmount, output);
    }

    public BuildingRecipeBuilder order(int menuOrder) {
        this.menuOrder = menuOrder;
        return this;
    }

    public BuildingRecipeBuilder addExtra(TagKey<Item> itemTag) {
        return this.addExtra(Ingredient.m_204132_(itemTag));
    }

    public BuildingRecipeBuilder addExtra(ItemLike item) {
        return this.addExtra(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public BuildingRecipeBuilder addExtra(Ingredient ingredient) {
        this.extraIngredient = ingredient;
        this.extraAmount = 1;
        return this;
    }

    public BuildingRecipeBuilder addExtra(TagKey<Item> itemTag, int amount) {
        return this.addExtra(Ingredient.m_204132_(itemTag), amount);
    }

    public BuildingRecipeBuilder addExtra(ItemLike item, int amount) {
        return this.addExtra(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), amount);
    }

    public BuildingRecipeBuilder addExtra(Ingredient ingredient, int amount) {
        this.extraIngredient = ingredient;
        this.extraAmount = amount;
        return this;
    }

    public BuildingRecipeBuilder requirement(RegistryObject<?> entryOrKnowledge) {
        this.requirement = entryOrKnowledge.getId();
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, "nightfall");
    }

    public void save(Consumer<FinishedRecipe> consumer, String namespace) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("building_" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.baseItem).m_135815_() + "_" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output).m_135815_()));
        if (this.baseAmount < 1) {
            throw new IllegalStateException("Base ingredient amount is less than 1 for building recipe " + id);
        }
        if (this.extraIngredient != null && this.extraAmount < 1) {
            throw new IllegalStateException("Extra ingredient is defined but amount is less than 1 for building recipe " + id);
        }
        if (this.extraAmount > 0 && this.extraIngredient == null) {
            throw new IllegalStateException("Extra ingredient amount is greater than 0 but ingredient is undefined for building recipe " + id);
        }
        consumer.accept(new Result(id, this.requirement, this.baseItem, this.extraIngredient, this.baseAmount, this.extraAmount, this.menuOrder, this.output));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ResourceLocation requirementId;
        private final Item baseItem;
        private final Ingredient extraIngredient;
        private final int baseAmount;
        private final int extraAmount;
        private final int menuOrder;
        private final Item output;

        public Result(ResourceLocation id, ResourceLocation requirementId, Item baseItem, Ingredient extraIngredient, int baseAmount, int extraAmount, int menuOrder, Item output) {
            this.id = id;
            this.requirementId = requirementId;
            this.baseItem = baseItem;
            this.extraIngredient = extraIngredient;
            this.baseAmount = baseAmount;
            this.extraAmount = extraAmount;
            this.menuOrder = menuOrder;
            this.output = output;
        }

        public void m_7917_(JsonObject json) {
            if (this.requirementId != null) {
                json.addProperty("requirement", this.requirementId.toString());
            }
            json.addProperty("outputItem", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output).toString());
            json.addProperty("baseAmount", (Number)this.baseAmount);
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.baseItem).toString());
            if (this.extraAmount > 0) {
                json.addProperty("extraAmount", (Number)this.extraAmount);
                json.add("extraIngredient", this.extraIngredient.m_43942_());
            }
            if (this.menuOrder >= 0) {
                json.addProperty("menuOrder", (Number)this.menuOrder);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return BuildingRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

