/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import frostnox.nightfall.data.recipe.CraftingRecipeNF;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class CraftingRecipeBuilder {
    private final Item result;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final int count;
    @Nullable
    private final ResourceLocation requirement;

    public CraftingRecipeBuilder(ItemLike result, int count, @Nullable ResourceLocation requirement) {
        this.result = result.m_5456_();
        this.count = count;
        this.requirement = requirement;
    }

    public static CraftingRecipeBuilder base(ItemLike result) {
        return new CraftingRecipeBuilder(result, 1, null);
    }

    public static CraftingRecipeBuilder base(ItemLike result, int count) {
        return new CraftingRecipeBuilder(result, count, null);
    }

    public static CraftingRecipeBuilder base(ItemLike result, RegistryObject<?> requirement) {
        return CraftingRecipeBuilder.base(result, 1, requirement);
    }

    public static CraftingRecipeBuilder base(ItemLike result, int count, RegistryObject<?> requirement) {
        return new CraftingRecipeBuilder(result, count, requirement.getId());
    }

    public CraftingRecipeBuilder define(Character symbol, TagKey<Item> itemTag) {
        return this.define(symbol, Ingredient.m_204132_(itemTag));
    }

    public CraftingRecipeBuilder define(Character symbol, ItemLike item) {
        return this.define(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public CraftingRecipeBuilder define(Character symbol, Ingredient ingredient) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredient);
        return this;
    }

    public CraftingRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, "nightfall");
    }

    public void save(Consumer<FinishedRecipe> consumer, String namespace) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("crafting_" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).m_135815_()));
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        consumer.accept(new Result(id, this.result, this.count, this.rows, this.key, this.requirement));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ResourceLocation requirement;
        private final Item result;
        private final int count;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;

        public Result(ResourceLocation id, Item result, int count, List<String> pattern, Map<Character, Ingredient> key, ResourceLocation requirement) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.pattern = pattern;
            this.key = key;
            this.requirement = requirement;
        }

        public void m_7917_(JsonObject json) {
            JsonArray patterns = new JsonArray();
            for (String string : this.pattern) {
                patterns.add(string);
            }
            json.add("pattern", (JsonElement)patterns);
            JsonObject keys = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                keys.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)keys);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            if (this.requirement != null) {
                json.addProperty("requirement", this.requirement.toString());
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return CraftingRecipeNF.SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

