/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import frostnox.nightfall.data.recipe.CauldronRecipe;
import frostnox.nightfall.data.recipe.FurnaceRecipe;
import frostnox.nightfall.data.recipe.MixtureRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.compress.utils.Lists;

public class MixtureRecipeBuilder {
    private static final HashMap<String, Integer> IDS = new HashMap();
    private final Item itemResult;
    private final Fluid fluidResult;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final List<Vec2> ranges = Lists.newArrayList();
    @Nullable
    private ResourceLocation requirement;
    private int unitsPerOutput = 1;
    private int cookTime = 1;

    public MixtureRecipeBuilder(ItemLike itemResult, Fluid fluidResult) {
        this.itemResult = itemResult.m_5456_();
        this.fluidResult = fluidResult;
    }

    public MixtureRecipeBuilder(ItemLike itemResult) {
        this.itemResult = itemResult.m_5456_();
        this.fluidResult = null;
    }

    public MixtureRecipeBuilder(Fluid fluidResult) {
        this.itemResult = null;
        this.fluidResult = fluidResult;
    }

    public static MixtureRecipeBuilder base(ItemLike itemResult, Fluid fluidResult) {
        return new MixtureRecipeBuilder(itemResult, fluidResult);
    }

    public static MixtureRecipeBuilder base(ItemLike itemResult) {
        return new MixtureRecipeBuilder(itemResult);
    }

    public static MixtureRecipeBuilder base(Fluid fluidResult) {
        return new MixtureRecipeBuilder(fluidResult);
    }

    public MixtureRecipeBuilder addIngredient(TagKey<Item> itemTag, float min, float max) {
        return this.addIngredient(Ingredient.m_204132_(itemTag), min, max);
    }

    public MixtureRecipeBuilder addIngredient(ItemLike item, float min, float max) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), min, max);
    }

    public MixtureRecipeBuilder addIngredient(Ingredient ingredient, float min, float max) {
        this.ingredients.add(ingredient);
        this.ranges.add(new Vec2(min, max));
        return this;
    }

    public MixtureRecipeBuilder unitsPerOutput(int units) {
        if (units < 0) {
            throw new IllegalArgumentException("Units per output for mixture recipe must be greater than 0");
        }
        this.unitsPerOutput = units;
        return this;
    }

    public MixtureRecipeBuilder cookTime(int cookTime) {
        if (cookTime < 0) {
            throw new IllegalArgumentException("Cook time for mixture recipe must be greater than 0");
        }
        this.cookTime = cookTime;
        return this;
    }

    public MixtureRecipeBuilder requirement(ResourceLocation requirement) {
        this.requirement = requirement;
        return this;
    }

    public void saveCauldron(Consumer<FinishedRecipe> consumer) {
        this.saveCauldron(consumer, "nightfall");
    }

    public void saveCauldron(Consumer<FinishedRecipe> consumer, String namespace) {
        this.save(consumer, CauldronRecipe.SERIALIZER, namespace);
    }

    public void saveFurnace(Consumer<FinishedRecipe> consumer) {
        this.saveFurnace(consumer, "nightfall");
    }

    public void saveFurnace(Consumer<FinishedRecipe> consumer, String namespace) {
        this.save(consumer, FurnaceRecipe.SERIALIZER, namespace);
    }

    public void save(Consumer<FinishedRecipe> consumer, MixtureRecipe.Serializer<?> serializer, String namespace) {
        String name = serializer.getRegistryName().m_135815_() + "_" + (this.fluidResult != null ? ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.fluidResult).m_135815_() : ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.itemResult).m_135815_());
        int number = 0;
        if (IDS.containsKey(name)) {
            number = IDS.get(name);
            ++number;
        }
        IDS.put(name, number);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(name + "_" + number));
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients defined for mixture recipe " + id);
        }
        if (this.itemResult == null && this.fluidResult == null) {
            throw new IllegalStateException("No result specified for mixture recipe " + id);
        }
        consumer.accept(new Result(serializer, id, this.requirement, this.itemResult, this.fluidResult, this.ingredients, this.ranges, this.unitsPerOutput, this.cookTime));
    }

    public static class Result
    implements FinishedRecipe {
        private final MixtureRecipe.Serializer<?> serializer;
        private final ResourceLocation id;
        private final ResourceLocation requirement;
        private final Item itemResult;
        private final Fluid fluidResult;
        private final List<Ingredient> ingredients;
        private final List<Vec2> ranges;
        private final int unitsPerOutput;
        private final int cookTime;

        public Result(MixtureRecipe.Serializer<?> serializer, ResourceLocation id, ResourceLocation requirement, Item itemResult, Fluid fluidResult, List<Ingredient> ingredients, List<Vec2> ranges, int unitsPerOutput, int cookTime) {
            this.serializer = serializer;
            this.id = id;
            this.requirement = requirement;
            this.itemResult = itemResult;
            this.fluidResult = fluidResult;
            this.ingredients = ingredients;
            this.ranges = ranges;
            this.unitsPerOutput = unitsPerOutput;
            this.cookTime = cookTime;
        }

        public void m_7917_(JsonObject json) {
            JsonObject result;
            if (this.itemResult != null) {
                result = new JsonObject();
                result.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.itemResult).toString());
                json.add("itemResult", (JsonElement)result);
            }
            if (this.fluidResult != null) {
                result = new JsonObject();
                result.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.fluidResult).toString());
                json.add("fluidResult", (JsonElement)result);
            }
            JsonArray input = new JsonArray();
            for (int i = 0; i < this.ingredients.size(); ++i) {
                input.add(this.ingredients.get(i).m_43942_());
                input.add((Number)Float.valueOf(this.ranges.get((int)i).f_82470_));
                input.add((Number)Float.valueOf(this.ranges.get((int)i).f_82471_));
            }
            json.add("input", (JsonElement)input);
            if (this.unitsPerOutput > 0) {
                json.addProperty("units", (Number)this.unitsPerOutput);
            }
            json.addProperty("cookTime", (Number)this.cookTime);
            if (this.requirement != null) {
                json.addProperty("requirement", this.requirement.toString());
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

