/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import frostnox.nightfall.data.recipe.CampfireRecipe;
import frostnox.nightfall.data.recipe.CrucibleRecipe;
import frostnox.nightfall.data.recipe.SingleRecipe;
import frostnox.nightfall.util.DataUtil;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SingleRecipeBuilder {
    private static final HashMap<String, Integer> IDS = new HashMap();
    @Nullable
    private ResourceLocation requirement;
    private Ingredient input;
    private ItemStack output;
    private FluidStack fluidOutput;
    private int cookTime;

    private SingleRecipeBuilder(ItemStack output, FluidStack fluidOutput) {
        this.output = output;
        this.fluidOutput = fluidOutput;
    }

    public static SingleRecipeBuilder base(ItemLike itemResult, int itemCount, Fluid fluidResult, int fluidCount) {
        return new SingleRecipeBuilder(new ItemStack(itemResult, itemCount), new FluidStack(fluidResult, fluidCount));
    }

    public static SingleRecipeBuilder base(ItemLike itemResult, int count) {
        return new SingleRecipeBuilder(new ItemStack(itemResult, count), FluidStack.EMPTY);
    }

    public static SingleRecipeBuilder base(Fluid fluidResult, int count) {
        return new SingleRecipeBuilder(ItemStack.f_41583_, new FluidStack(fluidResult, count));
    }

    public SingleRecipeBuilder input(TagKey<Item> itemTag) {
        this.input = Ingredient.m_204132_(itemTag);
        return this;
    }

    public SingleRecipeBuilder input(ItemLike item) {
        this.input = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
        return this;
    }

    public SingleRecipeBuilder cookTime(int cookTime) {
        if (cookTime < 0) {
            throw new IllegalArgumentException("Cook time for single recipe must be greater than 0");
        }
        this.cookTime = cookTime;
        return this;
    }

    public SingleRecipeBuilder requirement(ResourceLocation requirement) {
        this.requirement = requirement;
        return this;
    }

    public void saveCampfire(Consumer<FinishedRecipe> consumer) {
        this.saveCampfire(consumer, "nightfall");
    }

    public void saveCampfire(Consumer<FinishedRecipe> consumer, String namespace) {
        this.save(consumer, CampfireRecipe.SERIALIZER, namespace);
    }

    public void saveCrucible(Consumer<FinishedRecipe> consumer) {
        this.saveCrucible(consumer, "nightfall");
    }

    public void saveCrucible(Consumer<FinishedRecipe> consumer, String namespace) {
        this.save(consumer, CrucibleRecipe.SERIALIZER, namespace);
    }

    public void save(Consumer<FinishedRecipe> consumer, SingleRecipe.Serializer<?> serializer, String namespace) {
        String name = serializer.getRegistryName().m_135815_() + "_" + (!this.fluidOutput.isEmpty() ? ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.fluidOutput.getFluid()).m_135815_() : ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output.m_41720_()).m_135815_());
        int number = 0;
        if (IDS.containsKey(name)) {
            number = IDS.get(name);
            ++number;
        }
        IDS.put(name, number);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(name + "_" + number));
        if (this.input == null) {
            throw new IllegalStateException("No input defined for single recipe " + id);
        }
        if (this.output.m_41619_() && this.fluidOutput.isEmpty()) {
            throw new IllegalStateException("No result specified for single recipe " + id);
        }
        consumer.accept(new Result(serializer, id, this.requirement, this.input, this.output, this.fluidOutput, this.cookTime));
    }

    public static class Result
    implements FinishedRecipe {
        private final SingleRecipe.Serializer<?> serializer;
        private final ResourceLocation id;
        private final ResourceLocation requirement;
        private final Ingredient input;
        private final ItemStack output;
        private final FluidStack fluidOutput;
        private final int cookTime;

        public Result(SingleRecipe.Serializer<?> serializer, ResourceLocation id, ResourceLocation requirement, Ingredient input, ItemStack output, FluidStack fluidOutput, int cookTime) {
            this.serializer = serializer;
            this.id = id;
            this.requirement = requirement;
            this.input = input;
            this.output = output;
            this.fluidOutput = fluidOutput;
            this.cookTime = cookTime;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", this.input.m_43942_());
            if (!this.output.m_41619_()) {
                json.add("output", (JsonElement)DataUtil.itemStackToJson(this.output));
            }
            if (!this.fluidOutput.isEmpty()) {
                json.add("fluidOutput", (JsonElement)DataUtil.fluidStackToJson(this.fluidOutput));
            }
            if (this.cookTime > 0) {
                json.addProperty("cookTime", (Number)this.cookTime);
            }
            if (this.requirement != null) {
                json.addProperty("requirement", this.requirement.toString());
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

