/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.data.recipe.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import frostnox.nightfall.block.MicroGridShape;
import frostnox.nightfall.data.recipe.TieredAnvilRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class TieredAnvilRecipeBuilder {
    private static final HashMap<String, Integer> IDS = new HashMap();
    private final Item result;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final List<String> levelsStart = Lists.newArrayList();
    private final List<String> levelsFinish = Lists.newArrayList();
    private final int count;
    private final int tier;
    @Nullable
    private ResourceLocation requirement;
    private int randMin;
    private int randMax = 1024;
    private float slagChance;

    public TieredAnvilRecipeBuilder(ItemLike result, int count, int tier) {
        this.result = result.m_5456_();
        this.count = count;
        this.tier = tier;
    }

    public static TieredAnvilRecipeBuilder base(ItemLike result, int tier) {
        return TieredAnvilRecipeBuilder.base(result, 1, tier);
    }

    public static TieredAnvilRecipeBuilder base(ItemLike result, int count, int tier) {
        return new TieredAnvilRecipeBuilder(result, count, tier);
    }

    public TieredAnvilRecipeBuilder addIngredient(TagKey<Item> itemTag) {
        return this.addIngredient(Ingredient.m_204132_(itemTag));
    }

    public TieredAnvilRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public TieredAnvilRecipeBuilder addIngredient(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    private TieredAnvilRecipeBuilder addGridLevel(List<String> levels, String string) {
        if (string.length() != 112) {
            throw new IllegalArgumentException("Grid level must fully define all positions.");
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == 'o' || string.charAt(i) == 'X' || string.charAt(i) == '?') continue;
            throw new IllegalArgumentException("Grid level must be defined using only 'o', 'X', and '?' characters.");
        }
        levels.add(string);
        return this;
    }

    public TieredAnvilRecipeBuilder addFinishShape(String ... strings) {
        for (String string : strings) {
            this.addGridLevel(this.levelsFinish, string);
        }
        return this;
    }

    public TieredAnvilRecipeBuilder addStartShape(String ... strings) {
        for (String string : strings) {
            this.addGridLevel(this.levelsStart, string);
        }
        return this;
    }

    public TieredAnvilRecipeBuilder addStartShape(MicroGridShape shape) {
        return this.addStartShape(shape.getGridAsString());
    }

    public TieredAnvilRecipeBuilder addFinishShape(MicroGridShape shape) {
        return this.addFinishShape(shape.getGridAsString());
    }

    public TieredAnvilRecipeBuilder requirement(RegistryObject<?> entryOrKnowledge) {
        this.requirement = entryOrKnowledge.getId();
        return this;
    }

    public TieredAnvilRecipeBuilder requirement(ResourceLocation id) {
        this.requirement = id;
        return this;
    }

    public TieredAnvilRecipeBuilder randRange(int min, int max) {
        this.randMin = min;
        this.randMax = max;
        return this;
    }

    public TieredAnvilRecipeBuilder slagChance(float slagChance) {
        this.slagChance = slagChance;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, "nightfall");
    }

    public void save(Consumer<FinishedRecipe> consumer, String namespace) {
        String name = "anvil_" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).m_135815_();
        int number = 0;
        if (IDS.containsKey(name)) {
            number = IDS.get(name);
            ++number;
        }
        IDS.put(name, number);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(name + "_" + number));
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients defined for anvil recipe " + id);
        }
        if (this.ingredients.size() > 3) {
            throw new IllegalStateException("More than 3 ingredients defined for anvil recipe " + id);
        }
        if (this.levelsStart.isEmpty()) {
            throw new IllegalStateException("No starting grid shape defined for anvil recipe " + id);
        }
        if (this.levelsStart.size() > 6) {
            throw new IllegalStateException("Starting grid shape exceeds the maximum height of 6for anvil recipe " + id);
        }
        if (this.levelsFinish.isEmpty()) {
            throw new IllegalStateException("No finished grid shape defined for anvil recipe " + id);
        }
        if (this.levelsFinish.size() > 6) {
            throw new IllegalStateException("Finished grid shape exceeds the maximum height of 6for anvil recipe " + id);
        }
        if (this.slagChance < 0.0f || this.slagChance > 1.0f) {
            throw new IllegalStateException("Slag chance " + this.slagChance + " must be between 0 and 1.");
        }
        consumer.accept(new Result(id, this.requirement, this.result, this.count, this.tier, this.levelsStart, this.levelsFinish, this.ingredients, this.randMin, this.randMax, this.slagChance));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ResourceLocation requirement;
        private final Item result;
        private final int count;
        private final int tier;
        private final List<String> levelsStart;
        private final List<String> levelsFinish;
        private final List<Ingredient> ingredients;
        private final int randMin;
        private final int randMax;
        private final float slagChance;

        public Result(ResourceLocation id, ResourceLocation requirement, Item result, int count, int tier, List<String> levelsStart, List<String> levelsFinish, List<Ingredient> ingredients, int randMin, int randMax, float slagChance) {
            this.id = id;
            this.requirement = requirement;
            this.result = result;
            this.count = count;
            this.tier = tier;
            this.levelsStart = levelsStart;
            this.levelsFinish = levelsFinish;
            this.ingredients = ingredients;
            this.randMin = randMin;
            this.randMax = randMax;
            this.slagChance = slagChance;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("tier", (Number)this.tier);
            JsonObject result = new JsonObject();
            result.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                result.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)result);
            JsonArray input = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                input.add(ingredient.m_43942_());
            }
            json.add("input", (JsonElement)input);
            JsonArray gridStart = new JsonArray();
            for (String s : this.levelsStart) {
                gridStart.add(s);
            }
            json.add("gridStart", (JsonElement)gridStart);
            JsonArray jsonArray = new JsonArray();
            for (String s : this.levelsFinish) {
                jsonArray.add(s);
            }
            json.add("gridFinish", (JsonElement)jsonArray);
            if (this.requirement != null) {
                json.addProperty("requirement", this.requirement.toString());
            }
            if (this.randMin > 0) {
                json.addProperty("randMin", (Number)this.randMin);
            }
            if (this.randMax < 1024) {
                json.addProperty("randMax", (Number)this.randMax);
            }
            if (this.slagChance > 0.0f) {
                json.addProperty("slagChance", (Number)Float.valueOf(this.slagChance));
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return TieredAnvilRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

