/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.encyclopedia;

import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.encyclopedia.EntryStage;
import frostnox.nightfall.encyclopedia.Puzzle;
import frostnox.nightfall.encyclopedia.knowledge.Knowledge;
import frostnox.nightfall.registry.RegistriesNF;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class Entry
extends ForgeRegistryEntry<Entry> {
    public final List<RegistryObject<? extends Entry>> parents;
    public final Set<RegistryObject<? extends Knowledge>> prerequisites;
    @Nullable
    public final Puzzle puzzle;
    public final boolean isHidden;
    public final boolean isAddendum;
    private String descriptionId;

    protected Entry(List<RegistryObject<? extends Entry>> parents, Set<RegistryObject<? extends Knowledge>> prerequisites, @Nullable Puzzle puzzle, boolean isHidden, boolean isAddendum) {
        this.parents = parents;
        this.prerequisites = prerequisites;
        this.puzzle = puzzle;
        this.isHidden = isHidden;
        this.isAddendum = isAddendum;
    }

    public static Entry create(List<RegistryObject<? extends Entry>> parents, Set<RegistryObject<? extends Knowledge>> prerequisites, Puzzle puzzle) {
        return new Entry(parents, prerequisites, puzzle, false, false);
    }

    public static Entry createHidden(List<RegistryObject<? extends Entry>> parents, Set<RegistryObject<? extends Knowledge>> prerequisites, Puzzle puzzle) {
        return new Entry(parents, prerequisites, puzzle, true, false);
    }

    public static Entry createAddendum(List<RegistryObject<? extends Entry>> parents, RegistryObject<? extends Knowledge> ... prerequisites) {
        return new Entry(parents, Set.of(prerequisites), null, true, true);
    }

    public boolean shouldReveal(IPlayerData encyclopedia) {
        if (this.isHidden) {
            return false;
        }
        boolean puzzle = false;
        for (RegistryObject<? extends Entry> registryObject : this.parents) {
            EntryStage parentStage = encyclopedia.getStage(registryObject.getId());
            if (parentStage == EntryStage.HIDDEN || parentStage == EntryStage.LOCKED) {
                return false;
            }
            if (parentStage != EntryStage.PUZZLE) continue;
            puzzle = true;
        }
        if (puzzle) {
            if (this.prerequisites.isEmpty()) {
                return false;
            }
            for (RegistryObject registryObject : this.prerequisites) {
                if (encyclopedia.hasKnowledge(registryObject.getId())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean shouldUnlock(IPlayerData encyclopedia) {
        for (RegistryObject<? extends Knowledge> registryObject : this.prerequisites) {
            if (encyclopedia.hasKnowledge(registryObject.getId())) continue;
            return false;
        }
        for (RegistryObject registryObject : this.parents) {
            if (encyclopedia.hasEntryStage(registryObject.getId(), EntryStage.COMPLETED)) continue;
            return false;
        }
        return true;
    }

    public Set<RegistryObject<? extends Knowledge>> getAssociatedKnowledge() {
        if (this.puzzle == null) {
            return this.prerequisites;
        }
        return Stream.concat(this.prerequisites.stream(), this.puzzle.knowledge().stream()).collect(Collectors.toUnmodifiableSet());
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"entry", (ResourceLocation)RegistriesNF.getEntries().getKey((IForgeRegistryEntry)this));
        }
        return this.descriptionId;
    }
}

