/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.encyclopedia;

import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.encyclopedia.knowledge.Knowledge;
import frostnox.nightfall.world.condition.WorldCondition;
import frostnox.nightfall.world.inventory.ItemStackHandlerNF;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.RegistryObject;

public record Puzzle(List<RegistryObject<? extends Knowledge>> knowledge, List<Ingredient> ingredients, List<RegistryObject<? extends WorldCondition>> conditions) {
    public boolean isSolved(IPlayerData capP, ItemStackHandlerNF input) {
        for (RegistryObject<? extends Knowledge> knowledge : this.knowledge) {
            if (capP.hasKnowledge(knowledge.getId())) continue;
            return false;
        }
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (this.ingredients.get(i).test(input.getStackInSlot(i))) continue;
            return false;
        }
        for (RegistryObject<? extends WorldCondition> condition : this.conditions) {
            if (((WorldCondition)((Object)condition.get())).test(capP.getPlayer())) continue;
            return false;
        }
        return true;
    }

    public IntList getItemIcons(ItemStackHandlerNF input) {
        IntArrayList icons = new IntArrayList(this.ingredients.size());
        for (int i = 0; i < this.ingredients.size(); ++i) {
            icons.add(this.ingredients.get(i).test(input.getStackInSlot(i)) ? 2 : 1);
        }
        return icons;
    }

    public boolean hasAllKnowledge(IPlayerData capP) {
        for (RegistryObject<? extends Knowledge> knowledge : this.knowledge) {
            if (capP.hasKnowledge(knowledge.getId())) continue;
            return false;
        }
        return true;
    }
}

