/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.encyclopedia;

import com.mojang.datafixers.util.Pair;
import frostnox.nightfall.encyclopedia.Entry;
import frostnox.nightfall.encyclopedia.Puzzle;
import frostnox.nightfall.registry.EntriesNF;
import frostnox.nightfall.registry.forge.ContainersNF;
import frostnox.nightfall.world.inventory.ItemStackHandlerNF;
import frostnox.nightfall.world.inventory.PartialInventoryContainer;
import frostnox.nightfall.world.inventory.SingleFluidSlot;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.items.IItemHandler;

public class PuzzleContainer
extends PartialInventoryContainer {
    public static final int DEFAULT_ICON = 0;
    public static final int FAILURE_ICON = 1;
    public static final int SUCCESS_ICON = 2;
    public static final ResourceLocation UNKNOWN_ITEM = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"gui/icon/unknown_item");
    public static final ResourceLocation SUCCESS = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"gui/icon/puzzle_success");
    public static final ResourceLocation FAILURE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"gui/icon/puzzle_failure");
    public final Entry entry;
    public final ItemStackHandlerNF inventory;
    public final IntList itemIcons;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return PuzzleContainer.this.itemIcons.getInt(pIndex);
        }

        public void m_8050_(int pIndex, int pValue) {
            PuzzleContainer.this.itemIcons.set(pIndex, pValue);
        }

        public int m_6499_() {
            return PuzzleContainer.this.itemIcons.size();
        }
    };

    public PuzzleContainer(Inventory playerInv, int pContainerId, ResourceLocation entryId) {
        super((MenuType)ContainersNF.ENCYCLOPEDIA_PUZZLE.get(), playerInv, pContainerId, true);
        this.entry = EntriesNF.get(entryId);
        Puzzle puzzle = this.entry.puzzle;
        this.inventory = new ItemStackHandlerNF(puzzle.ingredients().size());
        this.itemIcons = new IntArrayList(puzzle.ingredients().size());
        for (int i = 0; i < puzzle.ingredients().size(); ++i) {
            this.itemIcons.add(0);
            this.m_38897_((Slot)new SingleFluidSlot((IItemHandler)this.inventory, this, playerInv.f_35978_, i, 38 + i * 21, 51, false){

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    int icon = PuzzleContainer.this.itemIcons.getInt(this.index);
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)(icon == 0 ? UNKNOWN_ITEM : (icon == 1 ? FAILURE : SUCCESS)));
                }
            });
        }
        this.m_38884_(this.data);
    }

    public boolean m_6875_(Player pPlayer) {
        return true;
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.inventory.transferToPlayer(pPlayer);
    }

    public static PuzzleContainer createClientContainer(int windowID, Inventory playerInv, FriendlyByteBuf extraData) {
        return new PuzzleContainer(playerInv, windowID, extraData.m_130281_());
    }
}

