/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity;

import frostnox.nightfall.block.IFoodBlock;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.IActionableEntity;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.Diet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface IHungerEntity
extends IActionableEntity {
    public void addSatiety(int var1);

    public boolean isHungry();

    public Diet getDiet();

    public void eatBlock(BlockState var1, BlockPos var2);

    public void eatEntity(Entity var1);

    default public boolean canEat(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof IFoodBlock) {
            IFoodBlock foodBlock = (IFoodBlock)block;
            return foodBlock.isEatable(state, this.getDiet());
        }
        return false;
    }

    default public boolean canEat(Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return switch (this.getDiet()) {
                default -> throw new IncompatibleClassChangeError();
                case Diet.HERBIVORE -> itemEntity.m_32055_().m_204117_(TagsNF.HERBIVORE_FOOD);
                case Diet.CARNIVORE -> itemEntity.m_32055_().m_204117_(TagsNF.CARNIVORE_FOOD);
                case Diet.OMNIVORE -> itemEntity.m_32055_().m_204117_(TagsNF.OMNIVORE_FOOD);
            };
        }
        return false;
    }

    default public void doEatClient(ItemStack item) {
        ActionableEntity entity = this.getEntity();
        Random random = entity.m_21187_();
        if (this.getEatSound() != null) {
            entity.f_19853_.m_7785_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), this.getEatSound(), entity.m_5720_(), 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
        }
        if (!item.m_41619_()) {
            Vec3 eyePos = entity.m_146892_();
            for (int i = 0; i < 4; ++i) {
                Vec3 speed = new Vec3(((double)random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)random.nextFloat() - 0.5) * 0.1);
                speed = speed.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
                speed = speed.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
                Vec3 pos = new Vec3(((double)random.nextFloat() - 0.5) * 0.6, ((double)random.nextFloat() - 0.5) * 0.6, (double)entity.m_20205_() + ((double)random.nextFloat() - 0.5) * 0.4);
                pos = pos.m_82524_(-entity.f_20883_ * ((float)Math.PI / 180));
                pos = pos.m_82549_(eyePos);
                entity.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, item), pos.f_82479_, pos.f_82480_, pos.f_82481_, speed.f_82479_, speed.f_82480_ + 0.05, speed.f_82481_);
            }
        }
    }

    public SoundEvent getEatSound();
}

