/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import frostnox.nightfall.util.math.OBB;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public interface IOrientedHitBoxes {
    public static final OBB[] EMPTY = new OBB[0];
    public static final double MAX_DIST_FROM_AABB = 1.0;

    public ActionableEntity getEntity();

    public boolean includeAABB();

    default public float getModelScale() {
        return 1.0f;
    }

    public Vector3f getOBBTranslation();

    public EnumMap<EntityPart, AnimationData> getDefaultAnimMap();

    public EntityPart[] getOrderedOBBParts();

    public OBB[] getDefaultOBBs();

    public AABB getEnclosingAABB();

    default public OBB[] getOBBs(float partial) {
        ActionableEntity entity = this.getEntity();
        if (!entity.m_6084_()) {
            return EMPTY;
        }
        float scale = this.getModelScale();
        IActionTracker capA = entity.getActionTracker();
        EnumMap<EntityPart, AnimationData> transforms = this.getDefaultAnimMap();
        if (scale != 1.0f) {
            for (AnimationData data : transforms.values()) {
                data.offset.m_122261_(scale);
            }
        }
        AnimationCalculator mCalc = new AnimationCalculator();
        if (!capA.isInactive() && !capA.isStunned()) {
            Action action = capA.getAction();
            for (AnimationData animationData : transforms.values()) {
                animationData.update(capA.getFrame(), capA.getDuration(), partial);
            }
            mCalc.update(capA.getFrame(), capA.getDuration(), partial, Easing.inOutSine);
            action.transformModel(capA.getState(), capA.getFrame(), capA.getDuration(), action.getChargeProgress(capA.getCharge(), capA.getChargePartial()), action.getPitch((LivingEntity)entity, partial), (LivingEntity)entity, transforms, mCalc);
        }
        EntityPart[] parts = this.getOrderedOBBParts();
        OBB[] boxes = this.getDefaultOBBs();
        if (scale != 1.0f) {
            for (OBB box : boxes) {
                box.center.m_122261_(scale);
                box.extents = box.extents.m_82542_((double)scale, (double)scale, (double)scale);
            }
        }
        float f = entity.m_5675_(partial) - Mth.m_14179_((float)partial, (float)entity.f_20884_, (float)entity.f_20883_);
        Quaternion bodyYaw = Vector3f.f_122225_.m_122240_(-Mth.m_14179_((float)partial, (float)entity.f_20884_, (float)entity.f_20883_) - mCalc.getTransformations().m_122260_());
        int partOffset = parts.length - boxes.length;
        for (int i = 0; i < boxes.length; ++i) {
            OBB box = boxes[i];
            EntityPart part = parts[i + partOffset];
            box.rotation.m_80148_(bodyYaw);
            for (int j = i + partOffset; j >= 0; --j) {
                AnimationData data = transforms.get((Object)parts[j]);
                Vector3f t = new Vector3f();
                Vector3f translations = data.tCalc.getTransformations();
                translations.m_122267_(data.dTranslation);
                translations.m_122263_(scale * 1.0f / 16.0f, scale * -1.0f / 16.0f, scale * -1.0f / 16.0f);
                if (j > 0) {
                    Quaternion r = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
                    t.m_122253_(data.offset);
                    t.m_122267_(transforms.get((Object)((Object)parts[j - 1])).offset);
                    for (int k = 0; k <= j - 1; ++k) {
                        AnimationData dataRoot = transforms.get((Object)parts[k]);
                        Vector3f rotationsRoot = dataRoot.rCalc.getTransformations();
                        if (parts[k] == EntityPart.NECK || parts[k] == EntityPart.HEAD) {
                            rotationsRoot.m_122272_(0.0f, f, 0.0f);
                        }
                        r.m_80148_(Vector3f.f_122227_.m_122240_(-rotationsRoot.m_122269_()));
                        r.m_80148_(Vector3f.f_122225_.m_122240_(-rotationsRoot.m_122260_()));
                        r.m_80148_(Vector3f.f_122223_.m_122240_(rotationsRoot.m_122239_()));
                    }
                    t.m_122251_(r);
                    translations.m_122251_(r);
                }
                if (j == i + partOffset) {
                    Vector3f translation = this.getOBBTranslation();
                    translation.m_122261_(scale);
                    translations.m_122253_(translation);
                }
                t.m_122253_(translations);
                t.m_122251_(bodyYaw);
                box.translation = box.translation.m_82520_((double)t.m_122239_(), (double)t.m_122260_(), (double)t.m_122269_());
            }
            Quaternion r = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
            boolean rotatedHead = false;
            for (int j = 0; j <= i + partOffset; ++j) {
                AnimationData data = transforms.get((Object)parts[j]);
                Vector3f rotations = data.rCalc.getTransformations();
                if (!(rotatedHead || parts[j] != EntityPart.NECK && parts[j] != EntityPart.HEAD)) {
                    rotations.m_122272_(0.0f, f, 0.0f);
                    rotatedHead = true;
                }
                r.m_80148_(Vector3f.f_122227_.m_122240_(-rotations.m_122269_()));
                r.m_80148_(Vector3f.f_122225_.m_122240_(-rotations.m_122260_()));
                r.m_80148_(Vector3f.f_122223_.m_122240_(rotations.m_122239_()));
            }
            box.rotation.m_80148_(r);
            if (part != EntityPart.HEAD || !capA.isInactive() && !capA.isStunned()) continue;
            box.rotation.m_80148_(Vector3f.f_122223_.m_122240_(entity.m_5686_(partial)));
        }
        return boxes;
    }
}

